/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ActionMenuPresenter;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.internal.R;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.bars.CustomActionBarWrapper;
import com.android.layoutlib.bridge.bars.OverflowMenuAdapter;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import java.util.ArrayList;

public class ActionBarLayout {
    private static final String LAYOUT_ATTR_NAME = "windowActionBarFullscreenDecorLayout";
    @NonNull
    private CustomActionBarWrapper mActionBar;
    @NonNull
    private final BridgeContext mBridgeContext;
    @NonNull
    private FrameLayout mContentRoot;
    @Nullable
    private ViewGroup mMeasureParent;
    @NonNull
    private final RelativeLayout mEnclosingLayout;

    public ActionBarLayout(@NonNull BridgeContext context, @NonNull SessionParams params, @NonNull ViewGroup parentView) {
        this.mBridgeContext = context;
        ResourceValue layoutName = context.getRenderResources().findItemInTheme(LAYOUT_ATTR_NAME, true);
        if (layoutName != null) {
            layoutName = context.getRenderResources().findResValue(layoutName.getValue(), layoutName.isFramework());
        }
        int layoutId = 0;
        String error = null;
        if (layoutName == null) {
            error = "Unable to find action bar layout (windowActionBarFullscreenDecorLayout) in the current theme.";
        } else {
            layoutId = context.getFrameworkResourceValue(layoutName.getResourceType(), layoutName.getName(), 0);
            if (layoutId == 0) {
                error = String.format("Unable to resolve attribute \"%s\" of type \"%s\"", layoutName.getName(), layoutName.getResourceType());
            }
        }
        if (layoutId == 0) {
            throw new RuntimeException(error);
        }
        this.mEnclosingLayout = new RelativeLayout(this.mBridgeContext);
        this.setMatchParent(this.mEnclosingLayout);
        parentView.addView(this.mEnclosingLayout);
        View decorContent = LayoutInflater.from(context).inflate(layoutId, (ViewGroup)this.mEnclosingLayout, true);
        this.mActionBar = CustomActionBarWrapper.getActionBarWrapper(context, params, decorContent);
        FrameLayout contentRoot = (FrameLayout)this.mEnclosingLayout.findViewById(0x1020002);
        if (contentRoot == null) {
            contentRoot = new FrameLayout(context);
            this.setMatchParent(contentRoot);
            this.mEnclosingLayout.addView(contentRoot);
            this.mContentRoot = contentRoot;
        } else {
            this.mContentRoot = contentRoot;
            this.mActionBar.setupActionBar();
            this.mActionBar.inflateMenus();
        }
    }

    private void setMatchParent(View view) {
        view.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
    }

    public void createMenuPopup() {
        assert (this.mEnclosingLayout.getChildCount() == 1) : "Action Bar Menus have already been created.";
        if (!this.isOverflowPopupNeeded()) {
            return;
        }
        DisplayMetrics metrics = this.mBridgeContext.getMetrics();
        MenuBuilder menu2 = this.mActionBar.getMenuBuilder();
        OverflowMenuAdapter adapter = new OverflowMenuAdapter(menu2, this.mActionBar.getPopupContext());
        ListView listView = new ListView(this.mActionBar.getPopupContext(), null, 16842861);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.measureContentWidth(adapter), -2);
        layoutParams.addRule(21);
        if (this.mActionBar.isSplit()) {
            layoutParams.addRule(12);
            layoutParams.bottomMargin = this.getActionBarHeight() + this.mActionBar.getMenuPopupMargin();
        } else {
            layoutParams.addRule(10);
            layoutParams.topMargin = this.getActionBarHeight() + this.mActionBar.getMenuPopupMargin();
        }
        layoutParams.setMarginEnd(ActionBarLayout.getPixelValue("5dp", metrics));
        listView.setLayoutParams(layoutParams);
        listView.setAdapter(adapter);
        TypedArray a = this.mActionBar.getPopupContext().obtainStyledAttributes(null, R.styleable.PopupWindow, 0x1010300, 0);
        listView.setBackground(a.getDrawable(0));
        listView.setDivider(a.getDrawable(16843675));
        a.recycle();
        listView.setElevation(this.mActionBar.getMenuPopupElevation());
        this.mEnclosingLayout.addView(listView);
    }

    private boolean isOverflowPopupNeeded() {
        boolean needed = this.mActionBar.isOverflowPopupNeeded();
        if (!needed) {
            return false;
        }
        ArrayList<MenuItemImpl> menus = this.mActionBar.getMenuBuilder().getNonActionItems();
        ActionMenuPresenter presenter = this.mActionBar.getActionMenuPresenter();
        if (presenter == null) {
            throw new RuntimeException("Failed to create a Presenter for Action Bar Menus.");
        }
        if (presenter.isOverflowReserved() && menus != null) {
            int count = menus.size();
            needed = count == 1 ? !menus.get(0).isActionViewExpanded() : count > 0;
        }
        return needed;
    }

    @NonNull
    public FrameLayout getContentRoot() {
        return this.mContentRoot;
    }

    private int measureContentWidth(@NonNull ListAdapter adapter) {
        int maxWidth = 0;
        View itemView = null;
        int itemType = 0;
        Context context = this.mActionBar.getPopupContext();
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            if (this.mMeasureParent == null) {
                this.mMeasureParent = new FrameLayout(context);
            }
            itemView = adapter.getView(i, itemView, this.mMeasureParent);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            int itemWidth = itemView.getMeasuredWidth();
            int popupMaxWidth = Math.max(this.mBridgeContext.getMetrics().widthPixels / 2, context.getResources().getDimensionPixelSize(17104905));
            if (itemWidth >= popupMaxWidth) {
                return popupMaxWidth;
            }
            if (itemWidth <= maxWidth) continue;
            maxWidth = itemWidth;
        }
        return maxWidth;
    }

    static int getPixelValue(@NonNull String value, @NonNull DisplayMetrics metrics) {
        TypedValue typedValue = ResourceHelper.getValue(null, value, false);
        return (int)typedValue.getDimension(metrics);
    }

    private int getActionBarHeight() {
        TypedValue typedValue;
        RenderResources resources = this.mBridgeContext.getRenderResources();
        DisplayMetrics metrics = this.mBridgeContext.getMetrics();
        ResourceValue value = resources.findItemInTheme("actionBarSize", true);
        if ((value = resources.resolveResValue(value)) != null && (typedValue = ResourceHelper.getValue("actionBarSize", value.getValue(), true)) != null) {
            return (int)typedValue.getDimension(metrics);
        }
        return 0;
    }
}

