/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.ActionBar;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.CollapsibleActionView;
import android.view.ContextThemeWrapper;
import android.view.Gravity;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ActionMenuPresenter;
import android.widget.ActionMenuView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RtlSpacingHelper;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import com.android.internal.widget.DecorToolbar;
import com.android.internal.widget.ToolbarWidgetWrapper;
import java.util.ArrayList;
import java.util.List;

public class Toolbar
extends ViewGroup {
    private static final String TAG = "Toolbar";
    private ActionMenuView mMenuView;
    private TextView mTitleTextView;
    private TextView mSubtitleTextView;
    private ImageButton mNavButtonView;
    private ImageView mLogoView;
    private Drawable mCollapseIcon;
    private ImageButton mCollapseButtonView;
    View mExpandedActionView;
    private Context mPopupContext;
    private int mPopupTheme;
    private int mTitleTextAppearance;
    private int mSubtitleTextAppearance;
    private int mNavButtonStyle;
    private int mButtonGravity;
    private int mMaxButtonHeight;
    private int mTitleMarginStart;
    private int mTitleMarginEnd;
    private int mTitleMarginTop;
    private int mTitleMarginBottom;
    private final RtlSpacingHelper mContentInsets = new RtlSpacingHelper();
    private int mGravity = 8388627;
    private CharSequence mTitleText;
    private CharSequence mSubtitleText;
    private int mTitleTextColor;
    private int mSubtitleTextColor;
    private boolean mEatingTouch;
    private final ArrayList<View> mTempViews = new ArrayList();
    private final int[] mTempMargins = new int[2];
    private OnMenuItemClickListener mOnMenuItemClickListener;
    private final ActionMenuView.OnMenuItemClickListener mMenuViewItemClickListener = new ActionMenuView.OnMenuItemClickListener(){

        @Override
        public boolean onMenuItemClick(MenuItem item) {
            if (Toolbar.this.mOnMenuItemClickListener != null) {
                return Toolbar.this.mOnMenuItemClickListener.onMenuItemClick(item);
            }
            return false;
        }
    };
    private ToolbarWidgetWrapper mWrapper;
    private ActionMenuPresenter mOuterActionMenuPresenter;
    private ExpandedActionViewMenuPresenter mExpandedMenuPresenter;
    private MenuPresenter.Callback mActionMenuPresenterCallback;
    private MenuBuilder.Callback mMenuBuilderCallback;
    private boolean mCollapsible;
    private final Runnable mShowOverflowMenuRunnable = new Runnable(){

        @Override
        public void run() {
            Toolbar.this.showOverflowMenu();
        }
    };

    public Toolbar(Context context) {
        this(context, null);
    }

    public Toolbar(Context context, AttributeSet attrs) {
        this(context, attrs, 16843946);
    }

    public Toolbar(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public Toolbar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        CharSequence navDesc;
        CharSequence subtitle;
        int marginBottom;
        int marginTop;
        int marginEnd;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Toolbar, defStyleAttr, defStyleRes);
        this.mTitleTextAppearance = a.getResourceId(3, 0);
        this.mSubtitleTextAppearance = a.getResourceId(4, 0);
        this.mNavButtonStyle = a.getResourceId(18, 0);
        this.mGravity = a.getInteger(0, this.mGravity);
        this.mButtonGravity = a.getInteger(19, 48);
        this.mTitleMarginTop = this.mTitleMarginBottom = a.getDimensionPixelOffset(12, 0);
        this.mTitleMarginEnd = this.mTitleMarginBottom;
        this.mTitleMarginStart = this.mTitleMarginBottom;
        int marginStart = a.getDimensionPixelOffset(13, -1);
        if (marginStart >= 0) {
            this.mTitleMarginStart = marginStart;
        }
        if ((marginEnd = a.getDimensionPixelOffset(14, -1)) >= 0) {
            this.mTitleMarginEnd = marginEnd;
        }
        if ((marginTop = a.getDimensionPixelOffset(15, -1)) >= 0) {
            this.mTitleMarginTop = marginTop;
        }
        if ((marginBottom = a.getDimensionPixelOffset(16, -1)) >= 0) {
            this.mTitleMarginBottom = marginBottom;
        }
        this.mMaxButtonHeight = a.getDimensionPixelSize(17, -1);
        int contentInsetStart = a.getDimensionPixelOffset(5, Integer.MIN_VALUE);
        int contentInsetEnd = a.getDimensionPixelOffset(6, Integer.MIN_VALUE);
        int contentInsetLeft = a.getDimensionPixelSize(7, 0);
        int contentInsetRight = a.getDimensionPixelSize(8, 0);
        this.mContentInsets.setAbsolute(contentInsetLeft, contentInsetRight);
        if (contentInsetStart != Integer.MIN_VALUE || contentInsetEnd != Integer.MIN_VALUE) {
            this.mContentInsets.setRelative(contentInsetStart, contentInsetEnd);
        }
        this.mCollapseIcon = a.getDrawable(20);
        CharSequence title = a.getText(1);
        if (!TextUtils.isEmpty(title)) {
            this.setTitle(title);
        }
        if (!TextUtils.isEmpty(subtitle = a.getText(2))) {
            this.setSubtitle(subtitle);
        }
        this.mPopupContext = this.mContext;
        this.setPopupTheme(a.getResourceId(9, 0));
        Drawable navIcon = a.getDrawable(10);
        if (navIcon != null) {
            this.setNavigationIcon(navIcon);
        }
        if (!TextUtils.isEmpty(navDesc = a.getText(11))) {
            this.setNavigationContentDescription(navDesc);
        }
        a.recycle();
    }

    public void setPopupTheme(int resId) {
        if (this.mPopupTheme != resId) {
            this.mPopupTheme = resId;
            this.mPopupContext = resId == 0 ? this.mContext : new ContextThemeWrapper(this.mContext, resId);
        }
    }

    public int getPopupTheme() {
        return this.mPopupTheme;
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.mContentInsets.setDirection(layoutDirection == 1);
    }

    public void setLogo(int resId) {
        this.setLogo(this.getContext().getDrawable(resId));
    }

    public boolean canShowOverflowMenu() {
        return this.getVisibility() == 0 && this.mMenuView != null && this.mMenuView.isOverflowReserved();
    }

    public boolean isOverflowMenuShowing() {
        return this.mMenuView != null && this.mMenuView.isOverflowMenuShowing();
    }

    public boolean isOverflowMenuShowPending() {
        return this.mMenuView != null && this.mMenuView.isOverflowMenuShowPending();
    }

    public boolean showOverflowMenu() {
        return this.mMenuView != null && this.mMenuView.showOverflowMenu();
    }

    public boolean hideOverflowMenu() {
        return this.mMenuView != null && this.mMenuView.hideOverflowMenu();
    }

    public void setMenu(MenuBuilder menu2, ActionMenuPresenter outerPresenter) {
        if (menu2 == null && this.mMenuView == null) {
            return;
        }
        this.ensureMenuView();
        MenuBuilder oldMenu = this.mMenuView.peekMenu();
        if (oldMenu == menu2) {
            return;
        }
        if (oldMenu != null) {
            oldMenu.removeMenuPresenter(this.mOuterActionMenuPresenter);
            oldMenu.removeMenuPresenter(this.mExpandedMenuPresenter);
        }
        if (this.mExpandedMenuPresenter == null) {
            this.mExpandedMenuPresenter = new ExpandedActionViewMenuPresenter();
        }
        outerPresenter.setExpandedActionViewsExclusive(true);
        if (menu2 != null) {
            menu2.addMenuPresenter(outerPresenter, this.mPopupContext);
            menu2.addMenuPresenter(this.mExpandedMenuPresenter, this.mPopupContext);
        } else {
            outerPresenter.initForMenu(this.mPopupContext, null);
            this.mExpandedMenuPresenter.initForMenu(this.mPopupContext, null);
            outerPresenter.updateMenuView(true);
            this.mExpandedMenuPresenter.updateMenuView(true);
        }
        this.mMenuView.setPopupTheme(this.mPopupTheme);
        this.mMenuView.setPresenter(outerPresenter);
        this.mOuterActionMenuPresenter = outerPresenter;
    }

    public void dismissPopupMenus() {
        if (this.mMenuView != null) {
            this.mMenuView.dismissPopupMenus();
        }
    }

    public boolean isTitleTruncated() {
        if (this.mTitleTextView == null) {
            return false;
        }
        Layout titleLayout = this.mTitleTextView.getLayout();
        if (titleLayout == null) {
            return false;
        }
        int lineCount = titleLayout.getLineCount();
        for (int i = 0; i < lineCount; ++i) {
            if (titleLayout.getEllipsisCount(i) <= 0) continue;
            return true;
        }
        return false;
    }

    public void setLogo(Drawable drawable2) {
        if (drawable2 != null) {
            this.ensureLogoView();
            if (this.mLogoView.getParent() == null) {
                this.addSystemView(this.mLogoView);
                this.updateChildVisibilityForExpandedActionView(this.mLogoView);
            }
        } else if (this.mLogoView != null && this.mLogoView.getParent() != null) {
            this.removeView(this.mLogoView);
        }
        if (this.mLogoView != null) {
            this.mLogoView.setImageDrawable(drawable2);
        }
    }

    public Drawable getLogo() {
        return this.mLogoView != null ? this.mLogoView.getDrawable() : null;
    }

    public void setLogoDescription(int resId) {
        this.setLogoDescription(this.getContext().getText(resId));
    }

    public void setLogoDescription(CharSequence description) {
        if (!TextUtils.isEmpty(description)) {
            this.ensureLogoView();
        }
        if (this.mLogoView != null) {
            this.mLogoView.setContentDescription(description);
        }
    }

    public CharSequence getLogoDescription() {
        return this.mLogoView != null ? this.mLogoView.getContentDescription() : null;
    }

    private void ensureLogoView() {
        if (this.mLogoView == null) {
            this.mLogoView = new ImageView(this.getContext());
        }
    }

    public boolean hasExpandedActionView() {
        return this.mExpandedMenuPresenter != null && this.mExpandedMenuPresenter.mCurrentExpandedItem != null;
    }

    public void collapseActionView() {
        MenuItemImpl item;
        MenuItemImpl menuItemImpl = item = this.mExpandedMenuPresenter == null ? null : this.mExpandedMenuPresenter.mCurrentExpandedItem;
        if (item != null) {
            item.collapseActionView();
        }
    }

    public CharSequence getTitle() {
        return this.mTitleText;
    }

    public void setTitle(int resId) {
        this.setTitle(this.getContext().getText(resId));
    }

    public void setTitle(CharSequence title) {
        if (!TextUtils.isEmpty(title)) {
            if (this.mTitleTextView == null) {
                Context context = this.getContext();
                this.mTitleTextView = new TextView(context);
                this.mTitleTextView.setSingleLine();
                this.mTitleTextView.setEllipsize(TextUtils.TruncateAt.END);
                if (this.mTitleTextAppearance != 0) {
                    this.mTitleTextView.setTextAppearance(context, this.mTitleTextAppearance);
                }
                if (this.mTitleTextColor != 0) {
                    this.mTitleTextView.setTextColor(this.mTitleTextColor);
                }
            }
            if (this.mTitleTextView.getParent() == null) {
                this.addSystemView(this.mTitleTextView);
                this.updateChildVisibilityForExpandedActionView(this.mTitleTextView);
            }
        } else if (this.mTitleTextView != null && this.mTitleTextView.getParent() != null) {
            this.removeView(this.mTitleTextView);
        }
        if (this.mTitleTextView != null) {
            this.mTitleTextView.setText(title);
        }
        this.mTitleText = title;
    }

    public CharSequence getSubtitle() {
        return this.mSubtitleText;
    }

    public void setSubtitle(int resId) {
        this.setSubtitle(this.getContext().getText(resId));
    }

    public void setSubtitle(CharSequence subtitle) {
        if (!TextUtils.isEmpty(subtitle)) {
            if (this.mSubtitleTextView == null) {
                Context context = this.getContext();
                this.mSubtitleTextView = new TextView(context);
                this.mSubtitleTextView.setSingleLine();
                this.mSubtitleTextView.setEllipsize(TextUtils.TruncateAt.END);
                if (this.mSubtitleTextAppearance != 0) {
                    this.mSubtitleTextView.setTextAppearance(context, this.mSubtitleTextAppearance);
                }
                if (this.mSubtitleTextColor != 0) {
                    this.mSubtitleTextView.setTextColor(this.mSubtitleTextColor);
                }
            }
            if (this.mSubtitleTextView.getParent() == null) {
                this.addSystemView(this.mSubtitleTextView);
                this.updateChildVisibilityForExpandedActionView(this.mSubtitleTextView);
            }
        } else if (this.mSubtitleTextView != null && this.mSubtitleTextView.getParent() != null) {
            this.removeView(this.mSubtitleTextView);
        }
        if (this.mSubtitleTextView != null) {
            this.mSubtitleTextView.setText(subtitle);
        }
        this.mSubtitleText = subtitle;
    }

    public void setTitleTextAppearance(Context context, int resId) {
        this.mTitleTextAppearance = resId;
        if (this.mTitleTextView != null) {
            this.mTitleTextView.setTextAppearance(context, resId);
        }
    }

    public void setSubtitleTextAppearance(Context context, int resId) {
        this.mSubtitleTextAppearance = resId;
        if (this.mSubtitleTextView != null) {
            this.mSubtitleTextView.setTextAppearance(context, resId);
        }
    }

    public void setTitleTextColor(int color2) {
        this.mTitleTextColor = color2;
        if (this.mTitleTextView != null) {
            this.mTitleTextView.setTextColor(color2);
        }
    }

    public void setSubtitleTextColor(int color2) {
        this.mSubtitleTextColor = color2;
        if (this.mSubtitleTextView != null) {
            this.mSubtitleTextView.setTextColor(color2);
        }
    }

    public CharSequence getNavigationContentDescription() {
        return this.mNavButtonView != null ? this.mNavButtonView.getContentDescription() : null;
    }

    public void setNavigationContentDescription(int resId) {
        this.setNavigationContentDescription(resId != 0 ? this.getContext().getText(resId) : null);
    }

    public void setNavigationContentDescription(CharSequence description) {
        if (!TextUtils.isEmpty(description)) {
            this.ensureNavButtonView();
        }
        if (this.mNavButtonView != null) {
            this.mNavButtonView.setContentDescription(description);
        }
    }

    public void setNavigationIcon(int resId) {
        this.setNavigationIcon(this.getContext().getDrawable(resId));
    }

    public void setNavigationIcon(Drawable icon) {
        if (icon != null) {
            this.ensureNavButtonView();
            if (this.mNavButtonView.getParent() == null) {
                this.addSystemView(this.mNavButtonView);
                this.updateChildVisibilityForExpandedActionView(this.mNavButtonView);
            }
        } else if (this.mNavButtonView != null && this.mNavButtonView.getParent() != null) {
            this.removeView(this.mNavButtonView);
        }
        if (this.mNavButtonView != null) {
            this.mNavButtonView.setImageDrawable(icon);
        }
    }

    public Drawable getNavigationIcon() {
        return this.mNavButtonView != null ? this.mNavButtonView.getDrawable() : null;
    }

    public void setNavigationOnClickListener(View.OnClickListener listener) {
        this.ensureNavButtonView();
        this.mNavButtonView.setOnClickListener(listener);
    }

    public Menu getMenu() {
        this.ensureMenu();
        return this.mMenuView.getMenu();
    }

    private void ensureMenu() {
        this.ensureMenuView();
        if (this.mMenuView.peekMenu() == null) {
            MenuBuilder menu2 = (MenuBuilder)this.mMenuView.getMenu();
            if (this.mExpandedMenuPresenter == null) {
                this.mExpandedMenuPresenter = new ExpandedActionViewMenuPresenter();
            }
            this.mMenuView.setExpandedActionViewsExclusive(true);
            menu2.addMenuPresenter(this.mExpandedMenuPresenter, this.mPopupContext);
        }
    }

    private void ensureMenuView() {
        if (this.mMenuView == null) {
            this.mMenuView = new ActionMenuView(this.getContext());
            this.mMenuView.setPopupTheme(this.mPopupTheme);
            this.mMenuView.setOnMenuItemClickListener(this.mMenuViewItemClickListener);
            this.mMenuView.setMenuCallbacks(this.mActionMenuPresenterCallback, this.mMenuBuilderCallback);
            LayoutParams lp = this.generateDefaultLayoutParams();
            lp.gravity = 0x800005 | this.mButtonGravity & 0x70;
            this.mMenuView.setLayoutParams(lp);
            this.addSystemView(this.mMenuView);
        }
    }

    private MenuInflater getMenuInflater() {
        return new MenuInflater(this.getContext());
    }

    public void inflateMenu(int resId) {
        this.getMenuInflater().inflate(resId, this.getMenu());
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener listener) {
        this.mOnMenuItemClickListener = listener;
    }

    public void setContentInsetsRelative(int contentInsetStart, int contentInsetEnd) {
        this.mContentInsets.setRelative(contentInsetStart, contentInsetEnd);
    }

    public int getContentInsetStart() {
        return this.mContentInsets.getStart();
    }

    public int getContentInsetEnd() {
        return this.mContentInsets.getEnd();
    }

    public void setContentInsetsAbsolute(int contentInsetLeft, int contentInsetRight) {
        this.mContentInsets.setAbsolute(contentInsetLeft, contentInsetRight);
    }

    public int getContentInsetLeft() {
        return this.mContentInsets.getLeft();
    }

    public int getContentInsetRight() {
        return this.mContentInsets.getRight();
    }

    private void ensureNavButtonView() {
        if (this.mNavButtonView == null) {
            this.mNavButtonView = new ImageButton(this.getContext(), null, 0, this.mNavButtonStyle);
            LayoutParams lp = this.generateDefaultLayoutParams();
            lp.gravity = 0x800003 | this.mButtonGravity & 0x70;
            this.mNavButtonView.setLayoutParams(lp);
        }
    }

    private void ensureCollapseButtonView() {
        if (this.mCollapseButtonView == null) {
            this.mCollapseButtonView = new ImageButton(this.getContext(), null, 0, this.mNavButtonStyle);
            this.mCollapseButtonView.setImageDrawable(this.mCollapseIcon);
            LayoutParams lp = this.generateDefaultLayoutParams();
            lp.gravity = 0x800003 | this.mButtonGravity & 0x70;
            lp.mViewType = 2;
            this.mCollapseButtonView.setLayoutParams(lp);
            this.mCollapseButtonView.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View v) {
                    Toolbar.this.collapseActionView();
                }
            });
        }
    }

    private void addSystemView(View v) {
        ViewGroup.LayoutParams vlp = v.getLayoutParams();
        LayoutParams lp = vlp == null ? this.generateDefaultLayoutParams() : (!this.checkLayoutParams(vlp) ? this.generateLayoutParams(vlp) : (LayoutParams)vlp);
        lp.mViewType = 1;
        this.addView(v, lp);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        SavedState state = new SavedState(super.onSaveInstanceState());
        if (this.mExpandedMenuPresenter != null && this.mExpandedMenuPresenter.mCurrentExpandedItem != null) {
            state.expandedMenuItemId = this.mExpandedMenuPresenter.mCurrentExpandedItem.getItemId();
        }
        state.isOverflowOpen = this.isOverflowMenuShowing();
        return state;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        MenuItem item;
        MenuBuilder menu2;
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        MenuBuilder menuBuilder = menu2 = this.mMenuView != null ? this.mMenuView.peekMenu() : null;
        if (ss.expandedMenuItemId != 0 && this.mExpandedMenuPresenter != null && menu2 != null && (item = menu2.findItem(ss.expandedMenuItemId)) != null) {
            item.expandActionView();
        }
        if (ss.isOverflowOpen) {
            this.postShowOverflowMenu();
        }
    }

    private void postShowOverflowMenu() {
        this.removeCallbacks(this.mShowOverflowMenuRunnable);
        this.post(this.mShowOverflowMenuRunnable);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mShowOverflowMenuRunnable);
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        if (action == 0) {
            this.mEatingTouch = false;
        }
        if (!this.mEatingTouch) {
            boolean handled = super.onTouchEvent(ev);
            if (action == 0 && !handled) {
                this.mEatingTouch = true;
            }
        }
        if (action == 1 || action == 3) {
            this.mEatingTouch = false;
        }
        return true;
    }

    @Override
    protected void onSetLayoutParams(View child, ViewGroup.LayoutParams lp) {
        if (!this.checkLayoutParams(lp)) {
            child.setLayoutParams(this.generateLayoutParams(lp));
        }
    }

    private void measureChildConstrained(View child, int parentWidthSpec, int widthUsed, int parentHeightSpec, int heightUsed, int heightConstraint) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int childWidthSpec = Toolbar.getChildMeasureSpec(parentWidthSpec, this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin + widthUsed, lp.width);
        int childHeightSpec = Toolbar.getChildMeasureSpec(parentHeightSpec, this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin + heightUsed, lp.height);
        int childHeightMode = View.MeasureSpec.getMode(childHeightSpec);
        if (childHeightMode != 0x40000000 && heightConstraint >= 0) {
            int size = childHeightMode != 0 ? Math.min(View.MeasureSpec.getSize(childHeightSpec), heightConstraint) : heightConstraint;
            childHeightSpec = View.MeasureSpec.makeMeasureSpec(size, 0x40000000);
        }
        child.measure(childWidthSpec, childHeightSpec);
    }

    private int measureChildCollapseMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed, int[] collapsingMargins) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int leftDiff = lp.leftMargin - collapsingMargins[0];
        int rightDiff = lp.rightMargin - collapsingMargins[1];
        int leftMargin = Math.max(0, leftDiff);
        int rightMargin = Math.max(0, rightDiff);
        int hMargins = leftMargin + rightMargin;
        collapsingMargins[0] = Math.max(0, -leftDiff);
        collapsingMargins[1] = Math.max(0, -rightDiff);
        int childWidthMeasureSpec = Toolbar.getChildMeasureSpec(parentWidthMeasureSpec, this.mPaddingLeft + this.mPaddingRight + hMargins + widthUsed, lp.width);
        int childHeightMeasureSpec = Toolbar.getChildMeasureSpec(parentHeightMeasureSpec, this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin + heightUsed, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        return child.getMeasuredWidth() + hMargins;
    }

    private boolean shouldCollapse() {
        if (!this.mCollapsible) {
            return false;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!this.shouldLayout(child) || child.getMeasuredWidth() <= 0 || child.getMeasuredHeight() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int marginEndIndex;
        int marginStartIndex;
        int width = 0;
        int height = 0;
        int childState = 0;
        int[] collapsingMargins = this.mTempMargins;
        if (this.isLayoutRtl()) {
            marginStartIndex = 1;
            marginEndIndex = 0;
        } else {
            marginStartIndex = 0;
            marginEndIndex = 1;
        }
        int navWidth = 0;
        if (this.shouldLayout(this.mNavButtonView)) {
            this.measureChildConstrained(this.mNavButtonView, widthMeasureSpec, width, heightMeasureSpec, 0, this.mMaxButtonHeight);
            navWidth = this.mNavButtonView.getMeasuredWidth() + this.getHorizontalMargins(this.mNavButtonView);
            height = Math.max(height, this.mNavButtonView.getMeasuredHeight() + this.getVerticalMargins(this.mNavButtonView));
            childState = Toolbar.combineMeasuredStates(childState, this.mNavButtonView.getMeasuredState());
        }
        if (this.shouldLayout(this.mCollapseButtonView)) {
            this.measureChildConstrained(this.mCollapseButtonView, widthMeasureSpec, width, heightMeasureSpec, 0, this.mMaxButtonHeight);
            navWidth = this.mCollapseButtonView.getMeasuredWidth() + this.getHorizontalMargins(this.mCollapseButtonView);
            height = Math.max(height, this.mCollapseButtonView.getMeasuredHeight() + this.getVerticalMargins(this.mCollapseButtonView));
            childState = Toolbar.combineMeasuredStates(childState, this.mCollapseButtonView.getMeasuredState());
        }
        int contentInsetStart = this.getContentInsetStart();
        width += Math.max(contentInsetStart, navWidth);
        collapsingMargins[marginStartIndex] = Math.max(0, contentInsetStart - navWidth);
        int menuWidth = 0;
        if (this.shouldLayout(this.mMenuView)) {
            this.measureChildConstrained(this.mMenuView, widthMeasureSpec, width, heightMeasureSpec, 0, this.mMaxButtonHeight);
            menuWidth = this.mMenuView.getMeasuredWidth() + this.getHorizontalMargins(this.mMenuView);
            height = Math.max(height, this.mMenuView.getMeasuredHeight() + this.getVerticalMargins(this.mMenuView));
            childState = Toolbar.combineMeasuredStates(childState, this.mMenuView.getMeasuredState());
        }
        int contentInsetEnd = this.getContentInsetEnd();
        width += Math.max(contentInsetEnd, menuWidth);
        collapsingMargins[marginEndIndex] = Math.max(0, contentInsetEnd - menuWidth);
        if (this.shouldLayout(this.mExpandedActionView)) {
            width += this.measureChildCollapseMargins(this.mExpandedActionView, widthMeasureSpec, width, heightMeasureSpec, 0, collapsingMargins);
            height = Math.max(height, this.mExpandedActionView.getMeasuredHeight() + this.getVerticalMargins(this.mExpandedActionView));
            childState = Toolbar.combineMeasuredStates(childState, this.mExpandedActionView.getMeasuredState());
        }
        if (this.shouldLayout(this.mLogoView)) {
            width += this.measureChildCollapseMargins(this.mLogoView, widthMeasureSpec, width, heightMeasureSpec, 0, collapsingMargins);
            height = Math.max(height, this.mLogoView.getMeasuredHeight() + this.getVerticalMargins(this.mLogoView));
            childState = Toolbar.combineMeasuredStates(childState, this.mLogoView.getMeasuredState());
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.mViewType != 0 || !this.shouldLayout(child)) continue;
            width += this.measureChildCollapseMargins(child, widthMeasureSpec, width, heightMeasureSpec, 0, collapsingMargins);
            height = Math.max(height, child.getMeasuredHeight() + this.getVerticalMargins(child));
            childState = Toolbar.combineMeasuredStates(childState, child.getMeasuredState());
        }
        int titleWidth = 0;
        int titleHeight = 0;
        int titleVertMargins = this.mTitleMarginTop + this.mTitleMarginBottom;
        int titleHorizMargins = this.mTitleMarginStart + this.mTitleMarginEnd;
        if (this.shouldLayout(this.mTitleTextView)) {
            titleWidth = this.measureChildCollapseMargins(this.mTitleTextView, widthMeasureSpec, width + titleHorizMargins, heightMeasureSpec, titleVertMargins, collapsingMargins);
            titleWidth = this.mTitleTextView.getMeasuredWidth() + this.getHorizontalMargins(this.mTitleTextView);
            titleHeight = this.mTitleTextView.getMeasuredHeight() + this.getVerticalMargins(this.mTitleTextView);
            childState = Toolbar.combineMeasuredStates(childState, this.mTitleTextView.getMeasuredState());
        }
        if (this.shouldLayout(this.mSubtitleTextView)) {
            titleWidth = Math.max(titleWidth, this.measureChildCollapseMargins(this.mSubtitleTextView, widthMeasureSpec, width + titleHorizMargins, heightMeasureSpec, titleHeight + titleVertMargins, collapsingMargins));
            titleHeight += this.mSubtitleTextView.getMeasuredHeight() + this.getVerticalMargins(this.mSubtitleTextView);
            childState = Toolbar.combineMeasuredStates(childState, this.mSubtitleTextView.getMeasuredState());
        }
        width += titleWidth;
        height = Math.max(height, titleHeight);
        int measuredWidth = Toolbar.resolveSizeAndState(Math.max(width += this.getPaddingLeft() + this.getPaddingRight(), this.getSuggestedMinimumWidth()), widthMeasureSpec, childState & 0xFF000000);
        int measuredHeight = Toolbar.resolveSizeAndState(Math.max(height += this.getPaddingTop() + this.getPaddingBottom(), this.getSuggestedMinimumHeight()), heightMeasureSpec, childState << 16);
        this.setMeasuredDimension(measuredWidth, this.shouldCollapse() ? 0 : measuredHeight);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        LayoutParams lp;
        boolean isRtl = this.getLayoutDirection() == 1;
        int width = this.getWidth();
        int height = this.getHeight();
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int left = paddingLeft;
        int right = width - paddingRight;
        int[] collapsingMargins = this.mTempMargins;
        collapsingMargins[1] = 0;
        collapsingMargins[0] = 0;
        int alignmentHeight = this.getMinimumHeight();
        if (this.shouldLayout(this.mNavButtonView)) {
            if (isRtl) {
                right = this.layoutChildRight(this.mNavButtonView, right, collapsingMargins, alignmentHeight);
            } else {
                left = this.layoutChildLeft(this.mNavButtonView, left, collapsingMargins, alignmentHeight);
            }
        }
        if (this.shouldLayout(this.mCollapseButtonView)) {
            if (isRtl) {
                right = this.layoutChildRight(this.mCollapseButtonView, right, collapsingMargins, alignmentHeight);
            } else {
                left = this.layoutChildLeft(this.mCollapseButtonView, left, collapsingMargins, alignmentHeight);
            }
        }
        if (this.shouldLayout(this.mMenuView)) {
            if (isRtl) {
                left = this.layoutChildLeft(this.mMenuView, left, collapsingMargins, alignmentHeight);
            } else {
                right = this.layoutChildRight(this.mMenuView, right, collapsingMargins, alignmentHeight);
            }
        }
        collapsingMargins[0] = Math.max(0, this.getContentInsetLeft() - left);
        collapsingMargins[1] = Math.max(0, this.getContentInsetRight() - (width - paddingRight - right));
        left = Math.max(left, this.getContentInsetLeft());
        right = Math.min(right, width - paddingRight - this.getContentInsetRight());
        if (this.shouldLayout(this.mExpandedActionView)) {
            if (isRtl) {
                right = this.layoutChildRight(this.mExpandedActionView, right, collapsingMargins, alignmentHeight);
            } else {
                left = this.layoutChildLeft(this.mExpandedActionView, left, collapsingMargins, alignmentHeight);
            }
        }
        if (this.shouldLayout(this.mLogoView)) {
            if (isRtl) {
                right = this.layoutChildRight(this.mLogoView, right, collapsingMargins, alignmentHeight);
            } else {
                left = this.layoutChildLeft(this.mLogoView, left, collapsingMargins, alignmentHeight);
            }
        }
        boolean layoutTitle = this.shouldLayout(this.mTitleTextView);
        boolean layoutSubtitle = this.shouldLayout(this.mSubtitleTextView);
        int titleHeight = 0;
        if (layoutTitle) {
            lp = (LayoutParams)this.mTitleTextView.getLayoutParams();
            titleHeight += lp.topMargin + this.mTitleTextView.getMeasuredHeight() + lp.bottomMargin;
        }
        if (layoutSubtitle) {
            lp = (LayoutParams)this.mSubtitleTextView.getLayoutParams();
            titleHeight += lp.topMargin + this.mSubtitleTextView.getMeasuredHeight() + lp.bottomMargin;
        }
        if (layoutTitle || layoutSubtitle) {
            int subtitleBottom;
            int titleBottom;
            LayoutParams lp2;
            int titleTop;
            TextView topChild = layoutTitle ? this.mTitleTextView : this.mSubtitleTextView;
            TextView bottomChild = layoutSubtitle ? this.mSubtitleTextView : this.mTitleTextView;
            LayoutParams toplp = (LayoutParams)topChild.getLayoutParams();
            LayoutParams bottomlp = (LayoutParams)bottomChild.getLayoutParams();
            boolean titleHasWidth = layoutTitle && this.mTitleTextView.getMeasuredWidth() > 0 || layoutSubtitle && this.mSubtitleTextView.getMeasuredWidth() > 0;
            switch (this.mGravity & 0x70) {
                case 48: {
                    titleTop = this.getPaddingTop() + toplp.topMargin + this.mTitleMarginTop;
                    break;
                }
                default: {
                    int space = height - paddingTop - paddingBottom;
                    int spaceAbove = (space - titleHeight) / 2;
                    if (spaceAbove < toplp.topMargin + this.mTitleMarginTop) {
                        spaceAbove = toplp.topMargin + this.mTitleMarginTop;
                    } else {
                        int spaceBelow = height - paddingBottom - titleHeight - spaceAbove - paddingTop;
                        if (spaceBelow < toplp.bottomMargin + this.mTitleMarginBottom) {
                            spaceAbove = Math.max(0, spaceAbove - (bottomlp.bottomMargin + this.mTitleMarginBottom - spaceBelow));
                        }
                    }
                    titleTop = paddingTop + spaceAbove;
                    break;
                }
                case 80: {
                    titleTop = height - paddingBottom - bottomlp.bottomMargin - this.mTitleMarginBottom - titleHeight;
                }
            }
            if (isRtl) {
                int rd = (titleHasWidth ? this.mTitleMarginStart : 0) - collapsingMargins[1];
                collapsingMargins[1] = Math.max(0, -rd);
                int titleRight = right -= Math.max(0, rd);
                int subtitleRight = right;
                if (layoutTitle) {
                    lp2 = (LayoutParams)this.mTitleTextView.getLayoutParams();
                    int titleLeft = titleRight - this.mTitleTextView.getMeasuredWidth();
                    titleBottom = titleTop + this.mTitleTextView.getMeasuredHeight();
                    this.mTitleTextView.layout(titleLeft, titleTop, titleRight, titleBottom);
                    titleRight = titleLeft - this.mTitleMarginEnd;
                    titleTop = titleBottom + lp2.bottomMargin;
                }
                if (layoutSubtitle) {
                    lp2 = (LayoutParams)this.mSubtitleTextView.getLayoutParams();
                    int subtitleLeft = subtitleRight - this.mSubtitleTextView.getMeasuredWidth();
                    subtitleBottom = (titleTop += lp2.topMargin) + this.mSubtitleTextView.getMeasuredHeight();
                    this.mSubtitleTextView.layout(subtitleLeft, titleTop, subtitleRight, subtitleBottom);
                    subtitleRight -= this.mTitleMarginEnd;
                    titleTop = subtitleBottom + lp2.bottomMargin;
                }
                if (titleHasWidth) {
                    right = Math.min(titleRight, subtitleRight);
                }
            } else {
                int ld = (titleHasWidth ? this.mTitleMarginStart : 0) - collapsingMargins[0];
                collapsingMargins[0] = Math.max(0, -ld);
                int titleLeft = left += Math.max(0, ld);
                int subtitleLeft = left;
                if (layoutTitle) {
                    lp2 = (LayoutParams)this.mTitleTextView.getLayoutParams();
                    int titleRight = titleLeft + this.mTitleTextView.getMeasuredWidth();
                    titleBottom = titleTop + this.mTitleTextView.getMeasuredHeight();
                    this.mTitleTextView.layout(titleLeft, titleTop, titleRight, titleBottom);
                    titleLeft = titleRight + this.mTitleMarginEnd;
                    titleTop = titleBottom + lp2.bottomMargin;
                }
                if (layoutSubtitle) {
                    lp2 = (LayoutParams)this.mSubtitleTextView.getLayoutParams();
                    int subtitleRight = subtitleLeft + this.mSubtitleTextView.getMeasuredWidth();
                    subtitleBottom = (titleTop += lp2.topMargin) + this.mSubtitleTextView.getMeasuredHeight();
                    this.mSubtitleTextView.layout(subtitleLeft, titleTop, subtitleRight, subtitleBottom);
                    subtitleLeft = subtitleRight + this.mTitleMarginEnd;
                    titleTop = subtitleBottom + lp2.bottomMargin;
                }
                if (titleHasWidth) {
                    left = Math.max(titleLeft, subtitleLeft);
                }
            }
        }
        this.addCustomViewsWithGravity(this.mTempViews, 3);
        int leftViewsCount = this.mTempViews.size();
        for (int i = 0; i < leftViewsCount; ++i) {
            left = this.layoutChildLeft(this.mTempViews.get(i), left, collapsingMargins, alignmentHeight);
        }
        this.addCustomViewsWithGravity(this.mTempViews, 5);
        int rightViewsCount = this.mTempViews.size();
        for (int i = 0; i < rightViewsCount; ++i) {
            right = this.layoutChildRight(this.mTempViews.get(i), right, collapsingMargins, alignmentHeight);
        }
        this.addCustomViewsWithGravity(this.mTempViews, 1);
        int centerViewsWidth = this.getViewListMeasuredWidth(this.mTempViews, collapsingMargins);
        int parentCenter = paddingLeft + (width - paddingLeft - paddingRight) / 2;
        int halfCenterViewsWidth = centerViewsWidth / 2;
        int centerLeft = parentCenter - halfCenterViewsWidth;
        int centerRight = centerLeft + centerViewsWidth;
        if (centerLeft < left) {
            centerLeft = left;
        } else if (centerRight > right) {
            centerLeft -= centerRight - right;
        }
        int centerViewsCount = this.mTempViews.size();
        for (int i = 0; i < centerViewsCount; ++i) {
            centerLeft = this.layoutChildLeft(this.mTempViews.get(i), centerLeft, collapsingMargins, alignmentHeight);
        }
        this.mTempViews.clear();
    }

    private int getViewListMeasuredWidth(List<View> views, int[] collapsingMargins) {
        int collapseLeft = collapsingMargins[0];
        int collapseRight = collapsingMargins[1];
        int width = 0;
        int count = views.size();
        for (int i = 0; i < count; ++i) {
            View v = views.get(i);
            LayoutParams lp = (LayoutParams)v.getLayoutParams();
            int l = lp.leftMargin - collapseLeft;
            int r = lp.rightMargin - collapseRight;
            int leftMargin = Math.max(0, l);
            int rightMargin = Math.max(0, r);
            collapseLeft = Math.max(0, -l);
            collapseRight = Math.max(0, -r);
            width += leftMargin + v.getMeasuredWidth() + rightMargin;
        }
        return width;
    }

    private int layoutChildLeft(View child, int left, int[] collapsingMargins, int alignmentHeight) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int l = lp.leftMargin - collapsingMargins[0];
        collapsingMargins[0] = Math.max(0, -l);
        int top = this.getChildTop(child, alignmentHeight);
        int childWidth = child.getMeasuredWidth();
        child.layout(left += Math.max(0, l), top, left + childWidth, top + child.getMeasuredHeight());
        return left += childWidth + lp.rightMargin;
    }

    private int layoutChildRight(View child, int right, int[] collapsingMargins, int alignmentHeight) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int r = lp.rightMargin - collapsingMargins[1];
        collapsingMargins[1] = Math.max(0, -r);
        int top = this.getChildTop(child, alignmentHeight);
        int childWidth = child.getMeasuredWidth();
        child.layout((right -= Math.max(0, r)) - childWidth, top, right, top + child.getMeasuredHeight());
        return right -= childWidth + lp.leftMargin;
    }

    private int getChildTop(View child, int alignmentHeight) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int childHeight = child.getMeasuredHeight();
        int alignmentOffset = alignmentHeight > 0 ? (childHeight - alignmentHeight) / 2 : 0;
        switch (this.getChildVerticalGravity(lp.gravity)) {
            case 48: {
                return this.getPaddingTop() - alignmentOffset;
            }
            case 80: {
                return this.getHeight() - this.getPaddingBottom() - childHeight - lp.bottomMargin - alignmentOffset;
            }
        }
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int height = this.getHeight();
        int space = height - paddingTop - paddingBottom;
        int spaceAbove = (space - childHeight) / 2;
        if (spaceAbove < lp.topMargin) {
            spaceAbove = lp.topMargin;
        } else {
            int spaceBelow = height - paddingBottom - childHeight - spaceAbove - paddingTop;
            if (spaceBelow < lp.bottomMargin) {
                spaceAbove = Math.max(0, spaceAbove - (lp.bottomMargin - spaceBelow));
            }
        }
        return paddingTop + spaceAbove;
    }

    private int getChildVerticalGravity(int gravity) {
        int vgrav = gravity & 0x70;
        switch (vgrav) {
            case 16: 
            case 48: 
            case 80: {
                return vgrav;
            }
        }
        return this.mGravity & 0x70;
    }

    private void addCustomViewsWithGravity(List<View> views, int gravity) {
        boolean isRtl = this.getLayoutDirection() == 1;
        int childCount = this.getChildCount();
        int absGrav = Gravity.getAbsoluteGravity(gravity, this.getLayoutDirection());
        views.clear();
        if (isRtl) {
            for (int i = childCount - 1; i >= 0; --i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.mViewType != 0 || !this.shouldLayout(child) || this.getChildHorizontalGravity(lp.gravity) != absGrav) continue;
                views.add(child);
            }
        } else {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.mViewType != 0 || !this.shouldLayout(child) || this.getChildHorizontalGravity(lp.gravity) != absGrav) continue;
                views.add(child);
            }
        }
    }

    private int getChildHorizontalGravity(int gravity) {
        int ld = this.getLayoutDirection();
        int absGrav = Gravity.getAbsoluteGravity(gravity, ld);
        int hGrav = absGrav & 7;
        switch (hGrav) {
            case 1: 
            case 3: 
            case 5: {
                return hGrav;
            }
        }
        return ld == 1 ? 5 : 3;
    }

    private boolean shouldLayout(View view) {
        return view != null && view.getParent() == this && view.getVisibility() != 8;
    }

    private int getHorizontalMargins(View v) {
        ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
        return mlp.getMarginStart() + mlp.getMarginEnd();
    }

    private int getVerticalMargins(View v) {
        ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
        return mlp.topMargin + mlp.bottomMargin;
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (p instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)p);
        }
        if (p instanceof ActionBar.LayoutParams) {
            return new LayoutParams((ActionBar.LayoutParams)p);
        }
        if (p instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)p);
        }
        return new LayoutParams(p);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return super.checkLayoutParams(p) && p instanceof LayoutParams;
    }

    private static boolean isCustomView(View child) {
        return ((LayoutParams)child.getLayoutParams()).mViewType == 0;
    }

    public DecorToolbar getWrapper() {
        if (this.mWrapper == null) {
            this.mWrapper = new ToolbarWidgetWrapper(this, true);
        }
        return this.mWrapper;
    }

    private void setChildVisibilityForExpandedActionView(boolean expand) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.mViewType == 2 || child == this.mMenuView) continue;
            child.setVisibility(expand ? 8 : 0);
        }
    }

    private void updateChildVisibilityForExpandedActionView(View child) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.mViewType != 2 && child != this.mMenuView) {
            child.setVisibility(this.mExpandedActionView != null ? 8 : 0);
        }
    }

    public void setCollapsible(boolean collapsible) {
        this.mCollapsible = collapsible;
        this.requestLayout();
    }

    public void setMenuCallbacks(MenuPresenter.Callback pcb, MenuBuilder.Callback mcb) {
        this.mActionMenuPresenterCallback = pcb;
        this.mMenuBuilderCallback = mcb;
    }

    ActionMenuPresenter getOuterActionMenuPresenter() {
        return this.mOuterActionMenuPresenter;
    }

    Context getPopupContext() {
        return this.mPopupContext;
    }

    private class ExpandedActionViewMenuPresenter
    implements MenuPresenter {
        MenuBuilder mMenu;
        MenuItemImpl mCurrentExpandedItem;

        private ExpandedActionViewMenuPresenter() {
        }

        @Override
        public void initForMenu(Context context, MenuBuilder menu2) {
            if (this.mMenu != null && this.mCurrentExpandedItem != null) {
                this.mMenu.collapseItemActionView(this.mCurrentExpandedItem);
            }
            this.mMenu = menu2;
        }

        @Override
        public MenuView getMenuView(ViewGroup root) {
            return null;
        }

        @Override
        public void updateMenuView(boolean cleared) {
            if (this.mCurrentExpandedItem != null) {
                boolean found = false;
                if (this.mMenu != null) {
                    int count = this.mMenu.size();
                    for (int i = 0; i < count; ++i) {
                        MenuItem item = this.mMenu.getItem(i);
                        if (item != this.mCurrentExpandedItem) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    this.collapseItemActionView(this.mMenu, this.mCurrentExpandedItem);
                }
            }
        }

        @Override
        public void setCallback(MenuPresenter.Callback cb) {
        }

        @Override
        public boolean onSubMenuSelected(SubMenuBuilder subMenu) {
            return false;
        }

        @Override
        public void onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
        }

        @Override
        public boolean flagActionItems() {
            return false;
        }

        @Override
        public boolean expandItemActionView(MenuBuilder menu2, MenuItemImpl item) {
            Toolbar.this.ensureCollapseButtonView();
            if (Toolbar.this.mCollapseButtonView.getParent() != Toolbar.this) {
                Toolbar.this.addView(Toolbar.this.mCollapseButtonView);
            }
            Toolbar.this.mExpandedActionView = item.getActionView();
            this.mCurrentExpandedItem = item;
            if (Toolbar.this.mExpandedActionView.getParent() != Toolbar.this) {
                LayoutParams lp = Toolbar.this.generateDefaultLayoutParams();
                lp.gravity = 0x800003 | Toolbar.this.mButtonGravity & 0x70;
                lp.mViewType = 2;
                Toolbar.this.mExpandedActionView.setLayoutParams(lp);
                Toolbar.this.addView(Toolbar.this.mExpandedActionView);
            }
            Toolbar.this.setChildVisibilityForExpandedActionView(true);
            Toolbar.this.requestLayout();
            item.setActionViewExpanded(true);
            if (Toolbar.this.mExpandedActionView instanceof CollapsibleActionView) {
                ((CollapsibleActionView)((Object)Toolbar.this.mExpandedActionView)).onActionViewExpanded();
            }
            return true;
        }

        @Override
        public boolean collapseItemActionView(MenuBuilder menu2, MenuItemImpl item) {
            if (Toolbar.this.mExpandedActionView instanceof CollapsibleActionView) {
                ((CollapsibleActionView)((Object)Toolbar.this.mExpandedActionView)).onActionViewCollapsed();
            }
            Toolbar.this.removeView(Toolbar.this.mExpandedActionView);
            Toolbar.this.removeView(Toolbar.this.mCollapseButtonView);
            Toolbar.this.mExpandedActionView = null;
            Toolbar.this.setChildVisibilityForExpandedActionView(false);
            this.mCurrentExpandedItem = null;
            Toolbar.this.requestLayout();
            item.setActionViewExpanded(false);
            return true;
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public Parcelable onSaveInstanceState() {
            return null;
        }

        @Override
        public void onRestoreInstanceState(Parcelable state) {
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public int expandedMenuItemId;
        public boolean isOverflowOpen;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.expandedMenuItemId = source.readInt();
            this.isOverflowOpen = source.readInt() != 0;
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.expandedMenuItemId);
            out.writeInt(this.isOverflowOpen ? 1 : 0);
        }
    }

    public static class LayoutParams
    extends ActionBar.LayoutParams {
        static final int CUSTOM = 0;
        static final int SYSTEM = 1;
        static final int EXPANDED = 2;
        int mViewType = 0;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
            this.gravity = 8388627;
        }

        public LayoutParams(int width, int height, int gravity) {
            super(width, height);
            this.gravity = gravity;
        }

        public LayoutParams(int gravity) {
            this(-2, -1, gravity);
        }

        public LayoutParams(LayoutParams source) {
            super(source);
            this.mViewType = source.mViewType;
        }

        public LayoutParams(ActionBar.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super((ViewGroup.LayoutParams)source);
            this.copyMarginsFrom(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    public static interface OnMenuItemClickListener {
        public boolean onMenuItemClick(MenuItem var1);
    }
}

