/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.DatePickerController;
import android.widget.SimpleMonthView;
import java.util.Calendar;
import java.util.HashMap;

class SimpleMonthAdapter
extends BaseAdapter
implements SimpleMonthView.OnDayClickListener {
    private static final String TAG = "SimpleMonthAdapter";
    private final Context mContext;
    private final DatePickerController mController;
    private Calendar mSelectedDay;
    private ColorStateList mCalendarTextColors;

    public SimpleMonthAdapter(Context context, DatePickerController controller) {
        this.mContext = context;
        this.mController = controller;
        this.init();
        this.setSelectedDay(this.mController.getSelectedDay());
    }

    public void setSelectedDay(Calendar day) {
        if (this.mSelectedDay != day) {
            this.mSelectedDay = day;
            this.notifyDataSetChanged();
        }
    }

    void setCalendarTextColor(ColorStateList colors) {
        this.mCalendarTextColors = colors;
    }

    protected void init() {
        this.mSelectedDay = Calendar.getInstance();
    }

    @Override
    public int getCount() {
        int diffYear = this.mController.getMaxYear() - this.mController.getMinYear();
        int diffMonth = 1 + this.mController.getMaxMonth() - this.mController.getMinMonth() + 12 * diffYear;
        return diffMonth;
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        SimpleMonthView v;
        HashMap drawingParams = null;
        if (convertView != null) {
            v = (SimpleMonthView)convertView;
            drawingParams = (HashMap)v.getTag();
        } else {
            v = new SimpleMonthView(this.mContext);
            AbsListView.LayoutParams params = new AbsListView.LayoutParams(-1, -1);
            v.setLayoutParams(params);
            v.setClickable(true);
            v.setOnDayClickListener(this);
            if (this.mCalendarTextColors != null) {
                v.setTextColor(this.mCalendarTextColors);
            }
        }
        if (drawingParams == null) {
            drawingParams = new HashMap();
        } else {
            drawingParams.clear();
        }
        int currentMonth = position + this.mController.getMinMonth();
        int month = currentMonth % 12;
        int year = currentMonth / 12 + this.mController.getMinYear();
        int selectedDay = -1;
        if (this.isSelectedDayInMonth(year, month)) {
            selectedDay = this.mSelectedDay.get(5);
        }
        v.reuse();
        int enabledDayRangeStart = this.mController.getMinMonth() == month && this.mController.getMinYear() == year ? this.mController.getMinDay() : 1;
        int enabledDayRangeEnd = this.mController.getMaxMonth() == month && this.mController.getMaxYear() == year ? this.mController.getMaxDay() : 31;
        v.setMonthParams(selectedDay, month, year, this.mController.getFirstDayOfWeek(), enabledDayRangeStart, enabledDayRangeEnd);
        v.invalidate();
        return v;
    }

    private boolean isSelectedDayInMonth(int year, int month) {
        return this.mSelectedDay.get(1) == year && this.mSelectedDay.get(2) == month;
    }

    @Override
    public void onDayClick(SimpleMonthView view, Calendar day) {
        if (day != null) {
            this.onDayTapped(day);
        }
    }

    protected void onDayTapped(Calendar day) {
        this.mController.tryVibrate();
        this.mController.onDayOfMonthSelected(day.get(1), day.get(2), day.get(5));
        this.setSelectedDay(day);
    }
}

