/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.TextPaint;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import android.widget.TimePickerClockDelegate;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class RadialTimePickerView
extends View
implements View.OnTouchListener {
    private static final String TAG = "ClockView";
    private static final boolean DEBUG = false;
    private static final int DEBUG_COLOR = 0x20FF0000;
    private static final int DEBUG_TEXT_COLOR = 0x60FF0000;
    private static final int DEBUG_STROKE_WIDTH = 2;
    private static final int HOURS = 0;
    private static final int MINUTES = 1;
    private static final int HOURS_INNER = 2;
    private static final int AMPM = 3;
    private static final int SELECTOR_CIRCLE = 0;
    private static final int SELECTOR_DOT = 1;
    private static final int SELECTOR_LINE = 2;
    private static final int AM = 0;
    private static final int PM = 1;
    private static final int ALPHA_OPAQUE = 255;
    private static final int ALPHA_TRANSPARENT = 0;
    private static final int ALPHA_SELECTOR = 60;
    private static final int ALPHA_AMPM_SELECTED = 60;
    private static final int ALPHA_AMPM_PRESSED = 255;
    private static final float COSINE_30_DEGREES = (float)Math.sqrt(3.0) * 0.5f;
    private static final float SINE_30_DEGREES = 0.5f;
    private static final int DEGREES_FOR_ONE_HOUR = 30;
    private static final int DEGREES_FOR_ONE_MINUTE = 6;
    private static final int[] HOURS_NUMBERS = new int[]{12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] HOURS_NUMBERS_24 = new int[]{0, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] MINUTES_NUMBERS = new int[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
    private static final int CENTER_RADIUS = 2;
    private static final int[] STATE_SET_SELECTED = new int[]{0x10100A1};
    private static int[] sSnapPrefer30sMap = new int[361];
    private final String[] mHours12Texts = new String[12];
    private final String[] mOuterHours24Texts = new String[12];
    private final String[] mInnerHours24Texts = new String[12];
    private final String[] mMinutesTexts = new String[12];
    private final String[] mAmPmText = new String[2];
    private final Paint[] mPaint = new Paint[2];
    private final int[] mColor = new int[2];
    private final IntHolder[] mAlpha = new IntHolder[2];
    private final Paint mPaintCenter = new Paint();
    private final Paint[][] mPaintSelector = new Paint[2][3];
    private final int[][] mColorSelector = new int[2][3];
    private final IntHolder[][] mAlphaSelector = new IntHolder[2][3];
    private final Paint mPaintAmPmText = new Paint();
    private final Paint[] mPaintAmPmCircle = new Paint[2];
    private final Paint mPaintBackground = new Paint();
    private final Paint mPaintDisabled = new Paint();
    private final Paint mPaintDebug = new Paint();
    private Typeface mTypeface;
    private boolean mIs24HourMode;
    private boolean mShowHours;
    private boolean mIsOnInnerCircle;
    private int mXCenter;
    private int mYCenter;
    private float[] mCircleRadius = new float[3];
    private int mMinHypotenuseForInnerNumber;
    private int mMaxHypotenuseForOuterNumber;
    private int mHalfwayHypotenusePoint;
    private float[] mTextSize = new float[2];
    private float mInnerTextSize;
    private float[][] mTextGridHeights = new float[2][7];
    private float[][] mTextGridWidths = new float[2][7];
    private float[] mInnerTextGridHeights = new float[7];
    private float[] mInnerTextGridWidths = new float[7];
    private String[] mOuterTextHours;
    private String[] mInnerTextHours;
    private String[] mOuterTextMinutes;
    private float[] mCircleRadiusMultiplier = new float[2];
    private float[] mNumbersRadiusMultiplier = new float[3];
    private float[] mTextSizeMultiplier = new float[3];
    private float[] mAnimationRadiusMultiplier = new float[3];
    private float mTransitionMidRadiusMultiplier;
    private float mTransitionEndRadiusMultiplier;
    private AnimatorSet mTransition;
    private InvalidateUpdateListener mInvalidateUpdateListener = new InvalidateUpdateListener();
    private int[] mLineLength = new int[3];
    private int[] mSelectionRadius = new int[3];
    private float mSelectionRadiusMultiplier;
    private int[] mSelectionDegrees = new int[3];
    private int mAmPmCircleRadius;
    private float mAmPmYCenter;
    private float mAmPmCircleRadiusMultiplier;
    private int mAmPmTextColor;
    private float mLeftIndicatorXCenter;
    private float mRightIndicatorXCenter;
    private int mAmPmUnselectedColor;
    private int mAmPmSelectedColor;
    private int mAmOrPm;
    private int mAmOrPmPressed;
    private int mDisabledAlpha;
    private RectF mRectF = new RectF();
    private boolean mInputEnabled = true;
    private OnValueSelectedListener mListener;
    private final ArrayList<Animator> mHoursToMinutesAnims = new ArrayList();
    private final ArrayList<Animator> mMinuteToHoursAnims = new ArrayList();

    private static void preparePrefer30sMap() {
        int snappedOutputDegrees = 0;
        int count = 1;
        int expectedCount = 8;
        for (int degrees = 0; degrees < 361; ++degrees) {
            RadialTimePickerView.sSnapPrefer30sMap[degrees] = snappedOutputDegrees;
            if (count == expectedCount) {
                expectedCount = (snappedOutputDegrees += 6) == 360 ? 7 : (snappedOutputDegrees % 30 == 0 ? 14 : 4);
                count = 1;
                continue;
            }
            ++count;
        }
    }

    private static int snapPrefer30s(int degrees) {
        if (sSnapPrefer30sMap == null) {
            return -1;
        }
        return sSnapPrefer30sMap[degrees];
    }

    private static int snapOnly30s(int degrees, int forceHigherOrLower) {
        int stepSize = 30;
        int floor = degrees / 30 * 30;
        int ceiling = floor + 30;
        if (forceHigherOrLower == 1) {
            degrees = ceiling;
        } else if (forceHigherOrLower == -1) {
            if (degrees == floor) {
                floor -= 30;
            }
            degrees = floor;
        } else {
            degrees = degrees - floor < ceiling - degrees ? floor : ceiling;
        }
        return degrees;
    }

    public RadialTimePickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 16843933);
    }

    public RadialTimePickerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        int i;
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(0x1010033, outValue, true);
        this.mDisabledAlpha = (int)(outValue.getFloat() * 255.0f + 0.5f);
        Resources res = this.getResources();
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyle, 0);
        ColorStateList amPmBackgroundColor = a.getColorStateList(7);
        if (amPmBackgroundColor == null) {
            amPmBackgroundColor = res.getColorStateList(17170668);
        }
        int amPmSelectedColor = a.getColor(12, res.getColor(17170667));
        amPmBackgroundColor = ColorStateList.addFirstIfMissing(amPmBackgroundColor, 0x10100A1, amPmSelectedColor);
        this.mAmPmSelectedColor = amPmBackgroundColor.getColorForState(STATE_SET_SELECTED, amPmSelectedColor);
        this.mAmPmUnselectedColor = amPmBackgroundColor.getDefaultColor();
        this.mAmPmTextColor = a.getColor(6, res.getColor(17170666));
        this.mTypeface = Typeface.create("sans-serif", 0);
        for (i = 0; i < this.mAlpha.length; ++i) {
            this.mAlpha[i] = new IntHolder(255);
        }
        for (i = 0; i < this.mAlphaSelector.length; ++i) {
            for (int j = 0; j < this.mAlphaSelector[i].length; ++j) {
                this.mAlphaSelector[i][j] = new IntHolder(255);
            }
        }
        int numbersTextColor = a.getColor(3, res.getColor(17170666));
        this.mPaint[0] = new Paint();
        this.mPaint[0].setAntiAlias(true);
        this.mPaint[0].setTextAlign(Paint.Align.CENTER);
        this.mColor[0] = numbersTextColor;
        this.mPaint[1] = new Paint();
        this.mPaint[1].setAntiAlias(true);
        this.mPaint[1].setTextAlign(Paint.Align.CENTER);
        this.mColor[1] = numbersTextColor;
        this.mPaintCenter.setColor(numbersTextColor);
        this.mPaintCenter.setAntiAlias(true);
        this.mPaintCenter.setTextAlign(Paint.Align.CENTER);
        this.mPaintSelector[0][0] = new Paint();
        this.mPaintSelector[0][0].setAntiAlias(true);
        this.mColorSelector[0][0] = a.getColor(5, 17170669);
        this.mPaintSelector[0][1] = new Paint();
        this.mPaintSelector[0][1].setAntiAlias(true);
        this.mColorSelector[0][1] = a.getColor(5, 17170669);
        this.mPaintSelector[0][2] = new Paint();
        this.mPaintSelector[0][2].setAntiAlias(true);
        this.mPaintSelector[0][2].setStrokeWidth(2.0f);
        this.mColorSelector[0][2] = a.getColor(5, 17170669);
        this.mPaintSelector[1][0] = new Paint();
        this.mPaintSelector[1][0].setAntiAlias(true);
        this.mColorSelector[1][0] = a.getColor(5, 17170669);
        this.mPaintSelector[1][1] = new Paint();
        this.mPaintSelector[1][1].setAntiAlias(true);
        this.mColorSelector[1][1] = a.getColor(5, 17170669);
        this.mPaintSelector[1][2] = new Paint();
        this.mPaintSelector[1][2].setAntiAlias(true);
        this.mPaintSelector[1][2].setStrokeWidth(2.0f);
        this.mColorSelector[1][2] = a.getColor(5, 17170669);
        this.mPaintAmPmText.setColor(this.mAmPmTextColor);
        this.mPaintAmPmText.setTypeface(this.mTypeface);
        this.mPaintAmPmText.setAntiAlias(true);
        this.mPaintAmPmText.setTextAlign(Paint.Align.CENTER);
        this.mPaintAmPmCircle[0] = new Paint();
        this.mPaintAmPmCircle[0].setAntiAlias(true);
        this.mPaintAmPmCircle[1] = new Paint();
        this.mPaintAmPmCircle[1].setAntiAlias(true);
        this.mPaintBackground.setColor(a.getColor(4, res.getColor(17170670)));
        this.mPaintBackground.setAntiAlias(true);
        this.mShowHours = true;
        this.mIs24HourMode = false;
        this.mAmOrPm = 0;
        this.mAmOrPmPressed = -1;
        this.initHoursAndMinutesText();
        this.initData();
        this.mTransitionMidRadiusMultiplier = Float.parseFloat(res.getString(17039441));
        this.mTransitionEndRadiusMultiplier = Float.parseFloat(res.getString(17039442));
        this.mTextGridHeights[0] = new float[7];
        this.mTextGridHeights[1] = new float[7];
        this.mSelectionRadiusMultiplier = Float.parseFloat(res.getString(17039433));
        a.recycle();
        this.setOnTouchListener(this);
        this.setClickable(true);
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        int currentHour = calendar.get(11);
        int currentMinute = calendar.get(12);
        this.setCurrentHour(currentHour);
        this.setCurrentMinute(currentMinute);
        this.setHapticFeedbackEnabled(true);
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = View.MeasureSpec.getSize(widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int measuredHeight = View.MeasureSpec.getSize(heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int minDimension = Math.min(measuredWidth, measuredHeight);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec(minDimension, widthMode), View.MeasureSpec.makeMeasureSpec(minDimension, heightMode));
    }

    public void initialize(int hour, int minute, boolean is24HourMode) {
        this.mIs24HourMode = is24HourMode;
        this.setCurrentHour(hour);
        this.setCurrentMinute(minute);
    }

    public void setCurrentItemShowing(int item, boolean animate) {
        switch (item) {
            case 0: {
                this.showHours(animate);
                break;
            }
            case 1: {
                this.showMinutes(animate);
                break;
            }
            default: {
                Log.e(TAG, "ClockView does not support showing item " + item);
            }
        }
    }

    public int getCurrentItemShowing() {
        return this.mShowHours ? 0 : 1;
    }

    public void setOnValueSelectedListener(OnValueSelectedListener listener) {
        this.mListener = listener;
    }

    public void setCurrentHour(int hour) {
        int degrees;
        this.mSelectionDegrees[0] = degrees = hour % 12 * 30;
        this.mSelectionDegrees[2] = degrees;
        int n = this.mAmOrPm = hour == 0 || hour % 24 < 12 ? 0 : 1;
        this.mIsOnInnerCircle = this.mIs24HourMode ? hour >= 1 && hour <= 12 : false;
        this.initData();
        this.updateLayoutData();
        this.invalidate();
    }

    public int getCurrentHour() {
        int hour = this.mSelectionDegrees[this.mIsOnInnerCircle ? 2 : 0] / 30 % 12;
        if (this.mIs24HourMode) {
            if (this.mIsOnInnerCircle && hour == 0) {
                hour = 12;
            } else if (!this.mIsOnInnerCircle && hour != 0) {
                hour += 12;
            }
        } else if (this.mAmOrPm == 1) {
            hour += 12;
        }
        return hour;
    }

    public void setCurrentMinute(int minute) {
        this.mSelectionDegrees[1] = minute % 60 * 6;
        this.invalidate();
    }

    public int getCurrentMinute() {
        return this.mSelectionDegrees[1] / 6;
    }

    public void setAmOrPm(int val) {
        this.mAmOrPm = val % 2;
        this.invalidate();
    }

    public int getAmOrPm() {
        return this.mAmOrPm;
    }

    public void swapAmPm() {
        this.mAmOrPm = this.mAmOrPm == 0 ? 1 : 0;
        this.invalidate();
    }

    public void showHours(boolean animate) {
        if (this.mShowHours) {
            return;
        }
        this.mShowHours = true;
        if (animate) {
            this.startMinutesToHoursAnimation();
        }
        this.initData();
        this.updateLayoutData();
        this.invalidate();
    }

    public void showMinutes(boolean animate) {
        if (!this.mShowHours) {
            return;
        }
        this.mShowHours = false;
        if (animate) {
            this.startHoursToMinutesAnimation();
        }
        this.initData();
        this.updateLayoutData();
        this.invalidate();
    }

    private void initHoursAndMinutesText() {
        for (int i = 0; i < 12; ++i) {
            this.mHours12Texts[i] = String.format("%d", HOURS_NUMBERS[i]);
            this.mOuterHours24Texts[i] = String.format("%02d", HOURS_NUMBERS_24[i]);
            this.mInnerHours24Texts[i] = String.format("%d", HOURS_NUMBERS[i]);
            this.mMinutesTexts[i] = String.format("%02d", MINUTES_NUMBERS[i]);
        }
        String[] amPmStrings = TimePickerClockDelegate.getAmPmStrings(this.mContext);
        this.mAmPmText[0] = amPmStrings[0];
        this.mAmPmText[1] = amPmStrings[1];
    }

    private void initData() {
        if (this.mIs24HourMode) {
            this.mOuterTextHours = this.mOuterHours24Texts;
            this.mInnerTextHours = this.mInnerHours24Texts;
        } else {
            this.mOuterTextHours = this.mHours12Texts;
            this.mInnerTextHours = null;
        }
        this.mOuterTextMinutes = this.mMinutesTexts;
        Resources res = this.getResources();
        if (this.mShowHours) {
            if (this.mIs24HourMode) {
                this.mCircleRadiusMultiplier[0] = Float.parseFloat(res.getString(17039432));
                this.mNumbersRadiusMultiplier[0] = Float.parseFloat(res.getString(17039437));
                this.mTextSizeMultiplier[0] = Float.parseFloat(res.getString(17039440));
                this.mNumbersRadiusMultiplier[2] = Float.parseFloat(res.getString(17039436));
                this.mTextSizeMultiplier[2] = Float.parseFloat(res.getString(17039439));
            } else {
                this.mCircleRadiusMultiplier[0] = Float.parseFloat(res.getString(17039431));
                this.mNumbersRadiusMultiplier[0] = Float.parseFloat(res.getString(17039435));
                this.mTextSizeMultiplier[0] = Float.parseFloat(res.getString(17039438));
            }
        } else {
            this.mCircleRadiusMultiplier[1] = Float.parseFloat(res.getString(17039431));
            this.mNumbersRadiusMultiplier[1] = Float.parseFloat(res.getString(17039435));
            this.mTextSizeMultiplier[1] = Float.parseFloat(res.getString(17039438));
        }
        this.mAnimationRadiusMultiplier[0] = 1.0f;
        this.mAnimationRadiusMultiplier[2] = 1.0f;
        this.mAnimationRadiusMultiplier[1] = 1.0f;
        this.mAmPmCircleRadiusMultiplier = Float.parseFloat(res.getString(17039434));
        this.mAlpha[0].setValue(this.mShowHours ? 255 : 0);
        this.mAlpha[1].setValue(this.mShowHours ? 0 : 255);
        this.mAlphaSelector[0][0].setValue(this.mShowHours ? 60 : 0);
        this.mAlphaSelector[0][1].setValue(this.mShowHours ? 255 : 0);
        this.mAlphaSelector[0][2].setValue(this.mShowHours ? 60 : 0);
        this.mAlphaSelector[1][0].setValue(this.mShowHours ? 0 : 60);
        this.mAlphaSelector[1][1].setValue(this.mShowHours ? 0 : 255);
        this.mAlphaSelector[1][2].setValue(this.mShowHours ? 0 : 60);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.updateLayoutData();
    }

    private void updateLayoutData() {
        this.mXCenter = this.getWidth() / 2;
        this.mYCenter = this.getHeight() / 2;
        int min = Math.min(this.mXCenter, this.mYCenter);
        this.mCircleRadius[0] = (float)min * this.mCircleRadiusMultiplier[0];
        this.mCircleRadius[2] = (float)min * this.mCircleRadiusMultiplier[0];
        this.mCircleRadius[1] = (float)min * this.mCircleRadiusMultiplier[1];
        if (!this.mIs24HourMode) {
            int amPmCircleRadius = (int)(this.mCircleRadius[0] * this.mAmPmCircleRadiusMultiplier);
            this.mYCenter -= amPmCircleRadius / 2;
        }
        this.mMinHypotenuseForInnerNumber = (int)(this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[2]) - this.mSelectionRadius[0];
        this.mMaxHypotenuseForOuterNumber = (int)(this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[0]) + this.mSelectionRadius[0];
        this.mHalfwayHypotenusePoint = (int)(this.mCircleRadius[0] * ((this.mNumbersRadiusMultiplier[0] + this.mNumbersRadiusMultiplier[2]) / 2.0f));
        this.mTextSize[0] = this.mCircleRadius[0] * this.mTextSizeMultiplier[0];
        this.mTextSize[1] = this.mCircleRadius[1] * this.mTextSizeMultiplier[1];
        if (this.mIs24HourMode) {
            this.mInnerTextSize = this.mCircleRadius[0] * this.mTextSizeMultiplier[2];
        }
        this.calculateGridSizesHours();
        this.calculateGridSizesMinutes();
        this.mSelectionRadius[0] = (int)(this.mCircleRadius[0] * this.mSelectionRadiusMultiplier);
        this.mSelectionRadius[2] = this.mSelectionRadius[0];
        this.mSelectionRadius[1] = (int)(this.mCircleRadius[1] * this.mSelectionRadiusMultiplier);
        this.mAmPmCircleRadius = (int)(this.mCircleRadius[0] * this.mAmPmCircleRadiusMultiplier);
        this.mPaintAmPmText.setTextSize(this.mAmPmCircleRadius * 3 / 4);
        this.mAmPmYCenter = (float)this.mYCenter + this.mCircleRadius[0];
        this.mLeftIndicatorXCenter = (float)this.mXCenter - this.mCircleRadius[0] + (float)this.mAmPmCircleRadius;
        this.mRightIndicatorXCenter = (float)this.mXCenter + this.mCircleRadius[0] - (float)this.mAmPmCircleRadius;
    }

    @Override
    public void onDraw(Canvas canvas) {
        if (!this.mInputEnabled) {
            canvas.saveLayerAlpha(0.0f, 0.0f, this.getWidth(), this.getHeight(), this.mDisabledAlpha);
        } else {
            canvas.save();
        }
        this.calculateGridSizesHours();
        this.calculateGridSizesMinutes();
        this.drawCircleBackground(canvas);
        this.drawSelector(canvas);
        this.drawTextElements(canvas, this.mTextSize[0], this.mTypeface, this.mOuterTextHours, this.mTextGridWidths[0], this.mTextGridHeights[0], this.mPaint[0], this.mColor[0], this.mAlpha[0].getValue());
        if (this.mIs24HourMode && this.mInnerTextHours != null) {
            this.drawTextElements(canvas, this.mInnerTextSize, this.mTypeface, this.mInnerTextHours, this.mInnerTextGridWidths, this.mInnerTextGridHeights, this.mPaint[0], this.mColor[0], this.mAlpha[0].getValue());
        }
        this.drawTextElements(canvas, this.mTextSize[1], this.mTypeface, this.mOuterTextMinutes, this.mTextGridWidths[1], this.mTextGridHeights[1], this.mPaint[1], this.mColor[1], this.mAlpha[1].getValue());
        this.drawCenter(canvas);
        if (!this.mIs24HourMode) {
            this.drawAmPm(canvas);
        }
        canvas.restore();
    }

    private void drawCircleBackground(Canvas canvas) {
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCircleRadius[0], this.mPaintBackground);
    }

    private void drawCenter(Canvas canvas) {
        canvas.drawCircle(this.mXCenter, this.mYCenter, 2.0f, this.mPaintCenter);
    }

    private void drawSelector(Canvas canvas) {
        this.drawSelector(canvas, this.mIsOnInnerCircle ? 2 : 0);
        this.drawSelector(canvas, 1);
    }

    private void drawAmPm(Canvas canvas) {
        boolean isLayoutRtl = this.isLayoutRtl();
        int amColor = this.mAmPmUnselectedColor;
        int amAlpha = 255;
        int pmColor = this.mAmPmUnselectedColor;
        int pmAlpha = 255;
        if (this.mAmOrPm == 0) {
            amColor = this.mAmPmSelectedColor;
            amAlpha = 60;
        } else if (this.mAmOrPm == 1) {
            pmColor = this.mAmPmSelectedColor;
            pmAlpha = 60;
        }
        if (this.mAmOrPmPressed == 0) {
            amColor = this.mAmPmSelectedColor;
            amAlpha = 255;
        } else if (this.mAmOrPmPressed == 1) {
            pmColor = this.mAmPmSelectedColor;
            pmAlpha = 255;
        }
        this.mPaintAmPmCircle[0].setColor(amColor);
        this.mPaintAmPmCircle[0].setAlpha(this.getMultipliedAlpha(amColor, amAlpha));
        canvas.drawCircle(isLayoutRtl ? this.mRightIndicatorXCenter : this.mLeftIndicatorXCenter, this.mAmPmYCenter, this.mAmPmCircleRadius, this.mPaintAmPmCircle[0]);
        this.mPaintAmPmCircle[1].setColor(pmColor);
        this.mPaintAmPmCircle[1].setAlpha(this.getMultipliedAlpha(pmColor, pmAlpha));
        canvas.drawCircle(isLayoutRtl ? this.mLeftIndicatorXCenter : this.mRightIndicatorXCenter, this.mAmPmYCenter, this.mAmPmCircleRadius, this.mPaintAmPmCircle[1]);
        this.mPaintAmPmText.setColor(this.mAmPmTextColor);
        float textYCenter = this.mAmPmYCenter - (float)((int)(this.mPaintAmPmText.descent() + this.mPaintAmPmText.ascent()) / 2);
        canvas.drawText(isLayoutRtl ? this.mAmPmText[1] : this.mAmPmText[0], this.mLeftIndicatorXCenter, textYCenter, this.mPaintAmPmText);
        canvas.drawText(isLayoutRtl ? this.mAmPmText[0] : this.mAmPmText[1], this.mRightIndicatorXCenter, textYCenter, this.mPaintAmPmText);
    }

    private int getMultipliedAlpha(int argb, int alpha) {
        return (int)((double)Color.alpha(argb) * ((double)alpha / 255.0) + 0.5);
    }

    private void drawSelector(Canvas canvas, int index) {
        this.mLineLength[index] = (int)(this.mCircleRadius[index] * this.mNumbersRadiusMultiplier[index] * this.mAnimationRadiusMultiplier[index]);
        double selectionRadians = Math.toRadians(this.mSelectionDegrees[index]);
        int pointX = this.mXCenter + (int)((double)this.mLineLength[index] * Math.sin(selectionRadians));
        int pointY = this.mYCenter - (int)((double)this.mLineLength[index] * Math.cos(selectionRadians));
        int color2 = this.mColorSelector[index % 2][0];
        int alpha = this.mAlphaSelector[index % 2][0].getValue();
        Paint paint = this.mPaintSelector[index % 2][0];
        paint.setColor(color2);
        paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
        canvas.drawCircle(pointX, pointY, this.mSelectionRadius[index], paint);
        if (this.mSelectionDegrees[index] % 30 != 0) {
            color2 = this.mColorSelector[index % 2][1];
            alpha = this.mAlphaSelector[index % 2][1].getValue();
            paint = this.mPaintSelector[index % 2][1];
            paint.setColor(color2);
            paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
            canvas.drawCircle(pointX, pointY, this.mSelectionRadius[index] * 2 / 7, paint);
        } else {
            int lineLength = this.mLineLength[index] - this.mSelectionRadius[index];
            pointX = this.mXCenter + (int)((double)lineLength * Math.sin(selectionRadians));
            pointY = this.mYCenter - (int)((double)lineLength * Math.cos(selectionRadians));
        }
        color2 = this.mColorSelector[index % 2][2];
        alpha = this.mAlphaSelector[index % 2][2].getValue();
        paint = this.mPaintSelector[index % 2][2];
        paint.setColor(color2);
        paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
        canvas.drawLine(this.mXCenter, this.mYCenter, pointX, pointY, paint);
    }

    private void drawDebug(Canvas canvas) {
        float outerRadius = this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[0];
        canvas.drawCircle(this.mXCenter, this.mYCenter, outerRadius, this.mPaintDebug);
        float innerRadius = this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[2];
        canvas.drawCircle(this.mXCenter, this.mYCenter, innerRadius, this.mPaintDebug);
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCircleRadius[0], this.mPaintDebug);
        float left = (float)this.mXCenter - outerRadius;
        float top = (float)this.mYCenter - outerRadius;
        float right = (float)this.mXCenter + outerRadius;
        float bottom = (float)this.mYCenter + outerRadius;
        this.mRectF = new RectF(left, top, right, bottom);
        canvas.drawRect(this.mRectF, this.mPaintDebug);
        left = (float)this.mXCenter - this.mCircleRadius[0];
        top = (float)this.mYCenter - this.mCircleRadius[0];
        right = (float)this.mXCenter + this.mCircleRadius[0];
        bottom = (float)this.mYCenter + this.mCircleRadius[0];
        this.mRectF.set(left, top, right, bottom);
        canvas.drawRect(this.mRectF, this.mPaintDebug);
        this.mRectF.set(0.0f, 0.0f, this.getWidth(), this.getHeight());
        canvas.drawRect(this.mRectF, this.mPaintDebug);
        String selected = String.format("%02d:%02d", this.getCurrentHour(), this.getCurrentMinute());
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-2, -2);
        TextView tv = new TextView(this.getContext());
        tv.setLayoutParams(lp);
        tv.setText(selected);
        tv.measure(0, 0);
        TextPaint paint = tv.getPaint();
        paint.setColor(0x60FF0000);
        int width = tv.getMeasuredWidth();
        float height = paint.descent() - paint.ascent();
        float x = this.mXCenter - width / 2;
        float y = (float)this.mYCenter + 1.5f * height;
        canvas.drawText(selected.toString(), x, y, paint);
    }

    private void calculateGridSizesHours() {
        float numbersRadius = this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[0] * this.mAnimationRadiusMultiplier[0];
        RadialTimePickerView.calculateGridSizes(this.mPaint[0], numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[0], this.mTextGridHeights[0], this.mTextGridWidths[0]);
        if (this.mIs24HourMode) {
            float innerNumbersRadius = this.mCircleRadius[2] * this.mNumbersRadiusMultiplier[2] * this.mAnimationRadiusMultiplier[2];
            RadialTimePickerView.calculateGridSizes(this.mPaint[0], innerNumbersRadius, this.mXCenter, this.mYCenter, this.mInnerTextSize, this.mInnerTextGridHeights, this.mInnerTextGridWidths);
        }
    }

    private void calculateGridSizesMinutes() {
        float numbersRadius = this.mCircleRadius[1] * this.mNumbersRadiusMultiplier[1] * this.mAnimationRadiusMultiplier[1];
        RadialTimePickerView.calculateGridSizes(this.mPaint[1], numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[1], this.mTextGridHeights[1], this.mTextGridWidths[1]);
    }

    private static void calculateGridSizes(Paint paint, float numbersRadius, float xCenter, float yCenter, float textSize, float[] textGridHeights, float[] textGridWidths) {
        float offset1 = numbersRadius;
        float offset2 = numbersRadius * COSINE_30_DEGREES;
        float offset3 = numbersRadius * 0.5f;
        paint.setTextSize(textSize);
        textGridHeights[0] = (yCenter -= (paint.descent() + paint.ascent()) / 2.0f) - offset1;
        textGridWidths[0] = xCenter - offset1;
        textGridHeights[1] = yCenter - offset2;
        textGridWidths[1] = xCenter - offset2;
        textGridHeights[2] = yCenter - offset3;
        textGridWidths[2] = xCenter - offset3;
        textGridHeights[3] = yCenter;
        textGridWidths[3] = xCenter;
        textGridHeights[4] = yCenter + offset3;
        textGridWidths[4] = xCenter + offset3;
        textGridHeights[5] = yCenter + offset2;
        textGridWidths[5] = xCenter + offset2;
        textGridHeights[6] = yCenter + offset1;
        textGridWidths[6] = xCenter + offset1;
    }

    private void drawTextElements(Canvas canvas, float textSize, Typeface typeface, String[] texts, float[] textGridWidths, float[] textGridHeights, Paint paint, int color2, int alpha) {
        paint.setTextSize(textSize);
        paint.setTypeface(typeface);
        paint.setColor(color2);
        paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
        canvas.drawText(texts[0], textGridWidths[3], textGridHeights[0], paint);
        canvas.drawText(texts[1], textGridWidths[4], textGridHeights[1], paint);
        canvas.drawText(texts[2], textGridWidths[5], textGridHeights[2], paint);
        canvas.drawText(texts[3], textGridWidths[6], textGridHeights[3], paint);
        canvas.drawText(texts[4], textGridWidths[5], textGridHeights[4], paint);
        canvas.drawText(texts[5], textGridWidths[4], textGridHeights[5], paint);
        canvas.drawText(texts[6], textGridWidths[3], textGridHeights[6], paint);
        canvas.drawText(texts[7], textGridWidths[2], textGridHeights[5], paint);
        canvas.drawText(texts[8], textGridWidths[1], textGridHeights[4], paint);
        canvas.drawText(texts[9], textGridWidths[0], textGridHeights[3], paint);
        canvas.drawText(texts[10], textGridWidths[1], textGridHeights[2], paint);
        canvas.drawText(texts[11], textGridWidths[2], textGridHeights[1], paint);
    }

    private void setAnimationRadiusMultiplierHours(float animationRadiusMultiplier) {
        this.mAnimationRadiusMultiplier[0] = animationRadiusMultiplier;
        this.mAnimationRadiusMultiplier[2] = animationRadiusMultiplier;
    }

    private void setAnimationRadiusMultiplierMinutes(float animationRadiusMultiplier) {
        this.mAnimationRadiusMultiplier[1] = animationRadiusMultiplier;
    }

    private static ObjectAnimator getRadiusDisappearAnimator(Object target, String radiusPropertyName, InvalidateUpdateListener updateListener, float midRadiusMultiplier, float endRadiusMultiplier) {
        float midwayPoint = 0.2f;
        int duration = 500;
        Keyframe kf0 = Keyframe.ofFloat(0.0f, 1.0f);
        Keyframe kf1 = Keyframe.ofFloat(midwayPoint, midRadiusMultiplier);
        Keyframe kf2 = Keyframe.ofFloat(1.0f, endRadiusMultiplier);
        PropertyValuesHolder radiusDisappear = PropertyValuesHolder.ofKeyframe(radiusPropertyName, kf0, kf1, kf2);
        ObjectAnimator animator2 = ObjectAnimator.ofPropertyValuesHolder(target, radiusDisappear).setDuration(duration);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private static ObjectAnimator getRadiusReappearAnimator(Object target, String radiusPropertyName, InvalidateUpdateListener updateListener, float midRadiusMultiplier, float endRadiusMultiplier) {
        float midwayPoint = 0.2f;
        int duration = 500;
        float delayMultiplier = 0.25f;
        float transitionDurationMultiplier = 1.0f;
        float totalDurationMultiplier = transitionDurationMultiplier + delayMultiplier;
        int totalDuration = (int)((float)duration * totalDurationMultiplier);
        float delayPoint = delayMultiplier * (float)duration / (float)totalDuration;
        midwayPoint = 1.0f - midwayPoint * (1.0f - delayPoint);
        Keyframe kf0 = Keyframe.ofFloat(0.0f, endRadiusMultiplier);
        Keyframe kf1 = Keyframe.ofFloat(delayPoint, endRadiusMultiplier);
        Keyframe kf2 = Keyframe.ofFloat(midwayPoint, midRadiusMultiplier);
        Keyframe kf3 = Keyframe.ofFloat(1.0f, 1.0f);
        PropertyValuesHolder radiusReappear = PropertyValuesHolder.ofKeyframe(radiusPropertyName, kf0, kf1, kf2, kf3);
        ObjectAnimator animator2 = ObjectAnimator.ofPropertyValuesHolder(target, radiusReappear).setDuration(totalDuration);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private static ObjectAnimator getFadeOutAnimator(IntHolder target, int startAlpha, int endAlpha, InvalidateUpdateListener updateListener) {
        int duration = 500;
        ObjectAnimator animator2 = ObjectAnimator.ofInt((Object)target, "value", startAlpha, endAlpha);
        animator2.setDuration(duration);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private static ObjectAnimator getFadeInAnimator(IntHolder target, int startAlpha, int endAlpha, InvalidateUpdateListener updateListener) {
        int duration = 500;
        float delayMultiplier = 0.25f;
        float transitionDurationMultiplier = 1.0f;
        float totalDurationMultiplier = transitionDurationMultiplier + delayMultiplier;
        int totalDuration = (int)((float)duration * totalDurationMultiplier);
        float delayPoint = delayMultiplier * (float)duration / (float)totalDuration;
        Keyframe kf0 = Keyframe.ofInt(0.0f, startAlpha);
        Keyframe kf1 = Keyframe.ofInt(delayPoint, startAlpha);
        Keyframe kf2 = Keyframe.ofInt(1.0f, endAlpha);
        PropertyValuesHolder fadeIn = PropertyValuesHolder.ofKeyframe("value", kf0, kf1, kf2);
        ObjectAnimator animator2 = ObjectAnimator.ofPropertyValuesHolder(target, fadeIn).setDuration(totalDuration);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private void startHoursToMinutesAnimation() {
        if (this.mHoursToMinutesAnims.size() == 0) {
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getRadiusDisappearAnimator(this, "animationRadiusMultiplierHours", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlpha[0], 255, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[0][0], 60, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[0][1], 255, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[0][2], 60, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getRadiusReappearAnimator(this, "animationRadiusMultiplierMinutes", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlpha[1], 0, 255, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[1][0], 0, 60, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[1][1], 0, 255, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[1][2], 0, 60, this.mInvalidateUpdateListener));
        }
        if (this.mTransition != null && this.mTransition.isRunning()) {
            this.mTransition.end();
        }
        this.mTransition = new AnimatorSet();
        this.mTransition.playTogether(this.mHoursToMinutesAnims);
        this.mTransition.start();
    }

    private void startMinutesToHoursAnimation() {
        if (this.mMinuteToHoursAnims.size() == 0) {
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getRadiusDisappearAnimator(this, "animationRadiusMultiplierMinutes", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlpha[1], 255, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[1][0], 60, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[1][1], 255, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[1][2], 60, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getRadiusReappearAnimator(this, "animationRadiusMultiplierHours", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlpha[0], 0, 255, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[0][0], 0, 60, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[0][1], 0, 255, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[0][2], 0, 60, this.mInvalidateUpdateListener));
        }
        if (this.mTransition != null && this.mTransition.isRunning()) {
            this.mTransition.end();
        }
        this.mTransition = new AnimatorSet();
        this.mTransition.playTogether(this.mMinuteToHoursAnims);
        this.mTransition.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getDegreesFromXY(float x, float y) {
        boolean topSide;
        double hypotenuse = Math.sqrt((y - (float)this.mYCenter) * (y - (float)this.mYCenter) + (x - (float)this.mXCenter) * (x - (float)this.mXCenter));
        if (hypotenuse > (double)this.mCircleRadius[0]) {
            return -1;
        }
        if (this.mIs24HourMode && this.mShowHours) {
            if (hypotenuse >= (double)this.mMinHypotenuseForInnerNumber && hypotenuse <= (double)this.mHalfwayHypotenusePoint) {
                this.mIsOnInnerCircle = true;
            } else {
                if (!(hypotenuse <= (double)this.mMaxHypotenuseForOuterNumber) || !(hypotenuse >= (double)this.mHalfwayHypotenusePoint)) return -1;
                this.mIsOnInnerCircle = false;
            }
        } else {
            int maxAllowedDistance;
            int index = this.mShowHours ? 0 : 1;
            float length = this.mCircleRadius[index] * this.mNumbersRadiusMultiplier[index];
            int distanceToNumber = (int)Math.abs(hypotenuse - (double)length);
            if (distanceToNumber > (maxAllowedDistance = (int)(this.mCircleRadius[index] * (1.0f - this.mNumbersRadiusMultiplier[index])))) {
                return -1;
            }
        }
        float opposite = Math.abs(y - (float)this.mYCenter);
        double degrees = Math.toDegrees(Math.asin((double)opposite / hypotenuse));
        boolean rightSide = x > (float)this.mXCenter;
        boolean bl = topSide = y < (float)this.mYCenter;
        if (rightSide && topSide) {
            degrees = 90.0 - degrees;
            return (int)degrees;
        } else if (rightSide && !topSide) {
            degrees = 90.0 + degrees;
            return (int)degrees;
        } else if (!rightSide && !topSide) {
            degrees = 270.0 - degrees;
            return (int)degrees;
        } else {
            if (rightSide || !topSide) return (int)degrees;
            degrees = 270.0 + degrees;
        }
        return (int)degrees;
    }

    private int getIsTouchingAmOrPm(float x, float y) {
        boolean isLayoutRtl = this.isLayoutRtl();
        int squaredYDistance = (int)((y - this.mAmPmYCenter) * (y - this.mAmPmYCenter));
        int distanceToAmCenter = (int)Math.sqrt((x - this.mLeftIndicatorXCenter) * (x - this.mLeftIndicatorXCenter) + (float)squaredYDistance);
        if (distanceToAmCenter <= this.mAmPmCircleRadius) {
            return isLayoutRtl ? 1 : 0;
        }
        int distanceToPmCenter = (int)Math.sqrt((x - this.mRightIndicatorXCenter) * (x - this.mRightIndicatorXCenter) + (float)squaredYDistance);
        if (distanceToPmCenter <= this.mAmPmCircleRadius) {
            return isLayoutRtl ? 0 : 1;
        }
        return -1;
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        if (!this.mInputEnabled) {
            return true;
        }
        float eventX = event.getX();
        float eventY = event.getY();
        boolean result = false;
        switch (event.getAction()) {
            case 0: 
            case 2: {
                this.mAmOrPmPressed = this.getIsTouchingAmOrPm(eventX, eventY);
                if (this.mAmOrPmPressed != -1) {
                    result = true;
                } else {
                    int degrees = this.getDegreesFromXY(eventX, eventY);
                    if (degrees != -1) {
                        int snapDegrees = (this.mShowHours ? RadialTimePickerView.snapOnly30s(degrees, 0) : RadialTimePickerView.snapPrefer30s(degrees)) % 360;
                        if (this.mShowHours) {
                            this.mSelectionDegrees[0] = snapDegrees;
                            this.mSelectionDegrees[2] = snapDegrees;
                        } else {
                            this.mSelectionDegrees[1] = snapDegrees;
                        }
                        this.performHapticFeedback(4);
                        if (this.mListener != null) {
                            if (this.mShowHours) {
                                this.mListener.onValueSelected(0, this.getCurrentHour(), false);
                            } else {
                                this.mListener.onValueSelected(1, this.getCurrentMinute(), false);
                            }
                        }
                        result = true;
                    }
                }
                this.invalidate();
                return result;
            }
            case 1: {
                this.mAmOrPmPressed = this.getIsTouchingAmOrPm(eventX, eventY);
                if (this.mAmOrPmPressed != -1) {
                    if (this.mAmOrPm != this.mAmOrPmPressed) {
                        this.swapAmPm();
                    }
                    this.mAmOrPmPressed = -1;
                    if (this.mListener != null) {
                        this.mListener.onValueSelected(3, this.getCurrentHour(), true);
                    }
                    result = true;
                } else {
                    int degrees = this.getDegreesFromXY(eventX, eventY);
                    if (degrees != -1) {
                        int snapDegrees = (this.mShowHours ? RadialTimePickerView.snapOnly30s(degrees, 0) : RadialTimePickerView.snapPrefer30s(degrees)) % 360;
                        if (this.mShowHours) {
                            this.mSelectionDegrees[0] = snapDegrees;
                            this.mSelectionDegrees[2] = snapDegrees;
                        } else {
                            this.mSelectionDegrees[1] = snapDegrees;
                        }
                        if (this.mListener != null) {
                            if (this.mShowHours) {
                                this.mListener.onValueSelected(0, this.getCurrentHour(), true);
                            } else {
                                this.mListener.onValueSelected(1, this.getCurrentMinute(), true);
                            }
                        }
                        result = true;
                    }
                }
                if (result) {
                    this.invalidate();
                }
                return result;
            }
        }
        return false;
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.addAction(4096);
        info.addAction(8192);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (event.getEventType() == 32) {
            event.getText().clear();
            Time time = new Time();
            time.hour = this.getCurrentHour();
            time.minute = this.getCurrentMinute();
            long millis = time.normalize(true);
            int flags = 1;
            if (this.mIs24HourMode) {
                flags |= 0x80;
            }
            String timeString = DateUtils.formatDateTime(this.getContext(), millis, flags);
            event.getText().add(timeString);
            return true;
        }
        return super.dispatchPopulateAccessibilityEvent(event);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (super.performAccessibilityAction(action, arguments)) {
            return true;
        }
        int changeMultiplier = 0;
        if (action == 4096) {
            changeMultiplier = 1;
        } else if (action == 8192) {
            changeMultiplier = -1;
        }
        if (changeMultiplier != 0) {
            int value = 0;
            int stepSize = 0;
            if (this.mShowHours) {
                stepSize = 30;
                value = this.getCurrentHour() % 12;
            } else {
                stepSize = 6;
                value = this.getCurrentMinute();
            }
            int degrees = value * stepSize;
            degrees = RadialTimePickerView.snapOnly30s(degrees, changeMultiplier);
            value = degrees / stepSize;
            int maxValue = 0;
            int minValue = 0;
            if (this.mShowHours) {
                if (this.mIs24HourMode) {
                    maxValue = 23;
                } else {
                    maxValue = 12;
                    minValue = 1;
                }
            } else {
                maxValue = 55;
            }
            if (value > maxValue) {
                value = minValue;
            } else if (value < minValue) {
                value = maxValue;
            }
            if (this.mShowHours) {
                this.setCurrentHour(value);
                if (this.mListener != null) {
                    this.mListener.onValueSelected(0, value, false);
                }
            } else {
                this.setCurrentMinute(value);
                if (this.mListener != null) {
                    this.mListener.onValueSelected(1, value, false);
                }
            }
            return true;
        }
        return false;
    }

    public void setInputEnabled(boolean inputEnabled) {
        this.mInputEnabled = inputEnabled;
        this.invalidate();
    }

    static {
        RadialTimePickerView.preparePrefer30sMap();
    }

    private static class IntHolder {
        private int mValue;

        public IntHolder(int value) {
            this.mValue = value;
        }

        public void setValue(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    private class InvalidateUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private InvalidateUpdateListener() {
        }

        @Override
        public void onAnimationUpdate(ValueAnimator animation) {
            RadialTimePickerView.this.invalidate();
        }
    }

    public static interface OnValueSelectedListener {
        public void onValueSelected(int var1, int var2, boolean var3);
    }
}

