/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.LayoutTransition;
import android.app.ActivityManagerNative;
import android.content.ClipDescription;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.media.AudioManager;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.AndroidRuntimeException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Slog;
import android.util.TypedValue;
import android.view.AccessibilityInteractionController;
import android.view.ActionMode;
import android.view.Choreographer;
import android.view.ContextMenu;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.DragEvent;
import android.view.FallbackEventHandler;
import android.view.FocusFinder;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.HardwareRenderer;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputEventConsistencyVerifier;
import android.view.InputEventReceiver;
import android.view.InputQueue;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MagnificationSpec;
import android.view.MotionEvent;
import android.view.RenderNode;
import android.view.SoundEffectConstants;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.ThreadedRenderer;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRootImpl_Delegate;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.WindowLeaked;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.Scroller;
import com.android.internal.os.SomeArgs;
import com.android.internal.policy.PolicyManager;
import com.android.internal.view.BaseSurfaceHolder;
import com.android.internal.view.RootViewSurfaceTaker;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;

public class ViewRootImpl
implements ViewParent,
View.AttachInfo.Callbacks,
HardwareRenderer.HardwareDrawCallbacks {
    private static final String TAG = "ViewRootImpl";
    private static final boolean DBG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final boolean DEBUG_DRAW = false;
    private static final boolean DEBUG_LAYOUT = false;
    private static final boolean DEBUG_DIALOG = false;
    private static final boolean DEBUG_INPUT_RESIZE = false;
    private static final boolean DEBUG_ORIENTATION = false;
    private static final boolean DEBUG_TRACKBALL = false;
    private static final boolean DEBUG_IMF = false;
    private static final boolean DEBUG_CONFIGURATION = false;
    private static final boolean DEBUG_FPS = false;
    private static final boolean DEBUG_INPUT_STAGES = false;
    private static final String PROPERTY_PROFILE_RENDERING = "viewroot.profile_rendering";
    private static final String PROPERTY_MEDIA_DISABLED = "config.disable_media";
    public static final String PROPERTY_EMULATOR_CIRCULAR = "ro.emulator.circular";
    static final int MAX_TRACKBALL_DELAY = 250;
    static final ThreadLocal<RunQueue> sRunQueues = new ThreadLocal();
    static final ArrayList<Runnable> sFirstDrawHandlers = new ArrayList();
    static boolean sFirstDrawComplete = false;
    static final ArrayList<ComponentCallbacks> sConfigCallbacks = new ArrayList();
    final Context mContext;
    final IWindowSession mWindowSession;
    final Display mDisplay;
    final DisplayManager mDisplayManager;
    final String mBasePackageName;
    final int[] mTmpLocation = new int[2];
    final TypedValue mTmpValue = new TypedValue();
    final Thread mThread;
    final WindowLeaked mLocation;
    final WindowManager.LayoutParams mWindowAttributes = new WindowManager.LayoutParams();
    final W mWindow;
    final int mTargetSdkVersion;
    int mSeq;
    View mView;
    View mAccessibilityFocusedHost;
    AccessibilityNodeInfo mAccessibilityFocusedVirtualView;
    int mViewVisibility;
    boolean mAppVisible = true;
    int mOrigWindowType = -1;
    boolean mStopped = false;
    boolean mLastInCompatMode = false;
    SurfaceHolder.Callback2 mSurfaceHolderCallback;
    BaseSurfaceHolder mSurfaceHolder;
    boolean mIsCreating;
    boolean mDrawingAllowed;
    final Region mTransparentRegion;
    final Region mPreviousTransparentRegion;
    int mWidth;
    int mHeight;
    Rect mDirty;
    boolean mIsAnimating;
    CompatibilityInfo.Translator mTranslator;
    final View.AttachInfo mAttachInfo;
    InputChannel mInputChannel;
    InputQueue.Callback mInputQueueCallback;
    InputQueue mInputQueue;
    FallbackEventHandler mFallbackEventHandler;
    Choreographer mChoreographer;
    final Rect mTempRect;
    final Rect mVisRect;
    boolean mTraversalScheduled;
    int mTraversalBarrier;
    boolean mWillDrawSoon;
    boolean mIsInTraversal;
    boolean mApplyInsetsRequested;
    boolean mLayoutRequested;
    boolean mFirst;
    boolean mReportNextDraw;
    boolean mFullRedrawNeeded;
    boolean mNewSurfaceNeeded;
    boolean mHasHadWindowFocus;
    boolean mLastWasImTarget;
    boolean mWindowsAnimating;
    boolean mDrawDuringWindowsAnimating;
    boolean mIsDrawing;
    int mLastSystemUiVisibility;
    int mClientWindowLayoutFlags;
    boolean mLastOverscanRequested;
    private static final int MAX_QUEUED_INPUT_EVENT_POOL_SIZE = 10;
    private QueuedInputEvent mQueuedInputEventPool;
    private int mQueuedInputEventPoolSize;
    QueuedInputEvent mPendingInputEventHead;
    QueuedInputEvent mPendingInputEventTail;
    int mPendingInputEventCount;
    boolean mProcessInputEventsScheduled;
    boolean mUnbufferedInputDispatch;
    String mPendingInputEventQueueLengthCounterName = "pq";
    InputStage mFirstInputStage;
    InputStage mFirstPostImeInputStage;
    InputStage mSyntheticInputStage;
    boolean mWindowAttributesChanged = false;
    int mWindowAttributesChangesFlag = 0;
    private final Surface mSurface = new Surface();
    boolean mAdded;
    boolean mAddedTouchMode;
    final DisplayAdjustments mDisplayAdjustments;
    final Rect mWinFrame;
    final Rect mPendingOverscanInsets = new Rect();
    final Rect mPendingVisibleInsets = new Rect();
    final Rect mPendingStableInsets = new Rect();
    final Rect mPendingContentInsets = new Rect();
    final ViewTreeObserver.InternalInsetsInfo mLastGivenInsets = new ViewTreeObserver.InternalInsetsInfo();
    final Rect mDispatchContentInsets = new Rect();
    final Rect mDispatchStableInsets = new Rect();
    final Configuration mLastConfiguration = new Configuration();
    final Configuration mPendingConfiguration = new Configuration();
    boolean mScrollMayChange;
    int mSoftInputMode;
    WeakReference<View> mLastScrolledFocus;
    int mScrollY;
    int mCurScrollY;
    Scroller mScroller;
    HardwareLayer mResizeBuffer;
    long mResizeBufferStartTime;
    int mResizeBufferDuration;
    boolean mBlockResizeBuffer;
    static final Interpolator mResizeInterpolator = new AccelerateDecelerateInterpolator();
    private ArrayList<LayoutTransition> mPendingTransitions;
    final ViewConfiguration mViewConfiguration;
    ClipDescription mDragDescription;
    View mCurrentDragView;
    volatile Object mLocalDragState;
    final PointF mDragPoint = new PointF();
    final PointF mLastTouchPoint = new PointF();
    private boolean mProfileRendering;
    private Choreographer.FrameCallback mRenderProfiler;
    private boolean mRenderProfilingEnabled;
    private boolean mMediaDisabled;
    private long mFpsStartTime = -1L;
    private long mFpsPrevTime = -1L;
    private int mFpsNumFrames;
    AudioManager mAudioManager;
    final AccessibilityManager mAccessibilityManager;
    AccessibilityInteractionController mAccessibilityInteractionController;
    AccessibilityInteractionConnectionManager mAccessibilityInteractionConnectionManager;
    HighContrastTextManager mHighContrastTextManager;
    SendWindowContentChangedAccessibilityEvent mSendWindowContentChangedAccessibilityEvent;
    HashSet<View> mTempHashSet;
    private final int mDensity;
    private final int mNoncompatDensity;
    private boolean mInLayout = false;
    ArrayList<View> mLayoutRequesters = new ArrayList();
    boolean mHandlingLayoutInLayoutRequest = false;
    private int mViewLayoutDirectionInitial;
    private boolean mRemoved;
    private boolean mIsEmulator;
    private boolean mIsCircularEmulator;
    private final boolean mWindowIsRound;
    protected final InputEventConsistencyVerifier mInputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0) : null;
    private boolean mProfile = false;
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        @Override
        public void onDisplayChanged(int displayId) {
            int newDisplayState;
            int oldDisplayState;
            if (ViewRootImpl.this.mView != null && ViewRootImpl.this.mDisplay.getDisplayId() == displayId && (oldDisplayState = ViewRootImpl.this.mAttachInfo.mDisplayState) != (newDisplayState = ViewRootImpl.this.mDisplay.getState())) {
                ViewRootImpl.this.mAttachInfo.mDisplayState = newDisplayState;
                if (oldDisplayState != 0) {
                    int newScreenState;
                    int oldScreenState = this.toViewScreenState(oldDisplayState);
                    if (oldScreenState != (newScreenState = this.toViewScreenState(newDisplayState))) {
                        ViewRootImpl.this.mView.dispatchScreenStateChanged(newScreenState);
                    }
                    if (oldDisplayState == 1) {
                        ViewRootImpl.this.mFullRedrawNeeded = true;
                        ViewRootImpl.this.scheduleTraversals();
                    }
                }
            }
        }

        @Override
        public void onDisplayRemoved(int displayId) {
        }

        @Override
        public void onDisplayAdded(int displayId) {
        }

        private int toViewScreenState(int displayState) {
            return displayState == 1 ? 0 : 1;
        }
    };
    int mHardwareXOffset;
    int mHardwareYOffset;
    int mResizeAlpha;
    final Paint mResizePaint = new Paint();
    private static final int MSG_INVALIDATE = 1;
    private static final int MSG_INVALIDATE_RECT = 2;
    private static final int MSG_DIE = 3;
    private static final int MSG_RESIZED = 4;
    private static final int MSG_RESIZED_REPORT = 5;
    private static final int MSG_WINDOW_FOCUS_CHANGED = 6;
    private static final int MSG_DISPATCH_INPUT_EVENT = 7;
    private static final int MSG_DISPATCH_APP_VISIBILITY = 8;
    private static final int MSG_DISPATCH_GET_NEW_SURFACE = 9;
    private static final int MSG_DISPATCH_KEY_FROM_IME = 11;
    private static final int MSG_FINISH_INPUT_CONNECTION = 12;
    private static final int MSG_CHECK_FOCUS = 13;
    private static final int MSG_CLOSE_SYSTEM_DIALOGS = 14;
    private static final int MSG_DISPATCH_DRAG_EVENT = 15;
    private static final int MSG_DISPATCH_DRAG_LOCATION_EVENT = 16;
    private static final int MSG_DISPATCH_SYSTEM_UI_VISIBILITY = 17;
    private static final int MSG_UPDATE_CONFIGURATION = 18;
    private static final int MSG_PROCESS_INPUT_EVENTS = 19;
    private static final int MSG_CLEAR_ACCESSIBILITY_FOCUS_HOST = 21;
    private static final int MSG_DISPATCH_DONE_ANIMATING = 22;
    private static final int MSG_INVALIDATE_WORLD = 23;
    private static final int MSG_WINDOW_MOVED = 24;
    private static final int MSG_SYNTHESIZE_INPUT_EVENT = 25;
    final ViewRootHandler mHandler = new ViewRootHandler();
    final TraversalRunnable mTraversalRunnable = new TraversalRunnable();
    WindowInputEventReceiver mInputEventReceiver;
    final ConsumeBatchedInputRunnable mConsumedBatchedInputRunnable = new ConsumeBatchedInputRunnable();
    boolean mConsumeBatchedInputScheduled;
    final ConsumeBatchedInputImmediatelyRunnable mConsumeBatchedInputImmediatelyRunnable = new ConsumeBatchedInputImmediatelyRunnable();
    boolean mConsumeBatchedInputImmediatelyScheduled;
    final InvalidateOnAnimationRunnable mInvalidateOnAnimationRunnable = new InvalidateOnAnimationRunnable();

    public ViewRootImpl(Context context, Display display) {
        this.mContext = context;
        this.mWindowSession = WindowManagerGlobal.getWindowSession();
        this.mDisplay = display;
        this.mBasePackageName = context.getBasePackageName();
        this.mDisplayAdjustments = display.getDisplayAdjustments();
        this.mThread = Thread.currentThread();
        this.mLocation = new WindowLeaked(null);
        this.mLocation.fillInStackTrace();
        this.mWidth = -1;
        this.mHeight = -1;
        this.mDirty = new Rect();
        this.mTempRect = new Rect();
        this.mVisRect = new Rect();
        this.mWinFrame = new Rect();
        this.mWindow = new W(this);
        this.mTargetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        this.mViewVisibility = 8;
        this.mTransparentRegion = new Region();
        this.mPreviousTransparentRegion = new Region();
        this.mFirst = true;
        this.mAdded = false;
        this.mAttachInfo = new View.AttachInfo(this.mWindowSession, this.mWindow, display, this, this.mHandler, this);
        this.mAccessibilityManager = AccessibilityManager.getInstance(context);
        this.mAccessibilityInteractionConnectionManager = new AccessibilityInteractionConnectionManager();
        this.mAccessibilityManager.addAccessibilityStateChangeListener(this.mAccessibilityInteractionConnectionManager);
        this.mHighContrastTextManager = new HighContrastTextManager();
        this.mAccessibilityManager.addHighTextContrastStateChangeListener(this.mHighContrastTextManager);
        this.mViewConfiguration = ViewConfiguration.get(context);
        this.mDensity = context.getResources().getDisplayMetrics().densityDpi;
        this.mNoncompatDensity = context.getResources().getDisplayMetrics().noncompatDensityDpi;
        this.mFallbackEventHandler = PolicyManager.makeNewFallbackEventHandler(context);
        this.mChoreographer = Choreographer.getInstance();
        this.mDisplayManager = (DisplayManager)context.getSystemService("display");
        this.loadSystemProperties();
        this.mWindowIsRound = context.getResources().getBoolean(17956972);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFirstDrawHandler(Runnable callback) {
        ArrayList<Runnable> arrayList = sFirstDrawHandlers;
        synchronized (arrayList) {
            if (!sFirstDrawComplete) {
                sFirstDrawHandlers.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfigCallback(ComponentCallbacks callback) {
        ArrayList<ComponentCallbacks> arrayList = sConfigCallbacks;
        synchronized (arrayList) {
            sConfigCallbacks.add(callback);
        }
    }

    public void profile() {
        this.mProfile = true;
    }

    static boolean isInTouchMode_Original() {
        IWindowSession windowSession = WindowManagerGlobal.peekWindowSession();
        if (windowSession != null) {
            try {
                return windowSession.getInTouchMode();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    @LayoutlibDelegate
    static boolean isInTouchMode() {
        return ViewRootImpl_Delegate.isInTouchMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setView(View view, WindowManager.LayoutParams attrs, View panelParentView) {
        ViewRootImpl viewRootImpl = this;
        synchronized (viewRootImpl) {
            if (this.mView == null) {
                int res;
                this.mView = view;
                this.mAttachInfo.mDisplayState = this.mDisplay.getState();
                this.mDisplayManager.registerDisplayListener(this.mDisplayListener, this.mHandler);
                this.mViewLayoutDirectionInitial = this.mView.getRawLayoutDirection();
                this.mFallbackEventHandler.setView(view);
                this.mWindowAttributes.copyFrom(attrs);
                if (this.mWindowAttributes.packageName == null) {
                    this.mWindowAttributes.packageName = this.mBasePackageName;
                }
                attrs = this.mWindowAttributes;
                this.mClientWindowLayoutFlags = attrs.flags;
                this.setAccessibilityFocus(null, null);
                if (view instanceof RootViewSurfaceTaker) {
                    this.mSurfaceHolderCallback = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheSurface();
                    if (this.mSurfaceHolderCallback != null) {
                        this.mSurfaceHolder = new TakenSurfaceHolder();
                        this.mSurfaceHolder.setFormat(0);
                    }
                }
                int surfaceInset = (int)Math.ceil(view.getZ() * 2.0f);
                attrs.surfaceInsets.set(surfaceInset, surfaceInset, surfaceInset, surfaceInset);
                CompatibilityInfo compatibilityInfo = this.mDisplayAdjustments.getCompatibilityInfo();
                this.mTranslator = compatibilityInfo.getTranslator();
                this.mDisplayAdjustments.setActivityToken(attrs.token);
                if (this.mSurfaceHolder == null) {
                    this.enableHardwareAcceleration(attrs);
                }
                boolean restore = false;
                if (this.mTranslator != null) {
                    this.mSurface.setCompatibilityTranslator(this.mTranslator);
                    restore = true;
                    attrs.backup();
                    this.mTranslator.translateWindowLayout(attrs);
                }
                if (!compatibilityInfo.supportsScreen()) {
                    attrs.privateFlags |= 0x80;
                    this.mLastInCompatMode = true;
                }
                this.mSoftInputMode = attrs.softInputMode;
                this.mWindowAttributesChanged = true;
                this.mWindowAttributesChangesFlag = -1;
                this.mAttachInfo.mRootView = view;
                this.mAttachInfo.mScalingRequired = this.mTranslator != null;
                float f = this.mAttachInfo.mApplicationScale = this.mTranslator == null ? 1.0f : this.mTranslator.applicationScale;
                if (panelParentView != null) {
                    this.mAttachInfo.mPanelParentWindowToken = panelParentView.getApplicationWindowToken();
                }
                this.mAdded = true;
                this.requestLayout();
                if ((this.mWindowAttributes.inputFeatures & 2) == 0) {
                    this.mInputChannel = new InputChannel();
                }
                try {
                    this.mOrigWindowType = this.mWindowAttributes.type;
                    this.mAttachInfo.mRecomputeGlobalAttributes = true;
                    this.collectViewAttributes();
                    res = this.mWindowSession.addToDisplay(this.mWindow, this.mSeq, this.mWindowAttributes, this.getHostVisibility(), this.mDisplay.getDisplayId(), this.mAttachInfo.mContentInsets, this.mInputChannel);
                }
                catch (RemoteException e) {
                    this.mAdded = false;
                    this.mView = null;
                    this.mAttachInfo.mRootView = null;
                    this.mInputChannel = null;
                    this.mFallbackEventHandler.setView(null);
                    this.unscheduleTraversals();
                    this.setAccessibilityFocus(null, null);
                    throw new RuntimeException("Adding window failed", e);
                }
                finally {
                    if (restore) {
                        attrs.restore();
                    }
                }
                if (this.mTranslator != null) {
                    this.mTranslator.translateRectInScreenToAppWindow(this.mAttachInfo.mContentInsets);
                }
                this.mPendingOverscanInsets.set(0, 0, 0, 0);
                this.mPendingContentInsets.set(this.mAttachInfo.mContentInsets);
                this.mPendingStableInsets.set(this.mAttachInfo.mStableInsets);
                this.mPendingVisibleInsets.set(0, 0, 0, 0);
                if (res < 0) {
                    this.mAttachInfo.mRootView = null;
                    this.mAdded = false;
                    this.mFallbackEventHandler.setView(null);
                    this.unscheduleTraversals();
                    this.setAccessibilityFocus(null, null);
                    switch (res) {
                        case -2: 
                        case -1: {
                            throw new WindowManager.BadTokenException("Unable to add window -- token " + attrs.token + " is not valid; is your activity running?");
                        }
                        case -3: {
                            throw new WindowManager.BadTokenException("Unable to add window -- token " + attrs.token + " is not for an application");
                        }
                        case -4: {
                            throw new WindowManager.BadTokenException("Unable to add window -- app for token " + attrs.token + " is exiting");
                        }
                        case -5: {
                            throw new WindowManager.BadTokenException("Unable to add window -- window " + this.mWindow + " has already been added");
                        }
                        case -6: {
                            return;
                        }
                        case -7: {
                            throw new WindowManager.BadTokenException("Unable to add window " + this.mWindow + " -- another window of this type already exists");
                        }
                        case -8: {
                            throw new WindowManager.BadTokenException("Unable to add window " + this.mWindow + " -- permission denied for this window type");
                        }
                        case -9: {
                            throw new WindowManager.InvalidDisplayException("Unable to add window " + this.mWindow + " -- the specified display can not be found");
                        }
                    }
                    throw new RuntimeException("Unable to add window -- unknown error code " + res);
                }
                if (view instanceof RootViewSurfaceTaker) {
                    this.mInputQueueCallback = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheInputQueue();
                }
                if (this.mInputChannel != null) {
                    if (this.mInputQueueCallback != null) {
                        this.mInputQueue = new InputQueue();
                        this.mInputQueueCallback.onInputQueueCreated(this.mInputQueue);
                    }
                    this.mInputEventReceiver = new WindowInputEventReceiver(this.mInputChannel, Looper.myLooper());
                }
                view.assignParent(this);
                this.mAddedTouchMode = (res & 1) != 0;
                boolean bl = this.mAppVisible = (res & 2) != 0;
                if (this.mAccessibilityManager.isEnabled()) {
                    this.mAccessibilityInteractionConnectionManager.ensureConnection();
                }
                if (view.getImportantForAccessibility() == 0) {
                    view.setImportantForAccessibility(1);
                }
                CharSequence counterSuffix = attrs.getTitle();
                this.mSyntheticInputStage = new SyntheticInputStage();
                ViewPostImeInputStage viewPostImeStage = new ViewPostImeInputStage(this.mSyntheticInputStage);
                NativePostImeInputStage nativePostImeStage = new NativePostImeInputStage(viewPostImeStage, "aq:native-post-ime:" + counterSuffix);
                EarlyPostImeInputStage earlyPostImeStage = new EarlyPostImeInputStage(nativePostImeStage);
                ImeInputStage imeStage = new ImeInputStage(earlyPostImeStage, "aq:ime:" + counterSuffix);
                ViewPreImeInputStage viewPreImeStage = new ViewPreImeInputStage(imeStage);
                NativePreImeInputStage nativePreImeStage = new NativePreImeInputStage(viewPreImeStage, "aq:native-pre-ime:" + counterSuffix);
                this.mFirstInputStage = nativePreImeStage;
                this.mFirstPostImeInputStage = earlyPostImeStage;
                this.mPendingInputEventQueueLengthCounterName = "aq:pending:" + counterSuffix;
            }
        }
    }

    private boolean isInLocalFocusMode() {
        return (this.mWindowAttributes.flags & 0x10000000) != 0;
    }

    void destroyHardwareResources() {
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.destroyHardwareResources(this.mView);
            this.mAttachInfo.mHardwareRenderer.destroy();
        }
    }

    public void detachFunctor(long functor) {
        this.mBlockResizeBuffer = true;
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.stopDrawing();
        }
    }

    public void invokeFunctor(long functor, boolean waitForCompletion) {
        ThreadedRenderer.invokeFunctor(functor, waitForCompletion);
    }

    public void registerAnimatingRenderNode(RenderNode animator2) {
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.registerAnimatingRenderNode(animator2);
        } else {
            if (this.mAttachInfo.mPendingAnimatingRenderNodes == null) {
                this.mAttachInfo.mPendingAnimatingRenderNodes = new ArrayList<RenderNode>();
            }
            this.mAttachInfo.mPendingAnimatingRenderNodes.add(animator2);
        }
    }

    private void enableHardwareAcceleration(WindowManager.LayoutParams attrs) {
        boolean hardwareAccelerated;
        this.mAttachInfo.mHardwareAccelerated = false;
        this.mAttachInfo.mHardwareAccelerationRequested = false;
        if (this.mTranslator != null) {
            return;
        }
        boolean bl = hardwareAccelerated = (attrs.flags & 0x1000000) != 0;
        if (hardwareAccelerated) {
            boolean forceHwAccelerated;
            if (!HardwareRenderer.isAvailable()) {
                return;
            }
            boolean fakeHwAccelerated = (attrs.privateFlags & 1) != 0;
            boolean bl2 = forceHwAccelerated = (attrs.privateFlags & 2) != 0;
            if (fakeHwAccelerated) {
                this.mAttachInfo.mHardwareAccelerationRequested = true;
            } else if (!HardwareRenderer.sRendererDisabled || HardwareRenderer.sSystemRendererDisabled && forceHwAccelerated) {
                if (this.mAttachInfo.mHardwareRenderer != null) {
                    this.mAttachInfo.mHardwareRenderer.destroy();
                }
                boolean translucent = attrs.format != -1;
                this.mAttachInfo.mHardwareRenderer = HardwareRenderer.create(this.mContext, translucent);
                if (this.mAttachInfo.mHardwareRenderer != null) {
                    this.mAttachInfo.mHardwareRenderer.setName(attrs.getTitle().toString());
                    this.mAttachInfo.mHardwareAccelerationRequested = true;
                    this.mAttachInfo.mHardwareAccelerated = true;
                }
            }
        }
    }

    public View getView() {
        return this.mView;
    }

    WindowLeaked getLocation() {
        return this.mLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLayoutParams(WindowManager.LayoutParams attrs, boolean newView) {
        ViewRootImpl viewRootImpl = this;
        synchronized (viewRootImpl) {
            int oldInsetLeft = this.mWindowAttributes.surfaceInsets.left;
            int oldInsetTop = this.mWindowAttributes.surfaceInsets.top;
            int oldInsetRight = this.mWindowAttributes.surfaceInsets.right;
            int oldInsetBottom = this.mWindowAttributes.surfaceInsets.bottom;
            int oldSoftInputMode = this.mWindowAttributes.softInputMode;
            this.mClientWindowLayoutFlags = attrs.flags;
            int compatibleWindowFlag = this.mWindowAttributes.privateFlags & 0x80;
            attrs.systemUiVisibility = this.mWindowAttributes.systemUiVisibility;
            attrs.subtreeSystemUiVisibility = this.mWindowAttributes.subtreeSystemUiVisibility;
            this.mWindowAttributesChangesFlag = this.mWindowAttributes.copyFrom(attrs);
            if ((this.mWindowAttributesChangesFlag & 0x80000) != 0) {
                this.mAttachInfo.mRecomputeGlobalAttributes = true;
            }
            if (this.mWindowAttributes.packageName == null) {
                this.mWindowAttributes.packageName = this.mBasePackageName;
            }
            this.mWindowAttributes.privateFlags |= compatibleWindowFlag;
            this.mWindowAttributes.surfaceInsets.set(oldInsetLeft, oldInsetTop, oldInsetRight, oldInsetBottom);
            this.applyKeepScreenOnFlag(this.mWindowAttributes);
            if (newView) {
                this.mSoftInputMode = attrs.softInputMode;
                this.requestLayout();
            }
            if ((attrs.softInputMode & 0xF0) == 0) {
                this.mWindowAttributes.softInputMode = this.mWindowAttributes.softInputMode & 0xFFFFFF0F | oldSoftInputMode & 0xF0;
            }
            this.mWindowAttributesChanged = true;
            this.scheduleTraversals();
        }
    }

    void handleAppVisibility(boolean visible) {
        if (this.mAppVisible != visible) {
            this.mAppVisible = visible;
            this.scheduleTraversals();
            if (!this.mAppVisible) {
                WindowManagerGlobal.trimForeground();
            }
        }
    }

    void handleGetNewSurface() {
        this.mNewSurfaceNeeded = true;
        this.mFullRedrawNeeded = true;
        this.scheduleTraversals();
    }

    @Override
    public void requestFitSystemWindows() {
        this.checkThread();
        this.mApplyInsetsRequested = true;
        this.scheduleTraversals();
    }

    @Override
    public void requestLayout() {
        if (!this.mHandlingLayoutInLayoutRequest) {
            this.checkThread();
            this.mLayoutRequested = true;
            this.scheduleTraversals();
        }
    }

    @Override
    public boolean isLayoutRequested() {
        return this.mLayoutRequested;
    }

    void invalidate() {
        this.mDirty.set(0, 0, this.mWidth, this.mHeight);
        if (!this.mWillDrawSoon) {
            this.scheduleTraversals();
        }
    }

    void invalidateWorld(View view) {
        view.invalidate();
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                this.invalidateWorld(parent.getChildAt(i));
            }
        }
    }

    @Override
    public void invalidateChild(View child, Rect dirty) {
        this.invalidateChildInParent(null, dirty);
    }

    @Override
    public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
        Rect localDirty;
        this.checkThread();
        if (dirty == null) {
            this.invalidate();
            return null;
        }
        if (dirty.isEmpty() && !this.mIsAnimating) {
            return null;
        }
        if (this.mCurScrollY != 0 || this.mTranslator != null) {
            this.mTempRect.set(dirty);
            dirty = this.mTempRect;
            if (this.mCurScrollY != 0) {
                dirty.offset(0, -this.mCurScrollY);
            }
            if (this.mTranslator != null) {
                this.mTranslator.translateRectInAppWindowToScreen(dirty);
            }
            if (this.mAttachInfo.mScalingRequired) {
                dirty.inset(-1, -1);
            }
        }
        if (!(localDirty = this.mDirty).isEmpty() && !localDirty.contains(dirty)) {
            this.mAttachInfo.mSetIgnoreDirtyState = true;
            this.mAttachInfo.mIgnoreDirtyState = true;
        }
        localDirty.union(dirty.left, dirty.top, dirty.right, dirty.bottom);
        float appScale = this.mAttachInfo.mApplicationScale;
        boolean intersected = localDirty.intersect(0, 0, (int)((float)this.mWidth * appScale + 0.5f), (int)((float)this.mHeight * appScale + 0.5f));
        if (!intersected) {
            localDirty.setEmpty();
        }
        if (!this.mWillDrawSoon && (intersected || this.mIsAnimating)) {
            this.scheduleTraversals();
        }
        return null;
    }

    void setStopped(boolean stopped) {
        if (this.mStopped != stopped) {
            this.mStopped = stopped;
            if (!stopped) {
                this.scheduleTraversals();
            }
        }
    }

    @Override
    public ViewParent getParent() {
        return null;
    }

    @Override
    public boolean getChildVisibleRect(View child, Rect r, Point offset) {
        if (child != this.mView) {
            throw new RuntimeException("child is not mine, honest!");
        }
        return r.intersect(0, 0, this.mWidth, this.mHeight);
    }

    @Override
    public void bringChildToFront(View child) {
    }

    int getHostVisibility() {
        return this.mAppVisible ? this.mView.getVisibility() : 8;
    }

    void disposeResizeBuffer() {
        if (this.mResizeBuffer != null) {
            this.mResizeBuffer.destroy();
            this.mResizeBuffer = null;
        }
    }

    public void requestTransitionStart(LayoutTransition transition2) {
        if (this.mPendingTransitions == null || !this.mPendingTransitions.contains(transition2)) {
            if (this.mPendingTransitions == null) {
                this.mPendingTransitions = new ArrayList();
            }
            this.mPendingTransitions.add(transition2);
        }
    }

    void notifyRendererOfFramePending() {
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.notifyFramePending();
        }
    }

    void scheduleTraversals() {
        if (!this.mTraversalScheduled) {
            this.mTraversalScheduled = true;
            this.mTraversalBarrier = this.mHandler.getLooper().postSyncBarrier();
            this.mChoreographer.postCallback(2, this.mTraversalRunnable, null);
            if (!this.mUnbufferedInputDispatch) {
                this.scheduleConsumeBatchedInput();
            }
            this.notifyRendererOfFramePending();
        }
    }

    void unscheduleTraversals() {
        if (this.mTraversalScheduled) {
            this.mTraversalScheduled = false;
            this.mHandler.getLooper().removeSyncBarrier(this.mTraversalBarrier);
            this.mChoreographer.removeCallbacks(2, this.mTraversalRunnable, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTraversal() {
        if (this.mTraversalScheduled) {
            this.mTraversalScheduled = false;
            this.mHandler.getLooper().removeSyncBarrier(this.mTraversalBarrier);
            if (this.mProfile) {
                Debug.startMethodTracing("ViewAncestor");
            }
            Trace.traceBegin(8L, "performTraversals");
            try {
                this.performTraversals();
            }
            finally {
                Trace.traceEnd(8L);
            }
            if (this.mProfile) {
                Debug.stopMethodTracing();
                this.mProfile = false;
            }
        }
    }

    private void applyKeepScreenOnFlag(WindowManager.LayoutParams params) {
        params.flags = this.mAttachInfo.mKeepScreenOn ? (params.flags |= 0x80) : params.flags & 0xFFFFFF7F | this.mClientWindowLayoutFlags & 0x80;
    }

    private boolean collectViewAttributes() {
        if (this.mAttachInfo.mRecomputeGlobalAttributes) {
            this.mAttachInfo.mRecomputeGlobalAttributes = false;
            boolean oldScreenOn = this.mAttachInfo.mKeepScreenOn;
            this.mAttachInfo.mKeepScreenOn = false;
            this.mAttachInfo.mSystemUiVisibility = 0;
            this.mAttachInfo.mHasSystemUiListeners = false;
            this.mView.dispatchCollectViewAttributes(this.mAttachInfo, 0);
            this.mAttachInfo.mSystemUiVisibility &= ~this.mAttachInfo.mDisabledSystemUiVisibility;
            WindowManager.LayoutParams params = this.mWindowAttributes;
            this.mAttachInfo.mSystemUiVisibility |= this.getImpliedSystemUiVisibility(params);
            if (this.mAttachInfo.mKeepScreenOn != oldScreenOn || this.mAttachInfo.mSystemUiVisibility != params.subtreeSystemUiVisibility || this.mAttachInfo.mHasSystemUiListeners != params.hasSystemUiListeners) {
                this.applyKeepScreenOnFlag(params);
                params.subtreeSystemUiVisibility = this.mAttachInfo.mSystemUiVisibility;
                params.hasSystemUiListeners = this.mAttachInfo.mHasSystemUiListeners;
                this.mView.dispatchWindowSystemUiVisiblityChanged(this.mAttachInfo.mSystemUiVisibility);
                return true;
            }
        }
        return false;
    }

    private int getImpliedSystemUiVisibility(WindowManager.LayoutParams params) {
        int vis = 0;
        if ((params.flags & 0x4000000) != 0) {
            vis |= 0x500;
        }
        if ((params.flags & 0x8000000) != 0) {
            vis |= 0x300;
        }
        return vis;
    }

    private boolean measureHierarchy(View host, WindowManager.LayoutParams lp, Resources res, int desiredWindowWidth, int desiredWindowHeight) {
        int childHeightMeasureSpec;
        int childWidthMeasureSpec;
        boolean windowSizeMayChange = false;
        boolean goodMeasure = false;
        if (lp.width == -2) {
            DisplayMetrics packageMetrics = res.getDisplayMetrics();
            res.getValue(17104905, this.mTmpValue, true);
            int baseSize = 0;
            if (this.mTmpValue.type == 5) {
                baseSize = (int)this.mTmpValue.getDimension(packageMetrics);
            }
            if (baseSize != 0 && desiredWindowWidth > baseSize) {
                childWidthMeasureSpec = ViewRootImpl.getRootMeasureSpec(baseSize, lp.width);
                childHeightMeasureSpec = ViewRootImpl.getRootMeasureSpec(desiredWindowHeight, lp.height);
                this.performMeasure(childWidthMeasureSpec, childHeightMeasureSpec);
                if ((host.getMeasuredWidthAndState() & 0x1000000) == 0) {
                    goodMeasure = true;
                } else {
                    baseSize = (baseSize + desiredWindowWidth) / 2;
                    childWidthMeasureSpec = ViewRootImpl.getRootMeasureSpec(baseSize, lp.width);
                    this.performMeasure(childWidthMeasureSpec, childHeightMeasureSpec);
                    if ((host.getMeasuredWidthAndState() & 0x1000000) == 0) {
                        goodMeasure = true;
                    }
                }
            }
        }
        if (!goodMeasure) {
            childWidthMeasureSpec = ViewRootImpl.getRootMeasureSpec(desiredWindowWidth, lp.width);
            childHeightMeasureSpec = ViewRootImpl.getRootMeasureSpec(desiredWindowHeight, lp.height);
            this.performMeasure(childWidthMeasureSpec, childHeightMeasureSpec);
            if (this.mWidth != host.getMeasuredWidth() || this.mHeight != host.getMeasuredHeight()) {
                windowSizeMayChange = true;
            }
        }
        return windowSizeMayChange;
    }

    void transformMatrixToGlobal(Matrix m) {
        m.preTranslate(this.mAttachInfo.mWindowLeft, this.mAttachInfo.mWindowTop);
    }

    void transformMatrixToLocal(Matrix m) {
        m.postTranslate(-this.mAttachInfo.mWindowLeft, -this.mAttachInfo.mWindowTop);
    }

    void dispatchApplyInsets(View host) {
        this.mDispatchContentInsets.set(this.mAttachInfo.mContentInsets);
        this.mDispatchStableInsets.set(this.mAttachInfo.mStableInsets);
        boolean isRound = this.mIsEmulator && this.mIsCircularEmulator || this.mWindowIsRound;
        host.dispatchApplyWindowInsets(new WindowInsets(this.mDispatchContentInsets, null, this.mDispatchStableInsets, isRound));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performTraversals() {
        boolean cancelDraw;
        boolean imTarget;
        boolean triggerGlobalLayoutListener;
        boolean layoutRequested;
        int desiredWindowHeight;
        int desiredWindowWidth;
        CompatibilityInfo compatibilityInfo;
        View host = this.mView;
        if (host == null || !this.mAdded) {
            return;
        }
        this.mIsInTraversal = true;
        this.mWillDrawSoon = true;
        boolean windowSizeMayChange = false;
        boolean newSurface = false;
        boolean surfaceChanged = false;
        WindowManager.LayoutParams lp = this.mWindowAttributes;
        int viewVisibility = this.getHostVisibility();
        boolean viewVisibilityChanged = this.mViewVisibility != viewVisibility || this.mNewSurfaceNeeded;
        WindowManager.LayoutParams params = null;
        if (this.mWindowAttributesChanged) {
            this.mWindowAttributesChanged = false;
            surfaceChanged = true;
            params = lp;
        }
        if ((compatibilityInfo = this.mDisplayAdjustments.getCompatibilityInfo()).supportsScreen() == this.mLastInCompatMode) {
            params = lp;
            this.mFullRedrawNeeded = true;
            this.mLayoutRequested = true;
            if (this.mLastInCompatMode) {
                params.privateFlags &= 0xFFFFFF7F;
                this.mLastInCompatMode = false;
            } else {
                params.privateFlags |= 0x80;
                this.mLastInCompatMode = true;
            }
        }
        this.mWindowAttributesChangesFlag = 0;
        Rect frame = this.mWinFrame;
        if (this.mFirst) {
            this.mFullRedrawNeeded = true;
            this.mLayoutRequested = true;
            if (lp.type == 2014 || lp.type == 2011) {
                Point size = new Point();
                this.mDisplay.getRealSize(size);
                desiredWindowWidth = size.x;
                desiredWindowHeight = size.y;
            } else {
                DisplayMetrics packageMetrics = this.mView.getContext().getResources().getDisplayMetrics();
                desiredWindowWidth = packageMetrics.widthPixels;
                desiredWindowHeight = packageMetrics.heightPixels;
            }
            this.mAttachInfo.mUse32BitDrawingCache = true;
            this.mAttachInfo.mHasWindowFocus = false;
            this.mAttachInfo.mWindowVisibility = viewVisibility;
            this.mAttachInfo.mRecomputeGlobalAttributes = false;
            viewVisibilityChanged = false;
            this.mLastConfiguration.setTo(host.getResources().getConfiguration());
            this.mLastSystemUiVisibility = this.mAttachInfo.mSystemUiVisibility;
            if (this.mViewLayoutDirectionInitial == 2) {
                host.setLayoutDirection(this.mLastConfiguration.getLayoutDirection());
            }
            host.dispatchAttachedToWindow(this.mAttachInfo, 0);
            this.mAttachInfo.mTreeObserver.dispatchOnWindowAttachedChange(true);
            this.dispatchApplyInsets(host);
        } else {
            desiredWindowWidth = frame.width();
            desiredWindowHeight = frame.height();
            if (desiredWindowWidth != this.mWidth || desiredWindowHeight != this.mHeight) {
                this.mFullRedrawNeeded = true;
                this.mLayoutRequested = true;
                windowSizeMayChange = true;
            }
        }
        if (viewVisibilityChanged) {
            this.mAttachInfo.mWindowVisibility = viewVisibility;
            host.dispatchWindowVisibilityChanged(viewVisibility);
            if (viewVisibility != 0 || this.mNewSurfaceNeeded) {
                this.destroyHardwareResources();
            }
            if (viewVisibility == 8) {
                this.mHasHadWindowFocus = false;
            }
        }
        ViewRootImpl.getRunQueue().executeActions(this.mAttachInfo.mHandler);
        boolean insetsChanged = false;
        boolean bl = layoutRequested = this.mLayoutRequested && !this.mStopped;
        if (layoutRequested) {
            Resources res = this.mView.getContext().getResources();
            if (this.mFirst) {
                this.mAttachInfo.mInTouchMode = !this.mAddedTouchMode;
                this.ensureTouchModeLocally(this.mAddedTouchMode);
            } else {
                if (!this.mPendingOverscanInsets.equals(this.mAttachInfo.mOverscanInsets)) {
                    insetsChanged = true;
                }
                if (!this.mPendingContentInsets.equals(this.mAttachInfo.mContentInsets)) {
                    insetsChanged = true;
                }
                if (!this.mPendingStableInsets.equals(this.mAttachInfo.mStableInsets)) {
                    insetsChanged = true;
                }
                if (!this.mPendingVisibleInsets.equals(this.mAttachInfo.mVisibleInsets)) {
                    this.mAttachInfo.mVisibleInsets.set(this.mPendingVisibleInsets);
                }
                if (lp.width == -2 || lp.height == -2) {
                    windowSizeMayChange = true;
                    if (lp.type == 2014 || lp.type == 2011) {
                        Point size = new Point();
                        this.mDisplay.getRealSize(size);
                        desiredWindowWidth = size.x;
                        desiredWindowHeight = size.y;
                    } else {
                        DisplayMetrics packageMetrics = res.getDisplayMetrics();
                        desiredWindowWidth = packageMetrics.widthPixels;
                        desiredWindowHeight = packageMetrics.heightPixels;
                    }
                }
            }
            windowSizeMayChange |= this.measureHierarchy(host, lp, res, desiredWindowWidth, desiredWindowHeight);
        }
        if (this.collectViewAttributes()) {
            params = lp;
        }
        if (this.mAttachInfo.mForceReportNewAttributes) {
            this.mAttachInfo.mForceReportNewAttributes = false;
            params = lp;
        }
        if (this.mFirst || this.mAttachInfo.mViewVisibilityChanged) {
            this.mAttachInfo.mViewVisibilityChanged = false;
            int resizeMode = this.mSoftInputMode & 0xF0;
            if (resizeMode == 0) {
                int N = this.mAttachInfo.mScrollContainers.size();
                for (int i = 0; i < N; ++i) {
                    if (!this.mAttachInfo.mScrollContainers.get(i).isShown()) continue;
                    resizeMode = 16;
                }
                if (resizeMode == 0) {
                    resizeMode = 32;
                }
                if ((lp.softInputMode & 0xF0) != resizeMode) {
                    lp.softInputMode = lp.softInputMode & 0xFFFFFF0F | resizeMode;
                    params = lp;
                }
            }
        }
        if (params != null) {
            if ((host.mPrivateFlags & 0x200) != 0 && !PixelFormat.formatHasAlpha(params.format)) {
                params.format = -3;
            }
            boolean bl2 = this.mAttachInfo.mOverscanRequested = (params.flags & 0x2000000) != 0;
        }
        if (this.mApplyInsetsRequested) {
            this.mApplyInsetsRequested = false;
            this.mLastOverscanRequested = this.mAttachInfo.mOverscanRequested;
            this.dispatchApplyInsets(host);
            if (this.mLayoutRequested) {
                windowSizeMayChange |= this.measureHierarchy(host, lp, this.mView.getContext().getResources(), desiredWindowWidth, desiredWindowHeight);
            }
        }
        if (layoutRequested) {
            this.mLayoutRequested = false;
        }
        boolean windowShouldResize = layoutRequested && windowSizeMayChange && (this.mWidth != host.getMeasuredWidth() || this.mHeight != host.getMeasuredHeight() || lp.width == -2 && frame.width() < desiredWindowWidth && frame.width() != this.mWidth || lp.height == -2 && frame.height() < desiredWindowHeight && frame.height() != this.mHeight);
        boolean computesInternalInsets = this.mAttachInfo.mTreeObserver.hasComputeInternalInsetsListeners() || this.mAttachInfo.mHasNonEmptyGivenInternalInsets;
        boolean insetsPending = false;
        int relayoutResult = 0;
        if (this.mFirst || windowShouldResize || insetsChanged || viewVisibilityChanged || params != null) {
            boolean focusChangedDueToTouchMode;
            boolean hadSurface;
            boolean contentInsetsChanged;
            boolean hwInitialized;
            block115: {
                if (viewVisibility == 0) {
                    boolean bl3 = insetsPending = computesInternalInsets && (this.mFirst || viewVisibilityChanged);
                }
                if (this.mSurfaceHolder != null) {
                    this.mSurfaceHolder.mSurfaceLock.lock();
                    this.mDrawingAllowed = true;
                }
                hwInitialized = false;
                contentInsetsChanged = false;
                hadSurface = this.mSurface.isValid();
                try {
                    boolean stableInsetsChanged;
                    if (this.mAttachInfo.mHardwareRenderer != null) {
                        this.mAttachInfo.mHardwareRenderer.pauseSurface(this.mSurface);
                    }
                    int surfaceGenerationId = this.mSurface.getGenerationId();
                    relayoutResult = this.relayoutWindow(params, viewVisibility, insetsPending);
                    if (!this.mDrawDuringWindowsAnimating && (relayoutResult & 8) != 0) {
                        this.mWindowsAnimating = true;
                    }
                    if (this.mPendingConfiguration.seq != 0) {
                        this.updateConfiguration(this.mPendingConfiguration, !this.mFirst);
                        this.mPendingConfiguration.seq = 0;
                    }
                    boolean overscanInsetsChanged = !this.mPendingOverscanInsets.equals(this.mAttachInfo.mOverscanInsets);
                    contentInsetsChanged = !this.mPendingContentInsets.equals(this.mAttachInfo.mContentInsets);
                    boolean visibleInsetsChanged = !this.mPendingVisibleInsets.equals(this.mAttachInfo.mVisibleInsets);
                    boolean bl4 = stableInsetsChanged = !this.mPendingStableInsets.equals(this.mAttachInfo.mStableInsets);
                    if (contentInsetsChanged) {
                        if (this.mWidth > 0 && this.mHeight > 0 && lp != null && ((lp.systemUiVisibility | lp.subtreeSystemUiVisibility) & 0x600) == 0 && this.mSurface != null && this.mSurface.isValid() && !this.mAttachInfo.mTurnOffWindowResizeAnim && this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled() && lp != null && !PixelFormat.formatHasAlpha(lp.format) && !this.mBlockResizeBuffer) {
                            this.disposeResizeBuffer();
                        }
                        this.mAttachInfo.mContentInsets.set(this.mPendingContentInsets);
                    }
                    if (overscanInsetsChanged) {
                        this.mAttachInfo.mOverscanInsets.set(this.mPendingOverscanInsets);
                        contentInsetsChanged = true;
                    }
                    if (stableInsetsChanged) {
                        this.mAttachInfo.mStableInsets.set(this.mPendingStableInsets);
                        contentInsetsChanged = true;
                    }
                    if (contentInsetsChanged || this.mLastSystemUiVisibility != this.mAttachInfo.mSystemUiVisibility || this.mApplyInsetsRequested || this.mLastOverscanRequested != this.mAttachInfo.mOverscanRequested) {
                        this.mLastSystemUiVisibility = this.mAttachInfo.mSystemUiVisibility;
                        this.mLastOverscanRequested = this.mAttachInfo.mOverscanRequested;
                        this.mApplyInsetsRequested = false;
                        this.dispatchApplyInsets(host);
                    }
                    if (visibleInsetsChanged) {
                        this.mAttachInfo.mVisibleInsets.set(this.mPendingVisibleInsets);
                    }
                    if (!hadSurface) {
                        if (!this.mSurface.isValid()) break block115;
                        newSurface = true;
                        this.mFullRedrawNeeded = true;
                        this.mPreviousTransparentRegion.setEmpty();
                        if (this.mAttachInfo.mHardwareRenderer == null) break block115;
                        try {
                            hwInitialized = this.mAttachInfo.mHardwareRenderer.initialize(this.mSurface);
                            break block115;
                        }
                        catch (Surface.OutOfResourcesException e) {
                            this.handleOutOfResourcesException(e);
                            return;
                        }
                    }
                    if (!this.mSurface.isValid()) {
                        if (this.mLastScrolledFocus != null) {
                            this.mLastScrolledFocus.clear();
                        }
                        this.mCurScrollY = 0;
                        this.mScrollY = 0;
                        if (this.mScroller != null) {
                            this.mScroller.abortAnimation();
                        }
                        this.disposeResizeBuffer();
                        if (this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled()) {
                            this.mAttachInfo.mHardwareRenderer.destroy();
                        }
                        break block115;
                    }
                    if (surfaceGenerationId == this.mSurface.getGenerationId() || this.mSurfaceHolder != null || this.mAttachInfo.mHardwareRenderer == null) break block115;
                    this.mFullRedrawNeeded = true;
                    try {
                        this.mAttachInfo.mHardwareRenderer.updateSurface(this.mSurface);
                    }
                    catch (Surface.OutOfResourcesException e) {
                        this.handleOutOfResourcesException(e);
                        return;
                    }
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            this.mAttachInfo.mWindowLeft = frame.left;
            this.mAttachInfo.mWindowTop = frame.top;
            if (this.mWidth != frame.width() || this.mHeight != frame.height()) {
                this.mWidth = frame.width();
                this.mHeight = frame.height();
            }
            if (this.mSurfaceHolder != null) {
                if (this.mSurface.isValid()) {
                    this.mSurfaceHolder.mSurface = this.mSurface;
                }
                this.mSurfaceHolder.setSurfaceFrameSize(this.mWidth, this.mHeight);
                this.mSurfaceHolder.mSurfaceLock.unlock();
                if (this.mSurface.isValid()) {
                    if (!hadSurface) {
                        this.mSurfaceHolder.ungetCallbacks();
                        this.mIsCreating = true;
                        this.mSurfaceHolderCallback.surfaceCreated(this.mSurfaceHolder);
                        SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                        if (callbacks != null) {
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceCreated(this.mSurfaceHolder);
                            }
                        }
                        surfaceChanged = true;
                    }
                    if (surfaceChanged) {
                        this.mSurfaceHolderCallback.surfaceChanged(this.mSurfaceHolder, lp.format, this.mWidth, this.mHeight);
                        SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                        if (callbacks != null) {
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceChanged(this.mSurfaceHolder, lp.format, this.mWidth, this.mHeight);
                            }
                        }
                    }
                    this.mIsCreating = false;
                } else if (hadSurface) {
                    this.mSurfaceHolder.ungetCallbacks();
                    SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                    this.mSurfaceHolderCallback.surfaceDestroyed(this.mSurfaceHolder);
                    if (callbacks != null) {
                        for (SurfaceHolder.Callback c : callbacks) {
                            c.surfaceDestroyed(this.mSurfaceHolder);
                        }
                    }
                    this.mSurfaceHolder.mSurfaceLock.lock();
                    try {
                        this.mSurfaceHolder.mSurface = new Surface();
                    }
                    finally {
                        this.mSurfaceHolder.mSurfaceLock.unlock();
                    }
                }
            }
            if (this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled() && (hwInitialized || this.mWidth != this.mAttachInfo.mHardwareRenderer.getWidth() || this.mHeight != this.mAttachInfo.mHardwareRenderer.getHeight())) {
                Rect surfaceInsets = params != null ? params.surfaceInsets : null;
                this.mAttachInfo.mHardwareRenderer.setup(this.mWidth, this.mHeight, surfaceInsets);
                if (!hwInitialized) {
                    this.mAttachInfo.mHardwareRenderer.invalidate(this.mSurface);
                    this.mFullRedrawNeeded = true;
                }
            }
            if (!this.mStopped && ((focusChangedDueToTouchMode = this.ensureTouchModeLocally((relayoutResult & 1) != 0)) || this.mWidth != host.getMeasuredWidth() || this.mHeight != host.getMeasuredHeight() || contentInsetsChanged)) {
                int childWidthMeasureSpec = ViewRootImpl.getRootMeasureSpec(this.mWidth, lp.width);
                int childHeightMeasureSpec = ViewRootImpl.getRootMeasureSpec(this.mHeight, lp.height);
                this.performMeasure(childWidthMeasureSpec, childHeightMeasureSpec);
                int width = host.getMeasuredWidth();
                int height = host.getMeasuredHeight();
                boolean measureAgain = false;
                if (lp.horizontalWeight > 0.0f) {
                    width += (int)((float)(this.mWidth - width) * lp.horizontalWeight);
                    childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
                    measureAgain = true;
                }
                if (lp.verticalWeight > 0.0f) {
                    height += (int)((float)(this.mHeight - height) * lp.verticalWeight);
                    childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
                    measureAgain = true;
                }
                if (measureAgain) {
                    this.performMeasure(childWidthMeasureSpec, childHeightMeasureSpec);
                }
                layoutRequested = true;
            }
        } else {
            boolean windowMoved;
            boolean bl5 = windowMoved = this.mAttachInfo.mWindowLeft != frame.left || this.mAttachInfo.mWindowTop != frame.top;
            if (windowMoved) {
                if (this.mTranslator != null) {
                    this.mTranslator.translateRectInScreenToAppWinFrame(frame);
                }
                this.mAttachInfo.mWindowLeft = frame.left;
                this.mAttachInfo.mWindowTop = frame.top;
            }
        }
        boolean didLayout = layoutRequested && !this.mStopped;
        boolean bl6 = triggerGlobalLayoutListener = didLayout || this.mAttachInfo.mRecomputeGlobalAttributes;
        if (didLayout) {
            this.performLayout(lp, desiredWindowWidth, desiredWindowHeight);
            if ((host.mPrivateFlags & 0x200) != 0) {
                host.getLocationInWindow(this.mTmpLocation);
                this.mTransparentRegion.set(this.mTmpLocation[0], this.mTmpLocation[1], this.mTmpLocation[0] + host.mRight - host.mLeft, this.mTmpLocation[1] + host.mBottom - host.mTop);
                host.gatherTransparentRegion(this.mTransparentRegion);
                if (this.mTranslator != null) {
                    this.mTranslator.translateRegionInWindowToScreen(this.mTransparentRegion);
                }
                if (!this.mTransparentRegion.equals(this.mPreviousTransparentRegion)) {
                    this.mPreviousTransparentRegion.set(this.mTransparentRegion);
                    this.mFullRedrawNeeded = true;
                    try {
                        this.mWindowSession.setTransparentRegion(this.mWindow, this.mTransparentRegion);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
        }
        if (triggerGlobalLayoutListener) {
            this.mAttachInfo.mRecomputeGlobalAttributes = false;
            this.mAttachInfo.mTreeObserver.dispatchOnGlobalLayout();
        }
        if (computesInternalInsets) {
            ViewTreeObserver.InternalInsetsInfo insets = this.mAttachInfo.mGivenInternalInsets;
            insets.reset();
            this.mAttachInfo.mTreeObserver.dispatchOnComputeInternalInsets(insets);
            boolean bl7 = this.mAttachInfo.mHasNonEmptyGivenInternalInsets = !insets.isEmpty();
            if (insetsPending || !this.mLastGivenInsets.equals(insets)) {
                Region touchableRegion;
                Rect visibleInsets;
                Rect contentInsets;
                this.mLastGivenInsets.set(insets);
                if (this.mTranslator != null) {
                    contentInsets = this.mTranslator.getTranslatedContentInsets(insets.contentInsets);
                    visibleInsets = this.mTranslator.getTranslatedVisibleInsets(insets.visibleInsets);
                    touchableRegion = this.mTranslator.getTranslatedTouchableArea(insets.touchableRegion);
                } else {
                    contentInsets = insets.contentInsets;
                    visibleInsets = insets.visibleInsets;
                    touchableRegion = insets.touchableRegion;
                }
                try {
                    this.mWindowSession.setInsets(this.mWindow, insets.mTouchableInsets, contentInsets, visibleInsets, touchableRegion);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        boolean skipDraw = false;
        if (this.mFirst) {
            if (this.mView != null && !this.mView.hasFocus()) {
                this.mView.requestFocus(2);
            }
            if ((relayoutResult & 8) != 0) {
                this.mWindowsAnimating = true;
            }
        } else if (this.mWindowsAnimating) {
            skipDraw = true;
        }
        this.mFirst = false;
        this.mWillDrawSoon = false;
        this.mNewSurfaceNeeded = false;
        this.mViewVisibility = viewVisibility;
        if (this.mAttachInfo.mHasWindowFocus && !this.isInLocalFocusMode() && (imTarget = WindowManager.LayoutParams.mayUseInputMethod(this.mWindowAttributes.flags)) != this.mLastWasImTarget) {
            this.mLastWasImTarget = imTarget;
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null && imTarget) {
                imm.startGettingWindowFocus(this.mView);
                imm.onWindowFocus(this.mView, this.mView.findFocus(), this.mWindowAttributes.softInputMode, !this.mHasHadWindowFocus, this.mWindowAttributes.flags);
            }
        }
        if ((relayoutResult & 2) != 0) {
            this.mReportNextDraw = true;
        }
        boolean bl8 = cancelDraw = this.mAttachInfo.mTreeObserver.dispatchOnPreDraw() || viewVisibility != 0;
        if (!cancelDraw && !newSurface) {
            if (!skipDraw || this.mReportNextDraw) {
                if (this.mPendingTransitions != null && this.mPendingTransitions.size() > 0) {
                    for (int i = 0; i < this.mPendingTransitions.size(); ++i) {
                        this.mPendingTransitions.get(i).startChangingAnimations();
                    }
                    this.mPendingTransitions.clear();
                }
                this.performDraw();
            }
        } else if (viewVisibility == 0) {
            this.scheduleTraversals();
        } else if (this.mPendingTransitions != null && this.mPendingTransitions.size() > 0) {
            for (int i = 0; i < this.mPendingTransitions.size(); ++i) {
                this.mPendingTransitions.get(i).endChangingAnimations();
            }
            this.mPendingTransitions.clear();
        }
        this.mIsInTraversal = false;
    }

    private void handleOutOfResourcesException(Surface.OutOfResourcesException e) {
        Log.e(TAG, "OutOfResourcesException initializing HW surface", e);
        try {
            if (!this.mWindowSession.outOfMemory(this.mWindow) && Process.myUid() != 1000) {
                Slog.w(TAG, "No processes killed for memory; killing self");
                Process.killProcess(Process.myPid());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.mLayoutRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performMeasure(int childWidthMeasureSpec, int childHeightMeasureSpec) {
        Trace.traceBegin(8L, "measure");
        try {
            this.mView.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
        finally {
            Trace.traceEnd(8L);
        }
    }

    boolean isInLayout() {
        return this.mInLayout;
    }

    boolean requestLayoutDuringLayout(View view) {
        if (view.mParent == null || view.mAttachInfo == null) {
            return true;
        }
        if (!this.mLayoutRequesters.contains(view)) {
            this.mLayoutRequesters.add(view);
        }
        return !this.mHandlingLayoutInLayoutRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performLayout(WindowManager.LayoutParams lp, int desiredWindowWidth, int desiredWindowHeight) {
        this.mLayoutRequested = false;
        this.mScrollMayChange = true;
        this.mInLayout = true;
        View host = this.mView;
        Trace.traceBegin(8L, "layout");
        try {
            ArrayList<View> validLayoutRequesters;
            host.layout(0, 0, host.getMeasuredWidth(), host.getMeasuredHeight());
            this.mInLayout = false;
            int numViewsRequestingLayout = this.mLayoutRequesters.size();
            if (numViewsRequestingLayout > 0 && (validLayoutRequesters = this.getValidLayoutRequesters(this.mLayoutRequesters, false)) != null) {
                this.mHandlingLayoutInLayoutRequest = true;
                int numValidRequests = validLayoutRequesters.size();
                for (int i = 0; i < numValidRequests; ++i) {
                    View view = validLayoutRequesters.get(i);
                    Log.w("View", "requestLayout() improperly called by " + view + " during layout: running second layout pass");
                    view.requestLayout();
                }
                this.measureHierarchy(host, lp, this.mView.getContext().getResources(), desiredWindowWidth, desiredWindowHeight);
                this.mInLayout = true;
                host.layout(0, 0, host.getMeasuredWidth(), host.getMeasuredHeight());
                this.mHandlingLayoutInLayoutRequest = false;
                validLayoutRequesters = this.getValidLayoutRequesters(this.mLayoutRequesters, true);
                if (validLayoutRequesters != null) {
                    final ArrayList<View> finalRequesters = validLayoutRequesters;
                    ViewRootImpl.getRunQueue().post(new Runnable(){

                        @Override
                        public void run() {
                            int numValidRequests = finalRequesters.size();
                            for (int i = 0; i < numValidRequests; ++i) {
                                View view = (View)finalRequesters.get(i);
                                Log.w("View", "requestLayout() improperly called by " + view + " during second layout pass: posting in next frame");
                                view.requestLayout();
                            }
                        }
                    });
                }
            }
        }
        finally {
            Trace.traceEnd(8L);
        }
        this.mInLayout = false;
    }

    private ArrayList<View> getValidLayoutRequesters(ArrayList<View> layoutRequesters, boolean secondLayoutRequests) {
        View view;
        int i;
        int numViewsRequestingLayout = layoutRequesters.size();
        ArrayList<View> validLayoutRequesters = null;
        for (i = 0; i < numViewsRequestingLayout; ++i) {
            view = layoutRequesters.get(i);
            if (view == null || view.mAttachInfo == null || view.mParent == null || !secondLayoutRequests && (view.mPrivateFlags & 0x1000) != 4096) continue;
            boolean gone = false;
            View parent = view;
            while (parent != null) {
                if ((parent.mViewFlags & 0xC) == 8) {
                    gone = true;
                    break;
                }
                if (parent.mParent instanceof View) {
                    parent = (View)((Object)parent.mParent);
                    continue;
                }
                parent = null;
            }
            if (gone) continue;
            if (validLayoutRequesters == null) {
                validLayoutRequesters = new ArrayList<View>();
            }
            validLayoutRequesters.add(view);
        }
        if (!secondLayoutRequests) {
            for (i = 0; i < numViewsRequestingLayout; ++i) {
                view = layoutRequesters.get(i);
                while (view != null && (view.mPrivateFlags & 0x1000) != 0) {
                    view.mPrivateFlags &= 0xFFFFEFFF;
                    if (view.mParent instanceof View) {
                        view = (View)((Object)view.mParent);
                        continue;
                    }
                    view = null;
                }
            }
        }
        layoutRequesters.clear();
        return validLayoutRequesters;
    }

    @Override
    public void requestTransparentRegion(View child) {
        this.checkThread();
        if (this.mView == child) {
            this.mView.mPrivateFlags |= 0x200;
            this.mWindowAttributesChanged = true;
            this.mWindowAttributesChangesFlag = 0;
            this.requestLayout();
        }
    }

    private static int getRootMeasureSpec(int windowSize, int rootDimension) {
        int measureSpec;
        switch (rootDimension) {
            case -1: {
                measureSpec = View.MeasureSpec.makeMeasureSpec(windowSize, 0x40000000);
                break;
            }
            case -2: {
                measureSpec = View.MeasureSpec.makeMeasureSpec(windowSize, Integer.MIN_VALUE);
                break;
            }
            default: {
                measureSpec = View.MeasureSpec.makeMeasureSpec(rootDimension, 0x40000000);
            }
        }
        return measureSpec;
    }

    @Override
    public void onHardwarePreDraw(HardwareCanvas canvas) {
        canvas.translate(-this.mHardwareXOffset, -this.mHardwareYOffset);
    }

    @Override
    public void onHardwarePostDraw(HardwareCanvas canvas) {
        if (this.mResizeBuffer != null) {
            this.mResizePaint.setAlpha(this.mResizeAlpha);
            canvas.drawHardwareLayer(this.mResizeBuffer, this.mHardwareXOffset, this.mHardwareYOffset, this.mResizePaint);
        }
    }

    void outputDisplayList(View view) {
        RenderNode renderNode = view.getDisplayList();
        if (renderNode != null) {
            renderNode.output();
        }
    }

    private void profileRendering(boolean enabled) {
        if (this.mProfileRendering) {
            this.mRenderProfilingEnabled = enabled;
            if (this.mRenderProfiler != null) {
                this.mChoreographer.removeFrameCallback(this.mRenderProfiler);
            }
            if (this.mRenderProfilingEnabled) {
                if (this.mRenderProfiler == null) {
                    this.mRenderProfiler = new Choreographer.FrameCallback(){

                        @Override
                        public void doFrame(long frameTimeNanos) {
                            ViewRootImpl.this.mDirty.set(0, 0, ViewRootImpl.this.mWidth, ViewRootImpl.this.mHeight);
                            ViewRootImpl.this.scheduleTraversals();
                            if (ViewRootImpl.this.mRenderProfilingEnabled) {
                                ViewRootImpl.this.mChoreographer.postFrameCallback(ViewRootImpl.this.mRenderProfiler);
                            }
                        }
                    };
                }
                this.mChoreographer.postFrameCallback(this.mRenderProfiler);
            } else {
                this.mRenderProfiler = null;
            }
        }
    }

    private void trackFPS() {
        long nowTime = System.currentTimeMillis();
        if (this.mFpsStartTime < 0L) {
            this.mFpsStartTime = this.mFpsPrevTime = nowTime;
            this.mFpsNumFrames = 0;
        } else {
            ++this.mFpsNumFrames;
            String thisHash = Integer.toHexString(System.identityHashCode(this));
            long frameTime = nowTime - this.mFpsPrevTime;
            long totalTime = nowTime - this.mFpsStartTime;
            Log.v(TAG, "0x" + thisHash + "\tFrame time:\t" + frameTime);
            this.mFpsPrevTime = nowTime;
            if (totalTime > 1000L) {
                float fps = (float)this.mFpsNumFrames * 1000.0f / (float)totalTime;
                Log.v(TAG, "0x" + thisHash + "\tFPS:\t" + fps);
                this.mFpsStartTime = nowTime;
                this.mFpsNumFrames = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDraw() {
        if (this.mAttachInfo.mDisplayState == 1 && !this.mReportNextDraw) {
            return;
        }
        boolean fullRedrawNeeded = this.mFullRedrawNeeded;
        this.mFullRedrawNeeded = false;
        this.mIsDrawing = true;
        Trace.traceBegin(8L, "draw");
        try {
            this.draw(fullRedrawNeeded);
        }
        finally {
            this.mIsDrawing = false;
            Trace.traceEnd(8L);
        }
        if (this.mAttachInfo.mPendingAnimatingRenderNodes != null) {
            int count = this.mAttachInfo.mPendingAnimatingRenderNodes.size();
            for (int i = 0; i < count; ++i) {
                this.mAttachInfo.mPendingAnimatingRenderNodes.get(i).endAllAnimators();
            }
            this.mAttachInfo.mPendingAnimatingRenderNodes.clear();
        }
        if (this.mReportNextDraw) {
            this.mReportNextDraw = false;
            if (this.mAttachInfo.mHardwareRenderer != null) {
                this.mAttachInfo.mHardwareRenderer.fence();
            }
            if (this.mSurfaceHolder != null && this.mSurface.isValid()) {
                this.mSurfaceHolderCallback.surfaceRedrawNeeded(this.mSurfaceHolder);
                SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                if (callbacks != null) {
                    for (SurfaceHolder.Callback c : callbacks) {
                        if (!(c instanceof SurfaceHolder.Callback2)) continue;
                        ((SurfaceHolder.Callback2)c).surfaceRedrawNeeded(this.mSurfaceHolder);
                    }
                }
            }
            try {
                this.mWindowSession.finishDrawing(this.mWindow);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void draw(boolean fullRedrawNeeded) {
        Rect surfaceInsets;
        boolean animating;
        int curScrollY;
        Surface surface = this.mSurface;
        if (!surface.isValid()) {
            return;
        }
        if (!sFirstDrawComplete) {
            ArrayList<Runnable> arrayList = sFirstDrawHandlers;
            synchronized (arrayList) {
                sFirstDrawComplete = true;
                int count = sFirstDrawHandlers.size();
                for (int i = 0; i < count; ++i) {
                    this.mHandler.post(sFirstDrawHandlers.get(i));
                }
            }
        }
        this.scrollToRectOrFocus(null, false);
        if (this.mAttachInfo.mViewScrollChanged) {
            this.mAttachInfo.mViewScrollChanged = false;
            this.mAttachInfo.mTreeObserver.dispatchOnScrollChanged();
        }
        if (this.mCurScrollY != (curScrollY = (animating = this.mScroller != null && this.mScroller.computeScrollOffset()) ? this.mScroller.getCurrY() : this.mScrollY)) {
            this.mCurScrollY = curScrollY;
            fullRedrawNeeded = true;
        }
        float appScale = this.mAttachInfo.mApplicationScale;
        boolean scalingRequired = this.mAttachInfo.mScalingRequired;
        int resizeAlpha = 0;
        if (this.mResizeBuffer != null) {
            long deltaTime = SystemClock.uptimeMillis() - this.mResizeBufferStartTime;
            if (deltaTime < (long)this.mResizeBufferDuration) {
                float amt = (float)deltaTime / (float)this.mResizeBufferDuration;
                amt = mResizeInterpolator.getInterpolation(amt);
                animating = true;
                resizeAlpha = 255 - (int)(amt * 255.0f);
            } else {
                this.disposeResizeBuffer();
            }
        }
        Rect dirty = this.mDirty;
        if (this.mSurfaceHolder != null) {
            dirty.setEmpty();
            if (animating) {
                if (this.mScroller != null) {
                    this.mScroller.abortAnimation();
                }
                this.disposeResizeBuffer();
            }
            return;
        }
        if (fullRedrawNeeded) {
            this.mAttachInfo.mIgnoreDirtyState = true;
            dirty.set(0, 0, (int)((float)this.mWidth * appScale + 0.5f), (int)((float)this.mHeight * appScale + 0.5f));
        }
        this.mAttachInfo.mTreeObserver.dispatchOnDraw();
        int xOffset = 0;
        int yOffset = curScrollY;
        WindowManager.LayoutParams params = this.mWindowAttributes;
        Rect rect = surfaceInsets = params != null ? params.surfaceInsets : null;
        if (surfaceInsets != null) {
            xOffset -= surfaceInsets.left;
            yOffset -= surfaceInsets.top;
            dirty.offset(surfaceInsets.left, surfaceInsets.right);
        }
        if (!dirty.isEmpty() || this.mIsAnimating) {
            if (this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled()) {
                this.mIsAnimating = false;
                boolean invalidateRoot = false;
                if (this.mHardwareYOffset != yOffset || this.mHardwareXOffset != xOffset) {
                    this.mHardwareYOffset = yOffset;
                    this.mHardwareXOffset = xOffset;
                    this.mAttachInfo.mHardwareRenderer.invalidateRoot();
                }
                this.mResizeAlpha = resizeAlpha;
                dirty.setEmpty();
                this.mBlockResizeBuffer = false;
                this.mAttachInfo.mHardwareRenderer.draw(this.mView, this.mAttachInfo, this);
            } else {
                if (this.mAttachInfo.mHardwareRenderer != null && !this.mAttachInfo.mHardwareRenderer.isEnabled() && this.mAttachInfo.mHardwareRenderer.isRequested()) {
                    try {
                        this.mAttachInfo.mHardwareRenderer.initializeIfNeeded(this.mWidth, this.mHeight, this.mSurface, surfaceInsets);
                    }
                    catch (Surface.OutOfResourcesException e) {
                        this.handleOutOfResourcesException(e);
                        return;
                    }
                    this.mFullRedrawNeeded = true;
                    this.scheduleTraversals();
                    return;
                }
                if (!this.drawSoftware(surface, this.mAttachInfo, xOffset, yOffset, scalingRequired, dirty)) {
                    return;
                }
            }
        }
        if (animating) {
            this.mFullRedrawNeeded = true;
            this.scheduleTraversals();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drawSoftware(Surface surface, View.AttachInfo attachInfo, int xoff, int yoff, boolean scalingRequired, Rect dirty) {
        Canvas canvas;
        try {
            int left = dirty.left;
            int top = dirty.top;
            int right = dirty.right;
            int bottom = dirty.bottom;
            canvas = this.mSurface.lockCanvas(dirty);
            if (left != dirty.left || top != dirty.top || right != dirty.right || bottom != dirty.bottom) {
                attachInfo.mIgnoreDirtyState = true;
            }
            canvas.setDensity(this.mDensity);
        }
        catch (Surface.OutOfResourcesException e) {
            this.handleOutOfResourcesException(e);
            return false;
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Could not lock surface", e);
            this.mLayoutRequested = true;
            return false;
        }
        try {
            if (!canvas.isOpaque() || yoff != 0 || xoff != 0) {
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            }
            dirty.setEmpty();
            this.mIsAnimating = false;
            attachInfo.mDrawingTime = SystemClock.uptimeMillis();
            this.mView.mPrivateFlags |= 0x20;
            try {
                canvas.translate(-xoff, -yoff);
                if (this.mTranslator != null) {
                    this.mTranslator.translateCanvas(canvas);
                }
                canvas.setScreenDensity(scalingRequired ? this.mNoncompatDensity : 0);
                attachInfo.mSetIgnoreDirtyState = false;
                this.mView.draw(canvas);
            }
            finally {
                if (!attachInfo.mSetIgnoreDirtyState) {
                    attachInfo.mIgnoreDirtyState = false;
                }
            }
        }
        finally {
            try {
                surface.unlockCanvasAndPost(canvas);
            }
            catch (IllegalArgumentException e) {
                Log.e(TAG, "Could not unlock surface", e);
                this.mLayoutRequested = true;
                return false;
            }
        }
        return true;
    }

    Drawable getAccessibilityFocusedDrawable() {
        if (this.mAttachInfo.mAccessibilityFocusDrawable == null) {
            TypedValue value = new TypedValue();
            boolean resolved = this.mView.mContext.getTheme().resolveAttribute(16844044, value, true);
            if (resolved) {
                this.mAttachInfo.mAccessibilityFocusDrawable = this.mView.mContext.getDrawable(value.resourceId);
            }
        }
        return this.mAttachInfo.mAccessibilityFocusDrawable;
    }

    public void setDrawDuringWindowsAnimating(boolean value) {
        this.mDrawDuringWindowsAnimating = value;
        if (value) {
            this.handleDispatchDoneAnimating();
        }
    }

    boolean scrollToRectOrFocus(Rect rectangle, boolean immediate) {
        Rect ci = this.mAttachInfo.mContentInsets;
        Rect vi = this.mAttachInfo.mVisibleInsets;
        int scrollY = 0;
        boolean handled = false;
        if (vi.left > ci.left || vi.top > ci.top || vi.right > ci.right || vi.bottom > ci.bottom) {
            View lastScrolledFocus;
            scrollY = this.mScrollY;
            View focus = this.mView.findFocus();
            if (focus == null) {
                return false;
            }
            View view = lastScrolledFocus = this.mLastScrolledFocus != null ? (View)this.mLastScrolledFocus.get() : null;
            if (focus != lastScrolledFocus) {
                rectangle = null;
            }
            if (focus != lastScrolledFocus || this.mScrollMayChange || rectangle != null) {
                this.mLastScrolledFocus = new WeakReference<View>(focus);
                this.mScrollMayChange = false;
                if (focus.getGlobalVisibleRect(this.mVisRect, null)) {
                    if (rectangle == null) {
                        focus.getFocusedRect(this.mTempRect);
                        if (this.mView instanceof ViewGroup) {
                            ((ViewGroup)this.mView).offsetDescendantRectToMyCoords(focus, this.mTempRect);
                        }
                    } else {
                        this.mTempRect.set(rectangle);
                    }
                    if (this.mTempRect.intersect(this.mVisRect)) {
                        if (this.mTempRect.height() <= this.mView.getHeight() - vi.top - vi.bottom) {
                            if (this.mTempRect.top - scrollY < vi.top) {
                                scrollY -= vi.top - (this.mTempRect.top - scrollY);
                            } else if (this.mTempRect.bottom - scrollY > this.mView.getHeight() - vi.bottom) {
                                scrollY += this.mTempRect.bottom - scrollY - (this.mView.getHeight() - vi.bottom);
                            }
                        }
                        handled = true;
                    }
                }
            }
        }
        if (scrollY != this.mScrollY) {
            if (!immediate && this.mResizeBuffer == null) {
                if (this.mScroller == null) {
                    this.mScroller = new Scroller(this.mView.getContext());
                }
                this.mScroller.startScroll(0, this.mScrollY, 0, scrollY - this.mScrollY);
            } else if (this.mScroller != null) {
                this.mScroller.abortAnimation();
            }
            this.mScrollY = scrollY;
        }
        return handled;
    }

    public View getAccessibilityFocusedHost() {
        return this.mAccessibilityFocusedHost;
    }

    public AccessibilityNodeInfo getAccessibilityFocusedVirtualView() {
        return this.mAccessibilityFocusedVirtualView;
    }

    void setAccessibilityFocus(View view, AccessibilityNodeInfo node) {
        if (this.mAccessibilityFocusedVirtualView != null) {
            AccessibilityNodeInfo focusNode = this.mAccessibilityFocusedVirtualView;
            View focusHost = this.mAccessibilityFocusedHost;
            this.mAccessibilityFocusedHost = null;
            this.mAccessibilityFocusedVirtualView = null;
            focusHost.clearAccessibilityFocusNoCallbacks();
            AccessibilityNodeProvider provider = focusHost.getAccessibilityNodeProvider();
            if (provider != null) {
                focusNode.getBoundsInParent(this.mTempRect);
                focusHost.invalidate(this.mTempRect);
                int virtualNodeId = AccessibilityNodeInfo.getVirtualDescendantId(focusNode.getSourceNodeId());
                provider.performAction(virtualNodeId, 128, null);
            }
            focusNode.recycle();
        }
        if (this.mAccessibilityFocusedHost != null) {
            this.mAccessibilityFocusedHost.clearAccessibilityFocusNoCallbacks();
        }
        this.mAccessibilityFocusedHost = view;
        this.mAccessibilityFocusedVirtualView = node;
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.invalidateRoot();
        }
    }

    @Override
    public void requestChildFocus(View child, View focused) {
        this.checkThread();
        this.scheduleTraversals();
    }

    @Override
    public void clearChildFocus(View child) {
        this.checkThread();
        this.scheduleTraversals();
    }

    @Override
    public ViewParent getParentForAccessibility() {
        return null;
    }

    @Override
    public void focusableViewAvailable(View v) {
        this.checkThread();
        if (this.mView != null) {
            if (!this.mView.hasFocus()) {
                v.requestFocus();
            } else {
                ViewGroup group;
                View focused = this.mView.findFocus();
                if (focused instanceof ViewGroup && (group = (ViewGroup)focused).getDescendantFocusability() == 262144 && ViewRootImpl.isViewDescendantOf(v, focused)) {
                    v.requestFocus();
                }
            }
        }
    }

    @Override
    public void recomputeViewAttributes(View child) {
        this.checkThread();
        if (this.mView == child) {
            this.mAttachInfo.mRecomputeGlobalAttributes = true;
            if (!this.mWillDrawSoon) {
                this.scheduleTraversals();
            }
        }
    }

    void dispatchDetachedFromWindow() {
        if (this.mView != null && this.mView.mAttachInfo != null) {
            this.mAttachInfo.mTreeObserver.dispatchOnWindowAttachedChange(false);
            this.mView.dispatchDetachedFromWindow();
        }
        this.mAccessibilityInteractionConnectionManager.ensureNoConnection();
        this.mAccessibilityManager.removeAccessibilityStateChangeListener(this.mAccessibilityInteractionConnectionManager);
        this.mAccessibilityManager.removeHighTextContrastStateChangeListener(this.mHighContrastTextManager);
        this.removeSendWindowContentChangedCallback();
        this.destroyHardwareRenderer();
        this.setAccessibilityFocus(null, null);
        this.mView.assignParent(null);
        this.mView = null;
        this.mAttachInfo.mRootView = null;
        this.mSurface.release();
        if (this.mInputQueueCallback != null && this.mInputQueue != null) {
            this.mInputQueueCallback.onInputQueueDestroyed(this.mInputQueue);
            this.mInputQueue.dispose();
            this.mInputQueueCallback = null;
            this.mInputQueue = null;
        }
        if (this.mInputEventReceiver != null) {
            this.mInputEventReceiver.dispose();
            this.mInputEventReceiver = null;
        }
        try {
            this.mWindowSession.remove(this.mWindow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.mInputChannel != null) {
            this.mInputChannel.dispose();
            this.mInputChannel = null;
        }
        this.mDisplayManager.unregisterDisplayListener(this.mDisplayListener);
        this.unscheduleTraversals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConfiguration(Configuration config, boolean force) {
        CompatibilityInfo ci = this.mDisplayAdjustments.getCompatibilityInfo();
        if (!ci.equals(CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO)) {
            config = new Configuration(config);
            ci.applyToConfiguration(this.mNoncompatDensity, config);
        }
        ArrayList<ComponentCallbacks> arrayList = sConfigCallbacks;
        synchronized (arrayList) {
            for (int i = sConfigCallbacks.size() - 1; i >= 0; --i) {
                sConfigCallbacks.get(i).onConfigurationChanged(config);
            }
        }
        if (this.mView != null) {
            config = this.mView.getResources().getConfiguration();
            if (force || this.mLastConfiguration.diff(config) != 0) {
                int lastLayoutDirection = this.mLastConfiguration.getLayoutDirection();
                int currentLayoutDirection = config.getLayoutDirection();
                this.mLastConfiguration.setTo(config);
                if (lastLayoutDirection != currentLayoutDirection && this.mViewLayoutDirectionInitial == 2) {
                    this.mView.setLayoutDirection(currentLayoutDirection);
                }
                this.mView.dispatchConfigurationChanged(config);
            }
        }
    }

    public static boolean isViewDescendantOf(View child, View parent) {
        if (child == parent) {
            return true;
        }
        ViewParent theParent = child.getParent();
        return theParent instanceof ViewGroup && ViewRootImpl.isViewDescendantOf((View)((Object)theParent), parent);
    }

    private static void forceLayout(View view) {
        view.forceLayout();
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewRootImpl.forceLayout(group.getChildAt(i));
            }
        }
    }

    boolean ensureTouchMode(boolean inTouchMode) {
        if (this.mAttachInfo.mInTouchMode == inTouchMode) {
            return false;
        }
        try {
            if (!this.isInLocalFocusMode()) {
                this.mWindowSession.setInTouchMode(inTouchMode);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return this.ensureTouchModeLocally(inTouchMode);
    }

    private boolean ensureTouchModeLocally(boolean inTouchMode) {
        if (this.mAttachInfo.mInTouchMode == inTouchMode) {
            return false;
        }
        this.mAttachInfo.mInTouchMode = inTouchMode;
        this.mAttachInfo.mTreeObserver.dispatchOnTouchModeChanged(inTouchMode);
        return inTouchMode ? this.enterTouchMode() : this.leaveTouchMode();
    }

    private boolean enterTouchMode() {
        View focused;
        if (this.mView != null && this.mView.hasFocus() && (focused = this.mView.findFocus()) != null && !focused.isFocusableInTouchMode()) {
            ViewGroup ancestorToTakeFocus = ViewRootImpl.findAncestorToTakeFocusInTouchMode(focused);
            if (ancestorToTakeFocus != null) {
                return ancestorToTakeFocus.requestFocus();
            }
            focused.clearFocusInternal(null, true, false);
            return true;
        }
        return false;
    }

    private static ViewGroup findAncestorToTakeFocusInTouchMode(View focused) {
        ViewParent parent = focused.getParent();
        while (parent instanceof ViewGroup) {
            ViewGroup vgParent = (ViewGroup)parent;
            if (vgParent.getDescendantFocusability() == 262144 && vgParent.isFocusableInTouchMode()) {
                return vgParent;
            }
            if (vgParent.isRootNamespace()) {
                return null;
            }
            parent = vgParent.getParent();
        }
        return null;
    }

    private boolean leaveTouchMode() {
        if (this.mView != null) {
            View focused;
            if (this.mView.hasFocus()) {
                View focusedView = this.mView.findFocus();
                if (!(focusedView instanceof ViewGroup)) {
                    return false;
                }
                if (((ViewGroup)focusedView).getDescendantFocusability() != 262144) {
                    return false;
                }
            }
            if ((focused = this.focusSearch(null, 130)) != null) {
                return focused.requestFocus(130);
            }
        }
        return false;
    }

    private static boolean isNavigationKey(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 61: 
            case 62: 
            case 66: 
            case 92: 
            case 93: 
            case 122: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    private static boolean isTypingKey(KeyEvent keyEvent) {
        return keyEvent.getUnicodeChar() > 0;
    }

    private boolean checkForLeavingTouchModeAndConsume(KeyEvent event) {
        if (!this.mAttachInfo.mInTouchMode) {
            return false;
        }
        int action = event.getAction();
        if (action != 0 && action != 2) {
            return false;
        }
        if ((event.getFlags() & 4) != 0) {
            return false;
        }
        if (ViewRootImpl.isNavigationKey(event)) {
            return this.ensureTouchMode(false);
        }
        if (ViewRootImpl.isTypingKey(event)) {
            this.ensureTouchMode(false);
            return false;
        }
        return false;
    }

    void setLocalDragState(Object obj) {
        this.mLocalDragState = obj;
    }

    private void handleDragEvent(DragEvent event) {
        if (this.mView != null && this.mAdded) {
            int what = event.mAction;
            if (what == 6) {
                this.mView.dispatchDragEvent(event);
            } else {
                if (what == 1) {
                    this.mCurrentDragView = null;
                    this.mDragDescription = event.mClipDescription;
                } else {
                    event.mClipDescription = this.mDragDescription;
                }
                if (what == 2 || what == 3) {
                    this.mDragPoint.set(event.mX, event.mY);
                    if (this.mTranslator != null) {
                        this.mTranslator.translatePointInScreenToAppWindow(this.mDragPoint);
                    }
                    if (this.mCurScrollY != 0) {
                        this.mDragPoint.offset(0.0f, this.mCurScrollY);
                    }
                    event.mX = this.mDragPoint.x;
                    event.mY = this.mDragPoint.y;
                }
                View prevDragView = this.mCurrentDragView;
                boolean result = this.mView.dispatchDragEvent(event);
                if (prevDragView != this.mCurrentDragView) {
                    try {
                        if (prevDragView != null) {
                            this.mWindowSession.dragRecipientExited(this.mWindow);
                        }
                        if (this.mCurrentDragView != null) {
                            this.mWindowSession.dragRecipientEntered(this.mWindow);
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e(TAG, "Unable to note drag target change");
                    }
                }
                if (what == 3) {
                    this.mDragDescription = null;
                    try {
                        Log.i(TAG, "Reporting drop result: " + result);
                        this.mWindowSession.reportDropResult(this.mWindow, result);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Unable to report drop result");
                    }
                }
                if (what == 4) {
                    this.setLocalDragState(null);
                }
            }
        }
        event.recycle();
    }

    public void handleDispatchSystemUiVisibilityChanged(SystemUiVisibilityInfo args) {
        int visibility;
        if (this.mSeq != args.seq) {
            this.mSeq = args.seq;
            this.mAttachInfo.mForceReportNewAttributes = true;
            this.scheduleTraversals();
        }
        if (this.mView == null) {
            return;
        }
        if (args.localChanges != 0) {
            this.mView.updateLocalSystemUiVisibility(args.localValue, args.localChanges);
        }
        if ((visibility = args.globalVisibility & 7) != this.mAttachInfo.mGlobalSystemUiVisibility) {
            this.mAttachInfo.mGlobalSystemUiVisibility = visibility;
            this.mView.dispatchSystemUiVisibilityChanged(visibility);
        }
    }

    public void handleDispatchDoneAnimating() {
        if (this.mWindowsAnimating) {
            this.mWindowsAnimating = false;
            if (!this.mDirty.isEmpty() || this.mIsAnimating || this.mFullRedrawNeeded) {
                this.scheduleTraversals();
            }
        }
    }

    public void getLastTouchPoint(Point outLocation) {
        outLocation.x = (int)this.mLastTouchPoint.x;
        outLocation.y = (int)this.mLastTouchPoint.y;
    }

    public void setDragFocus(View newDragTarget) {
        if (this.mCurrentDragView != newDragTarget) {
            this.mCurrentDragView = newDragTarget;
        }
    }

    private AudioManager getAudioManager() {
        if (this.mView == null) {
            throw new IllegalStateException("getAudioManager called when there is no mView");
        }
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.mView.getContext().getSystemService("audio");
        }
        return this.mAudioManager;
    }

    public AccessibilityInteractionController getAccessibilityInteractionController() {
        if (this.mView == null) {
            throw new IllegalStateException("getAccessibilityInteractionController called when there is no mView");
        }
        if (this.mAccessibilityInteractionController == null) {
            this.mAccessibilityInteractionController = new AccessibilityInteractionController(this);
        }
        return this.mAccessibilityInteractionController;
    }

    private int relayoutWindow(WindowManager.LayoutParams params, int viewVisibility, boolean insetsPending) throws RemoteException {
        float appScale = this.mAttachInfo.mApplicationScale;
        boolean restore = false;
        if (params != null && this.mTranslator != null) {
            restore = true;
            params.backup();
            this.mTranslator.translateWindowLayout(params);
        }
        if (params != null) {
            // empty if block
        }
        this.mPendingConfiguration.seq = 0;
        if (params != null && this.mOrigWindowType != params.type && this.mTargetSdkVersion < 14) {
            Slog.w(TAG, "Window type can not be changed after the window is added; ignoring change of " + this.mView);
            params.type = this.mOrigWindowType;
        }
        int relayoutResult = this.mWindowSession.relayout(this.mWindow, this.mSeq, params, (int)((float)this.mView.getMeasuredWidth() * appScale + 0.5f), (int)((float)this.mView.getMeasuredHeight() * appScale + 0.5f), viewVisibility, insetsPending ? 1 : 0, this.mWinFrame, this.mPendingOverscanInsets, this.mPendingContentInsets, this.mPendingVisibleInsets, this.mPendingStableInsets, this.mPendingConfiguration, this.mSurface);
        if (restore) {
            params.restore();
        }
        if (this.mTranslator != null) {
            this.mTranslator.translateRectInScreenToAppWinFrame(this.mWinFrame);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingOverscanInsets);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingContentInsets);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingVisibleInsets);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingStableInsets);
        }
        return relayoutResult;
    }

    @Override
    public void playSoundEffect(int effectId) {
        this.checkThread();
        if (this.mMediaDisabled) {
            return;
        }
        try {
            AudioManager audioManager = this.getAudioManager();
            switch (effectId) {
                case 0: {
                    audioManager.playSoundEffect(0);
                    return;
                }
                case 4: {
                    audioManager.playSoundEffect(2);
                    return;
                }
                case 1: {
                    audioManager.playSoundEffect(3);
                    return;
                }
                case 3: {
                    audioManager.playSoundEffect(4);
                    return;
                }
                case 2: {
                    audioManager.playSoundEffect(1);
                    return;
                }
            }
            throw new IllegalArgumentException("unknown effect id " + effectId + " not defined in " + SoundEffectConstants.class.getCanonicalName());
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "FATAL EXCEPTION when attempting to play sound effect: " + e);
            e.printStackTrace();
            return;
        }
    }

    @Override
    public boolean performHapticFeedback(int effectId, boolean always) {
        try {
            return this.mWindowSession.performHapticFeedback(this.mWindow, effectId, always);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public View focusSearch(View focused, int direction) {
        this.checkThread();
        if (!(this.mView instanceof ViewGroup)) {
            return null;
        }
        return FocusFinder.getInstance().findNextFocus((ViewGroup)this.mView, focused, direction);
    }

    public void debug() {
        this.mView.debug();
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        String innerPrefix = prefix + "  ";
        writer.print(prefix);
        writer.println("ViewRoot:");
        writer.print(innerPrefix);
        writer.print("mAdded=");
        writer.print(this.mAdded);
        writer.print(" mRemoved=");
        writer.println(this.mRemoved);
        writer.print(innerPrefix);
        writer.print("mConsumeBatchedInputScheduled=");
        writer.println(this.mConsumeBatchedInputScheduled);
        writer.print(innerPrefix);
        writer.print("mConsumeBatchedInputImmediatelyScheduled=");
        writer.println(this.mConsumeBatchedInputImmediatelyScheduled);
        writer.print(innerPrefix);
        writer.print("mPendingInputEventCount=");
        writer.println(this.mPendingInputEventCount);
        writer.print(innerPrefix);
        writer.print("mProcessInputEventsScheduled=");
        writer.println(this.mProcessInputEventsScheduled);
        writer.print(innerPrefix);
        writer.print("mTraversalScheduled=");
        writer.print(this.mTraversalScheduled);
        if (this.mTraversalScheduled) {
            writer.print(" (barrier=");
            writer.print(this.mTraversalBarrier);
            writer.println(")");
        } else {
            writer.println();
        }
        this.mFirstInputStage.dump(innerPrefix, writer);
        this.mChoreographer.dump(prefix, writer);
        writer.print(prefix);
        writer.println("View Hierarchy:");
        this.dumpViewHierarchy(innerPrefix, writer, this.mView);
    }

    private void dumpViewHierarchy(String prefix, PrintWriter writer, View view) {
        writer.print(prefix);
        if (view == null) {
            writer.println("null");
            return;
        }
        writer.println(view.toString());
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup grp = (ViewGroup)view;
        int N = grp.getChildCount();
        if (N <= 0) {
            return;
        }
        prefix = prefix + "  ";
        for (int i = 0; i < N; ++i) {
            this.dumpViewHierarchy(prefix, writer, grp.getChildAt(i));
        }
    }

    public void dumpGfxInfo(int[] info) {
        info[1] = 0;
        info[0] = 0;
        if (this.mView != null) {
            ViewRootImpl.getGfxInfo(this.mView, info);
        }
    }

    private static void getGfxInfo(View view, int[] info) {
        RenderNode renderNode = view.mRenderNode;
        info[0] = info[0] + 1;
        if (renderNode != null) {
            info[1] = info[1] + renderNode.getDebugSize();
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewRootImpl.getGfxInfo(group.getChildAt(i), info);
            }
        }
    }

    boolean die(boolean immediate) {
        if (immediate && !this.mIsInTraversal) {
            this.doDie();
            return false;
        }
        if (!this.mIsDrawing) {
            this.destroyHardwareRenderer();
        } else {
            Log.e(TAG, "Attempting to destroy the window while drawing!\n  window=" + this + ", title=" + this.mWindowAttributes.getTitle());
        }
        this.mHandler.sendEmptyMessage(3);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDie() {
        this.checkThread();
        ViewRootImpl viewRootImpl = this;
        synchronized (viewRootImpl) {
            if (this.mRemoved) {
                return;
            }
            this.mRemoved = true;
            if (this.mAdded) {
                this.dispatchDetachedFromWindow();
            }
            if (this.mAdded && !this.mFirst) {
                this.destroyHardwareRenderer();
                if (this.mView != null) {
                    boolean viewVisibilityChanged;
                    int viewVisibility = this.mView.getVisibility();
                    boolean bl = viewVisibilityChanged = this.mViewVisibility != viewVisibility;
                    if (this.mWindowAttributesChanged || viewVisibilityChanged) {
                        try {
                            if ((this.relayoutWindow(this.mWindowAttributes, viewVisibility, false) & 2) != 0) {
                                this.mWindowSession.finishDrawing(this.mWindow);
                            }
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    this.mSurface.release();
                }
            }
            this.mAdded = false;
        }
        WindowManagerGlobal.getInstance().doRemoveView(this);
    }

    public void requestUpdateConfiguration(Configuration config) {
        Message msg = this.mHandler.obtainMessage(18, config);
        this.mHandler.sendMessage(msg);
    }

    public void loadSystemProperties() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                boolean layout2;
                ViewRootImpl.this.mProfileRendering = SystemProperties.getBoolean(ViewRootImpl.PROPERTY_PROFILE_RENDERING, false);
                ViewRootImpl.this.profileRendering(ViewRootImpl.this.mAttachInfo.mHasWindowFocus);
                ViewRootImpl.this.mMediaDisabled = SystemProperties.getBoolean(ViewRootImpl.PROPERTY_MEDIA_DISABLED, false);
                if (ViewRootImpl.this.mAttachInfo.mHardwareRenderer != null && ViewRootImpl.this.mAttachInfo.mHardwareRenderer.loadSystemProperties()) {
                    ViewRootImpl.this.invalidate();
                }
                if ((layout2 = SystemProperties.getBoolean("debug.layout", false)) != ViewRootImpl.this.mAttachInfo.mDebugLayout) {
                    ViewRootImpl.this.mAttachInfo.mDebugLayout = layout2;
                    if (!ViewRootImpl.this.mHandler.hasMessages(23)) {
                        ViewRootImpl.this.mHandler.sendEmptyMessageDelayed(23, 200L);
                    }
                }
                ViewRootImpl.this.mIsEmulator = Build.HARDWARE.contains("goldfish");
                ViewRootImpl.this.mIsCircularEmulator = SystemProperties.getBoolean(ViewRootImpl.PROPERTY_EMULATOR_CIRCULAR, false);
            }
        });
    }

    private void destroyHardwareRenderer() {
        HardwareRenderer hardwareRenderer = this.mAttachInfo.mHardwareRenderer;
        if (hardwareRenderer != null) {
            if (this.mView != null) {
                hardwareRenderer.destroyHardwareResources(this.mView);
            }
            hardwareRenderer.destroy();
            hardwareRenderer.setRequested(false);
            this.mAttachInfo.mHardwareRenderer = null;
            this.mAttachInfo.mHardwareAccelerated = false;
        }
    }

    public void dispatchFinishInputConnection(InputConnection connection) {
        Message msg = this.mHandler.obtainMessage(12, connection);
        this.mHandler.sendMessage(msg);
    }

    public void dispatchResized(Rect frame, Rect overscanInsets, Rect contentInsets, Rect visibleInsets, Rect stableInsets, boolean reportDraw, Configuration newConfig) {
        Message msg = this.mHandler.obtainMessage(reportDraw ? 5 : 4);
        if (this.mTranslator != null) {
            this.mTranslator.translateRectInScreenToAppWindow(frame);
            this.mTranslator.translateRectInScreenToAppWindow(overscanInsets);
            this.mTranslator.translateRectInScreenToAppWindow(contentInsets);
            this.mTranslator.translateRectInScreenToAppWindow(visibleInsets);
        }
        SomeArgs args = SomeArgs.obtain();
        boolean sameProcessCall = Binder.getCallingPid() == Process.myPid();
        args.arg1 = sameProcessCall ? new Rect(frame) : frame;
        args.arg2 = sameProcessCall ? new Rect(contentInsets) : contentInsets;
        args.arg3 = sameProcessCall ? new Rect(visibleInsets) : visibleInsets;
        args.arg4 = sameProcessCall && newConfig != null ? new Configuration(newConfig) : newConfig;
        args.arg5 = sameProcessCall ? new Rect(overscanInsets) : overscanInsets;
        args.arg6 = sameProcessCall ? new Rect(stableInsets) : stableInsets;
        msg.obj = args;
        this.mHandler.sendMessage(msg);
    }

    public void dispatchMoved(int newX, int newY) {
        if (this.mTranslator != null) {
            PointF point = new PointF(newX, newY);
            this.mTranslator.translatePointInScreenToAppWindow(point);
            newX = (int)((double)point.x + 0.5);
            newY = (int)((double)point.y + 0.5);
        }
        Message msg = this.mHandler.obtainMessage(24, newX, newY);
        this.mHandler.sendMessage(msg);
    }

    private QueuedInputEvent obtainQueuedInputEvent(InputEvent event, InputEventReceiver receiver, int flags) {
        QueuedInputEvent q = this.mQueuedInputEventPool;
        if (q != null) {
            --this.mQueuedInputEventPoolSize;
            this.mQueuedInputEventPool = q.mNext;
            q.mNext = null;
        } else {
            q = new QueuedInputEvent();
        }
        q.mEvent = event;
        q.mReceiver = receiver;
        q.mFlags = flags;
        return q;
    }

    private void recycleQueuedInputEvent(QueuedInputEvent q) {
        q.mEvent = null;
        q.mReceiver = null;
        if (this.mQueuedInputEventPoolSize < 10) {
            ++this.mQueuedInputEventPoolSize;
            q.mNext = this.mQueuedInputEventPool;
            this.mQueuedInputEventPool = q;
        }
    }

    void enqueueInputEvent(InputEvent event) {
        this.enqueueInputEvent(event, null, 0, false);
    }

    void enqueueInputEvent(InputEvent event, InputEventReceiver receiver, int flags, boolean processImmediately) {
        QueuedInputEvent q = this.obtainQueuedInputEvent(event, receiver, flags);
        QueuedInputEvent last = this.mPendingInputEventTail;
        if (last == null) {
            this.mPendingInputEventHead = q;
            this.mPendingInputEventTail = q;
        } else {
            last.mNext = q;
            this.mPendingInputEventTail = q;
        }
        ++this.mPendingInputEventCount;
        Trace.traceCounter(4L, this.mPendingInputEventQueueLengthCounterName, this.mPendingInputEventCount);
        if (processImmediately) {
            this.doProcessInputEvents();
        } else {
            this.scheduleProcessInputEvents();
        }
    }

    private void scheduleProcessInputEvents() {
        if (!this.mProcessInputEventsScheduled) {
            this.mProcessInputEventsScheduled = true;
            Message msg = this.mHandler.obtainMessage(19);
            msg.setAsynchronous(true);
            this.mHandler.sendMessage(msg);
        }
    }

    void doProcessInputEvents() {
        while (this.mPendingInputEventHead != null) {
            QueuedInputEvent q = this.mPendingInputEventHead;
            this.mPendingInputEventHead = q.mNext;
            if (this.mPendingInputEventHead == null) {
                this.mPendingInputEventTail = null;
            }
            q.mNext = null;
            --this.mPendingInputEventCount;
            Trace.traceCounter(4L, this.mPendingInputEventQueueLengthCounterName, this.mPendingInputEventCount);
            this.deliverInputEvent(q);
        }
        if (this.mProcessInputEventsScheduled) {
            this.mProcessInputEventsScheduled = false;
            this.mHandler.removeMessages(19);
        }
    }

    private void deliverInputEvent(QueuedInputEvent q) {
        InputStage stage;
        Trace.asyncTraceBegin(8L, "deliverInputEvent", q.mEvent.getSequenceNumber());
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onInputEvent(q.mEvent, 0);
        }
        if (q.shouldSendToSynthesizer()) {
            stage = this.mSyntheticInputStage;
        } else {
            InputStage inputStage = stage = q.shouldSkipIme() ? this.mFirstPostImeInputStage : this.mFirstInputStage;
        }
        if (stage != null) {
            stage.deliver(q);
        } else {
            this.finishInputEvent(q);
        }
    }

    private void finishInputEvent(QueuedInputEvent q) {
        Trace.asyncTraceEnd(8L, "deliverInputEvent", q.mEvent.getSequenceNumber());
        if (q.mReceiver != null) {
            boolean handled = (q.mFlags & 8) != 0;
            q.mReceiver.finishInputEvent(q.mEvent, handled);
        } else {
            q.mEvent.recycleIfNeededAfterDispatch();
        }
        this.recycleQueuedInputEvent(q);
    }

    static boolean isTerminalInputEvent(InputEvent event) {
        if (event instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)event;
            return keyEvent.getAction() == 1;
        }
        MotionEvent motionEvent = (MotionEvent)event;
        int action = motionEvent.getAction();
        return action == 1 || action == 3 || action == 10;
    }

    void scheduleConsumeBatchedInput() {
        if (!this.mConsumeBatchedInputScheduled) {
            this.mConsumeBatchedInputScheduled = true;
            this.mChoreographer.postCallback(0, this.mConsumedBatchedInputRunnable, null);
        }
    }

    void unscheduleConsumeBatchedInput() {
        if (this.mConsumeBatchedInputScheduled) {
            this.mConsumeBatchedInputScheduled = false;
            this.mChoreographer.removeCallbacks(0, this.mConsumedBatchedInputRunnable, null);
        }
    }

    void scheduleConsumeBatchedInputImmediately() {
        if (!this.mConsumeBatchedInputImmediatelyScheduled) {
            this.unscheduleConsumeBatchedInput();
            this.mConsumeBatchedInputImmediatelyScheduled = true;
            this.mHandler.post(this.mConsumeBatchedInputImmediatelyRunnable);
        }
    }

    void doConsumeBatchedInput(long frameTimeNanos) {
        if (this.mConsumeBatchedInputScheduled) {
            this.mConsumeBatchedInputScheduled = false;
            if (this.mInputEventReceiver != null && this.mInputEventReceiver.consumeBatchedInputEvents(frameTimeNanos) && frameTimeNanos != -1L) {
                this.scheduleConsumeBatchedInput();
            }
            this.doProcessInputEvents();
        }
    }

    public void dispatchInvalidateDelayed(View view, long delayMilliseconds) {
        Message msg = this.mHandler.obtainMessage(1, view);
        this.mHandler.sendMessageDelayed(msg, delayMilliseconds);
    }

    public void dispatchInvalidateRectDelayed(View.AttachInfo.InvalidateInfo info, long delayMilliseconds) {
        Message msg = this.mHandler.obtainMessage(2, info);
        this.mHandler.sendMessageDelayed(msg, delayMilliseconds);
    }

    public void dispatchInvalidateOnAnimation(View view) {
        this.mInvalidateOnAnimationRunnable.addView(view);
    }

    public void dispatchInvalidateRectOnAnimation(View.AttachInfo.InvalidateInfo info) {
        this.mInvalidateOnAnimationRunnable.addViewRect(info);
    }

    public void cancelInvalidate(View view) {
        this.mHandler.removeMessages(1, view);
        this.mHandler.removeMessages(2, view);
        this.mInvalidateOnAnimationRunnable.removeView(view);
    }

    public void dispatchInputEvent(InputEvent event) {
        this.dispatchInputEvent(event, null);
    }

    public void dispatchInputEvent(InputEvent event, InputEventReceiver receiver) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = event;
        args.arg2 = receiver;
        Message msg = this.mHandler.obtainMessage(7, args);
        msg.setAsynchronous(true);
        this.mHandler.sendMessage(msg);
    }

    public void synthesizeInputEvent(InputEvent event) {
        Message msg = this.mHandler.obtainMessage(25, event);
        msg.setAsynchronous(true);
        this.mHandler.sendMessage(msg);
    }

    public void dispatchKeyFromIme(KeyEvent event) {
        Message msg = this.mHandler.obtainMessage(11, event);
        msg.setAsynchronous(true);
        this.mHandler.sendMessage(msg);
    }

    public void dispatchUnhandledInputEvent(InputEvent event) {
        if (event instanceof MotionEvent) {
            event = MotionEvent.obtain((MotionEvent)event);
        }
        this.synthesizeInputEvent(event);
    }

    public void dispatchAppVisibility(boolean visible) {
        Message msg = this.mHandler.obtainMessage(8);
        msg.arg1 = visible ? 1 : 0;
        this.mHandler.sendMessage(msg);
    }

    public void dispatchGetNewSurface() {
        Message msg = this.mHandler.obtainMessage(9);
        this.mHandler.sendMessage(msg);
    }

    public void windowFocusChanged(boolean hasFocus, boolean inTouchMode) {
        Message msg = Message.obtain();
        msg.what = 6;
        msg.arg1 = hasFocus ? 1 : 0;
        msg.arg2 = inTouchMode ? 1 : 0;
        this.mHandler.sendMessage(msg);
    }

    public void dispatchCloseSystemDialogs(String reason) {
        Message msg = Message.obtain();
        msg.what = 14;
        msg.obj = reason;
        this.mHandler.sendMessage(msg);
    }

    public void dispatchDragEvent(DragEvent event) {
        int what;
        if (event.getAction() == 2) {
            what = 16;
            this.mHandler.removeMessages(what);
        } else {
            what = 15;
        }
        Message msg = this.mHandler.obtainMessage(what, event);
        this.mHandler.sendMessage(msg);
    }

    public void dispatchSystemUiVisibilityChanged(int seq, int globalVisibility, int localValue, int localChanges) {
        SystemUiVisibilityInfo args = new SystemUiVisibilityInfo();
        args.seq = seq;
        args.globalVisibility = globalVisibility;
        args.localValue = localValue;
        args.localChanges = localChanges;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(17, args));
    }

    public void dispatchDoneAnimating() {
        this.mHandler.sendEmptyMessage(22);
    }

    public void dispatchCheckFocus() {
        if (!this.mHandler.hasMessages(13)) {
            this.mHandler.sendEmptyMessage(13);
        }
    }

    private void postSendWindowContentChangedCallback(View source, int changeType) {
        if (this.mSendWindowContentChangedAccessibilityEvent == null) {
            this.mSendWindowContentChangedAccessibilityEvent = new SendWindowContentChangedAccessibilityEvent();
        }
        this.mSendWindowContentChangedAccessibilityEvent.runOrPost(source, changeType);
    }

    private void removeSendWindowContentChangedCallback() {
        if (this.mSendWindowContentChangedAccessibilityEvent != null) {
            this.mHandler.removeCallbacks(this.mSendWindowContentChangedAccessibilityEvent);
        }
    }

    @Override
    public boolean showContextMenuForChild(View originalView) {
        return false;
    }

    @Override
    public ActionMode startActionModeForChild(View originalView, ActionMode.Callback callback) {
        return null;
    }

    @Override
    public void createContextMenu(ContextMenu menu2) {
    }

    @Override
    public void childDrawableStateChanged(View child) {
    }

    @Override
    public boolean requestSendAccessibilityEvent(View child, AccessibilityEvent event) {
        if (this.mView == null) {
            return false;
        }
        int eventType = event.getEventType();
        switch (eventType) {
            case 32768: {
                AccessibilityNodeProvider provider;
                long sourceNodeId = event.getSourceNodeId();
                int accessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(sourceNodeId);
                View source = this.mView.findViewByAccessibilityId(accessibilityViewId);
                if (source == null || (provider = source.getAccessibilityNodeProvider()) == null) break;
                int virtualNodeId = AccessibilityNodeInfo.getVirtualDescendantId(sourceNodeId);
                AccessibilityNodeInfo node = virtualNodeId == Integer.MAX_VALUE ? provider.createAccessibilityNodeInfo(-1) : provider.createAccessibilityNodeInfo(virtualNodeId);
                this.setAccessibilityFocus(source, node);
                break;
            }
            case 65536: {
                AccessibilityNodeProvider provider;
                long sourceNodeId = event.getSourceNodeId();
                int accessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(sourceNodeId);
                View source = this.mView.findViewByAccessibilityId(accessibilityViewId);
                if (source == null || (provider = source.getAccessibilityNodeProvider()) == null) break;
                this.setAccessibilityFocus(null, null);
                break;
            }
            case 2048: {
                AccessibilityNodeProvider provider;
                int changes;
                long eventSourceId;
                int hostViewId;
                if (this.mAccessibilityFocusedHost == null || this.mAccessibilityFocusedVirtualView == null || (hostViewId = AccessibilityNodeInfo.getAccessibilityViewId(eventSourceId = event.getSourceNodeId())) != this.mAccessibilityFocusedHost.getAccessibilityViewId() || ((changes = event.getContentChangeTypes()) & 1) == 0 && changes != 0 || (provider = this.mAccessibilityFocusedHost.getAccessibilityNodeProvider()) == null) break;
                int virtualChildId = AccessibilityNodeInfo.getVirtualDescendantId(this.mAccessibilityFocusedVirtualView.getSourceNodeId());
                this.mAccessibilityFocusedVirtualView = virtualChildId == Integer.MAX_VALUE ? provider.createAccessibilityNodeInfo(-1) : provider.createAccessibilityNodeInfo(virtualChildId);
            }
        }
        this.mAccessibilityManager.sendAccessibilityEvent(event);
        return true;
    }

    @Override
    public void notifySubtreeAccessibilityStateChanged(View child, View source, int changeType) {
        this.postSendWindowContentChangedCallback(source, changeType);
    }

    @Override
    public boolean canResolveLayoutDirection() {
        return true;
    }

    @Override
    public boolean isLayoutDirectionResolved() {
        return true;
    }

    @Override
    public int getLayoutDirection() {
        return 0;
    }

    @Override
    public boolean canResolveTextDirection() {
        return true;
    }

    @Override
    public boolean isTextDirectionResolved() {
        return true;
    }

    @Override
    public int getTextDirection() {
        return 1;
    }

    @Override
    public boolean canResolveTextAlignment() {
        return true;
    }

    @Override
    public boolean isTextAlignmentResolved() {
        return true;
    }

    @Override
    public int getTextAlignment() {
        return 1;
    }

    private View getCommonPredecessor(View first, View second) {
        if (this.mTempHashSet == null) {
            this.mTempHashSet = new HashSet();
        }
        HashSet<View> seen = this.mTempHashSet;
        seen.clear();
        View firstCurrent = first;
        while (firstCurrent != null) {
            seen.add(firstCurrent);
            ViewParent firstCurrentParent = firstCurrent.mParent;
            if (firstCurrentParent instanceof View) {
                firstCurrent = (View)((Object)firstCurrentParent);
                continue;
            }
            firstCurrent = null;
        }
        View secondCurrent = second;
        while (secondCurrent != null) {
            if (seen.contains(secondCurrent)) {
                seen.clear();
                return secondCurrent;
            }
            ViewParent secondCurrentParent = secondCurrent.mParent;
            if (secondCurrentParent instanceof View) {
                secondCurrent = (View)((Object)secondCurrentParent);
                continue;
            }
            secondCurrent = null;
        }
        seen.clear();
        return null;
    }

    void checkThread() {
        if (this.mThread != Thread.currentThread()) {
            throw new CalledFromWrongThreadException("Only the original thread that created a view hierarchy can touch its views.");
        }
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    @Override
    public boolean requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        boolean scrolled = this.scrollToRectOrFocus(rectangle, immediate);
        if (rectangle != null) {
            this.mTempRect.set(rectangle);
            this.mTempRect.offset(0, -this.mCurScrollY);
            this.mTempRect.offset(this.mAttachInfo.mWindowLeft, this.mAttachInfo.mWindowTop);
            try {
                this.mWindowSession.onRectangleOnScreenRequested(this.mWindow, this.mTempRect);
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
        return scrolled;
    }

    @Override
    public void childHasTransientStateChanged(View child, boolean hasTransientState) {
    }

    @Override
    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return false;
    }

    @Override
    public void onStopNestedScroll(View target) {
    }

    @Override
    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
    }

    @Override
    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
    }

    @Override
    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
    }

    @Override
    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    @Override
    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return false;
    }

    void changeCanvasOpacity(boolean opaque) {
        Log.d(TAG, "changeCanvasOpacity: opaque=" + opaque);
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.setOpaque(opaque);
        }
    }

    static RunQueue getRunQueue() {
        RunQueue rq = sRunQueues.get();
        if (rq != null) {
            return rq;
        }
        rq = new RunQueue();
        sRunQueues.set(rq);
        return rq;
    }

    private class SendWindowContentChangedAccessibilityEvent
    implements Runnable {
        private int mChangeTypes = 0;
        public View mSource;
        public long mLastEventTimeMillis;

        private SendWindowContentChangedAccessibilityEvent() {
        }

        @Override
        public void run() {
            if (AccessibilityManager.getInstance(ViewRootImpl.this.mContext).isEnabled()) {
                this.mLastEventTimeMillis = SystemClock.uptimeMillis();
                AccessibilityEvent event = AccessibilityEvent.obtain();
                event.setEventType(2048);
                event.setContentChangeTypes(this.mChangeTypes);
                this.mSource.sendAccessibilityEventUnchecked(event);
            } else {
                this.mLastEventTimeMillis = 0L;
            }
            this.mSource.resetSubtreeAccessibilityStateChanged();
            this.mSource = null;
            this.mChangeTypes = 0;
        }

        public void runOrPost(View source, int changeType) {
            long minEventIntevalMillis;
            if (this.mSource != null) {
                View predecessor = ViewRootImpl.this.getCommonPredecessor(this.mSource, source);
                this.mSource = predecessor != null ? predecessor : source;
                this.mChangeTypes |= changeType;
                return;
            }
            this.mSource = source;
            this.mChangeTypes = changeType;
            long timeSinceLastMillis = SystemClock.uptimeMillis() - this.mLastEventTimeMillis;
            if (timeSinceLastMillis >= (minEventIntevalMillis = ViewConfiguration.getSendRecurringAccessibilityEventsInterval())) {
                this.mSource.removeCallbacks(this);
                this.run();
            } else {
                this.mSource.postDelayed(this, minEventIntevalMillis - timeSinceLastMillis);
            }
        }
    }

    static class AccessibilityInteractionConnection
    extends IAccessibilityInteractionConnection.Stub {
        private final WeakReference<ViewRootImpl> mViewRootImpl;

        AccessibilityInteractionConnection(ViewRootImpl viewRootImpl) {
            this.mViewRootImpl = new WeakReference<ViewRootImpl>(viewRootImpl);
        }

        @Override
        public void findAccessibilityNodeInfoByAccessibilityId(long accessibilityNodeId, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().findAccessibilityNodeInfoByAccessibilityIdClientThread(accessibilityNodeId, interactiveRegion, interactionId, callback, flags, interrogatingPid, interrogatingTid, spec);
            } else {
                try {
                    callback.setFindAccessibilityNodeInfosResult(null, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
            }
        }

        @Override
        public void performAccessibilityAction(long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().performAccessibilityActionClientThread(accessibilityNodeId, action, arguments, interactionId, callback, flags, interrogatingPid, interrogatingTid);
            } else {
                try {
                    callback.setPerformAccessibilityActionResult(false, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
            }
        }

        @Override
        public void computeClickPointInScreen(long accessibilityNodeId, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().computeClickPointInScreenClientThread(accessibilityNodeId, interactiveRegion, interactionId, callback, interrogatingPid, interrogatingTid, spec);
            } else {
                try {
                    callback.setComputeClickPointInScreenActionResult(null, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
            }
        }

        @Override
        public void findAccessibilityNodeInfosByViewId(long accessibilityNodeId, String viewId, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().findAccessibilityNodeInfosByViewIdClientThread(accessibilityNodeId, viewId, interactiveRegion, interactionId, callback, flags, interrogatingPid, interrogatingTid, spec);
            } else {
                try {
                    callback.setFindAccessibilityNodeInfoResult(null, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
            }
        }

        @Override
        public void findAccessibilityNodeInfosByText(long accessibilityNodeId, String text, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().findAccessibilityNodeInfosByTextClientThread(accessibilityNodeId, text, interactiveRegion, interactionId, callback, flags, interrogatingPid, interrogatingTid, spec);
            } else {
                try {
                    callback.setFindAccessibilityNodeInfosResult(null, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
            }
        }

        @Override
        public void findFocus(long accessibilityNodeId, int focusType, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().findFocusClientThread(accessibilityNodeId, focusType, interactiveRegion, interactionId, callback, flags, interrogatingPid, interrogatingTid, spec);
            } else {
                try {
                    callback.setFindAccessibilityNodeInfoResult(null, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
            }
        }

        @Override
        public void focusSearch(long accessibilityNodeId, int direction, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().focusSearchClientThread(accessibilityNodeId, direction, interactiveRegion, interactionId, callback, flags, interrogatingPid, interrogatingTid, spec);
            } else {
                try {
                    callback.setFindAccessibilityNodeInfoResult(null, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
            }
        }
    }

    class HighContrastTextManager
    implements AccessibilityManager.HighTextContrastChangeListener {
        HighContrastTextManager() {
            ViewRootImpl.this.mAttachInfo.mHighContrastText = ViewRootImpl.this.mAccessibilityManager.isHighTextContrastEnabled();
        }

        @Override
        public void onHighTextContrastStateChanged(boolean enabled) {
            ViewRootImpl.this.mAttachInfo.mHighContrastText = enabled;
            ViewRootImpl.this.destroyHardwareResources();
            ViewRootImpl.this.invalidate();
        }
    }

    class AccessibilityInteractionConnectionManager
    implements AccessibilityManager.AccessibilityStateChangeListener {
        AccessibilityInteractionConnectionManager() {
        }

        @Override
        public void onAccessibilityStateChanged(boolean enabled) {
            if (enabled) {
                this.ensureConnection();
                if (ViewRootImpl.this.mAttachInfo.mHasWindowFocus) {
                    ViewRootImpl.this.mView.sendAccessibilityEvent(32);
                    View focusedView = ViewRootImpl.this.mView.findFocus();
                    if (focusedView != null && focusedView != ViewRootImpl.this.mView) {
                        focusedView.sendAccessibilityEvent(8);
                    }
                }
            } else {
                this.ensureNoConnection();
                ViewRootImpl.this.mHandler.obtainMessage(21).sendToTarget();
            }
        }

        public void ensureConnection() {
            boolean registered;
            boolean bl = registered = ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId != Integer.MAX_VALUE;
            if (!registered) {
                ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId = ViewRootImpl.this.mAccessibilityManager.addAccessibilityInteractionConnection(ViewRootImpl.this.mWindow, new AccessibilityInteractionConnection(ViewRootImpl.this));
            }
        }

        public void ensureNoConnection() {
            boolean registered;
            boolean bl = registered = ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId != Integer.MAX_VALUE;
            if (registered) {
                ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId = Integer.MAX_VALUE;
                ViewRootImpl.this.mAccessibilityManager.removeAccessibilityInteractionConnection(ViewRootImpl.this.mWindow);
            }
        }
    }

    static class RunQueue {
        private final ArrayList<HandlerAction> mActions = new ArrayList();

        RunQueue() {
        }

        void post(Runnable action) {
            this.postDelayed(action, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void postDelayed(Runnable action, long delayMillis) {
            HandlerAction handlerAction = new HandlerAction();
            handlerAction.action = action;
            handlerAction.delay = delayMillis;
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                this.mActions.add(handlerAction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeCallbacks(Runnable action) {
            HandlerAction handlerAction = new HandlerAction();
            handlerAction.action = action;
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                ArrayList<HandlerAction> actions = this.mActions;
                while (actions.remove(handlerAction)) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void executeActions(Handler handler) {
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                ArrayList<HandlerAction> actions = this.mActions;
                int count = actions.size();
                for (int i = 0; i < count; ++i) {
                    HandlerAction handlerAction = actions.get(i);
                    handler.postDelayed(handlerAction.action, handlerAction.delay);
                }
                actions.clear();
            }
        }

        private static class HandlerAction {
            Runnable action;
            long delay;

            private HandlerAction() {
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                HandlerAction that = (HandlerAction)o;
                return !(this.action == null ? that.action != null : !this.action.equals(that.action));
            }

            public int hashCode() {
                int result = this.action != null ? this.action.hashCode() : 0;
                result = 31 * result + (int)(this.delay ^ this.delay >>> 32);
                return result;
            }
        }
    }

    public static class CalledFromWrongThreadException
    extends AndroidRuntimeException {
        public CalledFromWrongThreadException(String msg) {
            super(msg);
        }
    }

    static class W
    extends IWindow.Stub {
        private final WeakReference<ViewRootImpl> mViewAncestor;
        private final IWindowSession mWindowSession;

        W(ViewRootImpl viewAncestor) {
            this.mViewAncestor = new WeakReference<ViewRootImpl>(viewAncestor);
            this.mWindowSession = viewAncestor.mWindowSession;
        }

        @Override
        public void resized(Rect frame, Rect overscanInsets, Rect contentInsets, Rect visibleInsets, Rect stableInsets, boolean reportDraw, Configuration newConfig) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchResized(frame, overscanInsets, contentInsets, visibleInsets, stableInsets, reportDraw, newConfig);
            }
        }

        @Override
        public void moved(int newX, int newY) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchMoved(newX, newY);
            }
        }

        @Override
        public void dispatchAppVisibility(boolean visible) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchAppVisibility(visible);
            }
        }

        @Override
        public void dispatchGetNewSurface() {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchGetNewSurface();
            }
        }

        @Override
        public void windowFocusChanged(boolean hasFocus, boolean inTouchMode) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.windowFocusChanged(hasFocus, inTouchMode);
            }
        }

        private static int checkCallingPermission(String permission2) {
            try {
                return ActivityManagerNative.getDefault().checkPermission(permission2, Binder.getCallingPid(), Binder.getCallingUid());
            }
            catch (RemoteException e) {
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeCommand(String command, String parameters, ParcelFileDescriptor out) {
            View view;
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null && (view = viewAncestor.mView) != null) {
                if (W.checkCallingPermission("android.permission.DUMP") != 0) {
                    throw new SecurityException("Insufficient permissions to invoke executeCommand() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                }
                ParcelFileDescriptor.AutoCloseOutputStream clientStream = null;
                try {
                    clientStream = new ParcelFileDescriptor.AutoCloseOutputStream(out);
                    ViewDebug.dispatchCommand(view, command, parameters, clientStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (clientStream != null) {
                        try {
                            ((OutputStream)clientStream).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }

        @Override
        public void closeSystemDialogs(String reason) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchCloseSystemDialogs(reason);
            }
        }

        @Override
        public void dispatchWallpaperOffsets(float x, float y, float xStep, float yStep, boolean sync) {
            if (sync) {
                try {
                    this.mWindowSession.wallpaperOffsetsComplete(this.asBinder());
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }

        @Override
        public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras, boolean sync) {
            if (sync) {
                try {
                    this.mWindowSession.wallpaperCommandComplete(this.asBinder(), null);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }

        @Override
        public void dispatchDragEvent(DragEvent event) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchDragEvent(event);
            }
        }

        @Override
        public void dispatchSystemUiVisibilityChanged(int seq, int globalVisibility, int localValue, int localChanges) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchSystemUiVisibilityChanged(seq, globalVisibility, localValue, localChanges);
            }
        }

        @Override
        public void doneAnimating() {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchDoneAnimating();
            }
        }
    }

    class TakenSurfaceHolder
    extends BaseSurfaceHolder {
        TakenSurfaceHolder() {
        }

        @Override
        public boolean onAllowLockCanvas() {
            return ViewRootImpl.this.mDrawingAllowed;
        }

        @Override
        public void onRelayoutContainer() {
        }

        @Override
        public void setFormat(int format) {
            ((RootViewSurfaceTaker)((Object)ViewRootImpl.this.mView)).setSurfaceFormat(format);
        }

        @Override
        public void setType(int type) {
            ((RootViewSurfaceTaker)((Object)ViewRootImpl.this.mView)).setSurfaceType(type);
        }

        @Override
        public void onUpdateSurface() {
            throw new IllegalStateException("Shouldn't be here");
        }

        @Override
        public boolean isCreating() {
            return ViewRootImpl.this.mIsCreating;
        }

        @Override
        public void setFixedSize(int width, int height) {
            throw new UnsupportedOperationException("Currently only support sizing from layout");
        }

        @Override
        public void setKeepScreenOn(boolean screenOn) {
            ((RootViewSurfaceTaker)((Object)ViewRootImpl.this.mView)).setSurfaceKeepScreenOn(screenOn);
        }
    }

    class InvalidateOnAnimationRunnable
    implements Runnable {
        private boolean mPosted;
        private final ArrayList<View> mViews = new ArrayList();
        private final ArrayList<View.AttachInfo.InvalidateInfo> mViewRects = new ArrayList();
        private View[] mTempViews;
        private View.AttachInfo.InvalidateInfo[] mTempViewRects;

        InvalidateOnAnimationRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addView(View view) {
            InvalidateOnAnimationRunnable invalidateOnAnimationRunnable = this;
            synchronized (invalidateOnAnimationRunnable) {
                this.mViews.add(view);
                this.postIfNeededLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addViewRect(View.AttachInfo.InvalidateInfo info) {
            InvalidateOnAnimationRunnable invalidateOnAnimationRunnable = this;
            synchronized (invalidateOnAnimationRunnable) {
                this.mViewRects.add(info);
                this.postIfNeededLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeView(View view) {
            InvalidateOnAnimationRunnable invalidateOnAnimationRunnable = this;
            synchronized (invalidateOnAnimationRunnable) {
                this.mViews.remove(view);
                int i = this.mViewRects.size();
                while (i-- > 0) {
                    View.AttachInfo.InvalidateInfo info = this.mViewRects.get(i);
                    if (info.target != view) continue;
                    this.mViewRects.remove(i);
                    info.recycle();
                }
                if (this.mPosted && this.mViews.isEmpty() && this.mViewRects.isEmpty()) {
                    ViewRootImpl.this.mChoreographer.removeCallbacks(1, this, null);
                    this.mPosted = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int i;
            int viewRectCount;
            int viewCount;
            InvalidateOnAnimationRunnable invalidateOnAnimationRunnable = this;
            synchronized (invalidateOnAnimationRunnable) {
                this.mPosted = false;
                viewCount = this.mViews.size();
                if (viewCount != 0) {
                    this.mTempViews = this.mViews.toArray(this.mTempViews != null ? this.mTempViews : new View[viewCount]);
                    this.mViews.clear();
                }
                if ((viewRectCount = this.mViewRects.size()) != 0) {
                    this.mTempViewRects = this.mViewRects.toArray(this.mTempViewRects != null ? this.mTempViewRects : new View.AttachInfo.InvalidateInfo[viewRectCount]);
                    this.mViewRects.clear();
                }
            }
            for (i = 0; i < viewCount; ++i) {
                this.mTempViews[i].invalidate();
                this.mTempViews[i] = null;
            }
            for (i = 0; i < viewRectCount; ++i) {
                View.AttachInfo.InvalidateInfo info = this.mTempViewRects[i];
                info.target.invalidate(info.left, info.top, info.right, info.bottom);
                info.recycle();
            }
        }

        private void postIfNeededLocked() {
            if (!this.mPosted) {
                ViewRootImpl.this.mChoreographer.postCallback(1, this, null);
                this.mPosted = true;
            }
        }
    }

    class ConsumeBatchedInputImmediatelyRunnable
    implements Runnable {
        ConsumeBatchedInputImmediatelyRunnable() {
        }

        @Override
        public void run() {
            ViewRootImpl.this.doConsumeBatchedInput(-1L);
        }
    }

    class ConsumeBatchedInputRunnable
    implements Runnable {
        ConsumeBatchedInputRunnable() {
        }

        @Override
        public void run() {
            ViewRootImpl.this.doConsumeBatchedInput(ViewRootImpl.this.mChoreographer.getFrameTimeNanos());
        }
    }

    class WindowInputEventReceiver
    extends InputEventReceiver {
        public WindowInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
        }

        @Override
        public void onInputEvent(InputEvent event) {
            ViewRootImpl.this.enqueueInputEvent(event, this, 0, true);
        }

        @Override
        public void onBatchedInputEventPending() {
            if (ViewRootImpl.this.mUnbufferedInputDispatch) {
                super.onBatchedInputEventPending();
            } else {
                ViewRootImpl.this.scheduleConsumeBatchedInput();
            }
        }

        @Override
        public void dispose() {
            ViewRootImpl.this.unscheduleConsumeBatchedInput();
            super.dispose();
        }
    }

    class TraversalRunnable
    implements Runnable {
        TraversalRunnable() {
        }

        @Override
        public void run() {
            ViewRootImpl.this.doTraversal();
        }
    }

    private static class QueuedInputEvent {
        public static final int FLAG_DELIVER_POST_IME = 1;
        public static final int FLAG_DEFERRED = 2;
        public static final int FLAG_FINISHED = 4;
        public static final int FLAG_FINISHED_HANDLED = 8;
        public static final int FLAG_RESYNTHESIZED = 16;
        public static final int FLAG_UNHANDLED = 32;
        public QueuedInputEvent mNext;
        public InputEvent mEvent;
        public InputEventReceiver mReceiver;
        public int mFlags;

        private QueuedInputEvent() {
        }

        public boolean shouldSkipIme() {
            if ((this.mFlags & 1) != 0) {
                return true;
            }
            return this.mEvent instanceof MotionEvent && this.mEvent.isFromSource(2);
        }

        public boolean shouldSendToSynthesizer() {
            return (this.mFlags & 0x20) != 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("QueuedInputEvent{flags=");
            boolean hasPrevious = false;
            hasPrevious = this.flagToString("DELIVER_POST_IME", 1, hasPrevious, sb);
            hasPrevious = this.flagToString("DEFERRED", 2, hasPrevious, sb);
            hasPrevious = this.flagToString("FINISHED", 4, hasPrevious, sb);
            hasPrevious = this.flagToString("FINISHED_HANDLED", 8, hasPrevious, sb);
            hasPrevious = this.flagToString("RESYNTHESIZED", 16, hasPrevious, sb);
            if (!(hasPrevious = this.flagToString("UNHANDLED", 32, hasPrevious, sb))) {
                sb.append("0");
            }
            sb.append(", hasNextQueuedEvent=" + (this.mEvent != null ? "true" : "false"));
            sb.append(", hasInputEventReceiver=" + (this.mReceiver != null ? "true" : "false"));
            sb.append(", mEvent=" + this.mEvent + "}");
            return sb.toString();
        }

        private boolean flagToString(String name, int flag, boolean hasPrevious, StringBuilder sb) {
            if ((this.mFlags & flag) != 0) {
                if (hasPrevious) {
                    sb.append("|");
                }
                sb.append(name);
                return true;
            }
            return hasPrevious;
        }
    }

    class SyntheticKeyboardHandler {
        SyntheticKeyboardHandler() {
        }

        public void process(KeyEvent event) {
            int metaState;
            int keyCode;
            if ((event.getFlags() & 0x400) != 0) {
                return;
            }
            KeyCharacterMap kcm = event.getKeyCharacterMap();
            KeyCharacterMap.FallbackAction fallbackAction = kcm.getFallbackAction(keyCode = event.getKeyCode(), metaState = event.getMetaState());
            if (fallbackAction != null) {
                int flags = event.getFlags() | 0x400;
                KeyEvent fallbackEvent = KeyEvent.obtain(event.getDownTime(), event.getEventTime(), event.getAction(), fallbackAction.keyCode, event.getRepeatCount(), fallbackAction.metaState, event.getDeviceId(), event.getScanCode(), flags, event.getSource(), null);
                fallbackAction.recycle();
                ViewRootImpl.this.enqueueInputEvent(fallbackEvent);
            }
        }
    }

    class SyntheticTouchNavigationHandler
    extends Handler {
        private static final String LOCAL_TAG = "SyntheticTouchNavigationHandler";
        private static final boolean LOCAL_DEBUG = false;
        private static final float DEFAULT_WIDTH_MILLIMETERS = 48.0f;
        private static final float DEFAULT_HEIGHT_MILLIMETERS = 48.0f;
        private static final int TICK_DISTANCE_MILLIMETERS = 12;
        private static final float MIN_FLING_VELOCITY_TICKS_PER_SECOND = 6.0f;
        private static final float MAX_FLING_VELOCITY_TICKS_PER_SECOND = 20.0f;
        private static final float FLING_TICK_DECAY = 0.8f;
        private int mCurrentDeviceId;
        private int mCurrentSource;
        private boolean mCurrentDeviceSupported;
        private float mConfigTickDistance;
        private float mConfigMinFlingVelocity;
        private float mConfigMaxFlingVelocity;
        private VelocityTracker mVelocityTracker;
        private int mActivePointerId;
        private float mStartX;
        private float mStartY;
        private float mLastX;
        private float mLastY;
        private float mAccumulatedX;
        private float mAccumulatedY;
        private boolean mConsumedMovement;
        private long mPendingKeyDownTime;
        private int mPendingKeyCode;
        private int mPendingKeyRepeatCount;
        private int mPendingKeyMetaState;
        private boolean mFlinging;
        private float mFlingVelocity;
        private final Runnable mFlingRunnable;

        public SyntheticTouchNavigationHandler() {
            super(true);
            this.mCurrentDeviceId = -1;
            this.mActivePointerId = -1;
            this.mPendingKeyCode = 0;
            this.mFlingRunnable = new Runnable(){

                @Override
                public void run() {
                    long time = SystemClock.uptimeMillis();
                    SyntheticTouchNavigationHandler.this.sendKeyDownOrRepeat(time, SyntheticTouchNavigationHandler.this.mPendingKeyCode, SyntheticTouchNavigationHandler.this.mPendingKeyMetaState);
                    SyntheticTouchNavigationHandler.this.mFlingVelocity *= 0.8f;
                    if (!SyntheticTouchNavigationHandler.this.postFling(time)) {
                        SyntheticTouchNavigationHandler.this.mFlinging = false;
                        SyntheticTouchNavigationHandler.this.finishKeys(time);
                    }
                }
            };
        }

        public void process(MotionEvent event) {
            long time = event.getEventTime();
            int deviceId = event.getDeviceId();
            int source = event.getSource();
            if (this.mCurrentDeviceId != deviceId || this.mCurrentSource != source) {
                this.finishKeys(time);
                this.finishTracking(time);
                this.mCurrentDeviceId = deviceId;
                this.mCurrentSource = source;
                this.mCurrentDeviceSupported = false;
                InputDevice device = event.getDevice();
                if (device != null) {
                    InputDevice.MotionRange xRange = device.getMotionRange(0);
                    InputDevice.MotionRange yRange = device.getMotionRange(1);
                    if (xRange != null && yRange != null) {
                        float yRes;
                        this.mCurrentDeviceSupported = true;
                        float xRes = xRange.getResolution();
                        if (xRes <= 0.0f) {
                            xRes = xRange.getRange() / 48.0f;
                        }
                        if ((yRes = yRange.getResolution()) <= 0.0f) {
                            yRes = yRange.getRange() / 48.0f;
                        }
                        float nominalRes = (xRes + yRes) * 0.5f;
                        this.mConfigTickDistance = 12.0f * nominalRes;
                        this.mConfigMinFlingVelocity = 6.0f * this.mConfigTickDistance;
                        this.mConfigMaxFlingVelocity = 20.0f * this.mConfigTickDistance;
                    }
                }
            }
            if (!this.mCurrentDeviceSupported) {
                return;
            }
            int action = event.getActionMasked();
            switch (action) {
                case 0: {
                    boolean caughtFling = this.mFlinging;
                    this.finishKeys(time);
                    this.finishTracking(time);
                    this.mActivePointerId = event.getPointerId(0);
                    this.mVelocityTracker = VelocityTracker.obtain();
                    this.mVelocityTracker.addMovement(event);
                    this.mStartX = event.getX();
                    this.mStartY = event.getY();
                    this.mLastX = this.mStartX;
                    this.mLastY = this.mStartY;
                    this.mAccumulatedX = 0.0f;
                    this.mAccumulatedY = 0.0f;
                    this.mConsumedMovement = caughtFling;
                    break;
                }
                case 1: 
                case 2: {
                    if (this.mActivePointerId < 0) break;
                    int index = event.findPointerIndex(this.mActivePointerId);
                    if (index < 0) {
                        this.finishKeys(time);
                        this.finishTracking(time);
                        break;
                    }
                    this.mVelocityTracker.addMovement(event);
                    float x = event.getX(index);
                    float y = event.getY(index);
                    this.mAccumulatedX += x - this.mLastX;
                    this.mAccumulatedY += y - this.mLastY;
                    this.mLastX = x;
                    this.mLastY = y;
                    int metaState = event.getMetaState();
                    this.consumeAccumulatedMovement(time, metaState);
                    if (action != 1) break;
                    if (this.mConsumedMovement && this.mPendingKeyCode != 0) {
                        this.mVelocityTracker.computeCurrentVelocity(1000, this.mConfigMaxFlingVelocity);
                        float vx = this.mVelocityTracker.getXVelocity(this.mActivePointerId);
                        float vy = this.mVelocityTracker.getYVelocity(this.mActivePointerId);
                        if (!this.startFling(time, vx, vy)) {
                            this.finishKeys(time);
                        }
                    }
                    this.finishTracking(time);
                    break;
                }
                case 3: {
                    this.finishKeys(time);
                    this.finishTracking(time);
                }
            }
        }

        public void cancel(MotionEvent event) {
            if (this.mCurrentDeviceId == event.getDeviceId() && this.mCurrentSource == event.getSource()) {
                long time = event.getEventTime();
                this.finishKeys(time);
                this.finishTracking(time);
            }
        }

        private void finishKeys(long time) {
            this.cancelFling();
            this.sendKeyUp(time);
        }

        private void finishTracking(long time) {
            if (this.mActivePointerId >= 0) {
                this.mActivePointerId = -1;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }

        private void consumeAccumulatedMovement(long time, int metaState) {
            float absY;
            float absX = Math.abs(this.mAccumulatedX);
            if (absX >= (absY = Math.abs(this.mAccumulatedY))) {
                if (absX >= this.mConfigTickDistance) {
                    this.mAccumulatedX = this.consumeAccumulatedMovement(time, metaState, this.mAccumulatedX, 21, 22);
                    this.mAccumulatedY = 0.0f;
                    this.mConsumedMovement = true;
                }
            } else if (absY >= this.mConfigTickDistance) {
                this.mAccumulatedY = this.consumeAccumulatedMovement(time, metaState, this.mAccumulatedY, 19, 20);
                this.mAccumulatedX = 0.0f;
                this.mConsumedMovement = true;
            }
        }

        private float consumeAccumulatedMovement(long time, int metaState, float accumulator, int negativeKeyCode, int positiveKeyCode) {
            while (accumulator <= -this.mConfigTickDistance) {
                this.sendKeyDownOrRepeat(time, negativeKeyCode, metaState);
                accumulator += this.mConfigTickDistance;
            }
            while (accumulator >= this.mConfigTickDistance) {
                this.sendKeyDownOrRepeat(time, positiveKeyCode, metaState);
                accumulator -= this.mConfigTickDistance;
            }
            return accumulator;
        }

        private void sendKeyDownOrRepeat(long time, int keyCode, int metaState) {
            if (this.mPendingKeyCode != keyCode) {
                this.sendKeyUp(time);
                this.mPendingKeyDownTime = time;
                this.mPendingKeyCode = keyCode;
                this.mPendingKeyRepeatCount = 0;
            } else {
                ++this.mPendingKeyRepeatCount;
            }
            this.mPendingKeyMetaState = metaState;
            ViewRootImpl.this.enqueueInputEvent(new KeyEvent(this.mPendingKeyDownTime, time, 0, this.mPendingKeyCode, this.mPendingKeyRepeatCount, this.mPendingKeyMetaState, this.mCurrentDeviceId, 1024, this.mCurrentSource));
        }

        private void sendKeyUp(long time) {
            if (this.mPendingKeyCode != 0) {
                ViewRootImpl.this.enqueueInputEvent(new KeyEvent(this.mPendingKeyDownTime, time, 1, this.mPendingKeyCode, 0, this.mPendingKeyMetaState, this.mCurrentDeviceId, 0, 1024, this.mCurrentSource));
                this.mPendingKeyCode = 0;
            }
        }

        private boolean startFling(long time, float vx, float vy) {
            switch (this.mPendingKeyCode) {
                case 21: {
                    if (-vx >= this.mConfigMinFlingVelocity && Math.abs(vy) < this.mConfigMinFlingVelocity) {
                        this.mFlingVelocity = -vx;
                        break;
                    }
                    return false;
                }
                case 22: {
                    if (vx >= this.mConfigMinFlingVelocity && Math.abs(vy) < this.mConfigMinFlingVelocity) {
                        this.mFlingVelocity = vx;
                        break;
                    }
                    return false;
                }
                case 19: {
                    if (-vy >= this.mConfigMinFlingVelocity && Math.abs(vx) < this.mConfigMinFlingVelocity) {
                        this.mFlingVelocity = -vy;
                        break;
                    }
                    return false;
                }
                case 20: {
                    if (vy >= this.mConfigMinFlingVelocity && Math.abs(vx) < this.mConfigMinFlingVelocity) {
                        this.mFlingVelocity = vy;
                        break;
                    }
                    return false;
                }
            }
            this.mFlinging = this.postFling(time);
            return this.mFlinging;
        }

        private boolean postFling(long time) {
            if (this.mFlingVelocity >= this.mConfigMinFlingVelocity) {
                long delay = (long)(this.mConfigTickDistance / this.mFlingVelocity * 1000.0f);
                this.postAtTime(this.mFlingRunnable, time + delay);
                return true;
            }
            return false;
        }

        private void cancelFling() {
            if (this.mFlinging) {
                this.removeCallbacks(this.mFlingRunnable);
                this.mFlinging = false;
            }
        }
    }

    class SyntheticJoystickHandler
    extends Handler {
        private static final String TAG = "SyntheticJoystickHandler";
        private static final int MSG_ENQUEUE_X_AXIS_KEY_REPEAT = 1;
        private static final int MSG_ENQUEUE_Y_AXIS_KEY_REPEAT = 2;
        private int mLastXDirection;
        private int mLastYDirection;
        private int mLastXKeyCode;
        private int mLastYKeyCode;

        public SyntheticJoystickHandler() {
            super(true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: 
                case 2: {
                    KeyEvent oldEvent = (KeyEvent)msg.obj;
                    KeyEvent e = KeyEvent.changeTimeRepeat(oldEvent, SystemClock.uptimeMillis(), oldEvent.getRepeatCount() + 1);
                    if (!ViewRootImpl.this.mAttachInfo.mHasWindowFocus) break;
                    ViewRootImpl.this.enqueueInputEvent(e);
                    Message m = this.obtainMessage(msg.what, e);
                    m.setAsynchronous(true);
                    this.sendMessageDelayed(m, ViewConfiguration.getKeyRepeatDelay());
                }
            }
        }

        public void process(MotionEvent event) {
            switch (event.getActionMasked()) {
                case 3: {
                    this.cancel(event);
                    break;
                }
                case 2: {
                    this.update(event, true);
                    break;
                }
                default: {
                    Log.w(TAG, "Unexpected action: " + event.getActionMasked());
                }
            }
        }

        private void cancel(MotionEvent event) {
            this.removeMessages(1);
            this.removeMessages(2);
            this.update(event, false);
        }

        private void update(MotionEvent event, boolean synthesizeNewKeys) {
            Message m;
            KeyEvent e;
            int yDirection;
            long time = event.getEventTime();
            int metaState = event.getMetaState();
            int deviceId = event.getDeviceId();
            int source = event.getSource();
            int xDirection = this.joystickAxisValueToDirection(event.getAxisValue(15));
            if (xDirection == 0) {
                xDirection = this.joystickAxisValueToDirection(event.getX());
            }
            if ((yDirection = this.joystickAxisValueToDirection(event.getAxisValue(16))) == 0) {
                yDirection = this.joystickAxisValueToDirection(event.getY());
            }
            if (xDirection != this.mLastXDirection) {
                if (this.mLastXKeyCode != 0) {
                    this.removeMessages(1);
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(time, time, 1, this.mLastXKeyCode, 0, metaState, deviceId, 0, 1024, source));
                    this.mLastXKeyCode = 0;
                }
                this.mLastXDirection = xDirection;
                if (xDirection != 0 && synthesizeNewKeys) {
                    this.mLastXKeyCode = xDirection > 0 ? 22 : 21;
                    e = new KeyEvent(time, time, 0, this.mLastXKeyCode, 0, metaState, deviceId, 0, 1024, source);
                    ViewRootImpl.this.enqueueInputEvent(e);
                    m = this.obtainMessage(1, e);
                    m.setAsynchronous(true);
                    this.sendMessageDelayed(m, ViewConfiguration.getKeyRepeatTimeout());
                }
            }
            if (yDirection != this.mLastYDirection) {
                if (this.mLastYKeyCode != 0) {
                    this.removeMessages(2);
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(time, time, 1, this.mLastYKeyCode, 0, metaState, deviceId, 0, 1024, source));
                    this.mLastYKeyCode = 0;
                }
                this.mLastYDirection = yDirection;
                if (yDirection != 0 && synthesizeNewKeys) {
                    this.mLastYKeyCode = yDirection > 0 ? 20 : 19;
                    e = new KeyEvent(time, time, 0, this.mLastYKeyCode, 0, metaState, deviceId, 0, 1024, source);
                    ViewRootImpl.this.enqueueInputEvent(e);
                    m = this.obtainMessage(2, e);
                    m.setAsynchronous(true);
                    this.sendMessageDelayed(m, ViewConfiguration.getKeyRepeatTimeout());
                }
            }
        }

        private int joystickAxisValueToDirection(float value) {
            if (value >= 0.5f) {
                return 1;
            }
            if (value <= -0.5f) {
                return -1;
            }
            return 0;
        }
    }

    static class TrackballAxis {
        static final float MAX_ACCELERATION = 20.0f;
        static final long FAST_MOVE_TIME = 150L;
        static final float ACCEL_MOVE_SCALING_FACTOR = 0.025f;
        static final float FIRST_MOVEMENT_THRESHOLD = 0.5f;
        static final float SECOND_CUMULATIVE_MOVEMENT_THRESHOLD = 2.0f;
        static final float SUBSEQUENT_INCREMENTAL_MOVEMENT_THRESHOLD = 1.0f;
        float position;
        float acceleration = 1.0f;
        long lastMoveTime = 0L;
        int step;
        int dir;
        int nonAccelMovement;

        TrackballAxis() {
        }

        void reset(int _step) {
            this.position = 0.0f;
            this.acceleration = 1.0f;
            this.lastMoveTime = 0L;
            this.step = _step;
            this.dir = 0;
        }

        float collect(float off, long time, String axis) {
            long normTime;
            if (off > 0.0f) {
                normTime = (long)(off * 150.0f);
                if (this.dir < 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = 1;
            } else if (off < 0.0f) {
                normTime = (long)(-off * 150.0f);
                if (this.dir > 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = -1;
            } else {
                normTime = 0L;
            }
            if (normTime > 0L) {
                long delta = time - this.lastMoveTime;
                this.lastMoveTime = time;
                float acc = this.acceleration;
                if (delta < normTime) {
                    float scale = (float)(normTime - delta) * 0.025f;
                    if (scale > 1.0f) {
                        acc *= scale;
                    }
                    this.acceleration = acc < 20.0f ? acc : 20.0f;
                } else {
                    float scale = (float)(delta - normTime) * 0.025f;
                    if (scale > 1.0f) {
                        acc /= scale;
                    }
                    this.acceleration = acc > 1.0f ? acc : 1.0f;
                }
            }
            this.position += off;
            return Math.abs(this.position);
        }

        int generate() {
            int movement = 0;
            this.nonAccelMovement = 0;
            block4: while (true) {
                int dir = this.position >= 0.0f ? 1 : -1;
                switch (this.step) {
                    case 0: {
                        if (Math.abs(this.position) < 0.5f) {
                            return movement;
                        }
                        movement += dir;
                        this.nonAccelMovement += dir;
                        this.step = 1;
                        continue block4;
                    }
                    case 1: {
                        if (Math.abs(this.position) < 2.0f) {
                            return movement;
                        }
                        movement += dir;
                        this.nonAccelMovement += dir;
                        this.position -= 2.0f * (float)dir;
                        this.step = 2;
                        continue block4;
                    }
                }
                if (Math.abs(this.position) < 1.0f) {
                    return movement;
                }
                movement += dir;
                this.position -= (float)dir * 1.0f;
                float acc = this.acceleration;
                this.acceleration = (acc *= 1.1f) < 20.0f ? acc : this.acceleration;
            }
        }
    }

    class SyntheticTrackballHandler {
        private final TrackballAxis mX = new TrackballAxis();
        private final TrackballAxis mY = new TrackballAxis();
        private long mLastTime;

        SyntheticTrackballHandler() {
        }

        public void process(MotionEvent event) {
            long curTime = SystemClock.uptimeMillis();
            if (this.mLastTime + 250L < curTime) {
                this.mX.reset(0);
                this.mY.reset(0);
                this.mLastTime = curTime;
            }
            int action = event.getAction();
            int metaState = event.getMetaState();
            switch (action) {
                case 0: {
                    this.mX.reset(2);
                    this.mY.reset(2);
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(curTime, curTime, 0, 23, 0, metaState, -1, 0, 1024, 257));
                    break;
                }
                case 1: {
                    this.mX.reset(2);
                    this.mY.reset(2);
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(curTime, curTime, 1, 23, 0, metaState, -1, 0, 1024, 257));
                }
            }
            float xOff = this.mX.collect(event.getX(), event.getEventTime(), "X");
            float yOff = this.mY.collect(event.getY(), event.getEventTime(), "Y");
            int keycode = 0;
            int movement = 0;
            float accel = 1.0f;
            if (xOff > yOff) {
                movement = this.mX.generate();
                if (movement != 0) {
                    keycode = movement > 0 ? 22 : 21;
                    accel = this.mX.acceleration;
                    this.mY.reset(2);
                }
            } else if (yOff > 0.0f && (movement = this.mY.generate()) != 0) {
                keycode = movement > 0 ? 20 : 19;
                accel = this.mY.acceleration;
                this.mX.reset(2);
            }
            if (keycode != 0) {
                int accelMovement;
                if (movement < 0) {
                    movement = -movement;
                }
                if ((accelMovement = (int)((float)movement * accel)) > movement) {
                    int repeatCount = accelMovement - --movement;
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(curTime, curTime, 2, keycode, repeatCount, metaState, -1, 0, 1024, 257));
                }
                while (movement > 0) {
                    --movement;
                    curTime = SystemClock.uptimeMillis();
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(curTime, curTime, 0, keycode, 0, metaState, -1, 0, 1024, 257));
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(curTime, curTime, 1, keycode, 0, metaState, -1, 0, 1024, 257));
                }
                this.mLastTime = curTime;
            }
        }

        public void cancel(MotionEvent event) {
            this.mLastTime = Integer.MIN_VALUE;
            if (ViewRootImpl.this.mView != null && ViewRootImpl.this.mAdded) {
                ViewRootImpl.this.ensureTouchMode(false);
            }
        }
    }

    class SyntheticInputStage
    extends InputStage {
        private final SyntheticTrackballHandler mTrackball;
        private final SyntheticJoystickHandler mJoystick;
        private final SyntheticTouchNavigationHandler mTouchNavigation;
        private final SyntheticKeyboardHandler mKeyboard;

        public SyntheticInputStage() {
            super(null);
            this.mTrackball = new SyntheticTrackballHandler();
            this.mJoystick = new SyntheticJoystickHandler();
            this.mTouchNavigation = new SyntheticTouchNavigationHandler();
            this.mKeyboard = new SyntheticKeyboardHandler();
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            q.mFlags |= 0x10;
            if (q.mEvent instanceof MotionEvent) {
                MotionEvent event = (MotionEvent)q.mEvent;
                int source = event.getSource();
                if ((source & 4) != 0) {
                    this.mTrackball.process(event);
                    return 1;
                }
                if ((source & 0x10) != 0) {
                    this.mJoystick.process(event);
                    return 1;
                }
                if ((source & 0x200000) == 0x200000) {
                    this.mTouchNavigation.process(event);
                    return 1;
                }
            } else if ((q.mFlags & 0x20) != 0) {
                this.mKeyboard.process((KeyEvent)q.mEvent);
                return 1;
            }
            return 0;
        }

        @Override
        protected void onDeliverToNext(QueuedInputEvent q) {
            if ((q.mFlags & 0x10) == 0 && q.mEvent instanceof MotionEvent) {
                MotionEvent event = (MotionEvent)q.mEvent;
                int source = event.getSource();
                if ((source & 4) != 0) {
                    this.mTrackball.cancel(event);
                } else if ((source & 0x10) != 0) {
                    this.mJoystick.cancel(event);
                } else if ((source & 0x200000) == 0x200000) {
                    this.mTouchNavigation.cancel(event);
                }
            }
            super.onDeliverToNext(q);
        }
    }

    class ViewPostImeInputStage
    extends InputStage {
        public ViewPostImeInputStage(InputStage next) {
            super(next);
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            if (q.mEvent instanceof KeyEvent) {
                return this.processKeyEvent(q);
            }
            ViewRootImpl.this.handleDispatchDoneAnimating();
            int source = q.mEvent.getSource();
            if ((source & 2) != 0) {
                return this.processPointerEvent(q);
            }
            if ((source & 4) != 0) {
                return this.processTrackballEvent(q);
            }
            return this.processGenericMotionEvent(q);
        }

        @Override
        protected void onDeliverToNext(QueuedInputEvent q) {
            if (ViewRootImpl.this.mUnbufferedInputDispatch && q.mEvent instanceof MotionEvent && ((MotionEvent)q.mEvent).isTouchEvent() && ViewRootImpl.isTerminalInputEvent(q.mEvent)) {
                ViewRootImpl.this.mUnbufferedInputDispatch = false;
                ViewRootImpl.this.scheduleConsumeBatchedInput();
            }
            super.onDeliverToNext(q);
        }

        private int processKeyEvent(QueuedInputEvent q) {
            KeyEvent event = (KeyEvent)q.mEvent;
            if (event.getAction() != 1) {
                ViewRootImpl.this.handleDispatchDoneAnimating();
            }
            if (ViewRootImpl.this.mView.dispatchKeyEvent(event)) {
                return 1;
            }
            if (this.shouldDropInputEvent(q)) {
                return 2;
            }
            if (event.getAction() == 0 && event.isCtrlPressed() && event.getRepeatCount() == 0 && !KeyEvent.isModifierKey(event.getKeyCode())) {
                if (ViewRootImpl.this.mView.dispatchKeyShortcutEvent(event)) {
                    return 1;
                }
                if (this.shouldDropInputEvent(q)) {
                    return 2;
                }
            }
            if (ViewRootImpl.this.mFallbackEventHandler.dispatchKeyEvent(event)) {
                return 1;
            }
            if (this.shouldDropInputEvent(q)) {
                return 2;
            }
            if (event.getAction() == 0) {
                int direction = 0;
                switch (event.getKeyCode()) {
                    case 21: {
                        if (!event.hasNoModifiers()) break;
                        direction = 17;
                        break;
                    }
                    case 22: {
                        if (!event.hasNoModifiers()) break;
                        direction = 66;
                        break;
                    }
                    case 19: {
                        if (!event.hasNoModifiers()) break;
                        direction = 33;
                        break;
                    }
                    case 20: {
                        if (!event.hasNoModifiers()) break;
                        direction = 130;
                        break;
                    }
                    case 61: {
                        if (event.hasNoModifiers()) {
                            direction = 2;
                            break;
                        }
                        if (!event.hasModifiers(1)) break;
                        direction = 1;
                    }
                }
                if (direction != 0) {
                    View focused = ViewRootImpl.this.mView.findFocus();
                    if (focused != null) {
                        View v = focused.focusSearch(direction);
                        if (v != null && v != focused) {
                            focused.getFocusedRect(ViewRootImpl.this.mTempRect);
                            if (ViewRootImpl.this.mView instanceof ViewGroup) {
                                ((ViewGroup)ViewRootImpl.this.mView).offsetDescendantRectToMyCoords(focused, ViewRootImpl.this.mTempRect);
                                ((ViewGroup)ViewRootImpl.this.mView).offsetRectIntoDescendantCoords(v, ViewRootImpl.this.mTempRect);
                            }
                            if (v.requestFocus(direction, ViewRootImpl.this.mTempRect)) {
                                ViewRootImpl.this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(direction));
                                return 1;
                            }
                        }
                        if (ViewRootImpl.this.mView.dispatchUnhandledMove(focused, direction)) {
                            return 1;
                        }
                    } else {
                        View v = ViewRootImpl.this.focusSearch(null, direction);
                        if (v != null && v.requestFocus(direction)) {
                            return 1;
                        }
                    }
                }
            }
            return 0;
        }

        private int processPointerEvent(QueuedInputEvent q) {
            MotionEvent event = (MotionEvent)q.mEvent;
            ViewRootImpl.this.mAttachInfo.mUnbufferedDispatchRequested = false;
            boolean handled = ViewRootImpl.this.mView.dispatchPointerEvent(event);
            if (ViewRootImpl.this.mAttachInfo.mUnbufferedDispatchRequested && !ViewRootImpl.this.mUnbufferedInputDispatch) {
                ViewRootImpl.this.mUnbufferedInputDispatch = true;
                if (ViewRootImpl.this.mConsumeBatchedInputScheduled) {
                    ViewRootImpl.this.scheduleConsumeBatchedInputImmediately();
                }
            }
            return handled ? 1 : 0;
        }

        private int processTrackballEvent(QueuedInputEvent q) {
            MotionEvent event = (MotionEvent)q.mEvent;
            if (ViewRootImpl.this.mView.dispatchTrackballEvent(event)) {
                return 1;
            }
            return 0;
        }

        private int processGenericMotionEvent(QueuedInputEvent q) {
            MotionEvent event = (MotionEvent)q.mEvent;
            if (ViewRootImpl.this.mView.dispatchGenericMotionEvent(event)) {
                return 1;
            }
            return 0;
        }
    }

    class NativePostImeInputStage
    extends AsyncInputStage
    implements InputQueue.FinishedInputEventCallback {
        public NativePostImeInputStage(InputStage next, String traceCounter) {
            super(next, traceCounter);
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            if (ViewRootImpl.this.mInputQueue != null) {
                ViewRootImpl.this.mInputQueue.sendInputEvent(q.mEvent, q, false, this);
                return 3;
            }
            return 0;
        }

        @Override
        public void onFinishedInputEvent(Object token, boolean handled) {
            QueuedInputEvent q = (QueuedInputEvent)token;
            if (handled) {
                this.finish(q, true);
                return;
            }
            this.forward(q);
        }
    }

    class EarlyPostImeInputStage
    extends InputStage {
        public EarlyPostImeInputStage(InputStage next) {
            super(next);
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            if (q.mEvent instanceof KeyEvent) {
                return this.processKeyEvent(q);
            }
            int source = q.mEvent.getSource();
            if ((source & 2) != 0) {
                return this.processPointerEvent(q);
            }
            return 0;
        }

        private int processKeyEvent(QueuedInputEvent q) {
            KeyEvent event = (KeyEvent)q.mEvent;
            if (ViewRootImpl.this.checkForLeavingTouchModeAndConsume(event)) {
                return 1;
            }
            ViewRootImpl.this.mFallbackEventHandler.preDispatchKeyEvent(event);
            return 0;
        }

        private int processPointerEvent(QueuedInputEvent q) {
            int action;
            MotionEvent event = (MotionEvent)q.mEvent;
            if (ViewRootImpl.this.mTranslator != null) {
                ViewRootImpl.this.mTranslator.translateEventInScreenToAppWindow(event);
            }
            if ((action = event.getAction()) == 0 || action == 8) {
                ViewRootImpl.this.ensureTouchMode(true);
            }
            if (ViewRootImpl.this.mCurScrollY != 0) {
                event.offsetLocation(0.0f, ViewRootImpl.this.mCurScrollY);
            }
            if (event.isTouchEvent()) {
                ViewRootImpl.this.mLastTouchPoint.x = event.getRawX();
                ViewRootImpl.this.mLastTouchPoint.y = event.getRawY();
            }
            return 0;
        }
    }

    class ImeInputStage
    extends AsyncInputStage
    implements InputMethodManager.FinishedInputEventCallback {
        public ImeInputStage(InputStage next, String traceCounter) {
            super(next, traceCounter);
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            InputMethodManager imm;
            if (ViewRootImpl.this.mLastWasImTarget && !ViewRootImpl.this.isInLocalFocusMode() && (imm = InputMethodManager.peekInstance()) != null) {
                InputEvent event = q.mEvent;
                int result = imm.dispatchInputEvent(event, q, this, ViewRootImpl.this.mHandler);
                if (result == 1) {
                    return 1;
                }
                if (result == 0) {
                    return 0;
                }
                return 3;
            }
            return 0;
        }

        @Override
        public void onFinishedInputEvent(Object token, boolean handled) {
            QueuedInputEvent q = (QueuedInputEvent)token;
            if (handled) {
                this.finish(q, true);
                return;
            }
            this.forward(q);
        }
    }

    class ViewPreImeInputStage
    extends InputStage {
        public ViewPreImeInputStage(InputStage next) {
            super(next);
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            if (q.mEvent instanceof KeyEvent) {
                return this.processKeyEvent(q);
            }
            return 0;
        }

        private int processKeyEvent(QueuedInputEvent q) {
            KeyEvent event = (KeyEvent)q.mEvent;
            if (ViewRootImpl.this.mView.dispatchKeyEventPreIme(event)) {
                return 1;
            }
            return 0;
        }
    }

    class NativePreImeInputStage
    extends AsyncInputStage
    implements InputQueue.FinishedInputEventCallback {
        public NativePreImeInputStage(InputStage next, String traceCounter) {
            super(next, traceCounter);
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            if (ViewRootImpl.this.mInputQueue != null && q.mEvent instanceof KeyEvent) {
                ViewRootImpl.this.mInputQueue.sendInputEvent(q.mEvent, q, true, this);
                return 3;
            }
            return 0;
        }

        @Override
        public void onFinishedInputEvent(Object token, boolean handled) {
            QueuedInputEvent q = (QueuedInputEvent)token;
            if (handled) {
                this.finish(q, true);
                return;
            }
            this.forward(q);
        }
    }

    abstract class AsyncInputStage
    extends InputStage {
        private final String mTraceCounter;
        private QueuedInputEvent mQueueHead;
        private QueuedInputEvent mQueueTail;
        private int mQueueLength;
        protected static final int DEFER = 3;

        public AsyncInputStage(InputStage next, String traceCounter) {
            super(next);
            this.mTraceCounter = traceCounter;
        }

        protected void defer(QueuedInputEvent q) {
            q.mFlags |= 2;
            this.enqueue(q);
        }

        @Override
        protected void forward(QueuedInputEvent q) {
            q.mFlags &= 0xFFFFFFFD;
            QueuedInputEvent curr = this.mQueueHead;
            if (curr == null) {
                super.forward(q);
                return;
            }
            int deviceId = q.mEvent.getDeviceId();
            QueuedInputEvent prev = null;
            boolean blocked = false;
            while (curr != null && curr != q) {
                if (!blocked && deviceId == curr.mEvent.getDeviceId()) {
                    blocked = true;
                }
                prev = curr;
                curr = curr.mNext;
            }
            if (blocked) {
                if (curr == null) {
                    this.enqueue(q);
                }
                return;
            }
            if (curr != null) {
                curr = curr.mNext;
                this.dequeue(q, prev);
            }
            super.forward(q);
            while (curr != null) {
                if (deviceId == curr.mEvent.getDeviceId()) {
                    if ((curr.mFlags & 2) != 0) break;
                    QueuedInputEvent next = curr.mNext;
                    this.dequeue(curr, prev);
                    super.forward(curr);
                    curr = next;
                    continue;
                }
                prev = curr;
                curr = curr.mNext;
            }
        }

        @Override
        protected void apply(QueuedInputEvent q, int result) {
            if (result == 3) {
                this.defer(q);
            } else {
                super.apply(q, result);
            }
        }

        private void enqueue(QueuedInputEvent q) {
            if (this.mQueueTail == null) {
                this.mQueueHead = q;
                this.mQueueTail = q;
            } else {
                this.mQueueTail.mNext = q;
                this.mQueueTail = q;
            }
            ++this.mQueueLength;
            Trace.traceCounter(4L, this.mTraceCounter, this.mQueueLength);
        }

        private void dequeue(QueuedInputEvent q, QueuedInputEvent prev) {
            if (prev == null) {
                this.mQueueHead = q.mNext;
            } else {
                prev.mNext = q.mNext;
            }
            if (this.mQueueTail == q) {
                this.mQueueTail = prev;
            }
            q.mNext = null;
            --this.mQueueLength;
            Trace.traceCounter(4L, this.mTraceCounter, this.mQueueLength);
        }

        @Override
        void dump(String prefix, PrintWriter writer) {
            writer.print(prefix);
            writer.print(this.getClass().getName());
            writer.print(": mQueueLength=");
            writer.println(this.mQueueLength);
            super.dump(prefix, writer);
        }
    }

    abstract class InputStage {
        private final InputStage mNext;
        protected static final int FORWARD = 0;
        protected static final int FINISH_HANDLED = 1;
        protected static final int FINISH_NOT_HANDLED = 2;

        public InputStage(InputStage next) {
            this.mNext = next;
        }

        public void deliver(QueuedInputEvent q) {
            if ((q.mFlags & 4) != 0) {
                this.forward(q);
            } else if (this.shouldDropInputEvent(q)) {
                this.finish(q, false);
            } else {
                this.apply(q, this.onProcess(q));
            }
        }

        protected void finish(QueuedInputEvent q, boolean handled) {
            q.mFlags |= 4;
            if (handled) {
                q.mFlags |= 8;
            }
            this.forward(q);
        }

        protected void forward(QueuedInputEvent q) {
            this.onDeliverToNext(q);
        }

        protected void apply(QueuedInputEvent q, int result) {
            if (result == 0) {
                this.forward(q);
            } else if (result == 1) {
                this.finish(q, true);
            } else if (result == 2) {
                this.finish(q, false);
            } else {
                throw new IllegalArgumentException("Invalid result: " + result);
            }
        }

        protected int onProcess(QueuedInputEvent q) {
            return 0;
        }

        protected void onDeliverToNext(QueuedInputEvent q) {
            if (this.mNext != null) {
                this.mNext.deliver(q);
            } else {
                ViewRootImpl.this.finishInputEvent(q);
            }
        }

        protected boolean shouldDropInputEvent(QueuedInputEvent q) {
            if (ViewRootImpl.this.mView == null || !ViewRootImpl.this.mAdded) {
                Slog.w(ViewRootImpl.TAG, "Dropping event due to root view being removed: " + q.mEvent);
                return true;
            }
            if (!(ViewRootImpl.this.mAttachInfo.mHasWindowFocus || q.mEvent.isFromSource(2) || ViewRootImpl.isTerminalInputEvent(q.mEvent))) {
                Slog.w(ViewRootImpl.TAG, "Dropping event due to no window focus: " + q.mEvent);
                return true;
            }
            return false;
        }

        void dump(String prefix, PrintWriter writer) {
            if (this.mNext != null) {
                this.mNext.dump(prefix, writer);
            }
        }
    }

    class ViewRootHandler
    extends Handler {
        ViewRootHandler() {
        }

        @Override
        public String getMessageName(Message message) {
            switch (message.what) {
                case 1: {
                    return "MSG_INVALIDATE";
                }
                case 2: {
                    return "MSG_INVALIDATE_RECT";
                }
                case 3: {
                    return "MSG_DIE";
                }
                case 4: {
                    return "MSG_RESIZED";
                }
                case 5: {
                    return "MSG_RESIZED_REPORT";
                }
                case 6: {
                    return "MSG_WINDOW_FOCUS_CHANGED";
                }
                case 7: {
                    return "MSG_DISPATCH_INPUT_EVENT";
                }
                case 8: {
                    return "MSG_DISPATCH_APP_VISIBILITY";
                }
                case 9: {
                    return "MSG_DISPATCH_GET_NEW_SURFACE";
                }
                case 11: {
                    return "MSG_DISPATCH_KEY_FROM_IME";
                }
                case 12: {
                    return "MSG_FINISH_INPUT_CONNECTION";
                }
                case 13: {
                    return "MSG_CHECK_FOCUS";
                }
                case 14: {
                    return "MSG_CLOSE_SYSTEM_DIALOGS";
                }
                case 15: {
                    return "MSG_DISPATCH_DRAG_EVENT";
                }
                case 16: {
                    return "MSG_DISPATCH_DRAG_LOCATION_EVENT";
                }
                case 17: {
                    return "MSG_DISPATCH_SYSTEM_UI_VISIBILITY";
                }
                case 18: {
                    return "MSG_UPDATE_CONFIGURATION";
                }
                case 19: {
                    return "MSG_PROCESS_INPUT_EVENTS";
                }
                case 21: {
                    return "MSG_CLEAR_ACCESSIBILITY_FOCUS_HOST";
                }
                case 22: {
                    return "MSG_DISPATCH_DONE_ANIMATING";
                }
                case 24: {
                    return "MSG_WINDOW_MOVED";
                }
                case 25: {
                    return "MSG_SYNTHESIZE_INPUT_EVENT";
                }
            }
            return super.getMessageName(message);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ((View)msg.obj).invalidate();
                    break;
                }
                case 2: {
                    View.AttachInfo.InvalidateInfo info = (View.AttachInfo.InvalidateInfo)msg.obj;
                    info.target.invalidate(info.left, info.top, info.right, info.bottom);
                    info.recycle();
                    break;
                }
                case 19: {
                    ViewRootImpl.this.mProcessInputEventsScheduled = false;
                    ViewRootImpl.this.doProcessInputEvents();
                    break;
                }
                case 8: {
                    ViewRootImpl.this.handleAppVisibility(msg.arg1 != 0);
                    break;
                }
                case 9: {
                    ViewRootImpl.this.handleGetNewSurface();
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    if (ViewRootImpl.this.mWinFrame.equals(args.arg1) && ViewRootImpl.this.mPendingOverscanInsets.equals(args.arg5) && ViewRootImpl.this.mPendingContentInsets.equals(args.arg2) && ViewRootImpl.this.mPendingStableInsets.equals(args.arg6) && ViewRootImpl.this.mPendingVisibleInsets.equals(args.arg3) && args.arg4 == null) break;
                }
                case 5: {
                    if (!ViewRootImpl.this.mAdded) break;
                    SomeArgs args = (SomeArgs)msg.obj;
                    Configuration config = (Configuration)args.arg4;
                    if (config != null) {
                        ViewRootImpl.this.updateConfiguration(config, false);
                    }
                    ViewRootImpl.this.mWinFrame.set((Rect)args.arg1);
                    ViewRootImpl.this.mPendingOverscanInsets.set((Rect)args.arg5);
                    ViewRootImpl.this.mPendingContentInsets.set((Rect)args.arg2);
                    ViewRootImpl.this.mPendingStableInsets.set((Rect)args.arg6);
                    ViewRootImpl.this.mPendingVisibleInsets.set((Rect)args.arg3);
                    args.recycle();
                    if (msg.what == 5) {
                        ViewRootImpl.this.mReportNextDraw = true;
                    }
                    if (ViewRootImpl.this.mView != null) {
                        ViewRootImpl.forceLayout(ViewRootImpl.this.mView);
                    }
                    ViewRootImpl.this.requestLayout();
                    break;
                }
                case 24: {
                    if (!ViewRootImpl.this.mAdded) break;
                    int w = ViewRootImpl.this.mWinFrame.width();
                    int h = ViewRootImpl.this.mWinFrame.height();
                    int l = msg.arg1;
                    int t = msg.arg2;
                    ViewRootImpl.this.mWinFrame.left = l;
                    ViewRootImpl.this.mWinFrame.right = l + w;
                    ViewRootImpl.this.mWinFrame.top = t;
                    ViewRootImpl.this.mWinFrame.bottom = t + h;
                    if (ViewRootImpl.this.mView != null) {
                        ViewRootImpl.forceLayout(ViewRootImpl.this.mView);
                    }
                    ViewRootImpl.this.requestLayout();
                    break;
                }
                case 6: {
                    boolean hasWindowFocus;
                    if (!ViewRootImpl.this.mAdded) break;
                    ViewRootImpl.this.mAttachInfo.mHasWindowFocus = hasWindowFocus = msg.arg1 != 0;
                    ViewRootImpl.this.profileRendering(hasWindowFocus);
                    if (hasWindowFocus) {
                        boolean inTouchMode = msg.arg2 != 0;
                        ViewRootImpl.this.ensureTouchModeLocally(inTouchMode);
                        if (ViewRootImpl.this.mAttachInfo.mHardwareRenderer != null && ViewRootImpl.this.mSurface.isValid()) {
                            ViewRootImpl.this.mFullRedrawNeeded = true;
                            try {
                                WindowManager.LayoutParams lp = ViewRootImpl.this.mWindowAttributes;
                                Rect surfaceInsets = lp != null ? lp.surfaceInsets : null;
                                ViewRootImpl.this.mAttachInfo.mHardwareRenderer.initializeIfNeeded(ViewRootImpl.this.mWidth, ViewRootImpl.this.mHeight, ViewRootImpl.this.mSurface, surfaceInsets);
                            }
                            catch (Surface.OutOfResourcesException e) {
                                Log.e(ViewRootImpl.TAG, "OutOfResourcesException locking surface", e);
                                try {
                                    if (!ViewRootImpl.this.mWindowSession.outOfMemory(ViewRootImpl.this.mWindow)) {
                                        Slog.w(ViewRootImpl.TAG, "No processes killed for memory; killing self");
                                        Process.killProcess(Process.myPid());
                                    }
                                }
                                catch (RemoteException ex) {
                                    // empty catch block
                                }
                                this.sendMessageDelayed(this.obtainMessage(msg.what, msg.arg1, msg.arg2), 500L);
                                return;
                            }
                        }
                    }
                    ViewRootImpl.this.mLastWasImTarget = WindowManager.LayoutParams.mayUseInputMethod(ViewRootImpl.this.mWindowAttributes.flags);
                    InputMethodManager imm = InputMethodManager.peekInstance();
                    if (ViewRootImpl.this.mView != null) {
                        if (hasWindowFocus && imm != null && ViewRootImpl.this.mLastWasImTarget && !ViewRootImpl.this.isInLocalFocusMode()) {
                            imm.startGettingWindowFocus(ViewRootImpl.this.mView);
                        }
                        ViewRootImpl.this.mAttachInfo.mKeyDispatchState.reset();
                        ViewRootImpl.this.mView.dispatchWindowFocusChanged(hasWindowFocus);
                        ViewRootImpl.this.mAttachInfo.mTreeObserver.dispatchOnWindowFocusChange(hasWindowFocus);
                    }
                    if (hasWindowFocus) {
                        if (imm != null && ViewRootImpl.this.mLastWasImTarget && !ViewRootImpl.this.isInLocalFocusMode()) {
                            imm.onWindowFocus(ViewRootImpl.this.mView, ViewRootImpl.this.mView.findFocus(), ViewRootImpl.this.mWindowAttributes.softInputMode, !ViewRootImpl.this.mHasHadWindowFocus, ViewRootImpl.this.mWindowAttributes.flags);
                        }
                        ViewRootImpl.this.mWindowAttributes.softInputMode &= 0xFFFFFEFF;
                        ((WindowManager.LayoutParams)ViewRootImpl.this.mView.getLayoutParams()).softInputMode &= 0xFFFFFEFF;
                        ViewRootImpl.this.mHasHadWindowFocus = true;
                    }
                    if (ViewRootImpl.this.mView == null || !ViewRootImpl.this.mAccessibilityManager.isEnabled() || !hasWindowFocus) break;
                    ViewRootImpl.this.mView.sendAccessibilityEvent(32);
                    break;
                }
                case 3: {
                    ViewRootImpl.this.doDie();
                    break;
                }
                case 7: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    InputEvent event = (InputEvent)args.arg1;
                    InputEventReceiver receiver = (InputEventReceiver)args.arg2;
                    ViewRootImpl.this.enqueueInputEvent(event, receiver, 0, true);
                    args.recycle();
                    break;
                }
                case 25: {
                    InputEvent event = (InputEvent)msg.obj;
                    ViewRootImpl.this.enqueueInputEvent(event, null, 32, true);
                    break;
                }
                case 11: {
                    KeyEvent event = (KeyEvent)msg.obj;
                    if ((event.getFlags() & 8) != 0) {
                        event = KeyEvent.changeFlags(event, event.getFlags() & 0xFFFFFFF7);
                    }
                    ViewRootImpl.this.enqueueInputEvent(event, null, 1, true);
                    break;
                }
                case 12: {
                    InputMethodManager imm = InputMethodManager.peekInstance();
                    if (imm == null) break;
                    imm.reportFinishInputConnection((InputConnection)msg.obj);
                    break;
                }
                case 13: {
                    InputMethodManager imm = InputMethodManager.peekInstance();
                    if (imm == null) break;
                    imm.checkFocus();
                    break;
                }
                case 14: {
                    if (ViewRootImpl.this.mView == null) break;
                    ViewRootImpl.this.mView.onCloseSystemDialogs((String)msg.obj);
                    break;
                }
                case 15: 
                case 16: {
                    DragEvent event = (DragEvent)msg.obj;
                    event.mLocalState = ViewRootImpl.this.mLocalDragState;
                    ViewRootImpl.this.handleDragEvent(event);
                    break;
                }
                case 17: {
                    ViewRootImpl.this.handleDispatchSystemUiVisibilityChanged((SystemUiVisibilityInfo)msg.obj);
                    break;
                }
                case 18: {
                    Configuration config = (Configuration)msg.obj;
                    if (config.isOtherSeqNewer(ViewRootImpl.this.mLastConfiguration)) {
                        config = ViewRootImpl.this.mLastConfiguration;
                    }
                    ViewRootImpl.this.updateConfiguration(config, false);
                    break;
                }
                case 21: {
                    ViewRootImpl.this.setAccessibilityFocus(null, null);
                    break;
                }
                case 22: {
                    ViewRootImpl.this.handleDispatchDoneAnimating();
                    break;
                }
                case 23: {
                    if (ViewRootImpl.this.mView == null) break;
                    ViewRootImpl.this.invalidateWorld(ViewRootImpl.this.mView);
                }
            }
        }
    }

    static class SystemUiVisibilityInfo {
        int seq;
        int globalVisibility;
        int localValue;
        int localChanges;

        SystemUiVisibilityInfo() {
        }
    }
}

