/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.Log;
import android.util.LongSparseArray;
import android.view.Choreographer;
import android.view.GraphicBuffer;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.HardwareRenderer;
import android.view.IAssetAtlas;
import android.view.RenderNode;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashSet;

public class ThreadedRenderer
extends HardwareRenderer {
    private static final String LOGTAG = "ThreadedRenderer";
    private static final int SYNC_OK = 0;
    private static final int SYNC_INVALIDATE_REQUIRED = 1;
    private static final String[] VISUALIZERS = new String[]{"visual_bars"};
    private int mWidth;
    private int mHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mInsetTop;
    private int mInsetLeft;
    private boolean mHasInsets;
    private final float mLightY;
    private final float mLightZ;
    private final float mLightRadius;
    private final int mAmbientShadowAlpha;
    private final int mSpotShadowAlpha;
    private long mNativeProxy;
    private boolean mInitialized = false;
    private RenderNode mRootNode;
    private Choreographer mChoreographer;
    private boolean mProfilingEnabled;
    private boolean mRootNodeNeedsUpdate;

    ThreadedRenderer(Context context, boolean translucent) {
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Lighting, 0, 0);
        this.mLightY = a.getDimension(2, 0.0f);
        this.mLightZ = a.getDimension(3, 0.0f);
        this.mLightRadius = a.getDimension(4, 0.0f);
        this.mAmbientShadowAlpha = (int)(255.0f * a.getFloat(0, 0.0f) + 0.5f);
        this.mSpotShadowAlpha = (int)(255.0f * a.getFloat(1, 0.0f) + 0.5f);
        a.recycle();
        long rootNodePtr = ThreadedRenderer.nCreateRootRenderNode();
        this.mRootNode = RenderNode.adopt(rootNodePtr);
        this.mRootNode.setClipToBounds(false);
        this.mNativeProxy = ThreadedRenderer.nCreateProxy(translucent, rootNodePtr);
        AtlasInitializer.sInstance.init(context, this.mNativeProxy);
        this.mChoreographer = Choreographer.getInstance();
        ThreadedRenderer.nSetFrameInterval(this.mNativeProxy, this.mChoreographer.getFrameIntervalNanos());
        this.loadSystemProperties();
    }

    @Override
    void destroy() {
        this.mInitialized = false;
        this.updateEnabledState(null);
        ThreadedRenderer.nDestroy(this.mNativeProxy);
    }

    private void updateEnabledState(Surface surface) {
        if (surface == null || !surface.isValid()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.mInitialized);
        }
    }

    @Override
    boolean initialize(Surface surface) throws Surface.OutOfResourcesException {
        this.mInitialized = true;
        this.updateEnabledState(surface);
        boolean status = ThreadedRenderer.nInitialize(this.mNativeProxy, surface);
        surface.allocateBuffers();
        return status;
    }

    @Override
    void updateSurface(Surface surface) throws Surface.OutOfResourcesException {
        this.updateEnabledState(surface);
        ThreadedRenderer.nUpdateSurface(this.mNativeProxy, surface);
    }

    @Override
    void pauseSurface(Surface surface) {
        ThreadedRenderer.nPauseSurface(this.mNativeProxy, surface);
    }

    @Override
    void destroyHardwareResources(View view) {
        ThreadedRenderer.destroyResources(view);
        ThreadedRenderer.nDestroyHardwareResources(this.mNativeProxy);
    }

    private static void destroyResources(View view) {
        view.destroyHardwareResources();
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                ThreadedRenderer.destroyResources(group.getChildAt(i));
            }
        }
    }

    @Override
    void invalidate(Surface surface) {
        this.updateSurface(surface);
    }

    @Override
    void detachSurfaceTexture(long hardwareLayer) {
        ThreadedRenderer.nDetachSurfaceTexture(this.mNativeProxy, hardwareLayer);
    }

    @Override
    void setup(int width, int height, Rect surfaceInsets) {
        float lightX = (float)width / 2.0f;
        this.mWidth = width;
        this.mHeight = height;
        if (surfaceInsets != null && !surfaceInsets.isEmpty()) {
            this.mHasInsets = true;
            this.mInsetLeft = surfaceInsets.left;
            this.mInsetTop = surfaceInsets.top;
            this.mSurfaceWidth = width + this.mInsetLeft + surfaceInsets.right;
            this.mSurfaceHeight = height + this.mInsetTop + surfaceInsets.bottom;
            this.setOpaque(false);
        } else {
            this.mHasInsets = false;
            this.mInsetLeft = 0;
            this.mInsetTop = 0;
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
        }
        this.mRootNode.setLeftTopRightBottom(-this.mInsetLeft, -this.mInsetTop, this.mSurfaceWidth, this.mSurfaceHeight);
        ThreadedRenderer.nSetup(this.mNativeProxy, this.mSurfaceWidth, this.mSurfaceHeight, lightX, this.mLightY, this.mLightZ, this.mLightRadius, this.mAmbientShadowAlpha, this.mSpotShadowAlpha);
    }

    @Override
    void setOpaque(boolean opaque) {
        ThreadedRenderer.nSetOpaque(this.mNativeProxy, opaque && !this.mHasInsets);
    }

    @Override
    int getWidth() {
        return this.mWidth;
    }

    @Override
    int getHeight() {
        return this.mHeight;
    }

    @Override
    void dumpGfxInfo(PrintWriter pw, FileDescriptor fd) {
        pw.flush();
        ThreadedRenderer.nDumpProfileInfo(this.mNativeProxy, fd);
    }

    private static int search(String[] values, String value) {
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    private static boolean checkIfProfilingRequested() {
        String profiling = SystemProperties.get("debug.hwui.profile");
        int graphType = ThreadedRenderer.search(VISUALIZERS, profiling);
        return graphType >= 0 || Boolean.parseBoolean(profiling);
    }

    @Override
    boolean loadSystemProperties() {
        boolean changed = ThreadedRenderer.nLoadSystemProperties(this.mNativeProxy);
        boolean wantProfiling = ThreadedRenderer.checkIfProfilingRequested();
        if (wantProfiling != this.mProfilingEnabled) {
            this.mProfilingEnabled = wantProfiling;
            changed = true;
        }
        return changed;
    }

    private void updateViewTreeDisplayList(View view) {
        view.mPrivateFlags |= 0x20;
        view.mRecreateDisplayList = (view.mPrivateFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        view.mPrivateFlags &= Integer.MAX_VALUE;
        view.getDisplayList();
        view.mRecreateDisplayList = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRootDisplayList(View view, HardwareRenderer.HardwareDrawCallbacks callbacks) {
        Trace.traceBegin(8L, "getDisplayList");
        this.updateViewTreeDisplayList(view);
        if (this.mRootNodeNeedsUpdate || !this.mRootNode.isValid()) {
            HardwareCanvas canvas = this.mRootNode.start(this.mSurfaceWidth, this.mSurfaceHeight);
            try {
                int saveCount = canvas.save();
                canvas.translate(this.mInsetLeft, this.mInsetTop);
                callbacks.onHardwarePreDraw(canvas);
                canvas.insertReorderBarrier();
                canvas.drawRenderNode(view.getDisplayList());
                canvas.insertInorderBarrier();
                callbacks.onHardwarePostDraw(canvas);
                canvas.restoreToCount(saveCount);
                this.mRootNodeNeedsUpdate = false;
            }
            finally {
                this.mRootNode.end(canvas);
            }
        }
        Trace.traceEnd(8L);
    }

    @Override
    void invalidateRoot() {
        this.mRootNodeNeedsUpdate = true;
    }

    @Override
    void draw(View view, View.AttachInfo attachInfo, HardwareRenderer.HardwareDrawCallbacks callbacks) {
        int syncResult;
        attachInfo.mIgnoreDirtyState = true;
        long frameTimeNanos = this.mChoreographer.getFrameTimeNanos();
        attachInfo.mDrawingTime = frameTimeNanos / 1000000L;
        long recordDuration = 0L;
        if (this.mProfilingEnabled) {
            recordDuration = System.nanoTime();
        }
        this.updateRootDisplayList(view, callbacks);
        if (this.mProfilingEnabled) {
            recordDuration = System.nanoTime() - recordDuration;
        }
        attachInfo.mIgnoreDirtyState = false;
        if (attachInfo.mPendingAnimatingRenderNodes != null) {
            int count = attachInfo.mPendingAnimatingRenderNodes.size();
            for (int i = 0; i < count; ++i) {
                this.registerAnimatingRenderNode(attachInfo.mPendingAnimatingRenderNodes.get(i));
            }
            attachInfo.mPendingAnimatingRenderNodes.clear();
            attachInfo.mPendingAnimatingRenderNodes = null;
        }
        if (((syncResult = ThreadedRenderer.nSyncAndDrawFrame(this.mNativeProxy, frameTimeNanos, recordDuration, view.getResources().getDisplayMetrics().density)) & 1) != 0) {
            attachInfo.mViewRootImpl.invalidate();
        }
    }

    static void invokeFunctor(long functor, boolean waitForCompletion) {
        ThreadedRenderer.nInvokeFunctor(functor, waitForCompletion);
    }

    @Override
    HardwareLayer createTextureLayer() {
        long layer = ThreadedRenderer.nCreateTextureLayer(this.mNativeProxy);
        return HardwareLayer.adoptTextureLayer(this, layer);
    }

    @Override
    void buildLayer(RenderNode node) {
        ThreadedRenderer.nBuildLayer(this.mNativeProxy, node.getNativeDisplayList());
    }

    @Override
    boolean copyLayerInto(HardwareLayer layer, Bitmap bitmap) {
        return ThreadedRenderer.nCopyLayerInto(this.mNativeProxy, layer.getDeferredLayerUpdater(), bitmap.mNativeBitmap);
    }

    @Override
    void pushLayerUpdate(HardwareLayer layer) {
        ThreadedRenderer.nPushLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    @Override
    void onLayerDestroyed(HardwareLayer layer) {
        ThreadedRenderer.nCancelLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    @Override
    void setName(String name) {
    }

    @Override
    void fence() {
        ThreadedRenderer.nFence(this.mNativeProxy);
    }

    @Override
    void stopDrawing() {
        ThreadedRenderer.nStopDrawing(this.mNativeProxy);
    }

    @Override
    public void notifyFramePending() {
        ThreadedRenderer.nNotifyFramePending(this.mNativeProxy);
    }

    @Override
    void registerAnimatingRenderNode(RenderNode animator2) {
        ThreadedRenderer.nRegisterAnimatingRenderNode(this.mRootNode.mNativeRenderNode, animator2.mNativeRenderNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            ThreadedRenderer.nDeleteProxy(this.mNativeProxy);
            this.mNativeProxy = 0L;
        }
        finally {
            super.finalize();
        }
    }

    static void trimMemory(int level) {
        ThreadedRenderer.nTrimMemory(level);
    }

    static void setupShadersDiskCache(String string2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#setupShadersDiskCache(Ljava/lang/String;)V", true, null);
    }

    private static void nSetAtlas(long l, GraphicBuffer graphicBuffer, long[] lArray) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetAtlas(JLandroid/view/GraphicBuffer;[J)V", true, null);
    }

    private static long nCreateRootRenderNode() {
        return OverrideMethod.invokeL("android.view.ThreadedRenderer#nCreateRootRenderNode()J", true, null);
    }

    private static long nCreateProxy(boolean bl, long l) {
        return OverrideMethod.invokeL("android.view.ThreadedRenderer#nCreateProxy(ZJ)J", true, null);
    }

    private static void nDeleteProxy(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDeleteProxy(J)V", true, null);
    }

    private static void nSetFrameInterval(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetFrameInterval(JJ)V", true, null);
    }

    private static boolean nLoadSystemProperties(long l) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nLoadSystemProperties(J)Z", true, null) != 0;
    }

    private static boolean nInitialize(long l, Surface surface) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nInitialize(JLandroid/view/Surface;)Z", true, null) != 0;
    }

    private static void nUpdateSurface(long l, Surface surface) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nUpdateSurface(JLandroid/view/Surface;)V", true, null);
    }

    private static void nPauseSurface(long l, Surface surface) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nPauseSurface(JLandroid/view/Surface;)V", true, null);
    }

    private static void nSetup(long l, int n, int n2, float f, float f2, float f3, float f4, int n3, int n4) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetup(JIIFFFFII)V", true, null);
    }

    private static void nSetOpaque(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetOpaque(JZ)V", true, null);
    }

    private static int nSyncAndDrawFrame(long l, long l2, long l3, float f) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nSyncAndDrawFrame(JJJF)I", true, null);
    }

    private static void nDestroy(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDestroy(J)V", true, null);
    }

    private static void nRegisterAnimatingRenderNode(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nRegisterAnimatingRenderNode(JJ)V", true, null);
    }

    private static void nInvokeFunctor(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nInvokeFunctor(JZ)V", true, null);
    }

    private static long nCreateTextureLayer(long l) {
        return OverrideMethod.invokeL("android.view.ThreadedRenderer#nCreateTextureLayer(J)J", true, null);
    }

    private static void nBuildLayer(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nBuildLayer(JJ)V", true, null);
    }

    private static boolean nCopyLayerInto(long l, long l2, long l3) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nCopyLayerInto(JJJ)Z", true, null) != 0;
    }

    private static void nPushLayerUpdate(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nPushLayerUpdate(JJ)V", true, null);
    }

    private static void nCancelLayerUpdate(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nCancelLayerUpdate(JJ)V", true, null);
    }

    private static void nDetachSurfaceTexture(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDetachSurfaceTexture(JJ)V", true, null);
    }

    private static void nDestroyHardwareResources(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDestroyHardwareResources(J)V", true, null);
    }

    private static void nTrimMemory(int n) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nTrimMemory(I)V", true, null);
    }

    private static void nFence(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nFence(J)V", true, null);
    }

    private static void nStopDrawing(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nStopDrawing(J)V", true, null);
    }

    private static void nNotifyFramePending(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nNotifyFramePending(J)V", true, null);
    }

    private static void nDumpProfileInfo(long l, FileDescriptor fileDescriptor) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDumpProfileInfo(JLjava/io/FileDescriptor;)V", true, null);
    }

    private static class AtlasInitializer {
        static AtlasInitializer sInstance = new AtlasInitializer();
        private boolean mInitialized = false;

        private AtlasInitializer() {
        }

        synchronized void init(Context context, long renderProxy) {
            if (this.mInitialized) {
                return;
            }
            IBinder binder = ServiceManager.getService("assetatlas");
            if (binder == null) {
                return;
            }
            IAssetAtlas atlas = IAssetAtlas.Stub.asInterface(binder);
            try {
                GraphicBuffer buffer;
                if (atlas.isCompatible(Process.myPpid()) && (buffer = atlas.getBuffer()) != null) {
                    long[] map = atlas.getMap();
                    if (map != null) {
                        AtlasInitializer.validateMap(context, map);
                        ThreadedRenderer.nSetAtlas(renderProxy, buffer, map);
                        this.mInitialized = true;
                    }
                    if (atlas.getClass() != binder.getClass()) {
                        buffer.destroy();
                    }
                }
            }
            catch (RemoteException e) {
                Log.w("HardwareRenderer", "Could not acquire atlas", e);
            }
        }

        private static void validateMap(Context context, long[] map) {
            int i;
            Log.d("Atlas", "Validating map...");
            HashSet<Long> preloadedPointers = new HashSet<Long>();
            Resources resources = context.getResources();
            LongSparseArray<Drawable.ConstantState> drawables = resources.getPreloadedDrawables();
            int count = drawables.size();
            for (i = 0; i < count; ++i) {
                Bitmap bitmap = drawables.valueAt(i).getBitmap();
                if (bitmap == null || bitmap.getConfig() != Bitmap.Config.ARGB_8888) continue;
                preloadedPointers.add(bitmap.mNativeBitmap);
            }
            for (i = 0; i < map.length; i += 4) {
                if (preloadedPointers.contains(map[i])) continue;
                Log.w("Atlas", String.format("Pointer 0x%X, not in getPreloadedDrawables?", map[i]));
                map[i] = 0L;
            }
        }
    }
}

