/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class InputEvent
implements Parcelable {
    protected static final int PARCEL_TOKEN_MOTION_EVENT = 1;
    protected static final int PARCEL_TOKEN_KEY_EVENT = 2;
    private static final AtomicInteger mNextSeq = new AtomicInteger();
    protected int mSeq = mNextSeq.getAndIncrement();
    protected boolean mRecycled;
    private static final boolean TRACK_RECYCLED_LOCATION = false;
    private RuntimeException mRecycledLocation;
    public static final Parcelable.Creator<InputEvent> CREATOR = new Parcelable.Creator<InputEvent>(){

        @Override
        public InputEvent createFromParcel(Parcel in) {
            int token = in.readInt();
            if (token == 2) {
                return KeyEvent.createFromParcelBody(in);
            }
            if (token == 1) {
                return MotionEvent.createFromParcelBody(in);
            }
            throw new IllegalStateException("Unexpected input event type token in parcel.");
        }

        public InputEvent[] newArray(int size) {
            return new InputEvent[size];
        }
    };

    InputEvent() {
    }

    public abstract int getDeviceId();

    public InputDevice getDevice() {
        return InputDevice.getDevice(this.getDeviceId());
    }

    public abstract int getSource();

    public abstract void setSource(int var1);

    public boolean isFromSource(int source) {
        return (this.getSource() & source) == source;
    }

    public abstract InputEvent copy();

    public void recycle() {
        if (this.mRecycled) {
            throw new RuntimeException(this.toString() + " recycled twice!");
        }
        this.mRecycled = true;
    }

    public void recycleIfNeededAfterDispatch() {
        this.recycle();
    }

    protected void prepareForReuse() {
        this.mRecycled = false;
        this.mRecycledLocation = null;
        this.mSeq = mNextSeq.getAndIncrement();
    }

    public abstract boolean isTainted();

    public abstract void setTainted(boolean var1);

    public abstract long getEventTime();

    public abstract long getEventTimeNano();

    public int getSequenceNumber() {
        return this.mSeq;
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

