/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.resources.ResourceType;
import com.android.util.Pair;
import java.io.File;
import org.xmlpull.v1.XmlPullParser;

public final class BridgeInflater
extends LayoutInflater {
    private final IProjectCallback mProjectCallback;
    private boolean mIsInMerge = false;
    private ResourceReference mResourceReference;
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit."};

    protected BridgeInflater(LayoutInflater original, Context newContext) {
        super(original, newContext);
        this.mProjectCallback = null;
    }

    public BridgeInflater(Context context, IProjectCallback projectCallback) {
        super(context);
        this.mProjectCallback = projectCallback;
        this.mConstructorArgs[0] = context;
    }

    @Override
    public View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
        View view = null;
        try {
            for (String prefix : sClassPrefixList) {
                try {
                    view = this.createView(name, prefix, attrs);
                    if (view == null) continue;
                    break;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            try {
                if (view == null) {
                    view = super.onCreateView(name, attrs);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (view == null) {
                view = this.loadCustomView(name, attrs);
            }
        }
        catch (Exception e) {
            ClassNotFoundException exception = new ClassNotFoundException("onCreateView", e);
            throw exception;
        }
        this.setupViewInContext(view, attrs);
        return view;
    }

    @Override
    public View createViewFromTag(View parent, String name, AttributeSet attrs, boolean inheritContext) {
        View view = null;
        try {
            view = super.createViewFromTag(parent, name, attrs, inheritContext);
        }
        catch (InflateException e) {
            try {
                view = this.loadCustomView(name, attrs);
            }
            catch (Exception e2) {
                InflateException exception = new InflateException();
                if (!e2.getClass().equals(ClassNotFoundException.class)) {
                    exception.initCause(e2);
                } else {
                    exception.initCause(e);
                }
                throw exception;
            }
        }
        this.setupViewInContext(view, attrs);
        return view;
    }

    @Override
    public View inflate(int resource, ViewGroup root) {
        Context context = this.getContext();
        while (context instanceof ContextThemeWrapper) {
            context = ((ContextThemeWrapper)context).getBaseContext();
        }
        if (context instanceof BridgeContext) {
            File f;
            BridgeContext bridgeContext = (BridgeContext)context;
            ResourceValue value = null;
            Pair layoutInfo = Bridge.resolveResourceId(resource);
            if (layoutInfo != null) {
                value = bridgeContext.getRenderResources().getFrameworkResource(ResourceType.LAYOUT, (String)layoutInfo.getSecond());
            } else {
                layoutInfo = this.mProjectCallback.resolveResourceId(resource);
                if (layoutInfo != null) {
                    value = bridgeContext.getRenderResources().getProjectResource(ResourceType.LAYOUT, (String)layoutInfo.getSecond());
                }
            }
            if (value != null && (f = new File(value.getValue())).isFile()) {
                try {
                    XmlPullParser parser = ParserFactory.create(f);
                    BridgeXmlBlockParser bridgeParser = new BridgeXmlBlockParser(parser, bridgeContext, false);
                    return this.inflate(bridgeParser, root);
                }
                catch (Exception e) {
                    Bridge.getLog().error("resources.read", "Failed to parse file " + f.getAbsolutePath(), (Throwable)e, null);
                    return null;
                }
            }
        }
        return null;
    }

    private View loadCustomView(String name, AttributeSet attrs) throws ClassNotFoundException, Exception {
        if (this.mProjectCallback != null) {
            if (name.equals("view")) {
                name = attrs.getAttributeValue(null, "class");
            }
            this.mConstructorArgs[1] = attrs;
            Object customView = this.mProjectCallback.loadView(name, mConstructorSignature, this.mConstructorArgs);
            if (customView instanceof View) {
                return (View)customView;
            }
        }
        return null;
    }

    private void setupViewInContext(View view, AttributeSet attrs) {
        BridgeContext bc;
        Object viewKey;
        Context context = this.getContext();
        while (context instanceof ContextThemeWrapper) {
            context = ((ContextThemeWrapper)context).getBaseContext();
        }
        if (context instanceof BridgeContext && (viewKey = BridgeInflater.getViewKeyFromParser(attrs, bc = (BridgeContext)context, this.mResourceReference, this.mIsInMerge)) != null) {
            bc.addViewKey(view, viewKey);
        }
    }

    public void setIsInMerge(boolean isInMerge) {
        this.mIsInMerge = isInMerge;
    }

    public void setResourceReference(ResourceReference reference) {
        this.mResourceReference = reference;
    }

    @Override
    public LayoutInflater cloneInContext(Context newContext) {
        return new BridgeInflater(this, newContext);
    }

    static Object getViewKeyFromParser(AttributeSet attrs, BridgeContext bc, ResourceReference resourceReference, boolean isInMerge) {
        if (!(attrs instanceof BridgeXmlBlockParser)) {
            return null;
        }
        BridgeXmlBlockParser parser = (BridgeXmlBlockParser)attrs;
        Object viewKey = parser.getViewCookie();
        if (viewKey == null) {
            int currentDepth = parser.getDepth();
            BridgeXmlBlockParser previousParser = bc.getPreviousParser();
            if (previousParser != null) {
                int testDepth;
                int n = testDepth = isInMerge ? 2 : 1;
                if (currentDepth == testDepth && (viewKey = previousParser.getViewCookie()) != null && isInMerge) {
                    viewKey = new MergeCookie(viewKey);
                }
            } else if (resourceReference != null && currentDepth == 1) {
                viewKey = resourceReference;
            }
        }
        return viewKey;
    }
}

