/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.XmlPullAttributes;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import org.xmlpull.v1.XmlPullParser;

public class BridgeXmlPullAttributes
extends XmlPullAttributes {
    private final BridgeContext mContext;
    private final boolean mPlatformFile;

    public BridgeXmlPullAttributes(XmlPullParser parser, BridgeContext context, boolean platformFile) {
        super(parser);
        this.mContext = context;
        this.mPlatformFile = platformFile;
    }

    @Override
    public int getAttributeNameResource(int index) {
        Integer v;
        String name = this.getAttributeName(index);
        String ns = this.mParser.getAttributeNamespace(index);
        if ("http://schemas.android.com/apk/res/android".equals(ns)) {
            Integer v2 = Bridge.getResourceId(ResourceType.ATTR, name);
            if (v2 != null) {
                return v2;
            }
            return 0;
        }
        if (this.mContext.getProjectCallback().getNamespace().equals(ns) && (v = this.mContext.getProjectCallback().getResourceId(ResourceType.ATTR, name)) != null) {
            return v;
        }
        return 0;
    }

    @Override
    public int getAttributeListValue(String namespace, String attribute, String[] options, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToList(value, options, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public boolean getAttributeBooleanValue(String namespace, String attribute, boolean defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToBoolean(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        return this.resolveResourceValue(value, defaultValue);
    }

    @Override
    public int getAttributeIntValue(String namespace, String attribute, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToInt(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public int getAttributeUnsignedIntValue(String namespace, String attribute, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToUnsignedInt(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public float getAttributeFloatValue(String namespace, String attribute, float defaultValue) {
        String s = this.getAttributeValue(namespace, attribute);
        if (s != null) {
            ResourceValue r = this.getResourceValue(s);
            if (r != null) {
                s = r.getValue();
            }
            return Float.parseFloat(s);
        }
        return defaultValue;
    }

    @Override
    public int getAttributeListValue(int index, String[] options, int defaultValue) {
        return XmlUtils.convertValueToList(this.getAttributeValue(index), options, defaultValue);
    }

    @Override
    public boolean getAttributeBooleanValue(int index, boolean defaultValue) {
        String value = this.getAttributeValue(index);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToBoolean(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public int getAttributeResourceValue(int index, int defaultValue) {
        String value = this.getAttributeValue(index);
        return this.resolveResourceValue(value, defaultValue);
    }

    @Override
    public int getAttributeIntValue(int index, int defaultValue) {
        String value = this.getAttributeValue(index);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            if (value.charAt(0) == '#') {
                return ResourceHelper.getColor(value);
            }
            return XmlUtils.convertValueToInt(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public int getAttributeUnsignedIntValue(int index, int defaultValue) {
        String value = this.getAttributeValue(index);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToUnsignedInt(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public float getAttributeFloatValue(int index, float defaultValue) {
        String s = this.getAttributeValue(index);
        if (s != null) {
            ResourceValue r = this.getResourceValue(s);
            if (r != null) {
                s = r.getValue();
            }
            return Float.parseFloat(s);
        }
        return defaultValue;
    }

    private ResourceValue getResourceValue(String value) {
        RenderResources resources = this.mContext.getRenderResources();
        return resources.resolveResValue(resources.findResValue(value, this.mPlatformFile));
    }

    private int resolveResourceValue(String value, int defaultValue) {
        ResourceValue resource = this.getResourceValue(value);
        if (resource != null) {
            Integer id2 = null;
            id2 = this.mPlatformFile || resource.isFramework() ? Bridge.getResourceId(resource.getResourceType(), resource.getName()) : this.mContext.getProjectCallback().getResourceId(resource.getResourceType(), resource.getName());
            if (id2 != null) {
                return id2;
            }
        }
        return defaultValue;
    }
}

