/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellSignalStrength;
import android.telephony.Rlog;

public class CellSignalStrengthCdma
extends CellSignalStrength
implements Parcelable {
    private static final String LOG_TAG = "CellSignalStrengthCdma";
    private static final boolean DBG = false;
    private int mCdmaDbm;
    private int mCdmaEcio;
    private int mEvdoDbm;
    private int mEvdoEcio;
    private int mEvdoSnr;
    public static final Parcelable.Creator<CellSignalStrengthCdma> CREATOR = new Parcelable.Creator<CellSignalStrengthCdma>(){

        @Override
        public CellSignalStrengthCdma createFromParcel(Parcel in) {
            return new CellSignalStrengthCdma(in);
        }

        public CellSignalStrengthCdma[] newArray(int size) {
            return new CellSignalStrengthCdma[size];
        }
    };

    public CellSignalStrengthCdma() {
        this.setDefaultValues();
    }

    public CellSignalStrengthCdma(int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr) {
        this.initialize(cdmaDbm, cdmaEcio, evdoDbm, evdoEcio, evdoSnr);
    }

    public CellSignalStrengthCdma(CellSignalStrengthCdma s) {
        this.copyFrom(s);
    }

    public void initialize(int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr) {
        this.mCdmaDbm = cdmaDbm;
        this.mCdmaEcio = cdmaEcio;
        this.mEvdoDbm = evdoDbm;
        this.mEvdoEcio = evdoEcio;
        this.mEvdoSnr = evdoSnr;
    }

    protected void copyFrom(CellSignalStrengthCdma s) {
        this.mCdmaDbm = s.mCdmaDbm;
        this.mCdmaEcio = s.mCdmaEcio;
        this.mEvdoDbm = s.mEvdoDbm;
        this.mEvdoEcio = s.mEvdoEcio;
        this.mEvdoSnr = s.mEvdoSnr;
    }

    @Override
    public CellSignalStrengthCdma copy() {
        return new CellSignalStrengthCdma(this);
    }

    @Override
    public void setDefaultValues() {
        this.mCdmaDbm = Integer.MAX_VALUE;
        this.mCdmaEcio = Integer.MAX_VALUE;
        this.mEvdoDbm = Integer.MAX_VALUE;
        this.mEvdoEcio = Integer.MAX_VALUE;
        this.mEvdoSnr = Integer.MAX_VALUE;
    }

    @Override
    public int getLevel() {
        int cdmaLevel = this.getCdmaLevel();
        int evdoLevel = this.getEvdoLevel();
        int level = evdoLevel == 0 ? this.getCdmaLevel() : (cdmaLevel == 0 ? this.getEvdoLevel() : (cdmaLevel < evdoLevel ? cdmaLevel : evdoLevel));
        return level;
    }

    @Override
    public int getAsuLevel() {
        int cdmaDbm = this.getCdmaDbm();
        int cdmaEcio = this.getCdmaEcio();
        int cdmaAsuLevel = cdmaDbm >= -75 ? 16 : (cdmaDbm >= -82 ? 8 : (cdmaDbm >= -90 ? 4 : (cdmaDbm >= -95 ? 2 : (cdmaDbm >= -100 ? 1 : 99))));
        int ecioAsuLevel = cdmaEcio >= -90 ? 16 : (cdmaEcio >= -100 ? 8 : (cdmaEcio >= -115 ? 4 : (cdmaEcio >= -130 ? 2 : (cdmaEcio >= -150 ? 1 : 99))));
        int level = cdmaAsuLevel < ecioAsuLevel ? cdmaAsuLevel : ecioAsuLevel;
        return level;
    }

    public int getCdmaLevel() {
        int cdmaDbm = this.getCdmaDbm();
        int cdmaEcio = this.getCdmaEcio();
        int levelDbm = cdmaDbm >= -75 ? 4 : (cdmaDbm >= -85 ? 3 : (cdmaDbm >= -95 ? 2 : (cdmaDbm >= -100 ? 1 : 0)));
        int levelEcio = cdmaEcio >= -90 ? 4 : (cdmaEcio >= -110 ? 3 : (cdmaEcio >= -130 ? 2 : (cdmaEcio >= -150 ? 1 : 0)));
        int level = levelDbm < levelEcio ? levelDbm : levelEcio;
        return level;
    }

    public int getEvdoLevel() {
        int evdoDbm = this.getEvdoDbm();
        int evdoSnr = this.getEvdoSnr();
        int levelEvdoDbm = evdoDbm >= -65 ? 4 : (evdoDbm >= -75 ? 3 : (evdoDbm >= -90 ? 2 : (evdoDbm >= -105 ? 1 : 0)));
        int levelEvdoSnr = evdoSnr >= 7 ? 4 : (evdoSnr >= 5 ? 3 : (evdoSnr >= 3 ? 2 : (evdoSnr >= 1 ? 1 : 0)));
        int level = levelEvdoDbm < levelEvdoSnr ? levelEvdoDbm : levelEvdoSnr;
        return level;
    }

    @Override
    public int getDbm() {
        int evdoDbm;
        int cdmaDbm = this.getCdmaDbm();
        return cdmaDbm < (evdoDbm = this.getEvdoDbm()) ? cdmaDbm : evdoDbm;
    }

    public int getCdmaDbm() {
        return this.mCdmaDbm;
    }

    public void setCdmaDbm(int cdmaDbm) {
        this.mCdmaDbm = cdmaDbm;
    }

    public int getCdmaEcio() {
        return this.mCdmaEcio;
    }

    public void setCdmaEcio(int cdmaEcio) {
        this.mCdmaEcio = cdmaEcio;
    }

    public int getEvdoDbm() {
        return this.mEvdoDbm;
    }

    public void setEvdoDbm(int evdoDbm) {
        this.mEvdoDbm = evdoDbm;
    }

    public int getEvdoEcio() {
        return this.mEvdoEcio;
    }

    public void setEvdoEcio(int evdoEcio) {
        this.mEvdoEcio = evdoEcio;
    }

    public int getEvdoSnr() {
        return this.mEvdoSnr;
    }

    public void setEvdoSnr(int evdoSnr) {
        this.mEvdoSnr = evdoSnr;
    }

    @Override
    public int hashCode() {
        int primeNum = 31;
        return this.mCdmaDbm * primeNum + this.mCdmaEcio * primeNum + this.mEvdoDbm * primeNum + this.mEvdoEcio * primeNum + this.mEvdoSnr * primeNum;
    }

    @Override
    public boolean equals(Object o) {
        CellSignalStrengthCdma s;
        try {
            s = (CellSignalStrengthCdma)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this.mCdmaDbm == s.mCdmaDbm && this.mCdmaEcio == s.mCdmaEcio && this.mEvdoDbm == s.mEvdoDbm && this.mEvdoEcio == s.mEvdoEcio && this.mEvdoSnr == s.mEvdoSnr;
    }

    public String toString() {
        return "CellSignalStrengthCdma: cdmaDbm=" + this.mCdmaDbm + " cdmaEcio=" + this.mCdmaEcio + " evdoDbm=" + this.mEvdoDbm + " evdoEcio=" + this.mEvdoEcio + " evdoSnr=" + this.mEvdoSnr;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mCdmaDbm * -1);
        dest.writeInt(this.mCdmaEcio * -1);
        dest.writeInt(this.mEvdoDbm * -1);
        dest.writeInt(this.mEvdoEcio * -1);
        dest.writeInt(this.mEvdoSnr);
    }

    private CellSignalStrengthCdma(Parcel in) {
        this.mCdmaDbm = in.readInt() * -1;
        this.mCdmaEcio = in.readInt() * -1;
        this.mEvdoDbm = in.readInt() * -1;
        this.mEvdoEcio = in.readInt() * -1;
        this.mEvdoSnr = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static void log(String s) {
        Rlog.w(LOG_TAG, s);
    }
}

