/*
 * Decompiled with CFR 0.152.
 */
package android.service.persistentdata;

import android.os.RemoteException;
import android.service.persistentdata.IPersistentDataBlockService;
import android.util.Slog;

public class PersistentDataBlockManager {
    private static final String TAG = PersistentDataBlockManager.class.getSimpleName();
    private IPersistentDataBlockService sService;

    public PersistentDataBlockManager(IPersistentDataBlockService service) {
        this.sService = service;
    }

    public int write(byte[] data) {
        try {
            return this.sService.write(data);
        }
        catch (RemoteException e) {
            this.onError("writing data");
            return -1;
        }
    }

    public byte[] read() {
        try {
            return this.sService.read();
        }
        catch (RemoteException e) {
            this.onError("reading data");
            return null;
        }
    }

    public int getDataBlockSize() {
        try {
            return this.sService.getDataBlockSize();
        }
        catch (RemoteException e) {
            this.onError("getting data block size");
            return -1;
        }
    }

    public long getMaximumDataBlockSize() {
        try {
            return this.sService.getMaximumDataBlockSize();
        }
        catch (RemoteException e) {
            this.onError("getting maximum data block size");
            return -1L;
        }
    }

    public void wipe() {
        try {
            this.sService.wipe();
        }
        catch (RemoteException e) {
            this.onError("wiping persistent partition");
        }
    }

    public void setOemUnlockEnabled(boolean enabled) {
        try {
            this.sService.setOemUnlockEnabled(enabled);
        }
        catch (RemoteException e) {
            this.onError("setting OEM unlock enabled to " + enabled);
        }
    }

    public boolean getOemUnlockEnabled() {
        try {
            return this.sService.getOemUnlockEnabled();
        }
        catch (RemoteException e) {
            this.onError("getting OEM unlock enabled bit");
            return false;
        }
    }

    private void onError(String msg) {
        Slog.v(TAG, "Remote exception while " + msg);
    }
}

