/*
 * Decompiled with CFR 0.152.
 */
package android.service.fingerprint;

import android.content.ContentResolver;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import java.util.Arrays;

public class FingerprintUtils {
    private static final boolean DEBUG = true;
    private static final String TAG = "FingerprintUtils";

    public static int[] getFingerprintIdsForUser(ContentResolver res, int userId) {
        String fingerIdsRaw = Settings.Secure.getStringForUser(res, "user_fingerprint_ids", userId);
        int[] result = new int[]{};
        if (!TextUtils.isEmpty(fingerIdsRaw)) {
            String[] fingerStringIds = fingerIdsRaw.replace("[", "").replace("]", "").split(", ");
            result = new int[fingerStringIds.length];
            for (int i = 0; i < result.length; ++i) {
                try {
                    result[i] = Integer.decode(fingerStringIds[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    Log.d(TAG, "Error when parsing finger id " + fingerStringIds[i]);
                }
            }
        }
        return result;
    }

    public static void addFingerprintIdForUser(int fingerId, ContentResolver res, int userId) {
        int[] fingerIds = FingerprintUtils.getFingerprintIdsForUser(res, userId);
        if (fingerId == 0) {
            return;
        }
        for (int i = 0; i < fingerIds.length; ++i) {
            if (fingerIds[i] != fingerId) continue;
            return;
        }
        int[] newList = Arrays.copyOf(fingerIds, fingerIds.length + 1);
        newList[fingerIds.length] = fingerId;
        Settings.Secure.putStringForUser(res, "user_fingerprint_ids", Arrays.toString(newList), userId);
    }

    public static boolean removeFingerprintIdForUser(int fingerId, ContentResolver res, int userId) {
        if (fingerId == 0) {
            throw new IllegalStateException("Bad fingerId");
        }
        int[] fingerIds = FingerprintUtils.getFingerprintIdsForUser(res, userId);
        int[] resultIds = Arrays.copyOf(fingerIds, fingerIds.length);
        int resultCount = 0;
        for (int i = 0; i < fingerIds.length; ++i) {
            if (fingerId == fingerIds[i]) continue;
            resultIds[resultCount++] = fingerIds[i];
        }
        if (resultCount > 0) {
            Settings.Secure.putStringForUser(res, "user_fingerprint_ids", Arrays.toString(Arrays.copyOf(resultIds, resultCount)), userId);
            return true;
        }
        return false;
    }
}

