/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.util.SparseArray;
import java.io.PrintWriter;

public class UserHandle
implements Parcelable {
    public static final int PER_USER_RANGE = 100000;
    public static final int USER_ALL = -1;
    public static final UserHandle ALL = new UserHandle(-1);
    public static final int USER_CURRENT = -2;
    public static final UserHandle CURRENT = new UserHandle(-2);
    public static final int USER_CURRENT_OR_SELF = -3;
    public static final UserHandle CURRENT_OR_SELF = new UserHandle(-3);
    public static final int USER_NULL = -10000;
    public static final int USER_OWNER = 0;
    public static final UserHandle OWNER = new UserHandle(0);
    public static final boolean MU_ENABLED = true;
    final int mHandle;
    private static final SparseArray<UserHandle> userHandles = new SparseArray();
    public static final Parcelable.Creator<UserHandle> CREATOR = new Parcelable.Creator<UserHandle>(){

        @Override
        public UserHandle createFromParcel(Parcel in) {
            return new UserHandle(in);
        }

        public UserHandle[] newArray(int size) {
            return new UserHandle[size];
        }
    };

    public static boolean isSameUser(int uid1, int uid2) {
        return UserHandle.getUserId(uid1) == UserHandle.getUserId(uid2);
    }

    public static boolean isSameApp(int uid1, int uid2) {
        return UserHandle.getAppId(uid1) == UserHandle.getAppId(uid2);
    }

    public static boolean isIsolated(int uid) {
        if (uid > 0) {
            int appId = UserHandle.getAppId(uid);
            return appId >= 99000 && appId <= 99999;
        }
        return false;
    }

    public static boolean isApp(int uid) {
        if (uid > 0) {
            int appId = UserHandle.getAppId(uid);
            return appId >= 10000 && appId <= 19999;
        }
        return false;
    }

    public static int getUserId(int uid) {
        return uid / 100000;
    }

    public static int getCallingUserId() {
        return UserHandle.getUserId(Binder.getCallingUid());
    }

    public static UserHandle getCallingUserHandle() {
        int userId = UserHandle.getUserId(Binder.getCallingUid());
        UserHandle userHandle = userHandles.get(userId);
        if (userHandle == null) {
            userHandle = new UserHandle(userId);
            userHandles.put(userId, userHandle);
        }
        return userHandle;
    }

    public static int getUid(int userId, int appId) {
        return userId * 100000 + appId % 100000;
    }

    public static int getAppId(int uid) {
        return uid % 100000;
    }

    public static int getUserGid(int userId) {
        return UserHandle.getUid(userId, 9997);
    }

    public static int getSharedAppGid(int id2) {
        return 50000 + id2 % 100000 - 10000;
    }

    public static void formatUid(StringBuilder sb, int uid) {
        if (uid < 10000) {
            sb.append(uid);
        } else {
            sb.append('u');
            sb.append(UserHandle.getUserId(uid));
            int appId = UserHandle.getAppId(uid);
            if (appId >= 99000 && appId <= 99999) {
                sb.append('i');
                sb.append(appId - 99000);
            } else if (appId >= 10000) {
                sb.append('a');
                sb.append(appId - 10000);
            } else {
                sb.append('s');
                sb.append(appId);
            }
        }
    }

    public static void formatUid(PrintWriter pw, int uid) {
        if (uid < 10000) {
            pw.print(uid);
        } else {
            pw.print('u');
            pw.print(UserHandle.getUserId(uid));
            int appId = UserHandle.getAppId(uid);
            if (appId >= 99000 && appId <= 99999) {
                pw.print('i');
                pw.print(appId - 99000);
            } else if (appId >= 10000) {
                pw.print('a');
                pw.print(appId - 10000);
            } else {
                pw.print('s');
                pw.print(appId);
            }
        }
    }

    public static int myUserId() {
        return UserHandle.getUserId(Process.myUid());
    }

    public boolean isOwner() {
        return this.equals(OWNER);
    }

    public UserHandle(int h) {
        this.mHandle = h;
    }

    public int getIdentifier() {
        return this.mHandle;
    }

    public String toString() {
        return "UserHandle{" + this.mHandle + "}";
    }

    public boolean equals(Object obj) {
        try {
            if (obj != null) {
                UserHandle other = (UserHandle)obj;
                return this.mHandle == other.mHandle;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        return this.mHandle;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mHandle);
    }

    public static void writeToParcel(UserHandle h, Parcel out) {
        if (h != null) {
            h.writeToParcel(out, 0);
        } else {
            out.writeInt(-10000);
        }
    }

    public static UserHandle readFromParcel(Parcel in) {
        int h = in.readInt();
        return h != -10000 ? new UserHandle(h) : null;
    }

    public UserHandle(Parcel in) {
        this.mHandle = in.readInt();
    }
}

