/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.util.Slog;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;

public class SELinux {
    private static final String TAG = "SELinux";
    private static final int SELINUX_ANDROID_RESTORECON_NOCHANGE = 1;
    private static final int SELINUX_ANDROID_RESTORECON_VERBOSE = 2;
    private static final int SELINUX_ANDROID_RESTORECON_RECURSE = 4;
    private static final int SELINUX_ANDROID_RESTORECON_FORCE = 8;
    private static final int SELINUX_ANDROID_RESTORECON_DATADATA = 16;

    public static boolean isSELinuxEnabled() {
        return OverrideMethod.invokeI("android.os.SELinux#isSELinuxEnabled()Z", true, null) != 0;
    }

    public static boolean isSELinuxEnforced() {
        return OverrideMethod.invokeI("android.os.SELinux#isSELinuxEnforced()Z", true, null) != 0;
    }

    public static boolean setSELinuxEnforce(boolean bl) {
        return OverrideMethod.invokeI("android.os.SELinux#setSELinuxEnforce(Z)Z", true, null) != 0;
    }

    public static boolean setFSCreateContext(String string2) {
        return OverrideMethod.invokeI("android.os.SELinux#setFSCreateContext(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static boolean setFileContext(String string2, String string3) {
        return OverrideMethod.invokeI("android.os.SELinux#setFileContext(Ljava/lang/String;Ljava/lang/String;)Z", true, null) != 0;
    }

    public static String getFileContext(String string2) {
        return (String)OverrideMethod.invokeA("android.os.SELinux#getFileContext(Ljava/lang/String;)Ljava/lang/String;", true, null);
    }

    public static String getPeerContext(FileDescriptor fileDescriptor) {
        return (String)OverrideMethod.invokeA("android.os.SELinux#getPeerContext(Ljava/io/FileDescriptor;)Ljava/lang/String;", true, null);
    }

    public static String getContext() {
        return (String)OverrideMethod.invokeA("android.os.SELinux#getContext()Ljava/lang/String;", true, null);
    }

    public static String getPidContext(int n) {
        return (String)OverrideMethod.invokeA("android.os.SELinux#getPidContext(I)Ljava/lang/String;", true, null);
    }

    public static String[] getBooleanNames() {
        return (String[])OverrideMethod.invokeA("android.os.SELinux#getBooleanNames()[Ljava/lang/String;", true, null);
    }

    public static boolean getBooleanValue(String string2) {
        return OverrideMethod.invokeI("android.os.SELinux#getBooleanValue(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static boolean setBooleanValue(String string2, boolean bl) {
        return OverrideMethod.invokeI("android.os.SELinux#setBooleanValue(Ljava/lang/String;Z)Z", true, null) != 0;
    }

    public static boolean checkSELinuxAccess(String string2, String string3, String string4, String string5) {
        return OverrideMethod.invokeI("android.os.SELinux#checkSELinuxAccess(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", true, null) != 0;
    }

    public static boolean restorecon(String pathname) throws NullPointerException {
        if (pathname == null) {
            throw new NullPointerException();
        }
        return SELinux.native_restorecon(pathname, 0);
    }

    private static boolean native_restorecon(String string2, int n) {
        return OverrideMethod.invokeI("android.os.SELinux#native_restorecon(Ljava/lang/String;I)Z", true, null) != 0;
    }

    public static boolean restorecon(File file) throws NullPointerException {
        try {
            return SELinux.native_restorecon(file.getCanonicalPath(), 0);
        }
        catch (IOException e) {
            Slog.e(TAG, "Error getting canonical path. Restorecon failed for " + file.getPath(), e);
            return false;
        }
    }

    public static boolean restoreconRecursive(File file) {
        try {
            return SELinux.native_restorecon(file.getCanonicalPath(), 4);
        }
        catch (IOException e) {
            Slog.e(TAG, "Error getting canonical path. Restorecon failed for " + file.getPath(), e);
            return false;
        }
    }
}

