/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.ConditionVariable;
import android.os.FileUtils;
import android.os.PowerManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.pkcs7.ContentInfo;
import org.apache.harmony.security.pkcs7.SignedData;
import org.apache.harmony.security.pkcs7.SignerInfo;
import org.apache.harmony.security.x509.Certificate;

public class RecoverySystem {
    private static final String TAG = "RecoverySystem";
    private static final File DEFAULT_KEYSTORE = new File("/system/etc/security/otacerts.zip");
    private static final long PUBLISH_PROGRESS_INTERVAL_MS = 500L;
    private static File RECOVERY_DIR = new File("/cache/recovery");
    private static File COMMAND_FILE = new File(RECOVERY_DIR, "command");
    private static File LOG_FILE = new File(RECOVERY_DIR, "log");
    private static String LAST_PREFIX = "last_";
    private static int LOG_FILE_MAX_LENGTH = 65536;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashSet<X509Certificate> getTrustedCerts(File keystore) throws IOException, GeneralSecurityException {
        HashSet<X509Certificate> trusted = new HashSet<X509Certificate>();
        if (keystore == null) {
            keystore = DEFAULT_KEYSTORE;
        }
        ZipFile zip = new ZipFile(keystore);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream is = zip.getInputStream(entry);
                try {
                    trusted.add((X509Certificate)cf.generateCertificate(is));
                }
                finally {
                    is.close();
                }
            }
        }
        finally {
            zip.close();
        }
        return trusted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyPackage(File packageFile, ProgressListener listener, File deviceCertsZipFile) throws IOException, GeneralSecurityException {
        long fileLen = packageFile.length();
        RandomAccessFile raf = new RandomAccessFile(packageFile, "r");
        try {
            int read;
            int lastPercent = 0;
            long lastPublishTime = System.currentTimeMillis();
            if (listener != null) {
                listener.onProgress(lastPercent);
            }
            raf.seek(fileLen - 6L);
            byte[] footer = new byte[6];
            raf.readFully(footer);
            if (footer[2] != -1 || footer[3] != -1) {
                throw new SignatureException("no signature in file (no footer)");
            }
            int commentSize = footer[4] & 0xFF | (footer[5] & 0xFF) << 8;
            int signatureStart = footer[0] & 0xFF | (footer[1] & 0xFF) << 8;
            byte[] eocd = new byte[commentSize + 22];
            raf.seek(fileLen - (long)(commentSize + 22));
            raf.readFully(eocd);
            if (eocd[0] != 80 || eocd[1] != 75 || eocd[2] != 5 || eocd[3] != 6) {
                throw new SignatureException("no signature in file (bad footer)");
            }
            for (int i = 4; i < eocd.length - 3; ++i) {
                if (eocd[i] != 80 || eocd[i + 1] != 75 || eocd[i + 2] != 5 || eocd[i + 3] != 6) continue;
                throw new SignatureException("EOCD marker found after start of EOCD");
            }
            BerInputStream bis = new BerInputStream(new ByteArrayInputStream(eocd, commentSize + 22 - signatureStart, signatureStart));
            ContentInfo info = (ContentInfo)ContentInfo.ASN1.decode(bis);
            SignedData signedData = info.getSignedData();
            if (signedData == null) {
                throw new IOException("signedData is null");
            }
            List<Certificate> encCerts = signedData.getCertificates();
            if (encCerts.isEmpty()) {
                throw new IOException("encCerts is empty");
            }
            Iterator<Certificate> it = encCerts.iterator();
            X509Certificate cert = null;
            if (!it.hasNext()) {
                throw new SignatureException("signature contains no certificates");
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream is = new ByteArrayInputStream(it.next().getEncoded());
            cert = (X509Certificate)cf.generateCertificate(is);
            List<SignerInfo> sigInfos = signedData.getSignerInfos();
            if (sigInfos.isEmpty()) {
                throw new IOException("no signer infos!");
            }
            SignerInfo sigInfo = sigInfos.get(0);
            HashSet<X509Certificate> trusted = RecoverySystem.getTrustedCerts(deviceCertsZipFile == null ? DEFAULT_KEYSTORE : deviceCertsZipFile);
            PublicKey signatureKey = cert.getPublicKey();
            boolean verified = false;
            for (X509Certificate c : trusted) {
                if (!c.getPublicKey().equals(signatureKey)) continue;
                verified = true;
                break;
            }
            if (!verified) {
                throw new SignatureException("signature doesn't match any trusted key");
            }
            String da = sigInfo.getDigestAlgorithm();
            String dea = sigInfo.getDigestEncryptionAlgorithm();
            String alg = null;
            alg = da == null || dea == null ? cert.getSigAlgName() : da + "with" + dea;
            Signature sig = Signature.getInstance(alg);
            sig.initVerify(cert);
            long toRead = fileLen - (long)commentSize - 2L;
            raf.seek(0L);
            byte[] buffer = new byte[4096];
            boolean interrupted = false;
            for (long soFar = 0L; soFar < toRead && !(interrupted = Thread.interrupted()); soFar += (long)read) {
                int size = buffer.length;
                if (soFar + (long)size > toRead) {
                    size = (int)(toRead - soFar);
                }
                read = raf.read(buffer, 0, size);
                sig.update(buffer, 0, read);
                if (listener == null) continue;
                long now = System.currentTimeMillis();
                int p = (int)(soFar * 100L / toRead);
                if (p <= lastPercent || now - lastPublishTime <= 500L) continue;
                lastPercent = p;
                lastPublishTime = now;
                listener.onProgress(lastPercent);
            }
            if (listener != null) {
                listener.onProgress(100);
            }
            if (interrupted) {
                throw new SignatureException("verification was interrupted");
            }
            if (!sig.verify(sigInfo.getEncryptedDigest())) {
                throw new SignatureException("signature digest verification failed");
            }
        }
        finally {
            raf.close();
        }
    }

    public static void installPackage(Context context, File packageFile) throws IOException {
        String filename = packageFile.getCanonicalPath();
        Log.w(TAG, "!!! REBOOTING TO INSTALL " + filename + " !!!");
        String filenameArg = "--update_package=" + filename;
        String localeArg = "--locale=" + Locale.getDefault().toString();
        RecoverySystem.bootCommand(context, filenameArg, localeArg);
    }

    public static void rebootWipeUserData(Context context) throws IOException {
        RecoverySystem.rebootWipeUserData(context, false, context.getPackageName());
    }

    public static void rebootWipeUserData(Context context, String reason) throws IOException {
        RecoverySystem.rebootWipeUserData(context, false, reason);
    }

    public static void rebootWipeUserData(Context context, boolean shutdown) throws IOException {
        RecoverySystem.rebootWipeUserData(context, shutdown, context.getPackageName());
    }

    public static void rebootWipeUserData(Context context, boolean shutdown, String reason) throws IOException {
        UserManager um = (UserManager)context.getSystemService("user");
        if (um.hasUserRestriction("no_factory_reset")) {
            throw new SecurityException("Wiping data is not allowed for this user.");
        }
        final ConditionVariable condition = new ConditionVariable();
        Intent intent = new Intent("android.intent.action.MASTER_CLEAR_NOTIFICATION");
        intent.addFlags(0x10000000);
        context.sendOrderedBroadcastAsUser(intent, UserHandle.OWNER, "android.permission.MASTER_CLEAR", new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                condition.open();
            }
        }, null, 0, null, null);
        condition.block();
        String shutdownArg = null;
        if (shutdown) {
            shutdownArg = "--shutdown_after";
        }
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason);
        }
        String localeArg = "--locale=" + Locale.getDefault().toString();
        RecoverySystem.bootCommand(context, shutdownArg, "--wipe_data", reasonArg, localeArg);
    }

    public static void rebootWipeCache(Context context) throws IOException {
        RecoverySystem.rebootWipeCache(context, context.getPackageName());
    }

    public static void rebootWipeCache(Context context, String reason) throws IOException {
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason);
        }
        String localeArg = "--locale=" + Locale.getDefault().toString();
        RecoverySystem.bootCommand(context, "--wipe_cache", reasonArg, localeArg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bootCommand(Context context, String ... args) throws IOException {
        RECOVERY_DIR.mkdirs();
        COMMAND_FILE.delete();
        LOG_FILE.delete();
        FileWriter command = new FileWriter(COMMAND_FILE);
        try {
            for (String arg : args) {
                if (TextUtils.isEmpty(arg)) continue;
                command.write(arg);
                command.write("\n");
            }
        }
        finally {
            command.close();
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        pm.reboot("recovery");
        throw new IOException("Reboot failed (no permissions?)");
    }

    public static String handleAftermath() {
        String log = null;
        try {
            log = FileUtils.readTextFile(LOG_FILE, -LOG_FILE_MAX_LENGTH, "...\n");
        }
        catch (FileNotFoundException e) {
            Log.i(TAG, "No recovery log file");
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading recovery log", e);
        }
        String[] names = RECOVERY_DIR.list();
        for (int i = 0; names != null && i < names.length; ++i) {
            if (names[i].startsWith(LAST_PREFIX)) continue;
            File f = new File(RECOVERY_DIR, names[i]);
            if (!f.delete()) {
                Log.e(TAG, "Can't delete: " + f);
                continue;
            }
            Log.i(TAG, "Deleted: " + f);
        }
        return log;
    }

    private static String sanitizeArg(String arg) {
        arg = arg.replace('\u0000', '?');
        arg = arg.replace('\n', '?');
        return arg;
    }

    private void RecoverySystem() {
    }

    public static interface ProgressListener {
        public void onProgress(int var1);
    }
}

