/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.lang.ref.WeakReference;

class BinderProxy
implements IBinder {
    private final WeakReference mSelf = new WeakReference<BinderProxy>(this);
    private long mObject;
    private long mOrgue;

    @Override
    public boolean pingBinder() {
        return OverrideMethod.invokeI("android.os.BinderProxy#pingBinder()Z", true, this) != 0;
    }

    @Override
    public boolean isBinderAlive() {
        return OverrideMethod.invokeI("android.os.BinderProxy#isBinderAlive()Z", true, this) != 0;
    }

    @Override
    public IInterface queryLocalInterface(String descriptor) {
        return null;
    }

    @Override
    public boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        Binder.checkParcel(this, code, data, "Unreasonably large binder buffer");
        return this.transactNative(code, data, reply, flags);
    }

    @Override
    public String getInterfaceDescriptor() throws RemoteException {
        return (String)OverrideMethod.invokeA("android.os.BinderProxy#getInterfaceDescriptor()Ljava/lang/String;", true, this);
    }

    public boolean transactNative(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        return OverrideMethod.invokeI("android.os.BinderProxy#transactNative(ILandroid/os/Parcel;Landroid/os/Parcel;I)Z", true, this) != 0;
    }

    @Override
    public void linkToDeath(IBinder.DeathRecipient deathRecipient, int n) throws RemoteException {
        OverrideMethod.invokeV("android.os.BinderProxy#linkToDeath(Landroid/os/IBinder$DeathRecipient;I)V", true, this);
    }

    @Override
    public boolean unlinkToDeath(IBinder.DeathRecipient deathRecipient, int n) {
        return OverrideMethod.invokeI("android.os.BinderProxy#unlinkToDeath(Landroid/os/IBinder$DeathRecipient;I)Z", true, this) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, String[] args) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeFileDescriptor(fd);
        data.writeStringArray(args);
        try {
            this.transact(1598311760, data, reply, 0);
            reply.readException();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpAsync(FileDescriptor fd, String[] args) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeFileDescriptor(fd);
        data.writeStringArray(args);
        try {
            this.transact(1598311760, data, reply, 1);
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    BinderProxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    private void destroy() {
        OverrideMethod.invokeV("android.os.BinderProxy#destroy()V", true, this);
    }

    private static void sendDeathNotice(IBinder.DeathRecipient recipient) {
        try {
            recipient.binderDied();
        }
        catch (RuntimeException exc) {
            Log.w("BinderNative", "Uncaught exception from death notification", exc);
        }
    }
}

