/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.android.org.bouncycastle.asn1.x509.X509Name;
import com.android.tools.layoutlib.java.IntegralToString;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class SslCertificate {
    private static String ISO_8601_DATE_FORMAT = "yyyy-MM-dd HH:mm:ssZ";
    private final DName mIssuedTo;
    private final DName mIssuedBy;
    private final Date mValidNotBefore;
    private final Date mValidNotAfter;
    private final X509Certificate mX509Certificate;
    private static final String ISSUED_TO = "issued-to";
    private static final String ISSUED_BY = "issued-by";
    private static final String VALID_NOT_BEFORE = "valid-not-before";
    private static final String VALID_NOT_AFTER = "valid-not-after";
    private static final String X509_CERTIFICATE = "x509-certificate";

    public static Bundle saveState(SslCertificate certificate) {
        if (certificate == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putString(ISSUED_TO, certificate.getIssuedTo().getDName());
        bundle.putString(ISSUED_BY, certificate.getIssuedBy().getDName());
        bundle.putString(VALID_NOT_BEFORE, certificate.getValidNotBefore());
        bundle.putString(VALID_NOT_AFTER, certificate.getValidNotAfter());
        X509Certificate x509Certificate = certificate.mX509Certificate;
        if (x509Certificate != null) {
            try {
                bundle.putByteArray(X509_CERTIFICATE, x509Certificate.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
        return bundle;
    }

    public static SslCertificate restoreState(Bundle bundle) {
        X509Certificate x509Certificate;
        if (bundle == null) {
            return null;
        }
        byte[] bytes = bundle.getByteArray(X509_CERTIFICATE);
        if (bytes == null) {
            x509Certificate = null;
        } else {
            try {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                Certificate cert = certFactory.generateCertificate(new ByteArrayInputStream(bytes));
                x509Certificate = (X509Certificate)cert;
            }
            catch (CertificateException e) {
                x509Certificate = null;
            }
        }
        return new SslCertificate(bundle.getString(ISSUED_TO), bundle.getString(ISSUED_BY), SslCertificate.parseDate(bundle.getString(VALID_NOT_BEFORE)), SslCertificate.parseDate(bundle.getString(VALID_NOT_AFTER)), x509Certificate);
    }

    @Deprecated
    public SslCertificate(String issuedTo, String issuedBy, String validNotBefore, String validNotAfter) {
        this(issuedTo, issuedBy, SslCertificate.parseDate(validNotBefore), SslCertificate.parseDate(validNotAfter), null);
    }

    @Deprecated
    public SslCertificate(String issuedTo, String issuedBy, Date validNotBefore, Date validNotAfter) {
        this(issuedTo, issuedBy, validNotBefore, validNotAfter, null);
    }

    public SslCertificate(X509Certificate certificate) {
        this(certificate.getSubjectDN().getName(), certificate.getIssuerDN().getName(), certificate.getNotBefore(), certificate.getNotAfter(), certificate);
    }

    private SslCertificate(String issuedTo, String issuedBy, Date validNotBefore, Date validNotAfter, X509Certificate x509Certificate) {
        this.mIssuedTo = new DName(issuedTo);
        this.mIssuedBy = new DName(issuedBy);
        this.mValidNotBefore = SslCertificate.cloneDate(validNotBefore);
        this.mValidNotAfter = SslCertificate.cloneDate(validNotAfter);
        this.mX509Certificate = x509Certificate;
    }

    public Date getValidNotBeforeDate() {
        return SslCertificate.cloneDate(this.mValidNotBefore);
    }

    @Deprecated
    public String getValidNotBefore() {
        return SslCertificate.formatDate(this.mValidNotBefore);
    }

    public Date getValidNotAfterDate() {
        return SslCertificate.cloneDate(this.mValidNotAfter);
    }

    @Deprecated
    public String getValidNotAfter() {
        return SslCertificate.formatDate(this.mValidNotAfter);
    }

    public DName getIssuedTo() {
        return this.mIssuedTo;
    }

    public DName getIssuedBy() {
        return this.mIssuedBy;
    }

    private static String getSerialNumber(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "";
        }
        BigInteger serialNumber = x509Certificate.getSerialNumber();
        if (serialNumber == null) {
            return "";
        }
        return SslCertificate.fingerprint(serialNumber.toByteArray());
    }

    private static String getDigest(X509Certificate x509Certificate, String algorithm) {
        if (x509Certificate == null) {
            return "";
        }
        try {
            byte[] bytes = x509Certificate.getEncoded();
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] digest = md.digest(bytes);
            return SslCertificate.fingerprint(digest);
        }
        catch (CertificateEncodingException ignored) {
            return "";
        }
        catch (NoSuchAlgorithmException ignored) {
            return "";
        }
    }

    private static String fingerprint(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            IntegralToString.appendByteAsHex(sb, b, true);
            if (i + 1 == bytes.length) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    public String toString() {
        return "Issued to: " + this.mIssuedTo.getDName() + ";\n" + "Issued by: " + this.mIssuedBy.getDName() + ";\n";
    }

    private static Date parseDate(String string2) {
        try {
            return new SimpleDateFormat(ISO_8601_DATE_FORMAT).parse(string2);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(ISO_8601_DATE_FORMAT).format(date);
    }

    private static Date cloneDate(Date date) {
        if (date == null) {
            return null;
        }
        return (Date)date.clone();
    }

    public View inflateCertificateView(Context context) {
        LayoutInflater factory = LayoutInflater.from(context);
        View certificateView = factory.inflate(17367246, null);
        DName issuedTo = this.getIssuedTo();
        if (issuedTo != null) {
            ((TextView)certificateView.findViewById(16909202)).setText(issuedTo.getCName());
            ((TextView)certificateView.findViewById(16909204)).setText(issuedTo.getOName());
            ((TextView)certificateView.findViewById(16909206)).setText(issuedTo.getUName());
        }
        ((TextView)certificateView.findViewById(16909208)).setText(SslCertificate.getSerialNumber(this.mX509Certificate));
        DName issuedBy = this.getIssuedBy();
        if (issuedBy != null) {
            ((TextView)certificateView.findViewById(16909210)).setText(issuedBy.getCName());
            ((TextView)certificateView.findViewById(16909212)).setText(issuedBy.getOName());
            ((TextView)certificateView.findViewById(16909214)).setText(issuedBy.getUName());
        }
        String issuedOn = this.formatCertificateDate(context, this.getValidNotBeforeDate());
        ((TextView)certificateView.findViewById(16909217)).setText(issuedOn);
        String expiresOn = this.formatCertificateDate(context, this.getValidNotAfterDate());
        ((TextView)certificateView.findViewById(16909219)).setText(expiresOn);
        ((TextView)certificateView.findViewById(16909222)).setText(SslCertificate.getDigest(this.mX509Certificate, "SHA256"));
        ((TextView)certificateView.findViewById(16909224)).setText(SslCertificate.getDigest(this.mX509Certificate, "SHA1"));
        return certificateView;
    }

    private String formatCertificateDate(Context context, Date certificateDate) {
        if (certificateDate == null) {
            return "";
        }
        return DateFormat.getDateFormat(context).format(certificateDate);
    }

    public class DName {
        private String mDName;
        private String mCName;
        private String mOName;
        private String mUName;

        public DName(String dName) {
            if (dName != null) {
                this.mDName = dName;
                try {
                    X509Name x509Name = new X509Name(dName);
                    Vector val = x509Name.getValues();
                    Vector oid = x509Name.getOIDs();
                    for (int i = 0; i < oid.size(); ++i) {
                        if (oid.elementAt(i).equals(X509Name.CN)) {
                            if (this.mCName != null) continue;
                            this.mCName = (String)val.elementAt(i);
                            continue;
                        }
                        if (oid.elementAt(i).equals(X509Name.O) && this.mOName == null) {
                            this.mOName = (String)val.elementAt(i);
                            continue;
                        }
                        if (!oid.elementAt(i).equals(X509Name.OU) || this.mUName != null) continue;
                        this.mUName = (String)val.elementAt(i);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public String getDName() {
            return this.mDName != null ? this.mDName : "";
        }

        public String getCName() {
            return this.mCName != null ? this.mCName : "";
        }

        public String getOName() {
            return this.mOName != null ? this.mOName : "";
        }

        public String getUName() {
            return this.mUName != null ? this.mUName : "";
        }
    }
}

