/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.text.TextUtils;
import com.android.tools.layoutlib.java.Objects;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TvContentRating {
    private static final String DELIMITER = "/";
    private final String mDomain;
    private final String mRatingSystem;
    private final String mRating;
    private final String[] mSubRatings;
    private final int mHashCode;

    public static TvContentRating createRating(String domain, String ratingSystem, String rating, String ... subRatings) {
        if (TextUtils.isEmpty(domain)) {
            throw new IllegalArgumentException("domain cannot be empty");
        }
        if (TextUtils.isEmpty(ratingSystem)) {
            throw new IllegalArgumentException("ratingSystem cannot be empty");
        }
        if (TextUtils.isEmpty(rating)) {
            throw new IllegalArgumentException("rating cannot be empty");
        }
        return new TvContentRating(domain, ratingSystem, rating, subRatings);
    }

    public static TvContentRating unflattenFromString(String ratingString) {
        if (TextUtils.isEmpty(ratingString)) {
            throw new IllegalArgumentException("ratingString cannot be empty");
        }
        String[] strs = ratingString.split(DELIMITER);
        if (strs.length < 3) {
            throw new IllegalArgumentException("Invalid rating string: " + ratingString);
        }
        if (strs.length > 3) {
            String[] subRatings = new String[strs.length - 3];
            System.arraycopy(strs, 3, subRatings, 0, subRatings.length);
            return new TvContentRating(strs[0], strs[1], strs[2], subRatings);
        }
        return new TvContentRating(strs[0], strs[1], strs[2], null);
    }

    private TvContentRating(String domain, String ratingSystem, String rating, String[] subRatings) {
        this.mDomain = domain;
        this.mRatingSystem = ratingSystem;
        this.mRating = rating;
        if (subRatings == null || subRatings.length == 0) {
            this.mSubRatings = null;
        } else {
            Arrays.sort(subRatings);
            this.mSubRatings = subRatings;
        }
        this.mHashCode = 31 * Objects.hash(this.mDomain, this.mRating) + Arrays.hashCode(this.mSubRatings);
    }

    public String getDomain() {
        return this.mDomain;
    }

    public String getRatingSystem() {
        return this.mRatingSystem;
    }

    public String getMainRating() {
        return this.mRating;
    }

    public List<String> getSubRatings() {
        if (this.mSubRatings == null) {
            return null;
        }
        return Collections.unmodifiableList(Arrays.asList(this.mSubRatings));
    }

    public String flattenToString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.mDomain);
        builder.append(DELIMITER);
        builder.append(this.mRatingSystem);
        builder.append(DELIMITER);
        builder.append(this.mRating);
        if (this.mSubRatings != null) {
            for (String subRating : this.mSubRatings) {
                builder.append(DELIMITER);
                builder.append(subRating);
            }
        }
        return builder.toString();
    }

    public boolean contains(TvContentRating rating) {
        if (rating == null) {
            throw new IllegalArgumentException("rating cannot be null");
        }
        if (!rating.getMainRating().equals(this.mRating)) {
            return false;
        }
        if (!(rating.getDomain().equals(this.mDomain) && rating.getRatingSystem().equals(this.mRatingSystem) && rating.getMainRating().equals(this.mRating))) {
            return false;
        }
        List<String> subRatings = this.getSubRatings();
        List<String> subRatingsOther = rating.getSubRatings();
        if (subRatings == null && subRatingsOther == null) {
            return true;
        }
        if (subRatings == null && subRatingsOther != null) {
            return false;
        }
        if (subRatings != null && subRatingsOther == null) {
            return true;
        }
        return subRatings.containsAll(subRatingsOther);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TvContentRating)) {
            return false;
        }
        TvContentRating other = (TvContentRating)obj;
        if (this.mHashCode != other.mHashCode) {
            return false;
        }
        if (!TextUtils.equals(this.mDomain, other.mDomain)) {
            return false;
        }
        if (!TextUtils.equals(this.mRatingSystem, other.mRatingSystem)) {
            return false;
        }
        if (!TextUtils.equals(this.mRating, other.mRating)) {
            return false;
        }
        return Arrays.equals(this.mSubRatings, other.mSubRatings);
    }

    public int hashCode() {
        return this.mHashCode;
    }
}

