/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;

public class Geofence
implements Parcelable {
    public static final int TYPE_HORIZONTAL_CIRCLE = 1;
    private final int mType;
    private final double mLatitude;
    private final double mLongitude;
    private final float mRadius;
    public static final Parcelable.Creator<Geofence> CREATOR = new Parcelable.Creator<Geofence>(){

        @Override
        public Geofence createFromParcel(Parcel in) {
            int type = in.readInt();
            double latitude = in.readDouble();
            double longitude = in.readDouble();
            float radius = in.readFloat();
            Geofence.checkType(type);
            return Geofence.createCircle(latitude, longitude, radius);
        }

        public Geofence[] newArray(int size) {
            return new Geofence[size];
        }
    };

    public static Geofence createCircle(double latitude, double longitude, float radius) {
        return new Geofence(latitude, longitude, radius);
    }

    private Geofence(double latitude, double longitude, float radius) {
        Geofence.checkRadius(radius);
        Geofence.checkLatLong(latitude, longitude);
        this.mType = 1;
        this.mLatitude = latitude;
        this.mLongitude = longitude;
        this.mRadius = radius;
    }

    public int getType() {
        return this.mType;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public float getRadius() {
        return this.mRadius;
    }

    private static void checkRadius(float radius) {
        if (radius <= 0.0f) {
            throw new IllegalArgumentException("invalid radius: " + radius);
        }
    }

    private static void checkLatLong(double latitude, double longitude) {
        if (latitude > 90.0 || latitude < -90.0) {
            throw new IllegalArgumentException("invalid latitude: " + latitude);
        }
        if (longitude > 180.0 || longitude < -180.0) {
            throw new IllegalArgumentException("invalid longitude: " + longitude);
        }
    }

    private static void checkType(int type) {
        if (type != 1) {
            throw new IllegalArgumentException("invalid type: " + type);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mType);
        parcel.writeDouble(this.mLatitude);
        parcel.writeDouble(this.mLongitude);
        parcel.writeFloat(this.mRadius);
    }

    private static String typeToString(int type) {
        switch (type) {
            case 1: {
                return "CIRCLE";
            }
        }
        Geofence.checkType(type);
        return null;
    }

    public String toString() {
        return String.format("Geofence[%s %.6f, %.6f %.0fm]", Geofence.typeToString(this.mType), this.mLatitude, this.mLongitude, Float.valueOf(this.mRadius));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.mLatitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mLongitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + Float.floatToIntBits(this.mRadius);
        result = 31 * result + this.mType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Geofence)) {
            return false;
        }
        Geofence other = (Geofence)obj;
        if (this.mRadius != other.mRadius) {
            return false;
        }
        if (this.mLatitude != other.mLatitude) {
            return false;
        }
        if (this.mLongitude != other.mLongitude) {
            return false;
        }
        return this.mType == other.mType;
    }
}

