/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.hdmi.IHdmiVendorCommandListener;
import android.os.RemoteException;
import android.util.Log;

public abstract class HdmiClient {
    private static final String TAG = "HdmiClient";
    protected final IHdmiControlService mService;

    protected abstract int getDeviceType();

    public HdmiClient(IHdmiControlService service) {
        this.mService = service;
    }

    public HdmiDeviceInfo getActiveSource() {
        try {
            return this.mService.getActiveSource();
        }
        catch (RemoteException e) {
            Log.e(TAG, "getActiveSource threw exception ", e);
            return null;
        }
    }

    public void sendKeyEvent(int keyCode, boolean isPressed) {
        try {
            this.mService.sendKeyEvent(this.getDeviceType(), keyCode, isPressed);
        }
        catch (RemoteException e) {
            Log.e(TAG, "sendKeyEvent threw exception ", e);
        }
    }

    public void sendVendorCommand(int targetAddress, byte[] params, boolean hasVendorId) {
        try {
            this.mService.sendVendorCommand(this.getDeviceType(), targetAddress, params, hasVendorId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to send vendor command: ", e);
        }
    }

    public void addVendorCommandListener(HdmiControlManager.VendorCommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        try {
            this.mService.addVendorCommandListener(HdmiClient.getListenerWrapper(listener), this.getDeviceType());
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to add vendor command listener: ", e);
        }
    }

    private static IHdmiVendorCommandListener getListenerWrapper(final HdmiControlManager.VendorCommandListener listener) {
        return new IHdmiVendorCommandListener.Stub(){

            @Override
            public void onReceived(int srcAddress, byte[] params, boolean hasVendorId) {
                listener.onReceived(srcAddress, params, hasVendorId);
            }
        };
    }
}

