/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.os.Handler;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.HashSet;
import java.util.Set;

public class TaskDrainer<T> {
    private static final String TAG = "TaskDrainer";
    private final boolean VERBOSE = Log.isLoggable("TaskDrainer", 2);
    private final Handler mHandler;
    private final DrainListener mListener;
    private final String mName;
    private final Set<T> mTaskSet = new HashSet<T>();
    private final Object mLock = new Object();
    private boolean mDraining = false;
    private boolean mDrainFinished = false;

    public TaskDrainer(Handler handler, DrainListener listener) {
        this.mHandler = Preconditions.checkNotNull(handler, "handler must not be null");
        this.mListener = Preconditions.checkNotNull(listener, "listener must not be null");
        this.mName = null;
    }

    public TaskDrainer(Handler handler, DrainListener listener, String name) {
        this.mHandler = Preconditions.checkNotNull(handler, "handler must not be null");
        this.mListener = Preconditions.checkNotNull(listener, "listener must not be null");
        this.mName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskStarted(T task) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.VERBOSE) {
                Log.v("TaskDrainer[" + this.mName + "]", "taskStarted " + task);
            }
            if (this.mDraining) {
                throw new IllegalStateException("Can't start more tasks after draining has begun");
            }
            if (!this.mTaskSet.add(task)) {
                throw new IllegalStateException("Task " + task + " was already started");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskFinished(T task) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.VERBOSE) {
                Log.v("TaskDrainer[" + this.mName + "]", "taskFinished " + task);
            }
            if (!this.mTaskSet.remove(task)) {
                throw new IllegalStateException("Task " + task + " was already finished");
            }
            this.checkIfDrainFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginDrain() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mDraining) {
                if (this.VERBOSE) {
                    Log.v("TaskDrainer[" + this.mName + "]", "beginDrain started");
                }
                this.mDraining = true;
                this.checkIfDrainFinished();
            } else if (this.VERBOSE) {
                Log.v("TaskDrainer[" + this.mName + "]", "beginDrain ignored");
            }
        }
    }

    private void checkIfDrainFinished() {
        if (this.mTaskSet.isEmpty() && this.mDraining && !this.mDrainFinished) {
            this.mDrainFinished = true;
            this.postDrained();
        }
    }

    private void postDrained() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (TaskDrainer.this.VERBOSE) {
                    Log.v("TaskDrainer[" + TaskDrainer.this.mName + "]", "onDrained");
                }
                TaskDrainer.this.mListener.onDrained();
            }
        });
    }

    public static interface DrainListener {
        public void onDrained();
    }
}

