/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.util.Log;
import com.android.tools.layoutlib.java.Objects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArrayUtils {
    private static final String TAG = "ArrayUtils";
    private static final boolean VERBOSE = Log.isLoggable("ArrayUtils", 2);

    public static <T> int getArrayIndex(T[] array2, T needle) {
        if (array2 == null) {
            return -1;
        }
        int index = 0;
        for (T elem : array2) {
            if (Objects.equals(elem, needle)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static int getArrayIndex(int[] array2, int needle) {
        if (array2 == null) {
            return -1;
        }
        for (int i = 0; i < array2.length; ++i) {
            if (array2[i] != needle) continue;
            return i;
        }
        return -1;
    }

    public static int[] convertStringListToIntArray(List<String> list, String[] convertFrom, int[] convertTo) {
        if (list == null) {
            return null;
        }
        List<Integer> convertedList = ArrayUtils.convertStringListToIntList(list, convertFrom, convertTo);
        int[] returnArray = new int[convertedList.size()];
        for (int i = 0; i < returnArray.length; ++i) {
            returnArray[i] = convertedList.get(i);
        }
        return returnArray;
    }

    public static List<Integer> convertStringListToIntList(List<String> list, String[] convertFrom, int[] convertTo) {
        if (list == null) {
            return null;
        }
        ArrayList<Integer> convertedList = new ArrayList<Integer>(list.size());
        for (String str : list) {
            int strIndex = ArrayUtils.getArrayIndex(convertFrom, str);
            if (strIndex < 0) {
                Log.w(TAG, "Ignoring invalid value " + str);
                continue;
            }
            if (strIndex >= convertTo.length) continue;
            convertedList.add(convertTo[strIndex]);
        }
        return convertedList;
    }

    public static int[] toIntArray(List<Integer> list) {
        if (list == null) {
            return null;
        }
        int[] arr = new int[list.size()];
        int i = 0;
        Iterator<Integer> i$ = list.iterator();
        while (i$.hasNext()) {
            int elem;
            arr[i] = elem = i$.next().intValue();
            ++i;
        }
        return arr;
    }

    public static boolean contains(int[] array2, int elem) {
        return ArrayUtils.getArrayIndex(array2, elem) != -1;
    }

    public static <T> boolean contains(T[] array2, T elem) {
        return ArrayUtils.getArrayIndex(array2, elem) != -1;
    }

    private ArrayUtils() {
        throw new AssertionError();
    }
}

