/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.graphics.PointF;
import android.hardware.camera2.utils.HashCodeHelpers;
import com.android.internal.util.Preconditions;
import java.util.Arrays;

public class TonemapCurve {
    public static final float LEVEL_BLACK = 0.0f;
    public static final float LEVEL_WHITE = 1.0f;
    public static final int POINT_SIZE = 2;
    public static final int CHANNEL_RED = 0;
    public static final int CHANNEL_GREEN = 1;
    public static final int CHANNEL_BLUE = 2;
    private static final int OFFSET_POINT_IN = 0;
    private static final int OFFSET_POINT_OUT = 1;
    private static final int TONEMAP_MIN_CURVE_POINTS = 2;
    private static final int MIN_CURVE_LENGTH = 4;
    private final float[] mRed;
    private final float[] mGreen;
    private final float[] mBlue;
    private int mHashCode;
    private boolean mHashCalculated = false;

    public TonemapCurve(float[] red, float[] green, float[] blue) {
        Preconditions.checkNotNull(red, "red must not be null");
        Preconditions.checkNotNull(green, "green must not be null");
        Preconditions.checkNotNull(blue, "blue must not be null");
        TonemapCurve.checkArgumentArrayLengthDivisibleBy(red, 2, "red");
        TonemapCurve.checkArgumentArrayLengthDivisibleBy(green, 2, "green");
        TonemapCurve.checkArgumentArrayLengthDivisibleBy(blue, 2, "blue");
        TonemapCurve.checkArgumentArrayLengthNoLessThan(red, 4, "red");
        TonemapCurve.checkArgumentArrayLengthNoLessThan(green, 4, "green");
        TonemapCurve.checkArgumentArrayLengthNoLessThan(blue, 4, "blue");
        Preconditions.checkArrayElementsInRange(red, 0.0f, 1.0f, "red");
        Preconditions.checkArrayElementsInRange(green, 0.0f, 1.0f, "green");
        Preconditions.checkArrayElementsInRange(blue, 0.0f, 1.0f, "blue");
        this.mRed = Arrays.copyOf(red, red.length);
        this.mGreen = Arrays.copyOf(green, green.length);
        this.mBlue = Arrays.copyOf(blue, blue.length);
    }

    private static void checkArgumentArrayLengthDivisibleBy(float[] array2, int divisible, String arrayName) {
        if (array2.length % divisible != 0) {
            throw new IllegalArgumentException(arrayName + " size must be divisible by " + divisible);
        }
    }

    private static int checkArgumentColorChannel(int colorChannel) {
        switch (colorChannel) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("colorChannel out of range");
            }
        }
        return colorChannel;
    }

    private static void checkArgumentArrayLengthNoLessThan(float[] array2, int minLength, String arrayName) {
        if (array2.length < minLength) {
            throw new IllegalArgumentException(arrayName + " size must be at least " + minLength);
        }
    }

    public int getPointCount(int colorChannel) {
        TonemapCurve.checkArgumentColorChannel(colorChannel);
        return this.getCurve(colorChannel).length / 2;
    }

    public PointF getPoint(int colorChannel, int index) {
        TonemapCurve.checkArgumentColorChannel(colorChannel);
        if (index < 0 || index >= this.getPointCount(colorChannel)) {
            throw new IllegalArgumentException("index out of range");
        }
        float[] curve = this.getCurve(colorChannel);
        float pIn = curve[index * 2 + 0];
        float pOut = curve[index * 2 + 1];
        return new PointF(pIn, pOut);
    }

    public void copyColorCurve(int colorChannel, float[] destination, int offset) {
        Preconditions.checkArgumentNonnegative(offset, "offset must not be negative");
        Preconditions.checkNotNull(destination, "destination must not be null");
        if (destination.length + offset < this.getPointCount(colorChannel) * 2) {
            throw new ArrayIndexOutOfBoundsException("destination too small to fit elements");
        }
        float[] curve = this.getCurve(colorChannel);
        System.arraycopy(curve, 0, destination, offset, curve.length);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof TonemapCurve) {
            TonemapCurve other = (TonemapCurve)obj;
            return Arrays.equals(this.mRed, other.mRed) && Arrays.equals(this.mGreen, other.mGreen) && Arrays.equals(this.mBlue, other.mBlue);
        }
        return false;
    }

    public int hashCode() {
        if (this.mHashCalculated) {
            return this.mHashCode;
        }
        this.mHashCode = HashCodeHelpers.hashCode(this.mRed, this.mGreen, this.mBlue);
        this.mHashCalculated = true;
        return this.mHashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TonemapCurve{");
        sb.append("R:");
        sb.append(this.curveToString(0));
        sb.append(", G:");
        sb.append(this.curveToString(1));
        sb.append(", B:");
        sb.append(this.curveToString(2));
        sb.append("}");
        return sb.toString();
    }

    private String curveToString(int colorChannel) {
        TonemapCurve.checkArgumentColorChannel(colorChannel);
        StringBuilder sb = new StringBuilder("[");
        float[] curve = this.getCurve(colorChannel);
        int pointCount = curve.length / 2;
        int i = 0;
        int j = 0;
        while (i < pointCount) {
            sb.append("(");
            sb.append(curve[j]);
            sb.append(", ");
            sb.append(curve[j + 1]);
            sb.append("), ");
            ++i;
            j += 2;
        }
        sb.setLength(sb.length() - 2);
        sb.append("]");
        return sb.toString();
    }

    private float[] getCurve(int colorChannel) {
        switch (colorChannel) {
            case 0: {
                return this.mRed;
            }
            case 1: {
                return this.mGreen;
            }
            case 2: {
                return this.mBlue;
            }
        }
        throw new AssertionError((Object)"colorChannel out of range");
    }
}

