/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.os.SystemClock;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;

class PerfMeasurement {
    private static final String TAG = "PerfMeasurement";
    public static final int DEFAULT_MAX_QUERIES = 3;
    private final long mNativeContext;
    private int mCompletedQueryCount = 0;
    private ArrayList<Long> mCollectedGpuDurations = new ArrayList();
    private ArrayList<Long> mCollectedCpuDurations = new ArrayList();
    private ArrayList<Long> mCollectedTimestamps = new ArrayList();
    private Queue<Long> mTimestampQueue = new LinkedList<Long>();
    private Queue<Long> mCpuDurationsQueue = new LinkedList<Long>();
    private long mStartTimeNs;
    private static final long NO_DURATION_YET = -1L;
    private static final long FAILED_TIMING = -2L;

    public PerfMeasurement() {
        this.mNativeContext = PerfMeasurement.nativeCreateContext(3);
    }

    public PerfMeasurement(int maxQueries) {
        if (maxQueries < 1) {
            throw new IllegalArgumentException("maxQueries is less than 1");
        }
        this.mNativeContext = PerfMeasurement.nativeCreateContext(maxQueries);
    }

    public static boolean isGlTimingSupported() {
        return PerfMeasurement.nativeQuerySupport();
    }

    public void dumpPerformanceData(String path) {
        try {
            BufferedWriter dump = new BufferedWriter(new FileWriter(path));
            Throwable throwable = null;
            try {
                dump.write("timestamp gpu_duration cpu_duration\n");
                for (int i = 0; i < this.mCollectedGpuDurations.size(); ++i) {
                    dump.write(String.format("%d %d %d\n", this.mCollectedTimestamps.get(i), this.mCollectedGpuDurations.get(i), this.mCollectedCpuDurations.get(i)));
                }
                this.mCollectedTimestamps.clear();
                this.mCollectedGpuDurations.clear();
                this.mCollectedCpuDurations.clear();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dump != null) {
                    if (throwable != null) {
                        try {
                            dump.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        dump.close();
                    }
                }
            }
        }
        catch (IOException e) {
            Log.e(TAG, "Error writing data dump to " + path + ":" + e);
        }
    }

    public void startTimer() {
        PerfMeasurement.nativeStartGlTimer(this.mNativeContext);
        this.mStartTimeNs = SystemClock.elapsedRealtimeNanos();
    }

    public void stopTimer() {
        long endTimeNs = SystemClock.elapsedRealtimeNanos();
        this.mCpuDurationsQueue.add(endTimeNs - this.mStartTimeNs);
        PerfMeasurement.nativeStopGlTimer(this.mNativeContext);
        long duration = this.getNextGlDuration();
        if (duration > 0L) {
            this.mCollectedGpuDurations.add(duration);
            this.mCollectedTimestamps.add(this.mTimestampQueue.isEmpty() ? -1L : this.mTimestampQueue.poll());
            this.mCollectedCpuDurations.add(this.mCpuDurationsQueue.isEmpty() ? -1L : this.mCpuDurationsQueue.poll());
        }
        if (duration == -2L) {
            if (!this.mTimestampQueue.isEmpty()) {
                this.mTimestampQueue.poll();
            }
            if (!this.mCpuDurationsQueue.isEmpty()) {
                this.mCpuDurationsQueue.poll();
            }
        }
    }

    public void addTimestamp(long timestamp) {
        this.mTimestampQueue.add(timestamp);
    }

    private long getNextGlDuration() {
        long duration = PerfMeasurement.nativeGetNextGlDuration(this.mNativeContext);
        if (duration > 0L) {
            ++this.mCompletedQueryCount;
        }
        return duration;
    }

    public int getCompletedQueryCount() {
        return this.mCompletedQueryCount;
    }

    protected void finalize() {
        PerfMeasurement.nativeDeleteContext(this.mNativeContext);
    }

    private static long nativeCreateContext(int n) {
        return OverrideMethod.invokeL("android.hardware.camera2.legacy.PerfMeasurement#nativeCreateContext(I)J", true, null);
    }

    private static void nativeDeleteContext(long l) {
        OverrideMethod.invokeV("android.hardware.camera2.legacy.PerfMeasurement#nativeDeleteContext(J)V", true, null);
    }

    private static boolean nativeQuerySupport() {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.PerfMeasurement#nativeQuerySupport()Z", true, null) != 0;
    }

    protected static void nativeStartGlTimer(long l) {
        OverrideMethod.invokeV("android.hardware.camera2.legacy.PerfMeasurement#nativeStartGlTimer(J)V", true, null);
    }

    protected static void nativeStopGlTimer(long l) {
        OverrideMethod.invokeV("android.hardware.camera2.legacy.PerfMeasurement#nativeStopGlTimer(J)V", true, null);
    }

    protected static long nativeGetNextGlDuration(long l) {
        return OverrideMethod.invokeL("android.hardware.camera2.legacy.PerfMeasurement#nativeGetNextGlDuration(J)J", true, null);
    }
}

