/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.dispatch.ArgumentReplacingDispatcher;
import android.hardware.camera2.dispatch.BroadcastDispatcher;
import android.hardware.camera2.dispatch.DuckTypingDispatcher;
import android.hardware.camera2.dispatch.HandlerDispatcher;
import android.hardware.camera2.dispatch.InvokeDispatcher;
import android.hardware.camera2.impl.CallbackProxies;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.utils.TaskDrainer;
import android.hardware.camera2.utils.TaskSingleDrainer;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.List;

public class CameraCaptureSessionImpl
extends CameraCaptureSession {
    private static final String TAG = "CameraCaptureSession";
    private static final boolean VERBOSE = Log.isLoggable("CameraCaptureSession", 2);
    private final int mId;
    private final String mIdString;
    private final List<Surface> mOutputs;
    private final CameraCaptureSession.StateCallback mStateCallback;
    private final Handler mStateHandler;
    private final CameraDeviceImpl mDeviceImpl;
    private final Handler mDeviceHandler;
    private final TaskDrainer<Integer> mSequenceDrainer;
    private final TaskSingleDrainer mIdleDrainer;
    private final TaskSingleDrainer mAbortDrainer;
    private final TaskSingleDrainer mUnconfigureDrainer;
    private boolean mClosed = false;
    private final boolean mConfigureSuccess;
    private boolean mSkipUnconfigure = false;
    private volatile boolean mAborting;

    CameraCaptureSessionImpl(int id2, List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler stateHandler, CameraDeviceImpl deviceImpl, Handler deviceStateHandler, boolean configureSuccess) {
        if (outputs == null || outputs.isEmpty()) {
            throw new IllegalArgumentException("outputs must be a non-null, non-empty list");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.mId = id2;
        this.mIdString = String.format("Session %d: ", this.mId);
        this.mOutputs = outputs;
        this.mStateHandler = CameraDeviceImpl.checkHandler(stateHandler);
        this.mStateCallback = this.createUserStateCallbackProxy(this.mStateHandler, callback);
        this.mDeviceHandler = Preconditions.checkNotNull(deviceStateHandler, "deviceStateHandler must not be null");
        this.mDeviceImpl = Preconditions.checkNotNull(deviceImpl, "deviceImpl must not be null");
        this.mSequenceDrainer = new TaskDrainer(this.mDeviceHandler, new SequenceDrainListener(), "seq");
        this.mIdleDrainer = new TaskSingleDrainer(this.mDeviceHandler, new IdleDrainListener(), "idle");
        this.mAbortDrainer = new TaskSingleDrainer(this.mDeviceHandler, new AbortDrainListener(), "abort");
        this.mUnconfigureDrainer = new TaskSingleDrainer(this.mDeviceHandler, new UnconfigureDrainListener(), "unconf");
        if (configureSuccess) {
            this.mStateCallback.onConfigured(this);
            if (VERBOSE) {
                Log.v(TAG, this.mIdString + "Created session successfully");
            }
            this.mConfigureSuccess = true;
        } else {
            this.mStateCallback.onConfigureFailed(this);
            this.mClosed = true;
            Log.e(TAG, this.mIdString + "Failed to create capture session; configuration failed");
            this.mConfigureSuccess = false;
        }
    }

    @Override
    public CameraDevice getDevice() {
        return this.mDeviceImpl;
    }

    @Override
    public synchronized int capture(CaptureRequest request, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        this.checkNotClosed();
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        if (VERBOSE) {
            Log.v(TAG, this.mIdString + "capture - request " + request + ", callback " + callback + " handler " + handler);
        }
        return this.addPendingSequence(this.mDeviceImpl.capture(request, this.createCaptureCallbackProxy(handler, callback), this.mDeviceHandler));
    }

    @Override
    public synchronized int captureBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null) {
            throw new IllegalArgumentException("requests must not be null");
        }
        if (requests.isEmpty()) {
            throw new IllegalArgumentException("requests must have at least one element");
        }
        this.checkNotClosed();
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        if (VERBOSE) {
            Object[] requestArray = requests.toArray(new CaptureRequest[0]);
            Log.v(TAG, this.mIdString + "captureBurst - requests " + Arrays.toString(requestArray) + ", callback " + callback + " handler " + handler);
        }
        return this.addPendingSequence(this.mDeviceImpl.captureBurst(requests, this.createCaptureCallbackProxy(handler, callback), this.mDeviceHandler));
    }

    @Override
    public synchronized int setRepeatingRequest(CaptureRequest request, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        this.checkNotClosed();
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        if (VERBOSE) {
            Log.v(TAG, this.mIdString + "setRepeatingRequest - request " + request + ", callback " + callback + " handler" + " " + handler);
        }
        return this.addPendingSequence(this.mDeviceImpl.setRepeatingRequest(request, this.createCaptureCallbackProxy(handler, callback), this.mDeviceHandler));
    }

    @Override
    public synchronized int setRepeatingBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null) {
            throw new IllegalArgumentException("requests must not be null");
        }
        if (requests.isEmpty()) {
            throw new IllegalArgumentException("requests must have at least one element");
        }
        this.checkNotClosed();
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        if (VERBOSE) {
            Object[] requestArray = requests.toArray(new CaptureRequest[0]);
            Log.v(TAG, this.mIdString + "setRepeatingBurst - requests " + Arrays.toString(requestArray) + ", callback " + callback + " handler" + "" + handler);
        }
        return this.addPendingSequence(this.mDeviceImpl.setRepeatingBurst(requests, this.createCaptureCallbackProxy(handler, callback), this.mDeviceHandler));
    }

    @Override
    public synchronized void stopRepeating() throws CameraAccessException {
        this.checkNotClosed();
        if (VERBOSE) {
            Log.v(TAG, this.mIdString + "stopRepeating");
        }
        this.mDeviceImpl.stopRepeating();
    }

    @Override
    public synchronized void abortCaptures() throws CameraAccessException {
        this.checkNotClosed();
        if (VERBOSE) {
            Log.v(TAG, this.mIdString + "abortCaptures");
        }
        if (this.mAborting) {
            Log.w(TAG, this.mIdString + "abortCaptures - Session is already aborting; doing nothing");
            return;
        }
        this.mAborting = true;
        this.mAbortDrainer.taskStarted();
        this.mDeviceImpl.flush();
    }

    synchronized void replaceSessionClose() {
        if (VERBOSE) {
            Log.v(TAG, this.mIdString + "replaceSessionClose");
        }
        this.mSkipUnconfigure = true;
        this.close();
    }

    @Override
    public synchronized void close() {
        if (this.mClosed) {
            if (VERBOSE) {
                Log.v(TAG, this.mIdString + "close - reentering");
            }
            return;
        }
        if (VERBOSE) {
            Log.v(TAG, this.mIdString + "close - first time");
        }
        this.mClosed = true;
        try {
            this.mDeviceImpl.stopRepeating();
        }
        catch (IllegalStateException e) {
            Log.w(TAG, this.mIdString + "The camera device was already closed: ", e);
            this.mStateCallback.onClosed(this);
            return;
        }
        catch (CameraAccessException e) {
            Log.e(TAG, this.mIdString + "Exception while stopping repeating: ", e);
        }
        this.mSequenceDrainer.beginDrain();
    }

    boolean isAborting() {
        return this.mAborting;
    }

    private CameraCaptureSession.StateCallback createUserStateCallbackProxy(Handler handler, CameraCaptureSession.StateCallback callback) {
        InvokeDispatcher<CameraCaptureSession.StateCallback> userCallbackSink = new InvokeDispatcher<CameraCaptureSession.StateCallback>(callback);
        HandlerDispatcher<CameraCaptureSession.StateCallback> handlerPassthrough = new HandlerDispatcher<CameraCaptureSession.StateCallback>(userCallbackSink, handler);
        return new CallbackProxies.SessionStateCallbackProxy(handlerPassthrough);
    }

    private CameraDeviceImpl.CaptureCallback createCaptureCallbackProxy(Handler handler, CameraCaptureSession.CaptureCallback callback) {
        CameraDeviceImpl.CaptureCallback localCallback = new CameraDeviceImpl.CaptureCallback(){

            @Override
            public void onCaptureSequenceCompleted(CameraDevice camera, int sequenceId, long frameNumber) {
                CameraCaptureSessionImpl.this.finishPendingSequence(sequenceId);
            }

            @Override
            public void onCaptureSequenceAborted(CameraDevice camera, int sequenceId) {
                CameraCaptureSessionImpl.this.finishPendingSequence(sequenceId);
            }
        };
        if (callback == null) {
            return localCallback;
        }
        InvokeDispatcher<1> localSink = new InvokeDispatcher<1>(localCallback);
        InvokeDispatcher<CameraCaptureSession.CaptureCallback> userCallbackSink = new InvokeDispatcher<CameraCaptureSession.CaptureCallback>(callback);
        HandlerDispatcher<CameraCaptureSession.CaptureCallback> handlerPassthrough = new HandlerDispatcher<CameraCaptureSession.CaptureCallback>(userCallbackSink, handler);
        DuckTypingDispatcher duckToSession = new DuckTypingDispatcher(handlerPassthrough, CameraCaptureSession.CaptureCallback.class);
        ArgumentReplacingDispatcher replaceDeviceWithSession = new ArgumentReplacingDispatcher(duckToSession, 0, this);
        BroadcastDispatcher<CameraDeviceImpl.CaptureCallback> broadcaster = new BroadcastDispatcher<CameraDeviceImpl.CaptureCallback>(replaceDeviceWithSession, localSink);
        return new CallbackProxies.DeviceCaptureCallbackProxy(broadcaster);
    }

    CameraDeviceImpl.StateCallbackKK getDeviceStateCallback() {
        final CameraCaptureSessionImpl session = this;
        return new CameraDeviceImpl.StateCallbackKK(){
            private boolean mBusy = false;
            private boolean mActive = false;

            @Override
            public void onOpened(CameraDevice camera) {
                throw new AssertionError((Object)"Camera must already be open before creating a session");
            }

            @Override
            public void onDisconnected(CameraDevice camera) {
                if (VERBOSE) {
                    Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onDisconnected");
                }
                CameraCaptureSessionImpl.this.close();
            }

            @Override
            public void onError(CameraDevice camera, int error) {
                Log.wtf(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "Got device error " + error);
            }

            @Override
            public void onActive(CameraDevice camera) {
                CameraCaptureSessionImpl.this.mIdleDrainer.taskStarted();
                this.mActive = true;
                if (VERBOSE) {
                    Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onActive");
                }
                CameraCaptureSessionImpl.this.mStateCallback.onActive(session);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIdle(CameraDevice camera) {
                boolean isAborting;
                if (VERBOSE) {
                    Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onIdle");
                }
                CameraCaptureSession cameraCaptureSession = session;
                synchronized (cameraCaptureSession) {
                    isAborting = CameraCaptureSessionImpl.this.mAborting;
                }
                if (this.mBusy && isAborting) {
                    CameraCaptureSessionImpl.this.mAbortDrainer.taskFinished();
                    cameraCaptureSession = session;
                    synchronized (cameraCaptureSession) {
                        CameraCaptureSessionImpl.this.mAborting = false;
                    }
                }
                if (this.mActive) {
                    CameraCaptureSessionImpl.this.mIdleDrainer.taskFinished();
                }
                this.mBusy = false;
                this.mActive = false;
                CameraCaptureSessionImpl.this.mStateCallback.onReady(session);
            }

            @Override
            public void onBusy(CameraDevice camera) {
                this.mBusy = true;
                if (VERBOSE) {
                    Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onBusy");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUnconfigured(CameraDevice camera) {
                if (VERBOSE) {
                    Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onUnconfigured");
                }
                CameraCaptureSession cameraCaptureSession = session;
                synchronized (cameraCaptureSession) {
                    if (CameraCaptureSessionImpl.this.mClosed && CameraCaptureSessionImpl.this.mConfigureSuccess && !CameraCaptureSessionImpl.this.mSkipUnconfigure) {
                        CameraCaptureSessionImpl.this.mUnconfigureDrainer.taskFinished();
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void checkNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Session has been closed; further changes are illegal.");
        }
    }

    private int addPendingSequence(int sequenceId) {
        this.mSequenceDrainer.taskStarted(sequenceId);
        return sequenceId;
    }

    private void finishPendingSequence(int sequenceId) {
        this.mSequenceDrainer.taskFinished(sequenceId);
    }

    private class UnconfigureDrainListener
    implements TaskDrainer.DrainListener {
        private UnconfigureDrainListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDrained() {
            if (VERBOSE) {
                Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onUnconfigureDrained");
            }
            CameraCaptureSessionImpl cameraCaptureSessionImpl = CameraCaptureSessionImpl.this;
            synchronized (cameraCaptureSessionImpl) {
                CameraCaptureSessionImpl.this.mStateCallback.onClosed(CameraCaptureSessionImpl.this);
            }
        }
    }

    private class IdleDrainListener
    implements TaskDrainer.DrainListener {
        private IdleDrainListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDrained() {
            if (VERBOSE) {
                Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onIdleDrained");
            }
            Object object = ((CameraCaptureSessionImpl)CameraCaptureSessionImpl.this).mDeviceImpl.mInterfaceLock;
            synchronized (object) {
                CameraCaptureSessionImpl cameraCaptureSessionImpl = CameraCaptureSessionImpl.this;
                synchronized (cameraCaptureSessionImpl) {
                    if (VERBOSE) {
                        Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "Session drain complete, skip unconfigure: " + CameraCaptureSessionImpl.this.mSkipUnconfigure);
                    }
                    if (CameraCaptureSessionImpl.this.mSkipUnconfigure) {
                        CameraCaptureSessionImpl.this.mStateCallback.onClosed(CameraCaptureSessionImpl.this);
                        return;
                    }
                    CameraCaptureSessionImpl.this.mUnconfigureDrainer.taskStarted();
                    try {
                        CameraCaptureSessionImpl.this.mDeviceImpl.configureOutputsChecked(null);
                    }
                    catch (CameraAccessException e) {
                        Log.e(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "Exception while configuring outputs: ", e);
                    }
                    catch (IllegalStateException e) {
                        if (VERBOSE) {
                            Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "Camera was already closed or busy, skipping unconfigure");
                        }
                        CameraCaptureSessionImpl.this.mUnconfigureDrainer.taskFinished();
                    }
                    CameraCaptureSessionImpl.this.mUnconfigureDrainer.beginDrain();
                }
            }
        }
    }

    private class AbortDrainListener
    implements TaskDrainer.DrainListener {
        private AbortDrainListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDrained() {
            if (VERBOSE) {
                Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onAbortDrained");
            }
            CameraCaptureSessionImpl cameraCaptureSessionImpl = CameraCaptureSessionImpl.this;
            synchronized (cameraCaptureSessionImpl) {
                CameraCaptureSessionImpl.this.mIdleDrainer.beginDrain();
            }
        }
    }

    private class SequenceDrainListener
    implements TaskDrainer.DrainListener {
        private SequenceDrainListener() {
        }

        @Override
        public void onDrained() {
            if (VERBOSE) {
                Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onSequenceDrained");
            }
            CameraCaptureSessionImpl.this.mAbortDrainer.beginDrain();
        }
    }
}

