/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix_Delegate;
import android.graphics.Path;
import android.graphics.RectF;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public final class Path_Delegate {
    private static final DelegateManager<Path_Delegate> sManager = new DelegateManager<Path_Delegate>(Path_Delegate.class);
    private Path.FillType mFillType = Path.FillType.WINDING;
    private GeneralPath mPath = new GeneralPath();
    private float mLastX = 0.0f;
    private float mLastY = 0.0f;

    public static Path_Delegate getDelegate(long nPath) {
        return sManager.getDelegate(nPath);
    }

    public Shape getJavaShape() {
        return this.mPath;
    }

    public void setJavaShape(Shape shape) {
        this.mPath.reset();
        this.mPath.append(shape, false);
    }

    public void reset() {
        this.mPath.reset();
    }

    public void setPathIterator(PathIterator iterator) {
        this.mPath.reset();
        this.mPath.append(iterator, false);
    }

    @LayoutlibDelegate
    static long init1() {
        Path_Delegate newDelegate = new Path_Delegate();
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static long init2(long nPath) {
        Path_Delegate newDelegate = new Path_Delegate();
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate != null) {
            newDelegate.set(pathDelegate);
        }
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static void native_reset(long nPath) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.mPath.reset();
    }

    @LayoutlibDelegate
    static void native_rewind(long nPath) {
        Path_Delegate.native_reset(nPath);
    }

    @LayoutlibDelegate
    static void native_set(long native_dst, long native_src) {
        Path_Delegate pathDstDelegate = sManager.getDelegate(native_dst);
        if (pathDstDelegate == null) {
            return;
        }
        Path_Delegate pathSrcDelegate = sManager.getDelegate(native_src);
        if (pathSrcDelegate == null) {
            return;
        }
        pathDstDelegate.set(pathSrcDelegate);
    }

    @LayoutlibDelegate
    static boolean native_isConvex(long nPath) {
        Bridge.getLog().fidelityWarning("unsupported", "Path.isConvex is not supported.", null, null);
        return true;
    }

    @LayoutlibDelegate
    static int native_getFillType(long nPath) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return 0;
        }
        return pathDelegate.mFillType.nativeInt;
    }

    @LayoutlibDelegate
    static void native_setFillType(long nPath, int ft) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.mFillType = Path.sFillTypeArray[ft];
    }

    @LayoutlibDelegate
    static boolean native_isEmpty(long nPath) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return true;
        }
        return pathDelegate.isEmpty();
    }

    @LayoutlibDelegate
    static boolean native_isRect(long nPath, RectF rect) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return false;
        }
        Area area = new Area(pathDelegate.mPath);
        if (area.isRectangular()) {
            if (rect != null) {
                pathDelegate.fillBounds(rect);
            }
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static void native_computeBounds(long nPath, RectF bounds) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.fillBounds(bounds);
    }

    @LayoutlibDelegate
    static void native_incReserve(long nPath, int extraPtCount) {
    }

    @LayoutlibDelegate
    static void native_moveTo(long nPath, float x, float y) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.moveTo(x, y);
    }

    @LayoutlibDelegate
    static void native_rMoveTo(long nPath, float dx, float dy) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.rMoveTo(dx, dy);
    }

    @LayoutlibDelegate
    static void native_lineTo(long nPath, float x, float y) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.lineTo(x, y);
    }

    @LayoutlibDelegate
    static void native_rLineTo(long nPath, float dx, float dy) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.rLineTo(dx, dy);
    }

    @LayoutlibDelegate
    static void native_quadTo(long nPath, float x1, float y1, float x2, float y2) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.quadTo(x1, y1, x2, y2);
    }

    @LayoutlibDelegate
    static void native_rQuadTo(long nPath, float dx1, float dy1, float dx2, float dy2) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.rQuadTo(dx1, dy1, dx2, dy2);
    }

    @LayoutlibDelegate
    static void native_cubicTo(long nPath, float x1, float y1, float x2, float y2, float x3, float y3) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.cubicTo(x1, y1, x2, y2, x3, y3);
    }

    @LayoutlibDelegate
    static void native_rCubicTo(long nPath, float x1, float y1, float x2, float y2, float x3, float y3) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.rCubicTo(x1, y1, x2, y2, x3, y3);
    }

    @LayoutlibDelegate
    static void native_arcTo(long nPath, float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean forceMoveTo) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.arcTo(left, top, right, bottom, startAngle, sweepAngle, forceMoveTo);
    }

    @LayoutlibDelegate
    static void native_close(long nPath) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.close();
    }

    @LayoutlibDelegate
    static void native_addRect(long nPath, float left, float top, float right, float bottom, int dir) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.addRect(left, top, right, bottom, dir);
    }

    @LayoutlibDelegate
    static void native_addOval(long nPath, float left, float top, float right, float bottom, int dir) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.mPath.append(new Ellipse2D.Float(left, top, right - left, bottom - top), false);
    }

    @LayoutlibDelegate
    static void native_addCircle(long nPath, float x, float y, float radius, int dir) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.mPath.append(new Ellipse2D.Float(x - radius, y - radius, radius * 2.0f, radius * 2.0f), false);
    }

    @LayoutlibDelegate
    static void native_addArc(long nPath, float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.mPath.append(new Arc2D.Float(left, top, right - left, bottom - top, -startAngle, -sweepAngle, 0), false);
    }

    @LayoutlibDelegate
    static void native_addRoundRect(long nPath, float left, float top, float right, float bottom, float rx, float ry, int dir) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.mPath.append(new RoundRectangle2D.Float(left, top, right - left, bottom - top, rx * 2.0f, ry * 2.0f), false);
    }

    @LayoutlibDelegate
    static void native_addRoundRect(long nPath, float left, float top, float right, float bottom, float[] radii, int dir) {
        Path_Delegate.native_addRoundRect(nPath, left, top, right, bottom, radii[0], radii[1], dir);
        for (int i = 0; i < 3; ++i) {
            if (radii[i * 2] == radii[(i + 1) * 2] && radii[i * 2 + 1] == radii[(i + 1) * 2 + 1]) continue;
            Bridge.getLog().fidelityWarning("unsupported", "Different corner sizes are not supported in Path.addRoundRect.", null, null);
            break;
        }
    }

    @LayoutlibDelegate
    static void native_addPath(long nPath, long src, float dx, float dy) {
        Path_Delegate.addPath(nPath, src, AffineTransform.getTranslateInstance(dx, dy));
    }

    @LayoutlibDelegate
    static void native_addPath(long nPath, long src) {
        Path_Delegate.addPath(nPath, src, null);
    }

    @LayoutlibDelegate
    static void native_addPath(long nPath, long src, long matrix) {
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(matrix);
        if (matrixDelegate == null) {
            return;
        }
        Path_Delegate.addPath(nPath, src, matrixDelegate.getAffineTransform());
    }

    @LayoutlibDelegate
    static void native_offset(long nPath, float dx, float dy, long dst_path) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        Path_Delegate dstDelegate = sManager.getDelegate(dst_path);
        pathDelegate.offset(dx, dy, dstDelegate);
    }

    @LayoutlibDelegate
    static void native_offset(long nPath, float dx, float dy) {
        Path_Delegate.native_offset(nPath, dx, dy, 0L);
    }

    @LayoutlibDelegate
    static void native_setLastPoint(long nPath, float dx, float dy) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.mLastX = dx;
        pathDelegate.mLastY = dy;
    }

    @LayoutlibDelegate
    static void native_transform(long nPath, long matrix, long dst_path) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(matrix);
        if (matrixDelegate == null) {
            return;
        }
        Path_Delegate dstDelegate = sManager.getDelegate(dst_path);
        pathDelegate.transform(matrixDelegate, dstDelegate);
    }

    @LayoutlibDelegate
    static void native_transform(long nPath, long matrix) {
        Path_Delegate.native_transform(nPath, matrix, 0L);
    }

    @LayoutlibDelegate
    static boolean native_op(long nPath1, long nPath2, int op, long result) {
        Bridge.getLog().error("unsupported", "Path.op() not supported", null);
        return false;
    }

    @LayoutlibDelegate
    static void finalizer(long nPath) {
        sManager.removeJavaReferenceFor(nPath);
    }

    @LayoutlibDelegate
    static float[] native_approximate(long nPath, float error) {
        Bridge.getLog().error("unsupported", "Path.approximate() not supported", null);
        return new float[0];
    }

    private void set(Path_Delegate delegate) {
        this.mPath.reset();
        this.setFillType(delegate.mFillType);
        this.mPath.append(delegate.mPath, false);
    }

    private void setFillType(Path.FillType fillType) {
        this.mFillType = fillType;
        this.mPath.setWindingRule(Path_Delegate.getWindingRule(fillType));
    }

    private static int getWindingRule(Path.FillType type) {
        switch (type) {
            case WINDING: 
            case INVERSE_WINDING: {
                return 1;
            }
            case EVEN_ODD: 
            case INVERSE_EVEN_ODD: {
                return 0;
            }
        }
        assert (false);
        throw new IllegalArgumentException();
    }

    private static Path.Direction getDirection(int direction) {
        for (Path.Direction d : Path.Direction.values()) {
            if (direction != d.nativeInt) continue;
            return d;
        }
        assert (false);
        return null;
    }

    private static void addPath(long destPath, long srcPath, AffineTransform transform) {
        Path_Delegate destPathDelegate = sManager.getDelegate(destPath);
        if (destPathDelegate == null) {
            return;
        }
        Path_Delegate srcPathDelegate = sManager.getDelegate(srcPath);
        if (srcPathDelegate == null) {
            return;
        }
        if (transform != null) {
            destPathDelegate.mPath.append(srcPathDelegate.mPath.getPathIterator(transform), false);
        } else {
            destPathDelegate.mPath.append(srcPathDelegate.mPath, false);
        }
    }

    private boolean isEmpty() {
        return this.mPath.getCurrentPoint() == null;
    }

    private void fillBounds(RectF bounds) {
        Rectangle2D rect = this.mPath.getBounds2D();
        bounds.left = (float)rect.getMinX();
        bounds.right = (float)rect.getMaxX();
        bounds.top = (float)rect.getMinY();
        bounds.bottom = (float)rect.getMaxY();
    }

    private void moveTo(float x, float y) {
        this.mLastX = x;
        this.mLastY = y;
        this.mPath.moveTo(this.mLastX, this.mLastY);
    }

    private void rMoveTo(float dx, float dy) {
        this.mLastX = dx += this.mLastX;
        this.mLastY = dy += this.mLastY;
        this.mPath.moveTo(this.mLastX, this.mLastY);
    }

    private void lineTo(float x, float y) {
        if (this.isEmpty()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = x;
        this.mLastY = y;
        this.mPath.lineTo(this.mLastX, this.mLastY);
    }

    private void rLineTo(float dx, float dy) {
        if (this.isEmpty()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = dx += this.mLastX;
        this.mLastY = dy += this.mLastY;
        this.mPath.lineTo(this.mLastX, this.mLastY);
    }

    private void quadTo(float x1, float y1, float x2, float y2) {
        this.mLastX = x2;
        this.mLastY = y2;
        this.mPath.quadTo(x1, y1, this.mLastX, this.mLastY);
    }

    private void rQuadTo(float dx1, float dy1, float dx2, float dy2) {
        if (this.isEmpty()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = dx2 += this.mLastX;
        this.mLastY = dy2 += this.mLastY;
        this.mPath.quadTo(dx1 += this.mLastX, dy1 += this.mLastY, this.mLastX, this.mLastY);
    }

    private void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.mLastX = x3;
        this.mLastY = y3;
        this.mPath.curveTo(x1, y1, x2, y2, this.mLastX, this.mLastY);
    }

    private void rCubicTo(float dx1, float dy1, float dx2, float dy2, float dx3, float dy3) {
        if (this.isEmpty()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = dx3 += this.mLastX;
        this.mLastY = dy3 += this.mLastY;
        this.mPath.curveTo(dx1 += this.mLastX, dy1 += this.mLastY, dx2 += this.mLastX, dy2 += this.mLastY, this.mLastX, this.mLastY);
    }

    private void arcTo(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean forceMoveTo) {
        Arc2D.Float arc = new Arc2D.Float(left, top, right - left, bottom - top, -startAngle, -sweepAngle, 0);
        this.mPath.append(arc, true);
        this.resetLastPointFromPath();
    }

    private void close() {
        this.mPath.closePath();
    }

    private void resetLastPointFromPath() {
        Point2D last = this.mPath.getCurrentPoint();
        this.mLastX = (float)last.getX();
        this.mLastY = (float)last.getY();
    }

    private void addRect(float left, float top, float right, float bottom, int dir) {
        this.moveTo(left, top);
        Path.Direction direction = Path_Delegate.getDirection(dir);
        switch (direction) {
            case CW: {
                this.lineTo(right, top);
                this.lineTo(right, bottom);
                this.lineTo(left, bottom);
                break;
            }
            case CCW: {
                this.lineTo(left, bottom);
                this.lineTo(right, bottom);
                this.lineTo(right, top);
            }
        }
        this.close();
        this.resetLastPointFromPath();
    }

    public void offset(float dx, float dy, Path_Delegate dst) {
        GeneralPath newPath = new GeneralPath();
        PathIterator iterator = this.mPath.getPathIterator(new AffineTransform(0.0f, 0.0f, dx, 0.0f, 0.0f, dy));
        newPath.append(iterator, false);
        if (dst != null) {
            dst.mPath = newPath;
        } else {
            this.mPath = newPath;
        }
    }

    public void transform(Matrix_Delegate matrix, Path_Delegate dst) {
        if (matrix.hasPerspective()) {
            assert (false);
            Bridge.getLog().fidelityWarning("matrix.affine", "android.graphics.Path#transform() only supports affine transformations.", null, null);
        }
        GeneralPath newPath = new GeneralPath();
        PathIterator iterator = this.mPath.getPathIterator(matrix.getAffineTransform());
        newPath.append(iterator, false);
        if (dst != null) {
            dst.mPath = newPath;
        } else {
            this.mPath = newPath;
        }
    }
}

