/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.BidiRenderer;
import android.graphics.ColorFilter_Delegate;
import android.graphics.FontFamily_Delegate;
import android.graphics.MaskFilter_Delegate;
import android.graphics.Paint;
import android.graphics.PathEffect_Delegate;
import android.graphics.Path_Delegate;
import android.graphics.Rasterizer_Delegate;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader_Delegate;
import android.graphics.TemporaryBuffer;
import android.graphics.Typeface;
import android.graphics.Typeface_Delegate;
import android.graphics.Xfermode_Delegate;
import android.text.TextUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class Paint_Delegate {
    private static final DelegateManager<Paint_Delegate> sManager = new DelegateManager<Paint_Delegate>(Paint_Delegate.class);
    private List<FontInfo> mFonts;
    private int mFlags;
    private int mColor;
    private int mStyle;
    private int mCap;
    private int mJoin;
    private int mTextAlign;
    private Typeface_Delegate mTypeface;
    private float mStrokeWidth;
    private float mStrokeMiter;
    private float mTextSize;
    private float mTextScaleX;
    private float mTextSkewX;
    private int mHintingMode = 1;
    private FontFamily_Delegate.FontVariant mFontVariant = FontFamily_Delegate.FontVariant.COMPACT;
    private Xfermode_Delegate mXfermode;
    private ColorFilter_Delegate mColorFilter;
    private Shader_Delegate mShader;
    private PathEffect_Delegate mPathEffect;
    private MaskFilter_Delegate mMaskFilter;
    private Rasterizer_Delegate mRasterizer;
    private Locale mLocale = Locale.getDefault();
    public long mNativeTypeface;

    public static Paint_Delegate getDelegate(long native_paint) {
        return sManager.getDelegate(native_paint);
    }

    public List<FontInfo> getFonts() {
        return this.mFonts;
    }

    public boolean isAntiAliased() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isFilterBitmap() {
        return (this.mFlags & 2) != 0;
    }

    public int getStyle() {
        return this.mStyle;
    }

    public int getColor() {
        return this.mColor;
    }

    public int getAlpha() {
        return this.mColor >>> 24;
    }

    public void setAlpha(int alpha) {
        this.mColor = alpha << 24 | this.mColor & 0xFFFFFF;
    }

    public int getTextAlign() {
        return this.mTextAlign;
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public float getJavaStrokeMiter() {
        float miter = this.mStrokeMiter * this.mStrokeWidth;
        if (miter < 1.0f) {
            miter = 1.0f;
        }
        return miter;
    }

    public int getJavaCap() {
        switch (Paint.sCapArray[this.mCap]) {
            case BUTT: {
                return 0;
            }
            case ROUND: {
                return 1;
            }
        }
        return 2;
    }

    public int getJavaJoin() {
        switch (Paint.sJoinArray[this.mJoin]) {
            default: {
                return 0;
            }
            case ROUND: {
                return 1;
            }
            case BEVEL: 
        }
        return 2;
    }

    public Stroke getJavaStroke() {
        if (this.mPathEffect != null) {
            if (this.mPathEffect.isSupported()) {
                Stroke stroke = this.mPathEffect.getStroke(this);
                assert (stroke != null);
                if (stroke != null) {
                    return stroke;
                }
            } else {
                Bridge.getLog().fidelityWarning("patheffect", this.mPathEffect.getSupportMessage(), null, null);
            }
        }
        return new BasicStroke(this.getStrokeWidth(), this.getJavaCap(), this.getJavaJoin(), this.getJavaStrokeMiter());
    }

    public Xfermode_Delegate getXfermode() {
        return this.mXfermode;
    }

    public ColorFilter_Delegate getColorFilter() {
        return this.mColorFilter;
    }

    public Shader_Delegate getShader() {
        return this.mShader;
    }

    public MaskFilter_Delegate getMaskFilter() {
        return this.mMaskFilter;
    }

    public Rasterizer_Delegate getRasterizer() {
        return this.mRasterizer;
    }

    @LayoutlibDelegate
    static int getFlags(Paint thisPaint) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 0;
        }
        return delegate.mFlags;
    }

    @LayoutlibDelegate
    static void setFlags(Paint thisPaint, int flags) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mFlags = flags;
    }

    @LayoutlibDelegate
    static void setFilterBitmap(Paint thisPaint, boolean filter) {
        Paint_Delegate.setFlag(thisPaint, 2, filter);
    }

    @LayoutlibDelegate
    static int getHinting(Paint thisPaint) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 1;
        }
        return delegate.mHintingMode;
    }

    @LayoutlibDelegate
    static void setHinting(Paint thisPaint, int mode) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mHintingMode = mode;
    }

    @LayoutlibDelegate
    static void setAntiAlias(Paint thisPaint, boolean aa) {
        Paint_Delegate.setFlag(thisPaint, 1, aa);
    }

    @LayoutlibDelegate
    static void setSubpixelText(Paint thisPaint, boolean subpixelText) {
        Paint_Delegate.setFlag(thisPaint, 128, subpixelText);
    }

    @LayoutlibDelegate
    static void setUnderlineText(Paint thisPaint, boolean underlineText) {
        Paint_Delegate.setFlag(thisPaint, 8, underlineText);
    }

    @LayoutlibDelegate
    static void setStrikeThruText(Paint thisPaint, boolean strikeThruText) {
        Paint_Delegate.setFlag(thisPaint, 16, strikeThruText);
    }

    @LayoutlibDelegate
    static void setFakeBoldText(Paint thisPaint, boolean fakeBoldText) {
        Paint_Delegate.setFlag(thisPaint, 32, fakeBoldText);
    }

    @LayoutlibDelegate
    static void setDither(Paint thisPaint, boolean dither) {
        Paint_Delegate.setFlag(thisPaint, 4, dither);
    }

    @LayoutlibDelegate
    static void setLinearText(Paint thisPaint, boolean linearText) {
        Paint_Delegate.setFlag(thisPaint, 64, linearText);
    }

    @LayoutlibDelegate
    static int getColor(Paint thisPaint) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 0;
        }
        return delegate.mColor;
    }

    @LayoutlibDelegate
    static void setColor(Paint thisPaint, int color2) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mColor = color2;
    }

    @LayoutlibDelegate
    static int getAlpha(Paint thisPaint) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 0;
        }
        return delegate.getAlpha();
    }

    @LayoutlibDelegate
    static void setAlpha(Paint thisPaint, int a) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return;
        }
        delegate.setAlpha(a);
    }

    @LayoutlibDelegate
    static float getStrokeWidth(Paint thisPaint) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 1.0f;
        }
        return delegate.mStrokeWidth;
    }

    @LayoutlibDelegate
    static void setStrokeWidth(Paint thisPaint, float width) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mStrokeWidth = width;
    }

    @LayoutlibDelegate
    static float getStrokeMiter(Paint thisPaint) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 1.0f;
        }
        return delegate.mStrokeMiter;
    }

    @LayoutlibDelegate
    static void setStrokeMiter(Paint thisPaint, float miter) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mStrokeMiter = miter;
    }

    @LayoutlibDelegate
    static void native_setShadowLayer(long paint, float radius, float dx, float dy, int color2) {
        Bridge.getLog().fidelityWarning("unsupported", "Paint.setShadowLayer is not supported.", null, null);
    }

    @LayoutlibDelegate
    static boolean native_hasShadowLayer(long paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Paint.hasShadowLayer is not supported.", null, null);
        return false;
    }

    @LayoutlibDelegate
    static boolean isElegantTextHeight(Paint thisPaint) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        return delegate != null && delegate.mFontVariant == FontFamily_Delegate.FontVariant.ELEGANT;
    }

    @LayoutlibDelegate
    static void setElegantTextHeight(Paint thisPaint, boolean elegant) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mFontVariant = elegant ? FontFamily_Delegate.FontVariant.ELEGANT : FontFamily_Delegate.FontVariant.COMPACT;
    }

    @LayoutlibDelegate
    static float getTextSize(Paint thisPaint) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 1.0f;
        }
        return delegate.mTextSize;
    }

    @LayoutlibDelegate
    static void setTextSize(Paint thisPaint, float textSize) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mTextSize = textSize;
        delegate.updateFontObject();
    }

    @LayoutlibDelegate
    static float getTextScaleX(Paint thisPaint) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 1.0f;
        }
        return delegate.mTextScaleX;
    }

    @LayoutlibDelegate
    static void setTextScaleX(Paint thisPaint, float scaleX) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mTextScaleX = scaleX;
        delegate.updateFontObject();
    }

    @LayoutlibDelegate
    static float getTextSkewX(Paint thisPaint) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 1.0f;
        }
        return delegate.mTextSkewX;
    }

    @LayoutlibDelegate
    static void setTextSkewX(Paint thisPaint, float skewX) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mTextSkewX = skewX;
        delegate.updateFontObject();
    }

    @LayoutlibDelegate
    static float ascent(Paint thisPaint) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 0.0f;
        }
        if (delegate.mFonts.size() > 0) {
            FontMetrics javaMetrics = delegate.mFonts.get((int)0).mMetrics;
            return -javaMetrics.getAscent();
        }
        return 0.0f;
    }

    @LayoutlibDelegate
    static float descent(Paint thisPaint) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 0.0f;
        }
        if (delegate.mFonts.size() > 0) {
            FontMetrics javaMetrics = delegate.mFonts.get((int)0).mMetrics;
            return javaMetrics.getDescent();
        }
        return 0.0f;
    }

    @LayoutlibDelegate
    static float getFontMetrics(Paint thisPaint, Paint.FontMetrics metrics) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 0.0f;
        }
        return delegate.getFontMetrics(metrics);
    }

    @LayoutlibDelegate
    static int getFontMetricsInt(Paint thisPaint, Paint.FontMetricsInt fmi) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 0;
        }
        if (delegate.mFonts.size() > 0) {
            FontMetrics javaMetrics = delegate.mFonts.get((int)0).mMetrics;
            if (fmi != null) {
                fmi.top = -javaMetrics.getMaxAscent();
                fmi.ascent = -javaMetrics.getAscent();
                fmi.descent = javaMetrics.getDescent();
                fmi.bottom = javaMetrics.getMaxDescent();
                fmi.leading = javaMetrics.getLeading();
            }
            return javaMetrics.getHeight();
        }
        return 0;
    }

    @LayoutlibDelegate
    static float native_measureText(Paint thisPaint, char[] text, int index, int count, int bidiFlags) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return 0.0f;
        }
        RectF bounds = delegate.measureText(text, index, count, null, 0, bidiFlags);
        return bounds.right - bounds.left;
    }

    @LayoutlibDelegate
    static float native_measureText(Paint thisPaint, String text, int start, int end, int bidiFlags) {
        return Paint_Delegate.native_measureText(thisPaint, text.toCharArray(), start, end - start, bidiFlags);
    }

    @LayoutlibDelegate
    static float native_measureText(Paint thisPaint, String text, int bidiFlags) {
        return Paint_Delegate.native_measureText(thisPaint, text.toCharArray(), 0, text.length(), bidiFlags);
    }

    @LayoutlibDelegate
    static int native_breakText(long nativePaint, long nativeTypeface, char[] text, int index, int count, float maxWidth, int bidiFlags, float[] measuredWidth) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 0;
        }
        int inc = count > 0 ? 1 : -1;
        int measureIndex = 0;
        int i = index;
        while (i != index + count) {
            int end;
            int start;
            if (i < index) {
                start = i;
                end = index;
            } else {
                start = index;
                end = i;
            }
            RectF bounds = delegate.measureText(text, start, end - start + 1, null, 0, bidiFlags);
            float res = bounds.right - bounds.left;
            if (measuredWidth != null) {
                measuredWidth[measureIndex] = res;
            }
            if (res > maxWidth) {
                return measureIndex;
            }
            i += inc;
            ++measureIndex;
        }
        return measureIndex;
    }

    @LayoutlibDelegate
    static int native_breakText(long nativePaint, long nativeTypeface, String text, boolean measureForwards, float maxWidth, int bidiFlags, float[] measuredWidth) {
        return Paint_Delegate.native_breakText(nativePaint, nativeTypeface, text.toCharArray(), 0, text.length(), maxWidth, bidiFlags, measuredWidth);
    }

    @LayoutlibDelegate
    static long native_init() {
        Paint_Delegate newDelegate = new Paint_Delegate();
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static long native_initWithPaint(long paint) {
        Paint_Delegate delegate = sManager.getDelegate(paint);
        if (delegate == null) {
            return 0L;
        }
        Paint_Delegate newDelegate = new Paint_Delegate(delegate);
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static void native_reset(long native_object) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return;
        }
        delegate.reset();
    }

    @LayoutlibDelegate
    static void native_set(long native_dst, long native_src) {
        Paint_Delegate delegate_dst = sManager.getDelegate(native_dst);
        if (delegate_dst == null) {
            return;
        }
        Paint_Delegate delegate_src = sManager.getDelegate(native_src);
        if (delegate_src == null) {
            return;
        }
        delegate_dst.set(delegate_src);
    }

    @LayoutlibDelegate
    static int native_getStyle(long native_object) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return 0;
        }
        return delegate.mStyle;
    }

    @LayoutlibDelegate
    static void native_setStyle(long native_object, int style2) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return;
        }
        delegate.mStyle = style2;
    }

    @LayoutlibDelegate
    static int native_getStrokeCap(long native_object) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return 0;
        }
        return delegate.mCap;
    }

    @LayoutlibDelegate
    static void native_setStrokeCap(long native_object, int cap) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return;
        }
        delegate.mCap = cap;
    }

    @LayoutlibDelegate
    static int native_getStrokeJoin(long native_object) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return 0;
        }
        return delegate.mJoin;
    }

    @LayoutlibDelegate
    static void native_setStrokeJoin(long native_object, int join) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return;
        }
        delegate.mJoin = join;
    }

    @LayoutlibDelegate
    static boolean native_getFillPath(long native_object, long src, long dst) {
        Paint_Delegate paint = sManager.getDelegate(native_object);
        if (paint == null) {
            return false;
        }
        Path_Delegate srcPath = Path_Delegate.getDelegate(src);
        if (srcPath == null) {
            return true;
        }
        Path_Delegate dstPath = Path_Delegate.getDelegate(dst);
        if (dstPath == null) {
            return true;
        }
        Stroke stroke = paint.getJavaStroke();
        Shape strokeShape = stroke.createStrokedShape(srcPath.getJavaShape());
        dstPath.setJavaShape(strokeShape);
        return true;
    }

    @LayoutlibDelegate
    static long native_setShader(long native_object, long shader) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return shader;
        }
        delegate.mShader = Shader_Delegate.getDelegate(shader);
        return shader;
    }

    @LayoutlibDelegate
    static long native_setColorFilter(long native_object, long filter) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return filter;
        }
        delegate.mColorFilter = ColorFilter_Delegate.getDelegate(filter);
        if (delegate.mColorFilter != null && !delegate.mColorFilter.isSupported()) {
            Bridge.getLog().fidelityWarning("colorfilter", delegate.mColorFilter.getSupportMessage(), null, null);
        }
        return filter;
    }

    @LayoutlibDelegate
    static long native_setXfermode(long native_object, long xfermode) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return xfermode;
        }
        delegate.mXfermode = Xfermode_Delegate.getDelegate(xfermode);
        return xfermode;
    }

    @LayoutlibDelegate
    static long native_setPathEffect(long native_object, long effect) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return effect;
        }
        delegate.mPathEffect = PathEffect_Delegate.getDelegate(effect);
        return effect;
    }

    @LayoutlibDelegate
    static long native_setMaskFilter(long native_object, long maskfilter) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return maskfilter;
        }
        delegate.mMaskFilter = MaskFilter_Delegate.getDelegate(maskfilter);
        if (delegate.mMaskFilter != null && !delegate.mMaskFilter.isSupported()) {
            Bridge.getLog().fidelityWarning("maskfilter", delegate.mMaskFilter.getSupportMessage(), null, null);
        }
        return maskfilter;
    }

    @LayoutlibDelegate
    static long native_setTypeface(long native_object, long typeface) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return 0L;
        }
        delegate.mTypeface = Typeface_Delegate.getDelegate(typeface);
        delegate.mNativeTypeface = typeface;
        delegate.updateFontObject();
        return typeface;
    }

    @LayoutlibDelegate
    static long native_setRasterizer(long native_object, long rasterizer) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return rasterizer;
        }
        delegate.mRasterizer = Rasterizer_Delegate.getDelegate(rasterizer);
        if (delegate.mRasterizer != null && !delegate.mRasterizer.isSupported()) {
            Bridge.getLog().fidelityWarning("rasterizer", delegate.mRasterizer.getSupportMessage(), null, null);
        }
        return rasterizer;
    }

    @LayoutlibDelegate
    static int native_getTextAlign(long native_object) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return 0;
        }
        return delegate.mTextAlign;
    }

    @LayoutlibDelegate
    static void native_setTextAlign(long native_object, int align) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return;
        }
        delegate.mTextAlign = align;
    }

    @LayoutlibDelegate
    static void native_setTextLocale(long native_object, String locale) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return;
        }
        delegate.setTextLocale(locale);
    }

    @LayoutlibDelegate
    static int native_getTextWidths(long native_object, long native_typeface, char[] text, int index, int count, int bidiFlags, float[] widths) {
        Paint_Delegate delegate;
        if (widths != null) {
            for (int i = 0; i < count; ++i) {
                widths[i] = 0.0f;
            }
        }
        if ((delegate = sManager.getDelegate(native_object)) == null) {
            return 0;
        }
        assert (native_typeface == delegate.mNativeTypeface);
        RectF bounds = delegate.measureText(text, index, count, widths, 0, bidiFlags);
        return (int)(bounds.right - bounds.left);
    }

    @LayoutlibDelegate
    static int native_getTextWidths(long native_object, long native_typeface, String text, int start, int end, int bidiFlags, float[] widths) {
        return Paint_Delegate.native_getTextWidths(native_object, native_typeface, text.toCharArray(), start, end - start, bidiFlags, widths);
    }

    @LayoutlibDelegate
    static int native_getTextGlyphs(long native_object, String text, int start, int end, int contextStart, int contextEnd, int flags, char[] glyphs) {
        return 0;
    }

    @LayoutlibDelegate
    static float native_getTextRunAdvances(long native_object, long native_typeface, char[] text, int index, int count, int contextIndex, int contextCount, boolean isRtl, float[] advances, int advancesIndex) {
        Paint_Delegate delegate;
        if (advances != null) {
            for (int i = advancesIndex; i < advancesIndex + count; ++i) {
                advances[i] = 0.0f;
            }
        }
        if ((delegate = sManager.getDelegate(native_object)) == null) {
            return 0.0f;
        }
        assert (native_typeface == delegate.mNativeTypeface);
        RectF bounds = delegate.measureText(text, index, count, advances, advancesIndex, isRtl);
        return bounds.right - bounds.left;
    }

    @LayoutlibDelegate
    static float native_getTextRunAdvances(long native_object, long native_typeface, String text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesIndex) {
        int count = end - start;
        char[] buffer = TemporaryBuffer.obtain(count);
        TextUtils.getChars(text, start, end, buffer, 0);
        return Paint_Delegate.native_getTextRunAdvances(native_object, native_typeface, buffer, 0, count, contextStart, contextEnd - contextStart, isRtl, advances, advancesIndex);
    }

    @LayoutlibDelegate
    static int native_getTextRunCursor(Paint thisPaint, long native_object, char[] text, int contextStart, int contextLength, int flags, int offset, int cursorOpt) {
        Bridge.getLog().fidelityWarning("unsupported", "Paint.getTextRunCursor is not supported.", null, null);
        return 0;
    }

    @LayoutlibDelegate
    static int native_getTextRunCursor(Paint thisPaint, long native_object, String text, int contextStart, int contextEnd, int flags, int offset, int cursorOpt) {
        Bridge.getLog().fidelityWarning("unsupported", "Paint.getTextRunCursor is not supported.", null, null);
        return 0;
    }

    @LayoutlibDelegate
    static void native_getTextPath(long native_object, long native_typeface, int bidiFlags, char[] text, int index, int count, float x, float y, long path) {
        Bridge.getLog().fidelityWarning("unsupported", "Paint.getTextPath is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_getTextPath(long native_object, long native_typeface, int bidiFlags, String text, int start, int end, float x, float y, long path) {
        Bridge.getLog().fidelityWarning("unsupported", "Paint.getTextPath is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void nativeGetStringBounds(long nativePaint, long native_typeface, String text, int start, int end, int bidiFlags, Rect bounds) {
        Paint_Delegate.nativeGetCharArrayBounds(nativePaint, native_typeface, text.toCharArray(), start, end - start, bidiFlags, bounds);
    }

    @LayoutlibDelegate
    static void nativeGetCharArrayBounds(long nativePaint, long native_typeface, char[] text, int index, int count, int bidiFlags, Rect bounds) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        assert (native_typeface == delegate.mNativeTypeface);
        delegate.measureText(text, index, count, null, 0, bidiFlags).roundOut(bounds);
    }

    @LayoutlibDelegate
    static void finalizer(long nativePaint) {
        sManager.removeJavaReferenceFor(nativePaint);
    }

    @LayoutlibDelegate
    static float native_getLetterSpacing(long nativePaint) {
        return 0.0f;
    }

    @LayoutlibDelegate
    static void native_setLetterSpacing(long nativePaint, float letterSpacing) {
    }

    @LayoutlibDelegate
    static void native_setFontFeatureSettings(long nativePaint, String settings) {
    }

    Paint_Delegate() {
        this.reset();
    }

    private Paint_Delegate(Paint_Delegate paint) {
        this.set(paint);
    }

    private void set(Paint_Delegate paint) {
        this.mFlags = paint.mFlags;
        this.mColor = paint.mColor;
        this.mStyle = paint.mStyle;
        this.mCap = paint.mCap;
        this.mJoin = paint.mJoin;
        this.mTextAlign = paint.mTextAlign;
        this.mTypeface = paint.mTypeface;
        this.mNativeTypeface = paint.mNativeTypeface;
        this.mStrokeWidth = paint.mStrokeWidth;
        this.mStrokeMiter = paint.mStrokeMiter;
        this.mTextSize = paint.mTextSize;
        this.mTextScaleX = paint.mTextScaleX;
        this.mTextSkewX = paint.mTextSkewX;
        this.mXfermode = paint.mXfermode;
        this.mColorFilter = paint.mColorFilter;
        this.mShader = paint.mShader;
        this.mPathEffect = paint.mPathEffect;
        this.mMaskFilter = paint.mMaskFilter;
        this.mRasterizer = paint.mRasterizer;
        this.mHintingMode = paint.mHintingMode;
        this.updateFontObject();
    }

    private void reset() {
        this.mFlags = 1280;
        this.mColor = -16777216;
        this.mStyle = Paint.Style.FILL.nativeInt;
        this.mCap = Paint.Cap.BUTT.nativeInt;
        this.mJoin = Paint.Join.MITER.nativeInt;
        this.mTextAlign = 0;
        this.mTypeface = Typeface_Delegate.getDelegate(Typeface.sDefaults[0].native_instance);
        this.mNativeTypeface = 0L;
        this.mStrokeWidth = 1.0f;
        this.mStrokeMiter = 4.0f;
        this.mTextSize = 20.0f;
        this.mTextScaleX = 1.0f;
        this.mTextSkewX = 0.0f;
        this.mXfermode = null;
        this.mColorFilter = null;
        this.mShader = null;
        this.mPathEffect = null;
        this.mMaskFilter = null;
        this.mRasterizer = null;
        this.updateFontObject();
        this.mHintingMode = 1;
    }

    private void updateFontObject() {
        if (this.mTypeface != null) {
            List<Font> fonts = this.mTypeface.getFonts(this.mFontVariant);
            ArrayList<FontInfo> infoList = new ArrayList<FontInfo>(fonts.size());
            for (Font font : fonts) {
                if (font == null) {
                    infoList.add(null);
                    continue;
                }
                FontInfo info = new FontInfo();
                info.mFont = font.deriveFont(this.mTextSize);
                if ((double)this.mTextScaleX != 1.0 || this.mTextSkewX != 0.0f) {
                    info.mFont = info.mFont.deriveFont(new AffineTransform(this.mTextScaleX, this.mTextSkewX, 0.0f, 1.0f, 0.0f, 0.0f));
                }
                info.mMetrics = Toolkit.getDefaultToolkit().getFontMetrics(info.mFont);
                infoList.add(info);
            }
            this.mFonts = Collections.unmodifiableList(infoList);
        }
    }

    RectF measureText(char[] text, int index, int count, float[] advances, int advancesIndex, int bidiFlags) {
        return new BidiRenderer(null, this, text).renderText(index, index + count, bidiFlags, advances, advancesIndex, false);
    }

    RectF measureText(char[] text, int index, int count, float[] advances, int advancesIndex, boolean isRtl) {
        return new BidiRenderer(null, this, text).renderText(index, index + count, isRtl, advances, advancesIndex, false);
    }

    private float getFontMetrics(Paint.FontMetrics metrics) {
        if (this.mFonts.size() > 0) {
            FontMetrics javaMetrics = this.mFonts.get((int)0).mMetrics;
            if (metrics != null) {
                metrics.top = -javaMetrics.getMaxAscent();
                metrics.ascent = -javaMetrics.getAscent();
                metrics.descent = javaMetrics.getDescent();
                metrics.bottom = javaMetrics.getMaxDescent();
                metrics.leading = javaMetrics.getLeading();
            }
            return javaMetrics.getHeight();
        }
        return 0.0f;
    }

    private void setTextLocale(String locale) {
        this.mLocale = new Locale(locale);
    }

    private static void setFlag(Paint thisPaint, int flagMask, boolean flagValue) {
        Paint_Delegate delegate = sManager.getDelegate(thisPaint.mNativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mFlags = flagValue ? (delegate.mFlags |= flagMask) : (delegate.mFlags &= ~flagMask);
    }

    static final class FontInfo {
        Font mFont;
        FontMetrics mMetrics;

        FontInfo() {
        }
    }
}

