/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.os.SystemClock;
import com.android.tools.layoutlib.create.OverrideMethod;

public class Interpolator {
    private int mValueCount;
    private int mFrameCount;
    private final long native_instance;

    public Interpolator(int valueCount) {
        this.mValueCount = valueCount;
        this.mFrameCount = 2;
        this.native_instance = Interpolator.nativeConstructor(valueCount, 2);
    }

    public Interpolator(int valueCount, int frameCount) {
        this.mValueCount = valueCount;
        this.mFrameCount = frameCount;
        this.native_instance = Interpolator.nativeConstructor(valueCount, frameCount);
    }

    public void reset(int valueCount) {
        this.reset(valueCount, 2);
    }

    public void reset(int valueCount, int frameCount) {
        this.mValueCount = valueCount;
        this.mFrameCount = frameCount;
        Interpolator.nativeReset(this.native_instance, valueCount, frameCount);
    }

    public int getKeyFrameCount() {
        return this.mFrameCount;
    }

    public int getValueCount() {
        return this.mValueCount;
    }

    public void setKeyFrame(int index, int msec, float[] values) {
        this.setKeyFrame(index, msec, values, null);
    }

    public void setKeyFrame(int index, int msec, float[] values, float[] blend) {
        if (index < 0 || index >= this.mFrameCount) {
            throw new IndexOutOfBoundsException();
        }
        if (values.length < this.mValueCount) {
            throw new ArrayStoreException();
        }
        if (blend != null && blend.length < 4) {
            throw new ArrayStoreException();
        }
        Interpolator.nativeSetKeyFrame(this.native_instance, index, msec, values, blend);
    }

    public void setRepeatMirror(float repeatCount, boolean mirror) {
        if (repeatCount >= 0.0f) {
            Interpolator.nativeSetRepeatMirror(this.native_instance, repeatCount, mirror);
        }
    }

    public Result timeToValues(float[] values) {
        return this.timeToValues((int)SystemClock.uptimeMillis(), values);
    }

    public Result timeToValues(int msec, float[] values) {
        if (values != null && values.length < this.mValueCount) {
            throw new ArrayStoreException();
        }
        switch (Interpolator.nativeTimeToValues(this.native_instance, msec, values)) {
            case 0: {
                return Result.NORMAL;
            }
            case 1: {
                return Result.FREEZE_START;
            }
        }
        return Result.FREEZE_END;
    }

    protected void finalize() throws Throwable {
        Interpolator.nativeDestructor(this.native_instance);
    }

    private static long nativeConstructor(int n, int n2) {
        return OverrideMethod.invokeL("android.graphics.Interpolator#nativeConstructor(II)J", true, null);
    }

    private static void nativeDestructor(long l) {
        OverrideMethod.invokeV("android.graphics.Interpolator#nativeDestructor(J)V", true, null);
    }

    private static void nativeReset(long l, int n, int n2) {
        OverrideMethod.invokeV("android.graphics.Interpolator#nativeReset(JII)V", true, null);
    }

    private static void nativeSetKeyFrame(long l, int n, int n2, float[] fArray, float[] fArray2) {
        OverrideMethod.invokeV("android.graphics.Interpolator#nativeSetKeyFrame(JII[F[F)V", true, null);
    }

    private static void nativeSetRepeatMirror(long l, float f, boolean bl) {
        OverrideMethod.invokeV("android.graphics.Interpolator#nativeSetRepeatMirror(JFZ)V", true, null);
    }

    private static int nativeTimeToValues(long l, int n, float[] fArray) {
        return OverrideMethod.invokeI("android.graphics.Interpolator#nativeTimeToValues(JI[F)I", true, null);
    }

    public static enum Result {
        NORMAL,
        FREEZE_START,
        FREEZE_END;

    }
}

