/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;

public class FontFamily_Delegate {
    public static final int DEFAULT_FONT_WEIGHT = 400;
    public static final int BOLD_FONT_WEIGHT_DELTA = 300;
    public static final int BOLD_FONT_WEIGHT = 700;
    private static final String FONT_SUFFIX_ITALIC = "Italic.ttf";
    private static final String FN_ALL_FONTS_LIST = "fontsInSdk.txt";
    private static final DelegateManager<FontFamily_Delegate> sManager = new DelegateManager<FontFamily_Delegate>(FontFamily_Delegate.class);
    private static String sFontLocation;
    private static final List<FontFamily_Delegate> sPostInitDelegate;
    private static Set<String> SDK_FONTS;
    private List<FontInfo> mFonts = new ArrayList<FontInfo>();
    private FontVariant mVariant;
    private List<Runnable> mPostInitRunnables = new ArrayList<Runnable>();
    private boolean mValid = false;

    public static FontFamily_Delegate getDelegate(long nativeFontFamily) {
        return sManager.getDelegate(nativeFontFamily);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setFontLocation(String fontLocation) {
        sFontLocation = fontLocation;
        File allFonts = new File(fontLocation, FN_ALL_FONTS_LIST);
        HashSet<String> allFontsList = new HashSet<String>(128);
        Scanner scanner = null;
        try {
            scanner = new Scanner(allFonts);
            while (scanner.hasNext()) {
                String name = scanner.next();
                if (name.endsWith(".xml")) continue;
                allFontsList.add(name);
            }
        }
        catch (FileNotFoundException e) {
            Bridge.getLog().error("broken", "Unable to load the list of fonts. Try re-installing the SDK Platform from the SDK Manager.", (Throwable)e, null);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        SDK_FONTS = Collections.unmodifiableSet(allFontsList);
        for (FontFamily_Delegate fontFamily : sPostInitDelegate) {
            fontFamily.init();
        }
        sPostInitDelegate.clear();
    }

    @Nullable
    public Font getFont(int desiredWeight, boolean isItalic) {
        FontInfo desiredStyle = new FontInfo();
        desiredStyle.mWeight = desiredWeight;
        desiredStyle.mIsItalic = isItalic;
        FontInfo bestFont = null;
        int bestMatch = Integer.MAX_VALUE;
        for (FontInfo font : this.mFonts) {
            int match = FontFamily_Delegate.computeMatch(font, desiredStyle);
            if (match >= bestMatch) continue;
            bestMatch = match;
            bestFont = font;
        }
        if (bestFont == null) {
            return null;
        }
        if (bestMatch == 0) {
            return bestFont.mFont;
        }
        this.deriveFont(bestFont, desiredStyle);
        this.addFont(desiredStyle);
        return desiredStyle.mFont;
    }

    public FontVariant getVariant() {
        return this.mVariant;
    }

    public boolean isValid() {
        return this.mValid;
    }

    static Font loadFont(String path) {
        if (path.startsWith("/system/fonts/")) {
            String relativePath = path.substring("/system/fonts/".length());
            File f = new File(sFontLocation, relativePath);
            try {
                return Font.createFont(0, f);
            }
            catch (Exception e) {
                if (path.endsWith(".otf") && e instanceof FontFormatException) {
                    return null;
                }
                Bridge.getLog().fidelityWarning("broken", String.format("Unable to load font %1$s", relativePath), (Throwable)e, null);
            }
        } else {
            Bridge.getLog().fidelityWarning("unsupported", "Only platform fonts located in /system/fonts/can be loaded.", null, null);
        }
        return null;
    }

    @Nullable
    static String getFontLocation() {
        return sFontLocation;
    }

    @LayoutlibDelegate
    static long nCreateFamily(String lang, int variant) {
        FontFamily_Delegate delegate = new FontFamily_Delegate();
        assert (variant < 3);
        delegate.mVariant = FontVariant.values()[variant];
        if (sFontLocation != null) {
            delegate.init();
        } else {
            sPostInitDelegate.add(delegate);
        }
        return sManager.addNewDelegate(delegate);
    }

    @LayoutlibDelegate
    static void nUnrefFamily(long nativePtr) {
        sManager.removeJavaReferenceFor(nativePtr);
    }

    @LayoutlibDelegate
    static boolean nAddFont(long nativeFamily, final String path) {
        final FontFamily_Delegate delegate = FontFamily_Delegate.getDelegate(nativeFamily);
        if (delegate != null) {
            if (sFontLocation == null) {
                delegate.mPostInitRunnables.add(new Runnable(){

                    @Override
                    public void run() {
                        delegate.addFont(path);
                    }
                });
                return true;
            }
            return delegate.addFont(path);
        }
        return false;
    }

    @LayoutlibDelegate
    static boolean nAddFontWeightStyle(long nativeFamily, final String path, final int weight, final boolean isItalic) {
        final FontFamily_Delegate delegate = FontFamily_Delegate.getDelegate(nativeFamily);
        if (delegate != null) {
            if (sFontLocation == null) {
                delegate.mPostInitRunnables.add(new Runnable(){

                    @Override
                    public void run() {
                        delegate.addFont(path, weight, isItalic);
                    }
                });
                return true;
            }
            return delegate.addFont(path, weight, isItalic);
        }
        return false;
    }

    @LayoutlibDelegate
    static boolean nAddFontFromAsset(long nativeFamily, AssetManager mgr, String path) {
        Bridge.getLog().fidelityWarning("unsupported", "Typeface.createFromAsset is not supported.", null, null);
        return false;
    }

    private void init() {
        for (Runnable postInitRunnable : this.mPostInitRunnables) {
            postInitRunnable.run();
        }
        this.mPostInitRunnables = null;
    }

    private boolean addFont(@NonNull String path) {
        return this.addFont(path, 400, path.endsWith(FONT_SUFFIX_ITALIC));
    }

    private boolean addFont(@NonNull String path, int weight, boolean isItalic) {
        if (path.startsWith("/system/fonts/") && !SDK_FONTS.contains(path.substring("/system/fonts/".length()))) {
            this.mValid = false;
            return false;
        }
        this.mValid = true;
        Font font = FontFamily_Delegate.loadFont(path);
        if (font == null) {
            return false;
        }
        FontInfo fontInfo = new FontInfo();
        fontInfo.mFont = font;
        fontInfo.mWeight = weight;
        fontInfo.mIsItalic = isItalic;
        this.addFont(fontInfo);
        return true;
    }

    private boolean addFont(@NonNull FontInfo fontInfo) {
        int weight = fontInfo.mWeight;
        boolean isItalic = fontInfo.mIsItalic;
        for (FontInfo font : this.mFonts) {
            if (font.mWeight != weight || font.mIsItalic != isItalic) continue;
            return false;
        }
        this.mFonts.add(fontInfo);
        return true;
    }

    private static int computeMatch(@NonNull FontInfo font1, @NonNull FontInfo font2) {
        int score = Math.abs(font1.mWeight - font2.mWeight);
        if (font1.mIsItalic != font2.mIsItalic) {
            score += 200;
        }
        return score;
    }

    @NonNull
    private FontInfo deriveFont(@NonNull FontInfo srcFont, @NonNull FontInfo outFont) {
        int desiredWeight = outFont.mWeight;
        int srcWeight = srcFont.mWeight;
        Font derivedFont = srcFont.mFont;
        if (desiredWeight >= 700 && desiredWeight - srcWeight > 150) {
            derivedFont = derivedFont.deriveFont(1);
            srcWeight += 300;
        }
        if (outFont.mIsItalic && !srcFont.mIsItalic) {
            derivedFont = derivedFont.deriveFont(2);
        } else if (outFont.mIsItalic != srcFont.mIsItalic) {
            outFont.mIsItalic = srcFont.mIsItalic;
        }
        outFont.mFont = derivedFont;
        outFont.mWeight = srcWeight;
        return outFont;
    }

    static {
        sPostInitDelegate = new ArrayList<FontFamily_Delegate>();
    }

    public static enum FontVariant {
        NONE,
        COMPACT,
        ELEGANT;

    }

    private static final class FontInfo {
        @Nullable
        Font mFont;
        int mWeight;
        boolean mIsItalic;

        private FontInfo() {
        }
    }
}

