/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.FontFamily_Delegate;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class FontFamily {
    public long mNativePtr;

    public FontFamily() {
        this.mNativePtr = FontFamily.nCreateFamily(null, 0);
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("error creating native FontFamily");
        }
    }

    public FontFamily(String lang, String variant) {
        int varEnum = 0;
        if ("compact".equals(variant)) {
            varEnum = 1;
        } else if ("elegant".equals(variant)) {
            varEnum = 2;
        }
        this.mNativePtr = FontFamily.nCreateFamily(lang, varEnum);
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("error creating native FontFamily");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            FontFamily.nUnrefFamily(this.mNativePtr);
        }
        finally {
            super.finalize();
        }
    }

    public boolean addFont(String path) {
        return FontFamily.nAddFont(this.mNativePtr, path);
    }

    public boolean addFontWeightStyle(String path, int weight, boolean style2) {
        return FontFamily.nAddFontWeightStyle(this.mNativePtr, path, weight, style2);
    }

    public boolean addFontFromAsset(AssetManager mgr, String path) {
        return FontFamily.nAddFontFromAsset(this.mNativePtr, mgr, path);
    }

    @LayoutlibDelegate
    private static long nCreateFamily(String string2, int n) {
        return FontFamily_Delegate.nCreateFamily(string2, n);
    }

    @LayoutlibDelegate
    private static void nUnrefFamily(long l) {
        FontFamily_Delegate.nUnrefFamily(l);
    }

    @LayoutlibDelegate
    private static boolean nAddFont(long l, String string2) {
        return FontFamily_Delegate.nAddFont(l, string2);
    }

    @LayoutlibDelegate
    private static boolean nAddFontWeightStyle(long l, String string2, int n, boolean bl) {
        return FontFamily_Delegate.nAddFontWeightStyle(l, string2, n, bl);
    }

    @LayoutlibDelegate
    private static boolean nAddFontFromAsset(long l, AssetManager assetManager, String string2) {
        return FontFamily_Delegate.nAddFontFromAsset(l, assetManager, string2);
    }
}

