/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.Resources;
import android.graphics.Color;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.MathUtils;
import android.util.SparseArray;
import android.util.StateSet;
import android.util.Xml;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorStateList
implements Parcelable {
    private int[][] mStateSpecs;
    private int[] mColors;
    private int mDefaultColor = -65536;
    private static final int[][] EMPTY = new int[][]{new int[0]};
    private static final SparseArray<WeakReference<ColorStateList>> sCache = new SparseArray();
    public static final Parcelable.Creator<ColorStateList> CREATOR = new Parcelable.Creator<ColorStateList>(){

        public ColorStateList[] newArray(int size) {
            return new ColorStateList[size];
        }

        @Override
        public ColorStateList createFromParcel(Parcel source) {
            int N = source.readInt();
            int[][] stateSpecs = new int[N][];
            for (int i = 0; i < N; ++i) {
                stateSpecs[i] = source.createIntArray();
            }
            int[] colors = source.createIntArray();
            return new ColorStateList(stateSpecs, colors);
        }
    };

    private ColorStateList() {
    }

    public ColorStateList(int[][] states, int[] colors) {
        this.mStateSpecs = states;
        this.mColors = colors;
        if (states.length > 0) {
            this.mDefaultColor = colors[0];
            for (int i = 0; i < states.length; ++i) {
                if (states[i].length != 0) continue;
                this.mDefaultColor = colors[i];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorStateList valueOf(int color2) {
        SparseArray<WeakReference<ColorStateList>> sparseArray = sCache;
        synchronized (sparseArray) {
            ColorStateList csl;
            WeakReference<ColorStateList> ref = sCache.get(color2);
            ColorStateList colorStateList = csl = ref != null ? (ColorStateList)ref.get() : null;
            if (csl != null) {
                return csl;
            }
            csl = new ColorStateList(EMPTY, new int[]{color2});
            sCache.put(color2, new WeakReference<ColorStateList>(csl));
            return csl;
        }
    }

    public static ColorStateList createFromXml(Resources r, XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        AttributeSet attrs = Xml.asAttributeSet(parser);
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        return ColorStateList.createFromXmlInner(r, parser, attrs);
    }

    private static ColorStateList createFromXmlInner(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        String name = parser.getName();
        if (!name.equals("selector")) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": invalid drawable tag " + name);
        }
        ColorStateList colorStateList = new ColorStateList();
        colorStateList.inflate(r, parser, attrs);
        return colorStateList;
    }

    public ColorStateList withAlpha(int alpha) {
        int[] colors = new int[this.mColors.length];
        int len = colors.length;
        for (int i = 0; i < len; ++i) {
            colors[i] = this.mColors[i] & 0xFFFFFF | alpha << 24;
        }
        return new ColorStateList(this.mStateSpecs, colors);
    }

    private void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        int[][] stateSpecList = ArrayUtils.newUnpaddedArray(int[].class, 20);
        int[] colorList = new int[stateSpecList.length];
        int listSize = 0;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            int stateResId;
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            int alphaRes = 0;
            float alpha = 1.0f;
            int colorRes = 0;
            int color2 = -65536;
            boolean haveColor = false;
            int j = 0;
            int numAttrs = attrs.getAttributeCount();
            int[] stateSpec = new int[numAttrs];
            for (int i = 0; i < numAttrs && (stateResId = attrs.getAttributeNameResource(i)) != 0; ++i) {
                if (stateResId == 16843551) {
                    alphaRes = attrs.getAttributeResourceValue(i, 0);
                    if (alphaRes != 0) continue;
                    alpha = attrs.getAttributeFloatValue(i, 1.0f);
                    continue;
                }
                if (stateResId == 16843173) {
                    colorRes = attrs.getAttributeResourceValue(i, 0);
                    if (colorRes != 0) continue;
                    color2 = attrs.getAttributeIntValue(i, color2);
                    haveColor = true;
                    continue;
                }
                stateSpec[j++] = attrs.getAttributeBooleanValue(i, false) ? stateResId : -stateResId;
            }
            stateSpec = StateSet.trimStateSet(stateSpec, j);
            if (colorRes != 0) {
                color2 = r.getColor(colorRes);
            } else if (!haveColor) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'android:color' attribute.");
            }
            if (alphaRes != 0) {
                alpha = r.getFloat(alphaRes);
            }
            int alphaMod = MathUtils.constrain((int)((float)Color.alpha(color2) * alpha), 0, 255);
            color2 = color2 & 0xFFFFFF | alphaMod << 24;
            if (listSize == 0 || stateSpec.length == 0) {
                this.mDefaultColor = color2;
            }
            colorList = GrowingArrayUtils.append(colorList, listSize, color2);
            stateSpecList = GrowingArrayUtils.append(stateSpecList, listSize, stateSpec);
            ++listSize;
        }
        this.mColors = new int[listSize];
        this.mStateSpecs = new int[listSize][];
        System.arraycopy(colorList, 0, this.mColors, 0, listSize);
        System.arraycopy(stateSpecList, 0, this.mStateSpecs, 0, listSize);
    }

    public boolean isStateful() {
        return this.mStateSpecs.length > 1;
    }

    public boolean isOpaque() {
        int n = this.mColors.length;
        for (int i = 0; i < n; ++i) {
            if (Color.alpha(this.mColors[i]) == 255) continue;
            return false;
        }
        return true;
    }

    public int getColorForState(int[] stateSet, int defaultColor) {
        int setLength = this.mStateSpecs.length;
        for (int i = 0; i < setLength; ++i) {
            int[] stateSpec = this.mStateSpecs[i];
            if (!StateSet.stateSetMatches(stateSpec, stateSet)) continue;
            return this.mColors[i];
        }
        return defaultColor;
    }

    public int getDefaultColor() {
        return this.mDefaultColor;
    }

    public int[][] getStates() {
        return this.mStateSpecs;
    }

    public int[] getColors() {
        return this.mColors;
    }

    public static ColorStateList addFirstIfMissing(ColorStateList colorStateList, int state, int color2) {
        int[][] inputStates = colorStateList.getStates();
        for (int i = 0; i < inputStates.length; ++i) {
            int[] inputState = inputStates[i];
            for (int j = 0; j < inputState.length; ++j) {
                if (inputState[i] != state) continue;
                return colorStateList;
            }
        }
        int[][] outputStates = new int[inputStates.length + 1][];
        System.arraycopy(inputStates, 0, outputStates, 1, inputStates.length);
        outputStates[0] = new int[]{state};
        int[] inputColors = colorStateList.getColors();
        int[] outputColors = new int[inputColors.length + 1];
        System.arraycopy(inputColors, 0, outputColors, 1, inputColors.length);
        outputColors[0] = color2;
        return new ColorStateList(outputStates, outputColors);
    }

    public String toString() {
        return "ColorStateList{mStateSpecs=" + Arrays.deepToString((Object[])this.mStateSpecs) + "mColors=" + Arrays.toString(this.mColors) + "mDefaultColor=" + this.mDefaultColor + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int N = this.mStateSpecs.length;
        dest.writeInt(N);
        for (int i = 0; i < N; ++i) {
            dest.writeIntArray(this.mStateSpecs[i]);
        }
        dest.writeIntArray(this.mColors);
    }
}

