/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.content.pm.XmlSerializerAndParser;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Environment;
import android.os.Handler;
import android.os.UserHandle;
import android.util.AtomicFile;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.FastXmlSerializer;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class RegisteredServicesCache<V> {
    private static final String TAG = "PackageManager";
    private static final boolean DEBUG = false;
    public final Context mContext;
    private final String mInterfaceName;
    private final String mMetaDataName;
    private final String mAttributesName;
    private final XmlSerializerAndParser<V> mSerializerAndParser;
    private final Object mServicesLock = new Object();
    @GuardedBy(value="mServicesLock")
    private boolean mPersistentServicesFileDidNotExist;
    @GuardedBy(value="mServicesLock")
    private final SparseArray<UserServices<V>> mUserServices = new SparseArray(2);
    private final AtomicFile mPersistentServicesFile;
    private RegisteredServicesCacheListener<V> mListener;
    private Handler mHandler;
    private final BroadcastReceiver mPackageReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            if (uid != -1) {
                RegisteredServicesCache.this.handlePackageEvent(intent, UserHandle.getUserId(uid));
            }
        }
    };
    private final BroadcastReceiver mExternalReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            RegisteredServicesCache.this.handlePackageEvent(intent, 0);
        }
    };

    private UserServices<V> findOrCreateUserLocked(int userId) {
        UserServices<V> services = this.mUserServices.get(userId);
        if (services == null) {
            services = new UserServices();
            this.mUserServices.put(userId, services);
        }
        return services;
    }

    public RegisteredServicesCache(Context context, String interfaceName, String metaDataName, String attributeName, XmlSerializerAndParser<V> serializerAndParser) {
        this.mContext = context;
        this.mInterfaceName = interfaceName;
        this.mMetaDataName = metaDataName;
        this.mAttributesName = attributeName;
        this.mSerializerAndParser = serializerAndParser;
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        File syncDir = new File(systemDir, "registered_services");
        this.mPersistentServicesFile = new AtomicFile(new File(syncDir, interfaceName + ".xml"));
        this.readPersistentServicesLocked();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mPackageReceiver, UserHandle.ALL, intentFilter, null, null);
        IntentFilter sdFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(this.mExternalReceiver, sdFilter);
    }

    private void handlePackageEvent(Intent intent, int userId) {
        String action = intent.getAction();
        boolean isRemoval = "android.intent.action.PACKAGE_REMOVED".equals(action) || "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action);
        boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
        if (!isRemoval || !replacing) {
            this.generateServicesMap(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            user.services = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter fout, String[] args, int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services != null) {
                fout.println("RegisteredServicesCache: " + user.services.size() + " services");
                for (ServiceInfo info : user.services.values()) {
                    fout.println("  " + info);
                }
            } else {
                fout.println("RegisteredServicesCache: services not loaded");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredServicesCacheListener<V> getListener() {
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            return this.mListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(RegisteredServicesCacheListener<V> listener, Handler handler) {
        if (handler == null) {
            handler = new Handler(this.mContext.getMainLooper());
        }
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            this.mHandler = handler;
            this.mListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener(final V type, final int userId, final boolean removed) {
        Handler handler;
        RegisteredServicesCacheListener<V> listener;
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            listener = this.mListener;
            handler = this.mHandler;
        }
        if (listener == null) {
            return;
        }
        final RegisteredServicesCacheListener<V> listener2 = listener;
        handler.post(new Runnable(){

            @Override
            public void run() {
                listener2.onServiceChanged(type, userId, removed);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo<V> getServiceInfo(V type, int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services == null) {
                this.generateServicesMap(userId);
            }
            return user.services.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ServiceInfo<V>> getAllServices(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services == null) {
                this.generateServicesMap(userId);
            }
            return Collections.unmodifiableCollection(new ArrayList(user.services.values()));
        }
    }

    private boolean inSystemImage(int callerUid) {
        String[] packages;
        for (String name : packages = this.mContext.getPackageManager().getPackagesForUid(callerUid)) {
            try {
                PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo(name, 0);
                if ((packageInfo.applicationInfo.flags & 1) == 0) continue;
                return true;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateServicesMap(int userId) {
        PackageManager pm = this.mContext.getPackageManager();
        ArrayList<ServiceInfo<V>> serviceInfos = new ArrayList<ServiceInfo<V>>();
        List<ResolveInfo> resolveInfos = pm.queryIntentServicesAsUser(new Intent(this.mInterfaceName), 128, userId);
        for (ResolveInfo resolveInfo : resolveInfos) {
            try {
                ServiceInfo<V> info = this.parseServiceInfo(resolveInfo);
                if (info == null) {
                    Log.w(TAG, "Unable to load service info " + resolveInfo.toString());
                    continue;
                }
                serviceInfos.add(info);
            }
            catch (XmlPullParserException e) {
                Log.w(TAG, "Unable to load service info " + resolveInfo.toString(), e);
            }
            catch (IOException e) {
                Log.w(TAG, "Unable to load service info " + resolveInfo.toString(), e);
            }
        }
        Object object = this.mServicesLock;
        synchronized (object) {
            boolean firstScan;
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            boolean bl = firstScan = user.services == null;
            if (firstScan) {
                user.services = Maps.newHashMap();
            } else {
                user.services.clear();
            }
            StringBuilder changes = new StringBuilder();
            boolean changed = false;
            for (ServiceInfo serviceInfo : serviceInfos) {
                Integer previousUid = user.persistentServices.get(serviceInfo.type);
                if (previousUid == null) {
                    changed = true;
                    user.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    user.persistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                    if (this.mPersistentServicesFileDidNotExist && firstScan) continue;
                    this.notifyListener(serviceInfo.type, userId, false);
                    continue;
                }
                if (previousUid == serviceInfo.uid) {
                    user.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    continue;
                }
                if (!this.inSystemImage(serviceInfo.uid) && this.containsTypeAndUid(serviceInfos, serviceInfo.type, previousUid)) continue;
                changed = true;
                user.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                user.persistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                this.notifyListener(serviceInfo.type, userId, false);
            }
            ArrayList toBeRemoved = Lists.newArrayList();
            for (Object v1 : user.persistentServices.keySet()) {
                if (this.containsType(serviceInfos, v1)) continue;
                toBeRemoved.add(v1);
            }
            for (Object v1 : toBeRemoved) {
                changed = true;
                user.persistentServices.remove(v1);
                this.notifyListener(v1, userId, true);
            }
            if (changed) {
                this.writePersistentServicesLocked();
            }
        }
    }

    private boolean containsType(ArrayList<ServiceInfo<V>> serviceInfos, V type) {
        int N = serviceInfos.size();
        for (int i = 0; i < N; ++i) {
            if (!serviceInfos.get((int)i).type.equals(type)) continue;
            return true;
        }
        return false;
    }

    private boolean containsTypeAndUid(ArrayList<ServiceInfo<V>> serviceInfos, V type, int uid) {
        int N = serviceInfos.size();
        for (int i = 0; i < N; ++i) {
            ServiceInfo<V> serviceInfo = serviceInfos.get(i);
            if (!serviceInfo.type.equals(type) || serviceInfo.uid != uid) continue;
            return true;
        }
        return false;
    }

    private ServiceInfo<V> parseServiceInfo(ResolveInfo service) throws XmlPullParserException, IOException {
        android.content.pm.ServiceInfo si = service.serviceInfo;
        ComponentName componentName = new ComponentName(si.packageName, si.name);
        PackageManager pm = this.mContext.getPackageManager();
        XmlResourceParser parser = null;
        try {
            int type;
            parser = si.loadXmlMetaData(pm, this.mMetaDataName);
            if (parser == null) {
                throw new XmlPullParserException("No " + this.mMetaDataName + " meta-data");
            }
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!this.mAttributesName.equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with " + this.mAttributesName + " tag");
            }
            V v = this.parseServiceAttributes(pm.getResourcesForApplication(si.applicationInfo), si.packageName, attrs);
            if (v == null) {
                ServiceInfo<V> serviceInfo = null;
                return serviceInfo;
            }
            android.content.pm.ServiceInfo serviceInfo = service.serviceInfo;
            ApplicationInfo applicationInfo = serviceInfo.applicationInfo;
            int uid = applicationInfo.uid;
            ServiceInfo<V> serviceInfo2 = new ServiceInfo<V>(v, componentName, uid);
            return serviceInfo2;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new XmlPullParserException("Unable to load resources for pacakge " + si.packageName);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPersistentServicesLocked() {
        block20: {
            this.mUserServices.clear();
            if (this.mSerializerAndParser == null) {
                return;
            }
            FileInputStream fis = null;
            try {
                boolean bl = this.mPersistentServicesFileDidNotExist = !this.mPersistentServicesFile.getBaseFile().exists();
                if (this.mPersistentServicesFileDidNotExist) {
                    return;
                }
                fis = this.mPersistentServicesFile.openRead();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(fis, null);
                int eventType = parser.getEventType();
                while (eventType != 2 && eventType != 1) {
                    eventType = parser.next();
                }
                String tagName = parser.getName();
                if (!"services".equals(tagName)) break block20;
                eventType = parser.next();
                do {
                    if (eventType != 2 || parser.getDepth() != 2 || !"service".equals(tagName = parser.getName())) continue;
                    V service = this.mSerializerAndParser.createFromXml(parser);
                    if (service == null) {
                        break;
                    }
                    String uidString = parser.getAttributeValue(null, "uid");
                    int uid = Integer.parseInt(uidString);
                    int userId = UserHandle.getUserId(uid);
                    UserServices<V> user = this.findOrCreateUserLocked(userId);
                    user.persistentServices.put((Integer)service, uid);
                } while ((eventType = parser.next()) != 1);
            }
            catch (Exception e) {
                Log.w(TAG, "Error reading persistent services, starting from scratch", e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void writePersistentServicesLocked() {
        block5: {
            if (this.mSerializerAndParser == null) {
                return;
            }
            FileOutputStream fos = null;
            try {
                fos = this.mPersistentServicesFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, "utf-8");
                out.startDocument(null, true);
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, "services");
                for (int i = 0; i < this.mUserServices.size(); ++i) {
                    UserServices<V> user = this.mUserServices.valueAt(i);
                    for (Map.Entry service : user.persistentServices.entrySet()) {
                        out.startTag(null, "service");
                        out.attribute(null, "uid", Integer.toString(service.getValue()));
                        this.mSerializerAndParser.writeAsXml(service.getKey(), out);
                        out.endTag(null, "service");
                    }
                }
                out.endTag(null, "services");
                out.endDocument();
                this.mPersistentServicesFile.finishWrite(fos);
            }
            catch (IOException e1) {
                Log.w(TAG, "Error writing accounts", e1);
                if (fos == null) break block5;
                this.mPersistentServicesFile.failWrite(fos);
            }
        }
    }

    public abstract V parseServiceAttributes(Resources var1, String var2, AttributeSet var3);

    public static class ServiceInfo<V> {
        public final V type;
        public final ComponentName componentName;
        public final int uid;

        public ServiceInfo(V type, ComponentName componentName, int uid) {
            this.type = type;
            this.componentName = componentName;
            this.uid = uid;
        }

        public String toString() {
            return "ServiceInfo: " + this.type + ", " + this.componentName + ", uid " + this.uid;
        }
    }

    private static class UserServices<V> {
        @GuardedBy(value="mServicesLock")
        public final Map<V, Integer> persistentServices = Maps.newHashMap();
        @GuardedBy(value="mServicesLock")
        public Map<V, ServiceInfo<V>> services = null;

        private UserServices() {
        }
    }
}

