/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PatternMatcher;
import android.util.AndroidException;
import android.util.Log;
import android.util.Printer;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class IntentFilter
implements Parcelable {
    private static final String SGLOB_STR = "sglob";
    private static final String PREFIX_STR = "prefix";
    private static final String LITERAL_STR = "literal";
    private static final String PATH_STR = "path";
    private static final String PORT_STR = "port";
    private static final String HOST_STR = "host";
    private static final String AUTH_STR = "auth";
    private static final String SSP_STR = "ssp";
    private static final String SCHEME_STR = "scheme";
    private static final String TYPE_STR = "type";
    private static final String CAT_STR = "cat";
    private static final String NAME_STR = "name";
    private static final String ACTION_STR = "action";
    public static final int SYSTEM_HIGH_PRIORITY = 1000;
    public static final int SYSTEM_LOW_PRIORITY = -1000;
    public static final int MATCH_CATEGORY_MASK = 0xFFF0000;
    public static final int MATCH_ADJUSTMENT_MASK = 65535;
    public static final int MATCH_ADJUSTMENT_NORMAL = 32768;
    public static final int MATCH_CATEGORY_EMPTY = 0x100000;
    public static final int MATCH_CATEGORY_SCHEME = 0x200000;
    public static final int MATCH_CATEGORY_HOST = 0x300000;
    public static final int MATCH_CATEGORY_PORT = 0x400000;
    public static final int MATCH_CATEGORY_PATH = 0x500000;
    public static final int MATCH_CATEGORY_SCHEME_SPECIFIC_PART = 0x580000;
    public static final int MATCH_CATEGORY_TYPE = 0x600000;
    public static final int NO_MATCH_TYPE = -1;
    public static final int NO_MATCH_DATA = -2;
    public static final int NO_MATCH_ACTION = -3;
    public static final int NO_MATCH_CATEGORY = -4;
    private int mPriority;
    private final ArrayList<String> mActions;
    private ArrayList<String> mCategories = null;
    private ArrayList<String> mDataSchemes = null;
    private ArrayList<PatternMatcher> mDataSchemeSpecificParts = null;
    private ArrayList<AuthorityEntry> mDataAuthorities = null;
    private ArrayList<PatternMatcher> mDataPaths = null;
    private ArrayList<String> mDataTypes = null;
    private boolean mHasPartialTypes = false;
    public static final Parcelable.Creator<IntentFilter> CREATOR = new Parcelable.Creator<IntentFilter>(){

        @Override
        public IntentFilter createFromParcel(Parcel source) {
            return new IntentFilter(source);
        }

        public IntentFilter[] newArray(int size) {
            return new IntentFilter[size];
        }
    };

    private static int findStringInSet(String[] set, String string2, int[] lengths, int lenPos) {
        if (set == null) {
            return -1;
        }
        int N = lengths[lenPos];
        for (int i = 0; i < N; ++i) {
            if (!set[i].equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private static String[] addStringToSet(String[] set, String string2, int[] lengths, int lenPos) {
        if (IntentFilter.findStringInSet(set, string2, lengths, lenPos) >= 0) {
            return set;
        }
        if (set == null) {
            set = new String[2];
            set[0] = string2;
            lengths[lenPos] = 1;
            return set;
        }
        int N = lengths[lenPos];
        if (N < set.length) {
            set[N] = string2;
            lengths[lenPos] = N + 1;
            return set;
        }
        String[] newSet = new String[N * 3 / 2 + 2];
        System.arraycopy(set, 0, newSet, 0, N);
        set = newSet;
        set[N] = string2;
        lengths[lenPos] = N + 1;
        return set;
    }

    private static String[] removeStringFromSet(String[] set, String string2, int[] lengths, int lenPos) {
        int pos = IntentFilter.findStringInSet(set, string2, lengths, lenPos);
        if (pos < 0) {
            return set;
        }
        int N = lengths[lenPos];
        if (N > set.length / 4) {
            int copyLen = N - (pos + 1);
            if (copyLen > 0) {
                System.arraycopy(set, pos + 1, set, pos, copyLen);
            }
            set[N - 1] = null;
            lengths[lenPos] = N - 1;
            return set;
        }
        String[] newSet = new String[set.length / 3];
        if (pos > 0) {
            System.arraycopy(set, 0, newSet, 0, pos);
        }
        if (pos + 1 < N) {
            System.arraycopy(set, pos + 1, newSet, pos, N - (pos + 1));
        }
        return newSet;
    }

    public static IntentFilter create(String action, String dataType) {
        try {
            return new IntentFilter(action, dataType);
        }
        catch (MalformedMimeTypeException e) {
            throw new RuntimeException("Bad MIME type", e);
        }
    }

    public IntentFilter() {
        this.mPriority = 0;
        this.mActions = new ArrayList();
    }

    public IntentFilter(String action) {
        this.mPriority = 0;
        this.mActions = new ArrayList();
        this.addAction(action);
    }

    public IntentFilter(String action, String dataType) throws MalformedMimeTypeException {
        this.mPriority = 0;
        this.mActions = new ArrayList();
        this.addAction(action);
        this.addDataType(dataType);
    }

    public IntentFilter(IntentFilter o) {
        this.mPriority = o.mPriority;
        this.mActions = new ArrayList<String>(o.mActions);
        if (o.mCategories != null) {
            this.mCategories = new ArrayList<String>(o.mCategories);
        }
        if (o.mDataTypes != null) {
            this.mDataTypes = new ArrayList<String>(o.mDataTypes);
        }
        if (o.mDataSchemes != null) {
            this.mDataSchemes = new ArrayList<String>(o.mDataSchemes);
        }
        if (o.mDataSchemeSpecificParts != null) {
            this.mDataSchemeSpecificParts = new ArrayList<PatternMatcher>(o.mDataSchemeSpecificParts);
        }
        if (o.mDataAuthorities != null) {
            this.mDataAuthorities = new ArrayList<AuthorityEntry>(o.mDataAuthorities);
        }
        if (o.mDataPaths != null) {
            this.mDataPaths = new ArrayList<PatternMatcher>(o.mDataPaths);
        }
        this.mHasPartialTypes = o.mHasPartialTypes;
    }

    public void setPriority(int priority) {
        this.mPriority = priority;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public void addAction(String action) {
        if (!this.mActions.contains(action)) {
            this.mActions.add(action.intern());
        }
    }

    public int countActions() {
        return this.mActions.size();
    }

    public String getAction(int index) {
        return this.mActions.get(index);
    }

    public boolean hasAction(String action) {
        return action != null && this.mActions.contains(action);
    }

    public boolean matchAction(String action) {
        return this.hasAction(action);
    }

    public Iterator<String> actionsIterator() {
        return this.mActions != null ? this.mActions.iterator() : null;
    }

    public void addDataType(String type) throws MalformedMimeTypeException {
        int slashpos = type.indexOf(47);
        int typelen = type.length();
        if (slashpos > 0 && typelen >= slashpos + 2) {
            if (this.mDataTypes == null) {
                this.mDataTypes = new ArrayList();
            }
            if (typelen == slashpos + 2 && type.charAt(slashpos + 1) == '*') {
                String str = type.substring(0, slashpos);
                if (!this.mDataTypes.contains(str)) {
                    this.mDataTypes.add(str.intern());
                }
                this.mHasPartialTypes = true;
            } else if (!this.mDataTypes.contains(type)) {
                this.mDataTypes.add(type.intern());
            }
            return;
        }
        throw new MalformedMimeTypeException(type);
    }

    public boolean hasDataType(String type) {
        return this.mDataTypes != null && this.findMimeType(type);
    }

    public boolean hasExactDataType(String type) {
        return this.mDataTypes != null && this.mDataTypes.contains(type);
    }

    public int countDataTypes() {
        return this.mDataTypes != null ? this.mDataTypes.size() : 0;
    }

    public String getDataType(int index) {
        return this.mDataTypes.get(index);
    }

    public Iterator<String> typesIterator() {
        return this.mDataTypes != null ? this.mDataTypes.iterator() : null;
    }

    public void addDataScheme(String scheme) {
        if (this.mDataSchemes == null) {
            this.mDataSchemes = new ArrayList();
        }
        if (!this.mDataSchemes.contains(scheme)) {
            this.mDataSchemes.add(scheme.intern());
        }
    }

    public int countDataSchemes() {
        return this.mDataSchemes != null ? this.mDataSchemes.size() : 0;
    }

    public String getDataScheme(int index) {
        return this.mDataSchemes.get(index);
    }

    public boolean hasDataScheme(String scheme) {
        return this.mDataSchemes != null && this.mDataSchemes.contains(scheme);
    }

    public Iterator<String> schemesIterator() {
        return this.mDataSchemes != null ? this.mDataSchemes.iterator() : null;
    }

    public void addDataSchemeSpecificPart(String ssp, int type) {
        this.addDataSchemeSpecificPart(new PatternMatcher(ssp, type));
    }

    public void addDataSchemeSpecificPart(PatternMatcher ssp) {
        if (this.mDataSchemeSpecificParts == null) {
            this.mDataSchemeSpecificParts = new ArrayList();
        }
        this.mDataSchemeSpecificParts.add(ssp);
    }

    public int countDataSchemeSpecificParts() {
        return this.mDataSchemeSpecificParts != null ? this.mDataSchemeSpecificParts.size() : 0;
    }

    public PatternMatcher getDataSchemeSpecificPart(int index) {
        return this.mDataSchemeSpecificParts.get(index);
    }

    public boolean hasDataSchemeSpecificPart(String data) {
        if (this.mDataSchemeSpecificParts == null) {
            return false;
        }
        int numDataSchemeSpecificParts = this.mDataSchemeSpecificParts.size();
        for (int i = 0; i < numDataSchemeSpecificParts; ++i) {
            PatternMatcher pe = this.mDataSchemeSpecificParts.get(i);
            if (!pe.match(data)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDataSchemeSpecificPart(PatternMatcher ssp) {
        if (this.mDataSchemeSpecificParts == null) {
            return false;
        }
        int numDataSchemeSpecificParts = this.mDataSchemeSpecificParts.size();
        for (int i = 0; i < numDataSchemeSpecificParts; ++i) {
            PatternMatcher pe = this.mDataSchemeSpecificParts.get(i);
            if (pe.getType() != ssp.getType() || !pe.getPath().equals(ssp.getPath())) continue;
            return true;
        }
        return false;
    }

    public Iterator<PatternMatcher> schemeSpecificPartsIterator() {
        return this.mDataSchemeSpecificParts != null ? this.mDataSchemeSpecificParts.iterator() : null;
    }

    public void addDataAuthority(String host, String port) {
        if (port != null) {
            port = port.intern();
        }
        this.addDataAuthority(new AuthorityEntry(host.intern(), port));
    }

    public void addDataAuthority(AuthorityEntry ent) {
        if (this.mDataAuthorities == null) {
            this.mDataAuthorities = new ArrayList();
        }
        this.mDataAuthorities.add(ent);
    }

    public int countDataAuthorities() {
        return this.mDataAuthorities != null ? this.mDataAuthorities.size() : 0;
    }

    public AuthorityEntry getDataAuthority(int index) {
        return this.mDataAuthorities.get(index);
    }

    public boolean hasDataAuthority(Uri data) {
        return this.matchDataAuthority(data) >= 0;
    }

    public boolean hasDataAuthority(AuthorityEntry auth) {
        if (this.mDataAuthorities == null) {
            return false;
        }
        int numDataAuthorities = this.mDataAuthorities.size();
        for (int i = 0; i < numDataAuthorities; ++i) {
            if (!this.mDataAuthorities.get(i).match(auth)) continue;
            return true;
        }
        return false;
    }

    public Iterator<AuthorityEntry> authoritiesIterator() {
        return this.mDataAuthorities != null ? this.mDataAuthorities.iterator() : null;
    }

    public void addDataPath(String path, int type) {
        this.addDataPath(new PatternMatcher(path.intern(), type));
    }

    public void addDataPath(PatternMatcher path) {
        if (this.mDataPaths == null) {
            this.mDataPaths = new ArrayList();
        }
        this.mDataPaths.add(path);
    }

    public int countDataPaths() {
        return this.mDataPaths != null ? this.mDataPaths.size() : 0;
    }

    public PatternMatcher getDataPath(int index) {
        return this.mDataPaths.get(index);
    }

    public boolean hasDataPath(String data) {
        if (this.mDataPaths == null) {
            return false;
        }
        int numDataPaths = this.mDataPaths.size();
        for (int i = 0; i < numDataPaths; ++i) {
            PatternMatcher pe = this.mDataPaths.get(i);
            if (!pe.match(data)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDataPath(PatternMatcher path) {
        if (this.mDataPaths == null) {
            return false;
        }
        int numDataPaths = this.mDataPaths.size();
        for (int i = 0; i < numDataPaths; ++i) {
            PatternMatcher pe = this.mDataPaths.get(i);
            if (pe.getType() != path.getType() || !pe.getPath().equals(path.getPath())) continue;
            return true;
        }
        return false;
    }

    public Iterator<PatternMatcher> pathsIterator() {
        return this.mDataPaths != null ? this.mDataPaths.iterator() : null;
    }

    public int matchDataAuthority(Uri data) {
        if (this.mDataAuthorities == null) {
            return -2;
        }
        int numDataAuthorities = this.mDataAuthorities.size();
        for (int i = 0; i < numDataAuthorities; ++i) {
            AuthorityEntry ae = this.mDataAuthorities.get(i);
            int match = ae.match(data);
            if (match < 0) continue;
            return match;
        }
        return -2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int matchData(String type, String scheme, Uri data) {
        ArrayList<String> types = this.mDataTypes;
        ArrayList<String> schemes = this.mDataSchemes;
        int match = 0x100000;
        if (types == null && schemes == null) {
            if (type != null) return -2;
            if (data != null) return -2;
            return 0x108000;
        }
        if (schemes != null) {
            ArrayList<AuthorityEntry> authorities;
            if (!schemes.contains(scheme != null ? scheme : "")) return -2;
            match = 0x200000;
            ArrayList<PatternMatcher> schemeSpecificParts = this.mDataSchemeSpecificParts;
            if (schemeSpecificParts != null) {
                int n = match = this.hasDataSchemeSpecificPart(data.getSchemeSpecificPart()) ? 0x580000 : -2;
            }
            if (match != 0x580000 && (authorities = this.mDataAuthorities) != null) {
                int authMatch = this.matchDataAuthority(data);
                if (authMatch < 0) return -2;
                ArrayList<PatternMatcher> paths = this.mDataPaths;
                if (paths == null) {
                    match = authMatch;
                } else {
                    if (!this.hasDataPath(data.getPath())) return -2;
                    match = 0x500000;
                }
            }
            if (match == -2) {
                return -2;
            }
        } else if (!(scheme == null || "".equals(scheme) || "content".equals(scheme) || "file".equals(scheme))) {
            return -2;
        }
        if (types != null) {
            if (!this.findMimeType(type)) return -1;
            return 0x608000;
        }
        if (type == null) return match + 32768;
        return -1;
    }

    public void addCategory(String category) {
        if (this.mCategories == null) {
            this.mCategories = new ArrayList();
        }
        if (!this.mCategories.contains(category)) {
            this.mCategories.add(category.intern());
        }
    }

    public int countCategories() {
        return this.mCategories != null ? this.mCategories.size() : 0;
    }

    public String getCategory(int index) {
        return this.mCategories.get(index);
    }

    public boolean hasCategory(String category) {
        return this.mCategories != null && this.mCategories.contains(category);
    }

    public Iterator<String> categoriesIterator() {
        return this.mCategories != null ? this.mCategories.iterator() : null;
    }

    public String matchCategories(Set<String> categories) {
        if (categories == null) {
            return null;
        }
        Iterator<String> it = categories.iterator();
        if (this.mCategories == null) {
            return it.hasNext() ? it.next() : null;
        }
        while (it.hasNext()) {
            String category = it.next();
            if (this.mCategories.contains(category)) continue;
            return category;
        }
        return null;
    }

    public int match(ContentResolver resolver, Intent intent, boolean resolve, String logTag) {
        String type = resolve ? intent.resolveType(resolver) : intent.getType();
        return this.match(intent.getAction(), type, intent.getScheme(), intent.getData(), intent.getCategories(), logTag);
    }

    public int match(String action, String type, String scheme, Uri data, Set<String> categories, String logTag) {
        if (action != null && !this.matchAction(action)) {
            return -3;
        }
        int dataMatch = this.matchData(type, scheme, data);
        if (dataMatch < 0) {
            return dataMatch;
        }
        String categoryMismatch = this.matchCategories(categories);
        if (categoryMismatch != null) {
            return -4;
        }
        return dataMatch;
    }

    public void writeToXml(XmlSerializer serializer) throws IOException {
        PatternMatcher pe;
        int i;
        int N = this.countActions();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, ACTION_STR);
            serializer.attribute(null, NAME_STR, this.mActions.get(i));
            serializer.endTag(null, ACTION_STR);
        }
        N = this.countCategories();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, CAT_STR);
            serializer.attribute(null, NAME_STR, this.mCategories.get(i));
            serializer.endTag(null, CAT_STR);
        }
        N = this.countDataTypes();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, TYPE_STR);
            String type = this.mDataTypes.get(i);
            if (type.indexOf(47) < 0) {
                type = type + "/*";
            }
            serializer.attribute(null, NAME_STR, type);
            serializer.endTag(null, TYPE_STR);
        }
        N = this.countDataSchemes();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, SCHEME_STR);
            serializer.attribute(null, NAME_STR, this.mDataSchemes.get(i));
            serializer.endTag(null, SCHEME_STR);
        }
        N = this.countDataSchemeSpecificParts();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, SSP_STR);
            pe = this.mDataSchemeSpecificParts.get(i);
            switch (pe.getType()) {
                case 0: {
                    serializer.attribute(null, LITERAL_STR, pe.getPath());
                    break;
                }
                case 1: {
                    serializer.attribute(null, PREFIX_STR, pe.getPath());
                    break;
                }
                case 2: {
                    serializer.attribute(null, SGLOB_STR, pe.getPath());
                }
            }
            serializer.endTag(null, SSP_STR);
        }
        N = this.countDataAuthorities();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, AUTH_STR);
            AuthorityEntry ae = this.mDataAuthorities.get(i);
            serializer.attribute(null, HOST_STR, ae.getHost());
            if (ae.getPort() >= 0) {
                serializer.attribute(null, PORT_STR, Integer.toString(ae.getPort()));
            }
            serializer.endTag(null, AUTH_STR);
        }
        N = this.countDataPaths();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, PATH_STR);
            pe = this.mDataPaths.get(i);
            switch (pe.getType()) {
                case 0: {
                    serializer.attribute(null, LITERAL_STR, pe.getPath());
                    break;
                }
                case 1: {
                    serializer.attribute(null, PREFIX_STR, pe.getPath());
                    break;
                }
                case 2: {
                    serializer.attribute(null, SGLOB_STR, pe.getPath());
                }
            }
            serializer.endTag(null, PATH_STR);
        }
    }

    public void readFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String name;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(ACTION_STR)) {
                name = parser.getAttributeValue(null, NAME_STR);
                if (name != null) {
                    this.addAction(name);
                }
            } else if (tagName.equals(CAT_STR)) {
                name = parser.getAttributeValue(null, NAME_STR);
                if (name != null) {
                    this.addCategory(name);
                }
            } else if (tagName.equals(TYPE_STR)) {
                name = parser.getAttributeValue(null, NAME_STR);
                if (name != null) {
                    try {
                        this.addDataType(name);
                    }
                    catch (MalformedMimeTypeException e) {}
                }
            } else if (tagName.equals(SCHEME_STR)) {
                name = parser.getAttributeValue(null, NAME_STR);
                if (name != null) {
                    this.addDataScheme(name);
                }
            } else if (tagName.equals(SSP_STR)) {
                String ssp = parser.getAttributeValue(null, LITERAL_STR);
                if (ssp != null) {
                    this.addDataSchemeSpecificPart(ssp, 0);
                } else {
                    ssp = parser.getAttributeValue(null, PREFIX_STR);
                    if (ssp != null) {
                        this.addDataSchemeSpecificPart(ssp, 1);
                    } else {
                        ssp = parser.getAttributeValue(null, SGLOB_STR);
                        if (ssp != null) {
                            this.addDataSchemeSpecificPart(ssp, 2);
                        }
                    }
                }
            } else if (tagName.equals(AUTH_STR)) {
                String host = parser.getAttributeValue(null, HOST_STR);
                String port = parser.getAttributeValue(null, PORT_STR);
                if (host != null) {
                    this.addDataAuthority(host, port);
                }
            } else if (tagName.equals(PATH_STR)) {
                String path = parser.getAttributeValue(null, LITERAL_STR);
                if (path != null) {
                    this.addDataPath(path, 0);
                } else {
                    path = parser.getAttributeValue(null, PREFIX_STR);
                    if (path != null) {
                        this.addDataPath(path, 1);
                    } else {
                        path = parser.getAttributeValue(null, SGLOB_STR);
                        if (path != null) {
                            this.addDataPath(path, 2);
                        }
                    }
                }
            } else {
                Log.w("IntentFilter", "Unknown tag parsing IntentFilter: " + tagName);
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    public void dump(Printer du, String prefix) {
        Iterator<Object> it;
        StringBuilder sb = new StringBuilder(256);
        if (this.mActions.size() > 0) {
            it = this.mActions.iterator();
            while (it.hasNext()) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Action: \"");
                sb.append((String)it.next());
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mCategories != null) {
            it = this.mCategories.iterator();
            while (it.hasNext()) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Category: \"");
                sb.append((String)it.next());
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mDataSchemes != null) {
            it = this.mDataSchemes.iterator();
            while (it.hasNext()) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Scheme: \"");
                sb.append((String)it.next());
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mDataSchemeSpecificParts != null) {
            for (PatternMatcher pe : this.mDataSchemeSpecificParts) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Ssp: \"");
                sb.append(pe);
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mDataAuthorities != null) {
            for (AuthorityEntry ae : this.mDataAuthorities) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Authority: \"");
                sb.append(ae.mHost);
                sb.append("\": ");
                sb.append(ae.mPort);
                if (ae.mWild) {
                    sb.append(" WILD");
                }
                du.println(sb.toString());
            }
        }
        if (this.mDataPaths != null) {
            for (PatternMatcher pe : this.mDataPaths) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Path: \"");
                sb.append(pe);
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mDataTypes != null) {
            it = this.mDataTypes.iterator();
            while (it.hasNext()) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Type: \"");
                sb.append((String)it.next());
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mPriority != 0 || this.mHasPartialTypes) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mPriority=");
            sb.append(this.mPriority);
            sb.append(", mHasPartialTypes=");
            sb.append(this.mHasPartialTypes);
            du.println(sb.toString());
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int i;
        int N;
        dest.writeStringList(this.mActions);
        if (this.mCategories != null) {
            dest.writeInt(1);
            dest.writeStringList(this.mCategories);
        } else {
            dest.writeInt(0);
        }
        if (this.mDataSchemes != null) {
            dest.writeInt(1);
            dest.writeStringList(this.mDataSchemes);
        } else {
            dest.writeInt(0);
        }
        if (this.mDataTypes != null) {
            dest.writeInt(1);
            dest.writeStringList(this.mDataTypes);
        } else {
            dest.writeInt(0);
        }
        if (this.mDataSchemeSpecificParts != null) {
            N = this.mDataSchemeSpecificParts.size();
            dest.writeInt(N);
            for (i = 0; i < N; ++i) {
                this.mDataSchemeSpecificParts.get(i).writeToParcel(dest, flags);
            }
        } else {
            dest.writeInt(0);
        }
        if (this.mDataAuthorities != null) {
            N = this.mDataAuthorities.size();
            dest.writeInt(N);
            for (i = 0; i < N; ++i) {
                this.mDataAuthorities.get(i).writeToParcel(dest);
            }
        } else {
            dest.writeInt(0);
        }
        if (this.mDataPaths != null) {
            N = this.mDataPaths.size();
            dest.writeInt(N);
            for (i = 0; i < N; ++i) {
                this.mDataPaths.get(i).writeToParcel(dest, flags);
            }
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mPriority);
        dest.writeInt(this.mHasPartialTypes ? 1 : 0);
    }

    public boolean debugCheck() {
        return true;
    }

    private IntentFilter(Parcel source) {
        int i;
        int N;
        this.mActions = new ArrayList();
        source.readStringList(this.mActions);
        if (source.readInt() != 0) {
            this.mCategories = new ArrayList();
            source.readStringList(this.mCategories);
        }
        if (source.readInt() != 0) {
            this.mDataSchemes = new ArrayList();
            source.readStringList(this.mDataSchemes);
        }
        if (source.readInt() != 0) {
            this.mDataTypes = new ArrayList();
            source.readStringList(this.mDataTypes);
        }
        if ((N = source.readInt()) > 0) {
            this.mDataSchemeSpecificParts = new ArrayList(N);
            for (i = 0; i < N; ++i) {
                this.mDataSchemeSpecificParts.add(new PatternMatcher(source));
            }
        }
        if ((N = source.readInt()) > 0) {
            this.mDataAuthorities = new ArrayList(N);
            for (i = 0; i < N; ++i) {
                this.mDataAuthorities.add(new AuthorityEntry(source));
            }
        }
        if ((N = source.readInt()) > 0) {
            this.mDataPaths = new ArrayList(N);
            for (i = 0; i < N; ++i) {
                this.mDataPaths.add(new PatternMatcher(source));
            }
        }
        this.mPriority = source.readInt();
        this.mHasPartialTypes = source.readInt() > 0;
    }

    private boolean findMimeType(String type) {
        ArrayList<String> t = this.mDataTypes;
        if (type == null) {
            return false;
        }
        if (t.contains(type)) {
            return true;
        }
        int typeLength = type.length();
        if (typeLength == 3 && type.equals("*/*")) {
            return !t.isEmpty();
        }
        if (this.mHasPartialTypes && t.contains("*")) {
            return true;
        }
        int slashpos = type.indexOf(47);
        if (slashpos > 0) {
            if (this.mHasPartialTypes && t.contains(type.substring(0, slashpos))) {
                return true;
            }
            if (typeLength == slashpos + 2 && type.charAt(slashpos + 1) == '*') {
                int numTypes = t.size();
                for (int i = 0; i < numTypes; ++i) {
                    String v = t.get(i);
                    if (!type.regionMatches(0, v, 0, slashpos + 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class AuthorityEntry {
        private final String mOrigHost;
        private final String mHost;
        private final boolean mWild;
        private final int mPort;

        public AuthorityEntry(String host, String port) {
            this.mOrigHost = host;
            this.mWild = host.length() > 0 && host.charAt(0) == '*';
            this.mHost = this.mWild ? host.substring(1).intern() : host;
            this.mPort = port != null ? Integer.parseInt(port) : -1;
        }

        AuthorityEntry(Parcel src) {
            this.mOrigHost = src.readString();
            this.mHost = src.readString();
            this.mWild = src.readInt() != 0;
            this.mPort = src.readInt();
        }

        void writeToParcel(Parcel dest) {
            dest.writeString(this.mOrigHost);
            dest.writeString(this.mHost);
            dest.writeInt(this.mWild ? 1 : 0);
            dest.writeInt(this.mPort);
        }

        public String getHost() {
            return this.mOrigHost;
        }

        public int getPort() {
            return this.mPort;
        }

        public boolean match(AuthorityEntry other) {
            if (this.mWild != other.mWild) {
                return false;
            }
            if (!this.mHost.equals(other.mHost)) {
                return false;
            }
            return this.mPort == other.mPort;
        }

        public int match(Uri data) {
            String host = data.getHost();
            if (host == null) {
                return -2;
            }
            if (this.mWild) {
                if (host.length() < this.mHost.length()) {
                    return -2;
                }
                host = host.substring(host.length() - this.mHost.length());
            }
            if (host.compareToIgnoreCase(this.mHost) != 0) {
                return -2;
            }
            if (this.mPort >= 0) {
                if (this.mPort != data.getPort()) {
                    return -2;
                }
                return 0x400000;
            }
            return 0x300000;
        }
    }

    public static class MalformedMimeTypeException
    extends AndroidException {
        public MalformedMimeTypeException() {
        }

        public MalformedMimeTypeException(String name) {
            super(name);
        }
    }
}

