/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IActivityContainerCallback
extends IInterface {
    public void setVisible(IBinder var1, boolean var2) throws RemoteException;

    public void onAllActivitiesComplete(IBinder var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IActivityContainerCallback {
        private static final String DESCRIPTOR = "android.app.IActivityContainerCallback";
        static final int TRANSACTION_setVisible = 1;
        static final int TRANSACTION_onAllActivitiesComplete = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IActivityContainerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IActivityContainerCallback) {
                return (IActivityContainerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    this.setVisible(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    IBinder _arg0 = data.readStrongBinder();
                    this.onAllActivitiesComplete(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IActivityContainerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVisible(IBinder container, boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(container);
                    _data.writeInt(visible ? 1 : 0);
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAllActivitiesComplete(IBinder container) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(container);
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

