/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.os.Handler;
import android.os.Handler_Delegate;
import android.os.Message;
import com.android.ide.common.rendering.api.IAnimationListener;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import java.util.PriorityQueue;
import java.util.Queue;

public abstract class AnimationThread
extends Thread {
    private final RenderSessionImpl mSession;
    private Queue<MessageBundle> mQueue = new PriorityQueue<MessageBundle>();
    private final IAnimationListener mListener;

    public AnimationThread(RenderSessionImpl scene, String threadName, IAnimationListener listener) {
        super(threadName);
        this.mSession = scene;
        this.mListener = listener;
    }

    public abstract Result preAnimation();

    public abstract void postAnimation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Bridge.prepareThread();
        try {
            MessageBundle bundle;
            Result result = this.preAnimation();
            if (!result.isSuccess()) {
                this.mListener.done(result);
            }
            RenderSession session = this.mSession.getSession();
            while (!this.mListener.isCanceled() && (bundle = this.mQueue.poll()) != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime < bundle.mUptimeMillis) {
                    try {
                        AnimationThread.sleep(bundle.mUptimeMillis - currentTime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.mListener.isCanceled()) break;
                result = this.mSession.acquire(250L);
                if (!result.isSuccess()) {
                    this.mListener.done(result);
                    return;
                }
                try {
                    if (this.mListener.isCanceled()) break;
                    bundle.mTarget.handleMessage(bundle.mMessage);
                    if (this.mSession.render(false).isSuccess()) {
                        this.mListener.onNewFrame(session);
                    }
                }
                finally {
                    this.mSession.release();
                }
                if (!this.mListener.isCanceled() && this.mQueue.size() > 0) continue;
            }
            this.mListener.done(Result.Status.SUCCESS.createResult());
        }
        catch (Throwable throwable) {
            this.mListener.done(Result.Status.ERROR_UNKNOWN.createResult("Error playing animation", throwable));
        }
        finally {
            this.postAnimation();
            Handler_Delegate.setCallback(null);
            Bridge.cleanupThread();
        }
    }

    private static class MessageBundle
    implements Comparable<MessageBundle> {
        final Handler mTarget;
        final Message mMessage;
        final long mUptimeMillis;

        MessageBundle(Handler target, Message message, long uptimeMillis) {
            this.mTarget = target;
            this.mMessage = message;
            this.mUptimeMillis = uptimeMillis;
        }

        @Override
        public int compareTo(MessageBundle bundle) {
            if (this.mUptimeMillis < bundle.mUptimeMillis) {
                return -1;
            }
            return 1;
        }
    }
}

