/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.TypedValue;
import android.util.Xml;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class AccessibilityServiceInfo
implements Parcelable {
    private static final String TAG_ACCESSIBILITY_SERVICE = "accessibility-service";
    public static final int CAPABILITY_CAN_RETRIEVE_WINDOW_CONTENT = 1;
    public static final int CAPABILITY_CAN_REQUEST_TOUCH_EXPLORATION = 2;
    public static final int CAPABILITY_CAN_REQUEST_ENHANCED_WEB_ACCESSIBILITY = 4;
    public static final int CAPABILITY_CAN_REQUEST_FILTER_KEY_EVENTS = 8;
    private static final SparseArray<CapabilityInfo> sAvailableCapabilityInfos = new SparseArray();
    public static final int FEEDBACK_SPOKEN = 1;
    public static final int FEEDBACK_HAPTIC = 2;
    public static final int FEEDBACK_AUDIBLE = 4;
    public static final int FEEDBACK_VISUAL = 8;
    public static final int FEEDBACK_GENERIC = 16;
    public static final int FEEDBACK_BRAILLE = 32;
    public static final int FEEDBACK_ALL_MASK = -1;
    public static final int DEFAULT = 1;
    public static final int FLAG_INCLUDE_NOT_IMPORTANT_VIEWS = 2;
    public static final int FLAG_REQUEST_TOUCH_EXPLORATION_MODE = 4;
    public static final int FLAG_REQUEST_ENHANCED_WEB_ACCESSIBILITY = 8;
    public static final int FLAG_REPORT_VIEW_IDS = 16;
    public static final int FLAG_REQUEST_FILTER_KEY_EVENTS = 32;
    public static final int FLAG_RETRIEVE_INTERACTIVE_WINDOWS = 64;
    public int eventTypes;
    public String[] packageNames;
    public int feedbackType;
    public long notificationTimeout;
    public int flags;
    private String mId;
    private ResolveInfo mResolveInfo;
    private String mSettingsActivityName;
    private int mCapabilities;
    private int mDescriptionResId;
    private String mNonLocalizedDescription;
    public static final Parcelable.Creator<AccessibilityServiceInfo> CREATOR;

    public AccessibilityServiceInfo() {
    }

    public AccessibilityServiceInfo(ResolveInfo resolveInfo, Context context) throws XmlPullParserException, IOException {
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        this.mId = new ComponentName(serviceInfo.packageName, serviceInfo.name).flattenToShortString();
        this.mResolveInfo = resolveInfo;
        XmlResourceParser parser = null;
        try {
            TypedValue peekedValue;
            PackageManager packageManager = context.getPackageManager();
            parser = serviceInfo.loadXmlMetaData(packageManager, "android.accessibilityservice");
            if (parser == null) {
                return;
            }
            int type = 0;
            while (type != 1 && type != 2) {
                type = parser.next();
            }
            String nodeName = parser.getName();
            if (!TAG_ACCESSIBILITY_SERVICE.equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start withaccessibility-service tag");
            }
            AttributeSet allAttributes = Xml.asAttributeSet(parser);
            Resources resources = packageManager.getResourcesForApplication(serviceInfo.applicationInfo);
            TypedArray asAttributes = resources.obtainAttributes(allAttributes, R.styleable.AccessibilityService);
            this.eventTypes = asAttributes.getInt(2, 0);
            String packageNamez = asAttributes.getString(3);
            if (packageNamez != null) {
                this.packageNames = packageNamez.split("(\\s)*,(\\s)*");
            }
            this.feedbackType = asAttributes.getInt(4, 0);
            this.notificationTimeout = asAttributes.getInt(5, 0);
            this.flags = asAttributes.getInt(6, 0);
            this.mSettingsActivityName = asAttributes.getString(1);
            if (asAttributes.getBoolean(7, false)) {
                this.mCapabilities |= 1;
            }
            if (asAttributes.getBoolean(8, false)) {
                this.mCapabilities |= 2;
            }
            if (asAttributes.getBoolean(9, false)) {
                this.mCapabilities |= 4;
            }
            if (asAttributes.getBoolean(10, false)) {
                this.mCapabilities |= 8;
            }
            if ((peekedValue = asAttributes.peekValue(0)) != null) {
                this.mDescriptionResId = peekedValue.resourceId;
                CharSequence nonLocalizedDescription = peekedValue.coerceToString();
                if (nonLocalizedDescription != null) {
                    this.mNonLocalizedDescription = nonLocalizedDescription.toString().trim();
                }
            }
            asAttributes.recycle();
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new XmlPullParserException("Unable to create context for: " + serviceInfo.packageName);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    public void updateDynamicallyConfigurableProperties(AccessibilityServiceInfo other) {
        this.eventTypes = other.eventTypes;
        this.packageNames = other.packageNames;
        this.feedbackType = other.feedbackType;
        this.notificationTimeout = other.notificationTimeout;
        this.flags = other.flags;
    }

    public void setComponentName(ComponentName component) {
        this.mId = component.flattenToShortString();
    }

    public String getId() {
        return this.mId;
    }

    public ResolveInfo getResolveInfo() {
        return this.mResolveInfo;
    }

    public String getSettingsActivityName() {
        return this.mSettingsActivityName;
    }

    public boolean getCanRetrieveWindowContent() {
        return (this.mCapabilities & 1) != 0;
    }

    public int getCapabilities() {
        return this.mCapabilities;
    }

    public void setCapabilities(int capabilities) {
        this.mCapabilities = capabilities;
    }

    public String getDescription() {
        return this.mNonLocalizedDescription;
    }

    public String loadDescription(PackageManager packageManager) {
        if (this.mDescriptionResId == 0) {
            return this.mNonLocalizedDescription;
        }
        ServiceInfo serviceInfo = this.mResolveInfo.serviceInfo;
        CharSequence description = packageManager.getText(serviceInfo.packageName, this.mDescriptionResId, serviceInfo.applicationInfo);
        if (description != null) {
            return description.toString().trim();
        }
        return null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flagz) {
        parcel.writeInt(this.eventTypes);
        parcel.writeStringArray(this.packageNames);
        parcel.writeInt(this.feedbackType);
        parcel.writeLong(this.notificationTimeout);
        parcel.writeInt(this.flags);
        parcel.writeString(this.mId);
        parcel.writeParcelable(this.mResolveInfo, 0);
        parcel.writeString(this.mSettingsActivityName);
        parcel.writeInt(this.mCapabilities);
        parcel.writeInt(this.mDescriptionResId);
        parcel.writeString(this.mNonLocalizedDescription);
    }

    private void initFromParcel(Parcel parcel) {
        this.eventTypes = parcel.readInt();
        this.packageNames = parcel.readStringArray();
        this.feedbackType = parcel.readInt();
        this.notificationTimeout = parcel.readLong();
        this.flags = parcel.readInt();
        this.mId = parcel.readString();
        this.mResolveInfo = (ResolveInfo)parcel.readParcelable(null);
        this.mSettingsActivityName = parcel.readString();
        this.mCapabilities = parcel.readInt();
        this.mDescriptionResId = parcel.readInt();
        this.mNonLocalizedDescription = parcel.readString();
    }

    public int hashCode() {
        return 31 + (this.mId == null ? 0 : this.mId.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessibilityServiceInfo other = (AccessibilityServiceInfo)obj;
        return !(this.mId == null ? other.mId != null : !this.mId.equals(other.mId));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        AccessibilityServiceInfo.appendEventTypes(stringBuilder, this.eventTypes);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendPackageNames(stringBuilder, this.packageNames);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendFeedbackTypes(stringBuilder, this.feedbackType);
        stringBuilder.append(", ");
        stringBuilder.append("notificationTimeout: ").append(this.notificationTimeout);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendFlags(stringBuilder, this.flags);
        stringBuilder.append(", ");
        stringBuilder.append("id: ").append(this.mId);
        stringBuilder.append(", ");
        stringBuilder.append("resolveInfo: ").append(this.mResolveInfo);
        stringBuilder.append(", ");
        stringBuilder.append("settingsActivityName: ").append(this.mSettingsActivityName);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendCapabilities(stringBuilder, this.mCapabilities);
        return stringBuilder.toString();
    }

    private static void appendFeedbackTypes(StringBuilder stringBuilder, int feedbackTypes) {
        stringBuilder.append("feedbackTypes:");
        stringBuilder.append("[");
        while (feedbackTypes != 0) {
            int feedbackTypeBit = 1 << Integer.numberOfTrailingZeros(feedbackTypes);
            stringBuilder.append(AccessibilityServiceInfo.feedbackTypeToString(feedbackTypeBit));
            if ((feedbackTypes &= ~feedbackTypeBit) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static void appendPackageNames(StringBuilder stringBuilder, String[] packageNames) {
        stringBuilder.append("packageNames:");
        stringBuilder.append("[");
        if (packageNames != null) {
            int packageNameCount = packageNames.length;
            for (int i = 0; i < packageNameCount; ++i) {
                stringBuilder.append(packageNames[i]);
                if (i >= packageNameCount - 1) continue;
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append("]");
    }

    private static void appendEventTypes(StringBuilder stringBuilder, int eventTypes) {
        stringBuilder.append("eventTypes:");
        stringBuilder.append("[");
        while (eventTypes != 0) {
            int eventTypeBit = 1 << Integer.numberOfTrailingZeros(eventTypes);
            stringBuilder.append(AccessibilityEvent.eventTypeToString(eventTypeBit));
            if ((eventTypes &= ~eventTypeBit) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static void appendFlags(StringBuilder stringBuilder, int flags) {
        stringBuilder.append("flags:");
        stringBuilder.append("[");
        while (flags != 0) {
            int flagBit = 1 << Integer.numberOfTrailingZeros(flags);
            stringBuilder.append(AccessibilityServiceInfo.flagToString(flagBit));
            if ((flags &= ~flagBit) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static void appendCapabilities(StringBuilder stringBuilder, int capabilities) {
        stringBuilder.append("capabilities:");
        stringBuilder.append("[");
        while (capabilities != 0) {
            int capabilityBit = 1 << Integer.numberOfTrailingZeros(capabilities);
            stringBuilder.append(AccessibilityServiceInfo.capabilityToString(capabilityBit));
            if ((capabilities &= ~capabilityBit) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    public static String feedbackTypeToString(int feedbackType) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        while (feedbackType != 0) {
            int feedbackTypeFlag = 1 << Integer.numberOfTrailingZeros(feedbackType);
            feedbackType &= ~feedbackTypeFlag;
            switch (feedbackTypeFlag) {
                case 4: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_AUDIBLE");
                    break;
                }
                case 2: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_HAPTIC");
                    break;
                }
                case 16: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_GENERIC");
                    break;
                }
                case 1: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_SPOKEN");
                    break;
                }
                case 8: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_VISUAL");
                    break;
                }
                case 32: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_BRAILLE");
                }
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static String flagToString(int flag) {
        switch (flag) {
            case 1: {
                return "DEFAULT";
            }
            case 2: {
                return "FLAG_INCLUDE_NOT_IMPORTANT_VIEWS";
            }
            case 4: {
                return "FLAG_REQUEST_TOUCH_EXPLORATION_MODE";
            }
            case 8: {
                return "FLAG_REQUEST_ENHANCED_WEB_ACCESSIBILITY";
            }
            case 16: {
                return "FLAG_REPORT_VIEW_IDS";
            }
            case 32: {
                return "FLAG_REQUEST_FILTER_KEY_EVENTS";
            }
            case 64: {
                return "FLAG_RETRIEVE_INTERACTIVE_WINDOWS";
            }
        }
        return null;
    }

    public static String capabilityToString(int capability) {
        switch (capability) {
            case 1: {
                return "CAPABILITY_CAN_RETRIEVE_WINDOW_CONTENT";
            }
            case 2: {
                return "CAPABILITY_CAN_REQUEST_TOUCH_EXPLORATION";
            }
            case 4: {
                return "CAPABILITY_CAN_REQUEST_ENHANCED_WEB_ACCESSIBILITY";
            }
            case 8: {
                return "CAPABILITY_CAN_FILTER_KEY_EVENTS";
            }
        }
        return "UNKNOWN";
    }

    public List<CapabilityInfo> getCapabilityInfos() {
        int capabilityBit;
        if (this.mCapabilities == 0) {
            return Collections.emptyList();
        }
        ArrayList<CapabilityInfo> capabilityInfos = new ArrayList<CapabilityInfo>();
        for (int capabilities = this.mCapabilities; capabilities != 0; capabilities &= ~capabilityBit) {
            capabilityBit = 1 << Integer.numberOfTrailingZeros(capabilities);
            CapabilityInfo capabilityInfo = sAvailableCapabilityInfos.get(capabilityBit);
            if (capabilityInfo == null) continue;
            capabilityInfos.add(capabilityInfo);
        }
        return capabilityInfos;
    }

    static {
        sAvailableCapabilityInfos.put(1, new CapabilityInfo(1, 17039685, 17039686));
        sAvailableCapabilityInfos.put(2, new CapabilityInfo(2, 17039687, 17039688));
        sAvailableCapabilityInfos.put(4, new CapabilityInfo(4, 17039689, 17039690));
        sAvailableCapabilityInfos.put(8, new CapabilityInfo(8, 17039691, 17039692));
        CREATOR = new Parcelable.Creator<AccessibilityServiceInfo>(){

            @Override
            public AccessibilityServiceInfo createFromParcel(Parcel parcel) {
                AccessibilityServiceInfo info = new AccessibilityServiceInfo();
                info.initFromParcel(parcel);
                return info;
            }

            public AccessibilityServiceInfo[] newArray(int size) {
                return new AccessibilityServiceInfo[size];
            }
        };
    }

    public static class CapabilityInfo {
        public final int capability;
        public final int titleResId;
        public final int descResId;

        public CapabilityInfo(int capability, int titleResId, int descResId) {
            this.capability = capability;
            this.titleResId = titleResId;
            this.descResId = descResId;
        }
    }
}

