#!/bin/sh
#####################################################
##              START-UP PM PROCESS
#####################################################
if [ T"$PROC_HOME" == T"" ]
then
        source /root/.bashrc
fi

PROC_NAME=PM
PROC_INFO=$PROC_HOME/$PROC_NAME
PROC_ACCOUNT=root

CURR_UID=`id | awk '{print $1}'`
if [ "$CURR_UID" = "uid=0(root)" ]
then
	CURR_ACCOUNT="root"
else
	CURR_ACCOUNT=$USER
fi


check_process_status()
{
	PNAME=$1
	PID=`ps -ef|grep -v grep|grep -v tail| grep -v vi|grep -v uTest|grep "$PNAME" | awk '{print $2}'`
}

echo ""
echo "START-UP [[7m $PROC_NAME [0m] PROCESS"
echo "===================================================================="
echo ""


check_process_status "$PROC_NAME"
if [ T"$PID" != T"" ]
then
	echo "$PROC_NAME already started(pid:$PID)!!\n"
	exit
fi

ulimit -c unlimited

echo "Start $PROC_INFO"
if [ T"$CURR_ACCOUNT" != T"$PROC_ACCOUNT" ]
then
	if [ T"$CURR_ACCOUNT" != T"root" ]
	then
		echo ""
		echo "login : [7m$PROC_ACCOUNT[0m"
	fi
    
	su - $PROC_ACCOUNT -c "$PROC_INFO & "
else
	$PROC_INFO &
fi

#sleep 2

echo ""
check_process_status "$PROC_NAME"
if [ T"$PID" != T"" ]
then
	echo "Success!! $PROC_NAME started!!"
else
	echo "Error!! $PROC_NAME start failure!!"
fi
echo "===================================================================="
echo ""
