#ifndef _MEDIA_COMMON_H_
#define _MEDIA_COMMON_H_

#include <stdint.h>

#define AV_TIME_BASE 1000000

typedef enum InternetMediaType
{
	INTERNET_MEDIA_TYPE_UNKNOWN,
//	INTERNET_MEDIA_TYPE_VIDEO_MPEG, // MPEG-1 video, video/mpeg
	INTERNET_MEDIA_TYPE_VIDEO_MP4, // MP4 video, video/mp4
//	INTERNET_MEDIA_TYPE_VIDEO_OGG, // Ogg Theora, video/ogg
	INTERNET_MEDIA_TYPE_VIDEO_QUICKTIME, // QuickTime video, video/quicktime
//	INTERNET_MEDIA_TYPE_VIDEO_WEBM, // Webm Matroska-based open media format, video/webm
	INTERNET_MEDIA_TYPE_VIDEO_X_MATROSKA, // Matroska open media format, video/x-matroska
	INTERNET_MEDIA_TYPE_VIDEO_X_MS_WMV, // Windows Media Video, video/x-ms-wmv
	INTERNET_MEDIA_TYPE_VIDEO_MPEGTS, // mpegts, video/mp2t
	INTERNET_MEDIA_TYPE_VIDEO_X_FLV // Flash video, video/x-flv
} InternetMediaType;

typedef enum MediaContainerType
{
	MEDIA_CONTAINER_TYPE_UNKNOWN = -1,
	MEDIA_CONTAINER_TYPE_MP4,
	MEDIA_CONTAINER_TYPE_FLV,
	MEDIA_CONTAINER_TYPE_AVI
} MediaContainerType;

typedef struct StreamEntry
{
	int64_t pos;
	int64_t timestamp;
	int flags:2;
	int size:30;
	int min_distance;
} StreamEntry;

typedef struct VideoStreamContext VideoStreamContext;
struct VideoStreamContext
{
	char* codec_name;

	int width;
	int height;
	double fps;
	int bit_rate;

	int duration;

	// H.264
	int spspps_len;
	uint8_t* spspps;

	int64_t entry_count;
	StreamEntry* entries;

	VideoStreamContext* next;
};

typedef struct AudioStreamContext AudioStreamContext;
struct AudioStreamContext
{
	char* codec_name;

	int sample_rate;
	int channels;
	int bit_rate;

	int duration;

	int64_t entry_count;
	StreamEntry* entries;

	AudioStreamContext* next;
};

typedef struct SubtitleStreamContext SubtitleStreamContext;
struct SubtitleStreamContext
{
	char* codec_name;

	int duration;

	int64_t entry_count;
	StreamEntry* entries;

	SubtitleStreamContext* next;
};

typedef struct MediaContext
{
	char* filename;
	int64_t file_size;
	char* container_name;
	int duration;
	int bit_rate;
	InternetMediaType mime_type;
	char* mime_type_str;

	VideoStreamContext* video;
	AudioStreamContext* audio;
	SubtitleStreamContext* subtitle;
} MediaContext;

void media_context_register(void);

/**
  * Create media context
  *
  * @param: non
  * @return: if success return media context
  *		else NULL
  */
MediaContext* create_media_context(void);

/**
  * Build media information
  *
  * @param context(in): media context
  * @param filename(in): file name
  * @return: if 0 success
  *		else -1 media context is NULL
  *		else -2 file open error
  *		else -3 not support file format
  */
int build_media_info(MediaContext* context, char* filename);

/**
  * Free media context
  *
  * @param context(in): media context
  * @return: always 0
  */
int free_media_context(MediaContext* context);


#endif
